/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.util.UnsafeUtils;

public class C1SChunk
extends Chunk {
    protected static final int _OFF = 16;
    private transient double _scale;
    private transient long _bias;

    public double scale() {
        return this._scale;
    }

    @Override
    public boolean hasFloat() {
        return this._scale != (double)((long)this._scale);
    }

    C1SChunk(byte[] bs, long bias, double scale) {
        this._mem = bs;
        this._start = -1L;
        this.set_len(this._mem.length - 16);
        this._bias = bias;
        this._scale = scale;
        UnsafeUtils.set8d(this._mem, 0, scale);
        UnsafeUtils.set8(this._mem, 8, bias);
    }

    @Override
    protected final long at8_impl(int i) {
        long res = 0xFF & this._mem[i + 16];
        if (res == 255L) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return (long)((double)(res + this._bias) * this._scale);
    }

    @Override
    protected final double atd_impl(int i) {
        long res = 0xFF & this._mem[i + 16];
        return res == 255L ? Double.NaN : (double)(res + this._bias) * this._scale;
    }

    @Override
    protected final boolean isNA_impl(int i) {
        return (0xFF & this._mem[i + 16]) == 255;
    }

    @Override
    boolean set_impl(int i, long l) {
        long res = (long)((double)l / this._scale) - this._bias;
        double d = (double)(res + this._bias) * this._scale;
        if ((long)d != l) {
            return false;
        }
        if (0L > res || res >= 255L) {
            return false;
        }
        this._mem[i + 16] = (byte)res;
        return true;
    }

    @Override
    boolean set_impl(int i, double d) {
        return false;
    }

    @Override
    boolean set_impl(int i, float f) {
        return false;
    }

    @Override
    boolean setNA_impl(int idx) {
        this._mem[idx + 16] = -1;
        return true;
    }

    private void processRow(int r, ChunkVisitor v) {
        int res = 0xFF & this._mem[r + 16];
        if (res == 255) {
            v.addNAs(1);
        } else {
            v.addValue((double)((long)res + this._bias) * this._scale);
        }
    }

    private void processRow(int r, int exp, ChunkVisitor v) {
        int res = 0xFF & this._mem[r + 16];
        if (res == 255) {
            v.addNAs(1);
        } else {
            v.addValue((long)res + this._bias, exp);
        }
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v, int from, int to) {
        if (v.expandedVals()) {
            double x = Math.log10(this._scale);
            int e = (int)x;
            assert (x == (double)e) : "scale does not fit into int";
            for (int i = from; i < to; ++i) {
                this.processRow(i, e, v);
            }
        } else {
            for (int i = from; i < to; ++i) {
                this.processRow(i, v);
            }
        }
        return v;
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v, int[] ids) {
        if (v.expandedVals()) {
            double x = Math.log10(this._scale);
            int e = (int)x;
            assert (x == (double)e) : "scale does not fit into int";
            for (int i : ids) {
                this.processRow(i, e, v);
            }
        } else {
            for (int i : ids) {
                this.processRow(i, v);
            }
        }
        return v;
    }

    @Override
    public byte precision() {
        return (byte)Math.max(-Math.log10(this._scale), 0.0);
    }

    @Override
    public final void initFromBytes() {
        this._start = -1L;
        this._cidx = -1;
        this.set_len(this._mem.length - 16);
        this._scale = UnsafeUtils.get8d(this._mem, 0);
        this._bias = UnsafeUtils.get8(this._mem, 8);
    }

    @Override
    public double[] getDoubles(double[] vals, int from, int to, double NA) {
        for (int i = from; i < to; ++i) {
            long res = 0xFF & this._mem[16 + i];
            vals[i - from] = res != 255L ? (double)(res + this._bias) * this._scale : NA;
        }
        return vals;
    }

    @Override
    public double[] getDoubles(double[] vals, int[] ids) {
        int j = 0;
        for (int i : ids) {
            long res = 0xFF & this._mem[16 + i];
            vals[j++] = res != 255L ? (double)(res + this._bias) * this._scale : Double.NaN;
        }
        return vals;
    }
}

