/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.StringReader;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinuxProcFileReader {
    private String _systemData;
    private String _processData;
    private String _processStatus;
    private String _pid;
    private long _systemIdleTicks = -1L;
    private long _systemTotalTicks = -1L;
    private long _processTotalTicks = -1L;
    private long _processRss = -1L;
    private int _processCpusAllowed = -1;
    private int _processNumOpenFds = -1;
    private ArrayList<long[]> _cpuTicks = null;

    public long getSystemIdleTicks() {
        assert (this._systemIdleTicks > 0L);
        return this._systemIdleTicks;
    }

    public long getSystemTotalTicks() {
        assert (this._systemTotalTicks > 0L);
        return this._systemTotalTicks;
    }

    public long getProcessTotalTicks() {
        assert (this._processTotalTicks > 0L);
        return this._processTotalTicks;
    }

    public long[][] getCpuTicks() {
        assert (this._cpuTicks != null);
        return (long[][])this._cpuTicks.toArray((T[])new long[0][0]);
    }

    public long getProcessRss() {
        assert (this._processRss > 0L);
        return this._processRss;
    }

    private static boolean isOSNameMatch(String osName, String osNamePrefix) {
        if (osName == null) {
            return false;
        }
        return osName.startsWith(osNamePrefix);
    }

    private static boolean getOSMatchesName(String osNamePrefix) {
        String osName = System.getProperty("os.name");
        return LinuxProcFileReader.isOSNameMatch(osName, osNamePrefix);
    }

    private static boolean IS_OS_LINUX() {
        return LinuxProcFileReader.getOSMatchesName("Linux") || LinuxProcFileReader.getOSMatchesName("LINUX");
    }

    public int getProcessCpusAllowed() {
        if (!LinuxProcFileReader.IS_OS_LINUX()) {
            return Runtime.getRuntime().availableProcessors();
        }
        if (this._processCpusAllowed < 0) {
            return Runtime.getRuntime().availableProcessors();
        }
        return this._processCpusAllowed;
    }

    public int getProcessNumOpenFds() {
        assert (this._processNumOpenFds > 0);
        return this._processNumOpenFds;
    }

    public String getProcessID() {
        return this._pid;
    }

    public void read() {
        String pid = "-1";
        try {
            this._pid = pid = LinuxProcFileReader.getProcessId();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        File f = new File("/proc/stat");
        if (!f.exists()) {
            return;
        }
        try {
            this.readSystemProcFile();
            this.readProcessProcFile(pid);
            this.readProcessNumOpenFds(pid);
            this.readProcessStatusFile(pid);
            this.parseSystemProcFile(this._systemData);
            this.parseProcessProcFile(this._processData);
            this.parseProcessStatusFile(this._processStatus);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean valid() {
        return this._systemIdleTicks >= 0L && this._systemTotalTicks >= 0L && this._processTotalTicks >= 0L && this._processNumOpenFds >= 0;
    }

    public static int numSetBitsHex(String s) {
        int[] bits_set = new int[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};
        int nset = 0;
        for (int i = 0; i < s.length(); ++i) {
            Character ch = Character.valueOf(s.charAt(i));
            if (ch.charValue() == ',') continue;
            int x = Integer.parseInt(ch.toString(), 16);
            nset += bits_set[x];
        }
        return nset;
    }

    private static String getProcessId() throws Exception {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            throw new Exception("Can't get process Id");
        }
        return Long.toString(Long.parseLong(jvmName.substring(0, index)));
    }

    private String readFile(File f) throws Exception {
        int n;
        char[] buffer = new char[16384];
        FileReader fr = new FileReader(f);
        int bytesRead = 0;
        do {
            if ((n = fr.read(buffer, bytesRead, buffer.length - bytesRead)) < 0) {
                fr.close();
                return new String(buffer, 0, bytesRead);
            }
            if (n != 0) continue;
            fr.close();
            throw new Exception("LinuxProcFileReader readFile read 0 bytes");
        } while ((bytesRead += n) < buffer.length);
        fr.close();
        throw new Exception("LinuxProcFileReader readFile unexpected buffer full");
    }

    private void readSystemProcFile() {
        try {
            this._systemData = this.readFile(new File("/proc/stat"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parseSystemProcFile(String s) {
        if (s == null) {
            return;
        }
        try {
            BufferedReader reader = new BufferedReader(new StringReader(s));
            String line = reader.readLine();
            Pattern p = Pattern.compile("cpu\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+).*");
            Matcher m = p.matcher(line);
            boolean b = m.matches();
            if (!b) {
                return;
            }
            long systemUserTicks = Long.parseLong(m.group(1));
            long systemNiceTicks = Long.parseLong(m.group(2));
            long systemSystemTicks = Long.parseLong(m.group(3));
            this._systemIdleTicks = Long.parseLong(m.group(4));
            this._systemTotalTicks = systemUserTicks + systemNiceTicks + systemSystemTicks + this._systemIdleTicks;
            this._cpuTicks = new ArrayList();
            line = reader.readLine();
            while (line != null && (b = (m = (p = Pattern.compile("cpu(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+).*")).matcher(line)).matches())) {
                long cpuUserTicks = 0L;
                long cpuSystemTicks = 0L;
                long cpuOtherTicks = 0L;
                long cpuIdleTicks = 0L;
                cpuOtherTicks += Long.parseLong(m.group(3));
                cpuSystemTicks += Long.parseLong(m.group(4));
                cpuSystemTicks += Long.parseLong(m.group(7));
                long[] oneCpuTicks = new long[]{cpuUserTicks += Long.parseLong(m.group(2)), cpuSystemTicks += Long.parseLong(m.group(8)), cpuOtherTicks += Long.parseLong(m.group(6)), cpuIdleTicks += Long.parseLong(m.group(5))};
                this._cpuTicks.add(oneCpuTicks);
                line = reader.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readProcessProcFile(String pid) {
        try {
            String s = "/proc/" + pid + "/stat";
            this._processData = this.readFile(new File(s));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parseProcessProcFile(String s) {
        if (s == null) {
            return;
        }
        try {
            BufferedReader reader = new BufferedReader(new StringReader(s));
            String line = reader.readLine();
            Pattern p = Pattern.compile("(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+).*");
            Matcher m = p.matcher(line);
            boolean b = m.matches();
            if (!b) {
                return;
            }
            long processUserTicks = Long.parseLong(m.group(14));
            long processSystemTicks = Long.parseLong(m.group(15));
            this._processTotalTicks = processUserTicks + processSystemTicks;
            this._processRss = Long.parseLong(m.group(24));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readProcessNumOpenFds(String pid) {
        try {
            String s = "/proc/" + pid + "/fd";
            File f = new File(s);
            String[] arr = f.list();
            if (arr != null) {
                this._processNumOpenFds = arr.length;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readProcessStatusFile(String pid) {
        try {
            String s = "/proc/" + pid + "/status";
            this._processStatus = this.readFile(new File(s));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parseProcessStatusFile(String s) {
        if (s == null) {
            return;
        }
        try {
            Pattern p = Pattern.compile("Cpus_allowed:\\s+([A-Fa-f0-9,]+)");
            Matcher m = p.matcher(s);
            boolean b = m.find();
            if (!b) {
                return;
            }
            this._processCpusAllowed = LinuxProcFileReader.numSetBitsHex(m.group(1));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        String sysTestData = "cpu  43559117 24094 1632164 1033740407 245624 29 200080 0 0 0\ncpu0 1630761 1762 62861 31960072 40486 15 10614 0 0 0\ncpu1 1531923 86 62987 32118372 13190 0 6806 0 0 0\ncpu2 1436788 332 66513 32210723 10867 0 6772 0 0 0\ncpu3 1428700 1001 64574 32223156 8751 0 6811 0 0 0\ncpu4 1424410 152 62649 32232602 6552 0 6836 0 0 0\ncpu5 1427172 1478 58744 32233938 5471 0 6708 0 0 0\ncpu6 1418433 348 60957 32241807 5301 0 6639 0 0 0\ncpu7 1404882 182 60640 32258150 3847 0 6632 0 0 0\ncpu8 1485698 3593 67154 32101739 38387 0 9016 0 0 0\ncpu9 1422404 1601 66489 32193865 15133 0 8800 0 0 0\ncpu10 1383939 3386 69151 32233567 11219 0 8719 0 0 0\ncpu11 1376904 3051 65256 32246197 8307 0 8519 0 0 0\ncpu12 1381437 1496 68003 32237894 6966 0 8676 0 0 0\ncpu13 1376250 1527 66598 32247951 7020 0 8554 0 0 0\ncpu14 1364352 1573 65520 32262764 5093 0 8531 0 0 0\ncpu15 1359076 1176 64380 32269336 5219 0 8593 0 0 0\ncpu16 1363844 6 29612 32344252 4830 2 4366 0 0 0\ncpu17 1477797 1019 70211 32190189 6278 0 3731 0 0 0\ncpu18 1285849 30 29219 32428612 3549 0 3557 0 0 0\ncpu19 1272308 0 27306 32445340 2089 0 3541 0 0 0\ncpu20 1326369 5 29152 32386824 2458 0 4416 0 0 0\ncpu21 1320883 28 31886 32384709 2327 1 4869 0 0 0\ncpu22 1259498 1 26954 32458931 2247 0 3511 0 0 0\ncpu23 1279464 0 26694 32439550 1914 0 3571 0 0 0\ncpu24 1229977 19 32308 32471217 4191 0 4732 0 0 0\ncpu25 1329079 92 79253 32324092 5267 0 4821 0 0 0\ncpu26 1225922 30 34837 32475220 4000 0 4711 0 0 0\ncpu27 1261848 56 43928 32397341 3552 0 5625 0 0 0\ncpu28 1226707 20 36281 32463498 3935 4 5943 0 0 0\ncpu29 1379751 19 35593 32317723 2872 4 5913 0 0 0\ncpu30 1247661 0 32636 32455845 2033 0 4775 0 0 0\ncpu31 1219016 10 33804 32484916 2254 0 4756 0 0 0\nintr 840450413 1194 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 55 0 0 0 0 0 0 45 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 593665 88058 57766 41441 62426 61320 39848 39787 522984 116724 99144 95021 113975 99093 78676 78144 0 168858 168858 168858 162 2986764 4720950 3610168 5059579 3251008 2765017 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 00 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 00 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 00 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 00 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 00 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 00 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 00 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 00 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\nctxt 1506565570\nbtime 1385196580\nprocesses 1226464\nprocs_running 21\nprocs_blocked 0\nsoftirq 793917930 0 156954983 77578 492842649 1992553 0 7758971 51856558 228040 82206598\n";
        String procTestData = "16790 (java) S 1 16789 16789 0 -1 4202496 6714145 0 0 0 4773058 5391 0 0 20 0 110 0 33573283 64362651648 6467228 18446744073709551615 1073741824 1073778376 140734614041280 140734614032416 140242897981768 0 0 3 16800972 18446744073709551615 0 0 17 27 0 0 0 0 0\n";
        LinuxProcFileReader lpfr = new LinuxProcFileReader();
        lpfr.parseSystemProcFile("cpu  43559117 24094 1632164 1033740407 245624 29 200080 0 0 0\ncpu0 1630761 1762 62861 31960072 40486 15 10614 0 0 0\ncpu1 1531923 86 62987 32118372 13190 0 6806 0 0 0\ncpu2 1436788 332 66513 32210723 10867 0 6772 0 0 0\ncpu3 1428700 1001 64574 32223156 8751 0 6811 0 0 0\ncpu4 1424410 152 62649 32232602 6552 0 6836 0 0 0\ncpu5 1427172 1478 58744 32233938 5471 0 6708 0 0 0\ncpu6 1418433 348 60957 32241807 5301 0 6639 0 0 0\ncpu7 1404882 182 60640 32258150 3847 0 6632 0 0 0\ncpu8 1485698 3593 67154 32101739 38387 0 9016 0 0 0\ncpu9 1422404 1601 66489 32193865 15133 0 8800 0 0 0\ncpu10 1383939 3386 69151 32233567 11219 0 8719 0 0 0\ncpu11 1376904 3051 65256 32246197 8307 0 8519 0 0 0\ncpu12 1381437 1496 68003 32237894 6966 0 8676 0 0 0\ncpu13 1376250 1527 66598 32247951 7020 0 8554 0 0 0\ncpu14 1364352 1573 65520 32262764 5093 0 8531 0 0 0\ncpu15 1359076 1176 64380 32269336 5219 0 8593 0 0 0\ncpu16 1363844 6 29612 32344252 4830 2 4366 0 0 0\ncpu17 1477797 1019 70211 32190189 6278 0 3731 0 0 0\ncpu18 1285849 30 29219 32428612 3549 0 3557 0 0 0\ncpu19 1272308 0 27306 32445340 2089 0 3541 0 0 0\ncpu20 1326369 5 29152 32386824 2458 0 4416 0 0 0\ncpu21 1320883 28 31886 32384709 2327 1 4869 0 0 0\ncpu22 1259498 1 26954 32458931 2247 0 3511 0 0 0\ncpu23 1279464 0 26694 32439550 1914 0 3571 0 0 0\ncpu24 1229977 19 32308 32471217 4191 0 4732 0 0 0\ncpu25 1329079 92 79253 32324092 5267 0 4821 0 0 0\ncpu26 1225922 30 34837 32475220 4000 0 4711 0 0 0\ncpu27 1261848 56 43928 32397341 3552 0 5625 0 0 0\ncpu28 1226707 20 36281 32463498 3935 4 5943 0 0 0\ncpu29 1379751 19 35593 32317723 2872 4 5913 0 0 0\ncpu30 1247661 0 32636 32455845 2033 0 4775 0 0 0\ncpu31 1219016 10 33804 32484916 2254 0 4756 0 0 0\nintr 840450413 1194 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 55 0 0 0 0 0 0 45 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 593665 88058 57766 41441 62426 61320 39848 39787 522984 116724 99144 95021 113975 99093 78676 78144 0 168858 168858 168858 162 2986764 4720950 3610168 5059579 3251008 2765017 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 00 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 00 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 00 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 00 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 00 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 00 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 00 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 00 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\nctxt 1506565570\nbtime 1385196580\nprocesses 1226464\nprocs_running 21\nprocs_blocked 0\nsoftirq 793917930 0 156954983 77578 492842649 1992553 0 7758971 51856558 228040 82206598\n");
        lpfr.parseProcessProcFile("16790 (java) S 1 16789 16789 0 -1 4202496 6714145 0 0 0 4773058 5391 0 0 20 0 110 0 33573283 64362651648 6467228 18446744073709551615 1073741824 1073778376 140734614041280 140734614032416 140242897981768 0 0 3 16800972 18446744073709551615 0 0 17 27 0 0 0 0 0\n");
        System.out.println("System idle ticks: " + lpfr.getSystemIdleTicks());
        System.out.println("System total ticks: " + lpfr.getSystemTotalTicks());
        System.out.println("Process total ticks: " + lpfr.getProcessTotalTicks());
        System.out.println("Process RSS: " + lpfr.getProcessRss());
        System.out.println("Number of cpus: " + lpfr.getCpuTicks().length);
    }
}

