/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.Distribution;
import hex.MeanResidualDeviance;
import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsSupervised;
import hex.genmodel.utils.DistributionFamily;
import water.IcedUtils;
import water.MRTask;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.MathUtils;

public class ModelMetricsRegression
extends ModelMetricsSupervised {
    public final double _mean_residual_deviance;
    public final double _mean_absolute_error;
    public final double _root_mean_squared_log_error;

    public double residual_deviance() {
        return this._mean_residual_deviance;
    }

    public double mean_residual_deviance() {
        return this._mean_residual_deviance;
    }

    public double mae() {
        return this._mean_absolute_error;
    }

    public double rmsle() {
        return this._root_mean_squared_log_error;
    }

    public ModelMetricsRegression(Model model, Frame frame, long nobs, double mse, double sigma, double mae, double rmsle, double meanResidualDeviance) {
        super(model, frame, nobs, mse, null, sigma);
        this._mean_residual_deviance = meanResidualDeviance;
        this._mean_absolute_error = mae;
        this._root_mean_squared_log_error = rmsle;
    }

    public static ModelMetricsRegression getFromDKV(Model model, Frame frame) {
        ModelMetrics mm = ModelMetrics.getFromDKV(model, frame);
        if (!(mm instanceof ModelMetricsRegression)) {
            throw new H2OIllegalArgumentException("Expected to find a Regression ModelMetrics for model: " + model._key.toString() + " and frame: " + frame._key.toString(), "Expected to find a ModelMetricsRegression for model: " + model._key.toString() + " and frame: " + frame._key.toString() + " but found a: " + mm.getClass());
        }
        return (ModelMetricsRegression)mm;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" mean residual deviance: " + (float)this._mean_residual_deviance + "\n");
        sb.append(" mean absolute error: " + (float)this._mean_absolute_error + "\n");
        sb.append(" root mean squared log error: " + (float)this._root_mean_squared_log_error + "\n");
        return sb.toString();
    }

    public static ModelMetricsRegression make(Vec predicted, Vec actual, DistributionFamily family) {
        if (predicted == null || actual == null) {
            throw new IllegalArgumentException("Missing actual or predicted targets for regression metrics!");
        }
        if (!predicted.isNumeric()) {
            throw new IllegalArgumentException("Predicted values must be numeric for regression metrics.");
        }
        if (!actual.isNumeric()) {
            throw new IllegalArgumentException("Actual values must be numeric for regression metrics.");
        }
        if (family == DistributionFamily.quantile || family == DistributionFamily.tweedie || family == DistributionFamily.huber) {
            throw new IllegalArgumentException("Unsupported distribution family, requires additional parameters which cannot be specified right now.");
        }
        Frame predsActual = new Frame(predicted);
        predsActual.add("actual", actual);
        MetricBuilderRegression mb = ((RegressionMetrics)new RegressionMetrics((DistributionFamily)family).doAll((Frame)predsActual))._mb;
        ModelMetricsRegression mm = (ModelMetricsRegression)mb.makeModelMetrics(null, predsActual, null, null);
        mm._description = "Computed on user-given predictions and targets, distribution: " + (family == null ? DistributionFamily.gaussian.toString() : family.toString()) + ".";
        return mm;
    }

    public static double computeHuberDelta(Vec actual, Vec preds, Vec weight, double huberAlpha) {
        Vec absdiff = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs, NewChunk[] nc) {
                for (int i = 0; i < cs[0].len(); ++i) {
                    nc[0].addNum(Math.abs(cs[0].atd(i) - cs[1].atd(i)));
                }
            }
        }.doAll(1, (byte)3, new Frame(new String[]{"preds", "actual"}, new Vec[]{preds, actual}))).outputFrame().anyVec();
        double hd = MathUtils.computeWeightedQuantile(weight, absdiff, huberAlpha);
        absdiff.remove();
        return hd;
    }

    public static class MetricBuilderRegression<T extends MetricBuilderRegression<T>>
    extends ModelMetricsSupervised.MetricBuilderSupervised<T> {
        double _sumdeviance;
        Distribution _dist;
        double _abserror;
        double _rmslerror;

        public MetricBuilderRegression() {
            super(1, null);
        }

        public MetricBuilderRegression(Distribution dist) {
            super(1, null);
            this._dist = dist;
        }

        @Override
        public double[] perRow(double[] ds, float[] yact, Model m) {
            return this.perRow(ds, yact, 1.0, 0.0, m);
        }

        @Override
        public double[] perRow(double[] ds, float[] yact, double w, double o, Model m) {
            if (Float.isNaN(yact[0])) {
                return ds;
            }
            if (ArrayUtils.hasNaNs(ds)) {
                return ds;
            }
            if (w == 0.0 || Double.isNaN(w)) {
                return ds;
            }
            double err = (double)yact[0] - ds[0];
            double err_msle = Math.pow(Math.log1p(ds[0]) - Math.log1p(yact[0]), 2.0);
            this._sumsqe += w * err * err;
            this._abserror += w * Math.abs(err);
            this._rmslerror += w * err_msle;
            assert (!Double.isNaN(this._sumsqe));
            if (m != null && ((Model.Parameters)m._parms)._distribution != DistributionFamily.huber) {
                this._sumdeviance += m.deviance(w, yact[0], ds[0]);
            } else if (this._dist != null) {
                this._sumdeviance += this._dist.deviance(w, yact[0], ds[0]);
            }
            ++this._count;
            this._wcount += w;
            this._wY += w * (double)yact[0];
            this._wYY += w * (double)yact[0] * (double)yact[0];
            return ds;
        }

        @Override
        public void reduce(T mb) {
            super.reduce(mb);
            this._sumdeviance += ((MetricBuilderRegression)mb)._sumdeviance;
            this._abserror += ((MetricBuilderRegression)mb)._abserror;
            this._rmslerror += ((MetricBuilderRegression)mb)._rmslerror;
        }

        @Override
        public ModelMetrics makeModelMetrics(Model m, Frame f, Frame adaptedFrame, Frame preds) {
            double mse = this._sumsqe / this._wcount;
            double mae = this._abserror / this._wcount;
            double rmsle = Math.sqrt(this._rmslerror / this._wcount);
            if (adaptedFrame == null) {
                adaptedFrame = f;
            }
            double meanResDeviance = 0.0;
            if (m != null && ((Model.Parameters)m._parms)._distribution == DistributionFamily.huber) {
                assert (this._sumdeviance == 0.0);
                if (preds != null) {
                    Vec actual = adaptedFrame.vec(((Model.Parameters)m._parms)._response_column);
                    Vec weight = adaptedFrame.vec(((Model.Parameters)m._parms)._weights_column);
                    double huberDelta = ModelMetricsRegression.computeHuberDelta(actual, preds.anyVec(), weight, ((Model.Parameters)m._parms)._huber_alpha);
                    this._dist = IcedUtils.deepCopy(m._dist);
                    this._dist.setHuberDelta(huberDelta);
                    meanResDeviance = new MeanResidualDeviance((Distribution)this._dist, (Vec)preds.anyVec(), (Vec)actual, (Vec)weight).exec().meanResidualDeviance;
                }
            } else {
                meanResDeviance = this._sumdeviance / this._wcount;
            }
            ModelMetricsRegression mm = new ModelMetricsRegression(m, f, this._count, mse, this.weightedSigma(), mae, rmsle, meanResDeviance);
            if (m != null) {
                m.addModelMetrics(mm);
            }
            return mm;
        }
    }

    private static class RegressionMetrics
    extends MRTask<RegressionMetrics> {
        public MetricBuilderRegression _mb;
        final Distribution _distribution;

        RegressionMetrics(DistributionFamily family) {
            this._distribution = family == null ? new Distribution(DistributionFamily.gaussian) : new Distribution(family);
        }

        @Override
        public void map(Chunk[] chks) {
            this._mb = new MetricBuilderRegression(this._distribution);
            Chunk preds = chks[0];
            Chunk actuals = chks[1];
            double[] ds = new double[1];
            for (int i = 0; i < chks[0]._len; ++i) {
                ds[0] = preds.atd(i);
                this._mb.perRow(ds, new float[]{(float)actuals.atd(i)}, null);
            }
        }

        @Override
        public void reduce(RegressionMetrics mrt) {
            this._mb.reduce(mrt._mb);
        }
    }
}

