/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ServiceLoader;
import water.AbstractH2OExtension;
import water.H2O;
import water.api.RequestServer;
import water.api.RestApiExtension;
import water.api.SchemaServer;
import water.util.Log;

public class ExtensionManager {
    private static ExtensionManager extManager = new ExtensionManager();
    private HashMap<String, AbstractH2OExtension> coreExtensions = new HashMap();
    private HashMap<String, RestApiExtension> restApiExtensions = new HashMap();
    private long registerCoreExtensionsMillis = 0L;
    private boolean extensionsRegistered = false;
    private boolean restApiExtensionsRegistered = false;

    private ExtensionManager() {
    }

    public static ExtensionManager getInstance() {
        return extManager;
    }

    public Collection<AbstractH2OExtension> getCoreExtensions() {
        return this.coreExtensions.values();
    }

    public boolean isCoreExtensionsEnabled(String extensionName) {
        AbstractH2OExtension ext = this.coreExtensions.get(extensionName);
        return ext != null && ext.isEnabled();
    }

    public void registerCoreExtensions() {
        if (this.extensionsRegistered) {
            throw H2O.fail("Extensions already registered");
        }
        long before = System.currentTimeMillis();
        ServiceLoader<AbstractH2OExtension> extensionsLoader = ServiceLoader.load(AbstractH2OExtension.class);
        for (AbstractH2OExtension ext : extensionsLoader) {
            if (!ext.isEnabled()) continue;
            ext.init();
            this.coreExtensions.put(ext.getExtensionName(), ext);
        }
        this.extensionsRegistered = true;
        this.registerCoreExtensionsMillis = System.currentTimeMillis() - before;
    }

    public Collection<RestApiExtension> getRestApiExtensions() {
        return this.restApiExtensions.values();
    }

    private boolean areDependantCoreExtensionsEnabled(List<String> names) {
        for (String name : names) {
            AbstractH2OExtension ext = this.coreExtensions.get(name);
            if (ext != null && ext.isEnabled()) continue;
            return false;
        }
        return true;
    }

    public void registerRestApiExtensions() {
        if (this.restApiExtensionsRegistered) {
            throw H2O.fail("APIs already registered");
        }
        for (AbstractH2OExtension e : this.getCoreExtensions()) {
            e.printInitialized();
        }
        Log.info("Registered " + this.coreExtensions.size() + " core extensions in: " + this.registerCoreExtensionsMillis + "ms");
        Log.info("Registered H2O core extensions: " + Arrays.toString(this.getCoreExtensionNames()));
        long before = System.currentTimeMillis();
        RequestServer.DummyRestApiContext dummyRestApiContext = new RequestServer.DummyRestApiContext();
        ServiceLoader<RestApiExtension> restApiExtensionLoader = ServiceLoader.load(RestApiExtension.class);
        for (RestApiExtension r : restApiExtensionLoader) {
            try {
                if (!this.areDependantCoreExtensionsEnabled(r.getRequiredCoreExtensions())) continue;
                r.registerEndPoints(dummyRestApiContext);
                r.registerSchemas(dummyRestApiContext);
                this.restApiExtensions.put(r.getName(), r);
            }
            catch (Exception e) {
                Log.info("Cannot register extension: " + r + ". Skipping it...");
            }
        }
        this.restApiExtensionsRegistered = true;
        long registerApisMillis = System.currentTimeMillis() - before;
        Log.info("Registered: " + RequestServer.numRoutes() + " REST APIs in: " + registerApisMillis + "ms");
        Log.info("Registered REST API extensions: " + Arrays.toString(this.getRestApiExtensionNames()));
        SchemaServer.registerAllSchemasIfNecessary(dummyRestApiContext.getAllSchemas());
    }

    private String[] getRestApiExtensionNames() {
        return this.restApiExtensions.keySet().toArray(new String[this.restApiExtensions.keySet().size()]);
    }

    private String[] getCoreExtensionNames() {
        return this.coreExtensions.keySet().toArray(new String[this.coreExtensions.keySet().size()]);
    }
}

