/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.Model;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import water.DKV;
import water.Futures;
import water.Iced;
import water.Key;
import water.KeySnapshot;
import water.Value;
import water.api.Handler;
import water.api.SchemaServer;
import water.api.schemas3.FrameBaseV3;
import water.api.schemas3.FrameV3;
import water.api.schemas3.FramesV3;
import water.api.schemas3.JobV3;
import water.api.schemas3.ModelSchemaV3;
import water.api.schemas3.SchemaV3;
import water.exceptions.H2OColumnNotFoundArgumentException;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OKeyNotFoundArgumentException;
import water.exceptions.H2OKeyWrongTypeArgumentException;
import water.exceptions.H2OKeysNotFoundArgumentException;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.Log;

public class FramesHandler<I extends Frames, S extends SchemaV3<I, S>>
extends Handler {
    public FramesV3 list(int version, FramesV3 s) {
        Frames f = (Frames)s.createAndFillImpl();
        f.frames = Frame.fetchAll();
        s.fillFromImplWithSynopsis(f);
        return s;
    }

    public FramesV3 columns(int version, FramesV3 s) {
        return this.fetch(version, s);
    }

    public static Frame getFromDKV(String param_name, String key_str) {
        return FramesHandler.getFromDKV(param_name, Key.make(key_str));
    }

    public static Frame getFromDKV(String param_name, Key key) {
        if (null == key) {
            throw new H2OIllegalArgumentException(param_name, "Frames.getFromDKV()", null);
        }
        Value v = DKV.get(key);
        if (null == v) {
            throw new H2OKeyNotFoundArgumentException(param_name, key.toString());
        }
        Object ice = v.get();
        if (ice instanceof Vec) {
            return new Frame((Vec)ice);
        }
        if (!(ice instanceof Frame)) {
            throw new H2OKeyWrongTypeArgumentException(param_name, key.toString(), Frame.class, ice.getClass());
        }
        return (Frame)ice;
    }

    public FramesV3 column(int version, FramesV3 s) {
        Frame frame = FramesHandler.getFromDKV("key", s.frame_id.key());
        Vec vec = frame.vec(s.column);
        if (null == vec) {
            throw new H2OColumnNotFoundArgumentException("column", s.frame_id.toString(), s.column);
        }
        Vec[] vecs = new Vec[]{vec};
        String[] names = new String[]{s.column};
        Frame new_frame = new Frame(names, vecs);
        s.frames = new FrameV3[1];
        s.frames[0] = new FrameV3().fillFromImpl(new_frame);
        ((FrameV3)s.frames[0]).clearBinsField();
        return s;
    }

    public FramesV3 columnDomain(int version, FramesV3 s) {
        Frame frame = FramesHandler.getFromDKV("key", s.frame_id.key());
        Vec vec = frame.vec(s.column);
        if (vec == null) {
            throw new H2OColumnNotFoundArgumentException("column", s.frame_id.toString(), s.column);
        }
        s.domain = new String[1][];
        s.domain[0] = vec.domain();
        return s;
    }

    public FramesV3 columnSummary(int version, FramesV3 s) {
        Frame frame = FramesHandler.getFromDKV("key", s.frame_id.key());
        Vec vec = frame.vec(s.column);
        if (null == vec) {
            throw new H2OColumnNotFoundArgumentException("column", s.frame_id.toString(), s.column);
        }
        vec.bins();
        s.frames = new FrameV3[1];
        s.frames[0] = new FrameV3().fillFromImpl(new Frame(new String[]{s.column}, new Vec[]{vec}), s.row_offset, s.row_count, s.column_offset, s.column_count);
        return s;
    }

    public FramesV3 fetch(int version, FramesV3 s) {
        FramesV3 frames = this.doFetch(version, s);
        for (FrameBaseV3 a_frame : frames.frames) {
            ((FrameV3)a_frame).clearBinsField();
        }
        return frames;
    }

    private FramesV3 doFetch(int version, FramesV3 s) {
        s.createAndFillImpl();
        Frame frame = FramesHandler.getFromDKV("key", s.frame_id.key());
        s.frames = new FrameV3[1];
        s.frames[0] = new FrameV3(frame, s.row_offset, s.row_count).fillFromImpl(frame, s.row_offset, s.row_count, s.column_offset, s.column_count);
        if (s.find_compatible_models) {
            Model[] compatible = Frames.findCompatibleModels(frame, Model.fetchAll());
            s.compatible_models = new ModelSchemaV3[compatible.length];
            ((FrameV3)s.frames[0]).compatible_models = new String[compatible.length];
            int i = 0;
            for (Model m : compatible) {
                s.compatible_models[i] = (ModelSchemaV3)SchemaServer.schema(version, m).fillFromImpl(m);
                ((FrameV3)s.frames[0]).compatible_models[i] = m._key.toString();
                ++i;
            }
        }
        return s;
    }

    public FramesV3 export(int version, FramesV3 s) {
        Frame fr = FramesHandler.getFromDKV("key", s.frame_id.key());
        Log.info("ExportFiles processing (" + s.path + ")");
        s.job = new JobV3(Frame.export(fr, s.path, s.frame_id.key().toString(), s.force, s.num_parts));
        return s;
    }

    public FramesV3 summary(int version, FramesV3 s) {
        Frame frame = FramesHandler.getFromDKV("key", s.frame_id.key());
        if (null != frame) {
            Futures fs = new Futures();
            int i = 0;
            for (Vec v : frame.vecs()) {
                if (null == DKV.get(v._key)) {
                    Log.warn("For Frame: " + frame._key + ", Vec number: " + i + " (" + frame.name(i) + ") is missing; not returning it.");
                } else {
                    v.startRollupStats(fs, true);
                }
                ++i;
            }
            fs.blockForPending();
        }
        return this.doFetch(version, s);
    }

    public FramesV3 delete(int version, FramesV3 frames) {
        Frame frame = FramesHandler.getFromDKV("key", frames.frame_id.key());
        frame.delete();
        return frames;
    }

    public FramesV3 deleteAll(int version, FramesV3 frames) {
        Key[] keys = KeySnapshot.globalKeysOfClass(Frame.class);
        ArrayList<String> missing = new ArrayList<String>();
        Futures fs = new Futures();
        for (Key key : keys) {
            try {
                FramesHandler.getFromDKV("(none)", key).delete(null, fs);
            }
            catch (IllegalArgumentException iae) {
                missing.add(key.toString());
            }
        }
        fs.blockForPending();
        if (missing.size() != 0) {
            throw new H2OKeysNotFoundArgumentException("(none)", missing.toArray(new String[missing.size()]));
        }
        return frames;
    }

    public static final class Frames
    extends Iced {
        public Key<Frame> frame_id;
        public long row_offset;
        public int row_count;
        public Frame[] frames;
        public String column;
        public boolean find_compatible_models = false;

        protected static Map<Model, Set<String>> fetchModelCols(Model[] all_models) {
            HashMap<Model, Set<String>> all_models_cols = new HashMap<Model, Set<String>>();
            for (Model m : all_models) {
                all_models_cols.put(m, new HashSet<String>(Arrays.asList(((Model.Output)m._output)._names)));
            }
            return all_models_cols;
        }

        private static Model[] findCompatibleModels(Frame frame, Model[] all_models) {
            Map<Model, Set<String>> all_models_cols = Frames.fetchModelCols(all_models);
            ArrayList<Model> compatible_models = new ArrayList<Model>();
            HashSet<String> frame_column_names = new HashSet<String>(Arrays.asList(frame._names));
            for (Map.Entry<Model, Set<String>> entry : all_models_cols.entrySet()) {
                Model model = entry.getKey();
                Set<String> model_cols = entry.getValue();
                if (!frame_column_names.containsAll(model_cols)) continue;
                try {
                    if (model.adaptTestForTrain(new Frame(frame), false, false).length != 0) continue;
                    compatible_models.add(model);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return compatible_models.toArray(new Model[compatible_models.size()]);
        }
    }
}

