/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.Date;
import java.util.UUID;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.Iced;
import water.Value;
import water.fvec.C4VolatileChunk;
import water.fvec.C8DVolatileChunk;
import water.fvec.ChunkVisitor;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;

public abstract class Chunk
extends Iced<Chunk>
implements Vec.Holder {
    transient long _start = -1L;
    transient int _cidx = -1;
    public transient int _len;
    private transient Chunk _chk2;
    transient Vec _vec;
    byte[] _mem;

    public Chunk() {
    }

    private Chunk(byte[] bytes) {
        this._mem = bytes;
        this.initFromBytes();
    }

    public final long start() {
        return this._start;
    }

    int set_len(int len) {
        this._len = len;
        return this._len;
    }

    public int len() {
        return this._len;
    }

    public Chunk chk2() {
        return this._chk2;
    }

    @Override
    public Vec vec() {
        return this._vec;
    }

    public void setVec(Vec vec) {
        this._vec = vec;
    }

    public void setStart(long start) {
        this._start = start;
    }

    public byte[] getBytes() {
        return this._mem;
    }

    public void setBytes(byte[] mem) {
        this._mem = mem;
    }

    final long at8_abs(long i) {
        long x = i - (this._start > 0L ? this._start : 0L);
        if (0L <= x && x < (long)this._len) {
            return this.at8((int)x);
        }
        throw new ArrayIndexOutOfBoundsException("" + this._start + " <= " + i + " < " + (this._start + (long)this._len));
    }

    final double at_abs(long i) {
        long x = i - (this._start > 0L ? this._start : 0L);
        if (0L <= x && x < (long)this._len) {
            return this.atd((int)x);
        }
        throw new ArrayIndexOutOfBoundsException("" + this._start + " <= " + i + " < " + (this._start + (long)this._len));
    }

    final boolean isNA_abs(long i) {
        long x = i - (this._start > 0L ? this._start : 0L);
        if (0L <= x && x < (long)this._len) {
            return this.isNA((int)x);
        }
        throw new ArrayIndexOutOfBoundsException("" + this._start + " <= " + i + " < " + (this._start + (long)this._len));
    }

    final long at16l_abs(long i) {
        long x = i - (this._start > 0L ? this._start : 0L);
        if (0L <= x && x < (long)this._len) {
            return this.at16l((int)x);
        }
        throw new ArrayIndexOutOfBoundsException("" + this._start + " <= " + i + " < " + (this._start + (long)this._len));
    }

    final long at16h_abs(long i) {
        long x = i - (this._start > 0L ? this._start : 0L);
        if (0L <= x && x < (long)this._len) {
            return this.at16h((int)x);
        }
        throw new ArrayIndexOutOfBoundsException("" + this._start + " <= " + i + " < " + (this._start + (long)this._len));
    }

    final BufferedString atStr_abs(BufferedString bStr, long i) {
        long x = i - (this._start > 0L ? this._start : 0L);
        if (0L <= x && x < (long)this._len) {
            return this.atStr(bStr, (int)x);
        }
        throw new ArrayIndexOutOfBoundsException("" + this._start + " <= " + i + " < " + (this._start + (long)this._len));
    }

    public final double atd(int i) {
        return this._chk2 == null ? this.atd_impl(i) : this._chk2.atd_impl(i);
    }

    public final long at8(int i) {
        return this._chk2 == null ? this.at8_impl(i) : this._chk2.at8_impl(i);
    }

    public final boolean isNA(int i) {
        return this._chk2 == null ? this.isNA_impl(i) : this._chk2.isNA_impl(i);
    }

    public final long at16l(int i) {
        return this._chk2 == null ? this.at16l_impl(i) : this._chk2.at16l_impl(i);
    }

    public final long at16h(int i) {
        return this._chk2 == null ? this.at16h_impl(i) : this._chk2.at16h_impl(i);
    }

    public final BufferedString atStr(BufferedString bStr, int i) {
        return this._chk2 == null ? this.atStr_impl(bStr, i) : this._chk2.atStr_impl(bStr, i);
    }

    public String stringAt(int i) {
        return this.atStr(new BufferedString(), i).toString();
    }

    final void set_abs(long i, long l) {
        long x = i - this._start;
        if (0L <= x && x < (long)this._len) {
            this.set((int)x, l);
        } else {
            this._vec.set(i, l);
        }
    }

    final void set_abs(long i, double d) {
        long x = i - this._start;
        if (0L <= x && x < (long)this._len) {
            this.set((int)x, d);
        } else {
            this._vec.set(i, d);
        }
    }

    final void set_abs(long i, float f) {
        long x = i - this._start;
        if (0L <= x && x < (long)this._len) {
            this.set((int)x, f);
        } else {
            this._vec.set(i, f);
        }
    }

    final void setNA_abs(long i) {
        long x = i - this._start;
        if (0L <= x && x < (long)this._len) {
            this.setNA((int)x);
        } else {
            this._vec.setNA(i);
        }
    }

    public final void set_abs(long i, String str) {
        long x = i - this._start;
        if (0L <= x && x < (long)this._len) {
            this.set((int)x, str);
        } else {
            this._vec.set(i, str);
        }
    }

    public final void set_abs(long i, UUID uuid) {
        long x = i - this._start;
        if (0L <= x && x < (long)this._len) {
            this.set((int)x, uuid);
        } else {
            this._vec.set(i, uuid);
        }
    }

    public boolean hasFloat() {
        return true;
    }

    public boolean hasNA() {
        return true;
    }

    public void replaceAll(Chunk replacement) {
        assert (this._len == replacement._len);
        this._vec.preWriting();
        this._chk2 = replacement;
        assert (this._chk2._chk2 == null);
    }

    public Chunk deepCopy() {
        Chunk c2 = (Chunk)this.clone();
        c2._vec = null;
        c2._start = -1L;
        c2._cidx = -1;
        c2._mem = (byte[])this._mem.clone();
        c2.initFromBytes();
        assert (this.len() == c2._len);
        return c2;
    }

    private void setWrite() {
        if (this._chk2 != null) {
            return;
        }
        assert (!(this instanceof NewChunk)) : "Cannot direct-write into a NewChunk, only append";
        this.setWrite((Chunk)this.clone());
    }

    private void setWrite(Chunk ck) {
        assert (this._chk2 == null);
        this._vec.preWriting();
        this._chk2 = ck;
        assert (this._chk2._chk2 == null);
    }

    public final long set(int idx, long l) {
        this.setWrite();
        if (this._chk2.set_impl(idx, l)) {
            return l;
        }
        this._chk2 = this.inflate();
        this._chk2.set_impl(idx, l);
        return l;
    }

    public final double[] set(double[] d) {
        assert (d.length == this._len && this._chk2 == null);
        this.setWrite(new NewChunk(this, d));
        return d;
    }

    public final double set(int idx, double d) {
        this.setWrite();
        if (this._chk2.set_impl(idx, d)) {
            return d;
        }
        this._chk2 = this.inflate();
        this._chk2.set_impl(idx, d);
        return d;
    }

    public final float set(int idx, float f) {
        this.setWrite();
        if (this._chk2.set_impl(idx, f)) {
            return f;
        }
        this._chk2 = this.inflate();
        this._chk2.set_impl(idx, f);
        return f;
    }

    public final boolean setNA(int idx) {
        this.setWrite();
        if (this._chk2.setNA_impl(idx)) {
            return true;
        }
        this._chk2 = this.inflate();
        this._chk2.setNA_impl(idx);
        return true;
    }

    public final String set(int idx, String str) {
        this.setWrite();
        if (this._chk2.set_impl(idx, str)) {
            return str;
        }
        this._chk2 = this.inflate();
        this._chk2.set_impl(idx, str);
        return str;
    }

    public final UUID set(int idx, UUID uuid) {
        this.setWrite();
        long lo = uuid.getLeastSignificantBits();
        long hi = uuid.getMostSignificantBits();
        if (this._chk2.set_impl(idx, lo, hi)) {
            return uuid;
        }
        this._chk2 = this.inflate();
        this._chk2.set_impl(idx, lo, hi);
        return uuid;
    }

    private Object setUnknown(int idx) {
        this.setNA(idx);
        return null;
    }

    public final Object setAny(int idx, Object x) {
        return x instanceof String ? this.set(idx, (String)x) : (x instanceof Double ? Double.valueOf(this.set(idx, (Double)x)) : (x instanceof Float ? Float.valueOf(this.set(idx, ((Float)x).floatValue())) : (x instanceof Long ? Long.valueOf(this.set(idx, (Long)x)) : (x instanceof Integer ? Long.valueOf(this.set(idx, ((Integer)x).longValue())) : (x instanceof UUID ? this.set(idx, (UUID)x) : (x instanceof Date ? Long.valueOf(this.set(idx, ((Date)x).getTime())) : this.setUnknown(idx)))))));
    }

    public Futures close(int cidx, Futures fs) {
        if (this instanceof NewChunk) {
            this._chk2 = this;
        }
        if (this._chk2 == null) {
            return fs;
        }
        if (this._chk2 instanceof NewChunk) {
            this._chk2 = ((NewChunk)this._chk2).new_close();
        }
        DKV.put(this._vec.chunkKey(cidx), this._chk2, fs, true);
        return fs;
    }

    public int cidx() {
        assert (this._cidx != -1) : "Chunk idx was not properly loaded!";
        return this._cidx;
    }

    public final Chunk setVolatile(double[] ds) {
        C8DVolatileChunk res = new C8DVolatileChunk(ds);
        Value v = new Value(this._vec.chunkKey(this._cidx), res, ds.length * 8, 1);
        DKV.put(v._key, v);
        return res;
    }

    public final Chunk setVolatile(int[] vals) {
        C4VolatileChunk res = new C4VolatileChunk(vals);
        Value v = new Value(this._vec.chunkKey(this._cidx), res, vals.length * 4, 1);
        DKV.put(v._key, v);
        return res;
    }

    public boolean isVolatile() {
        return false;
    }

    static WrongType wrongType(Class<?> expected, Class<?> actual) {
        return new WrongType(expected, actual);
    }

    abstract double atd_impl(int var1);

    abstract long at8_impl(int var1);

    abstract boolean isNA_impl(int var1);

    long at16l_impl(int idx) {
        throw Chunk.wrongType(UUID.class, Object.class);
    }

    long at16h_impl(int idx) {
        throw Chunk.wrongType(UUID.class, Object.class);
    }

    BufferedString atStr_impl(BufferedString bStr, int idx) {
        throw new IllegalArgumentException("Not a String");
    }

    abstract boolean set_impl(int var1, long var2);

    abstract boolean set_impl(int var1, double var2);

    abstract boolean set_impl(int var1, float var2);

    abstract boolean setNA_impl(int var1);

    boolean set_impl(int idx, String str) {
        return false;
    }

    boolean set_impl(int i, long lo, long hi) {
        return false;
    }

    public boolean isSparseZero() {
        return false;
    }

    public int sparseLenZero() {
        return this._len;
    }

    public int nextNZ(int rid) {
        return rid + 1;
    }

    public int nonzeros(int[] res) {
        int k = 0;
        for (int i = 0; i < this._len; ++i) {
            if (this.atd(i) == 0.0) continue;
            res[k++] = i;
        }
        return k;
    }

    public boolean isSparseNA() {
        return false;
    }

    public int sparseLenNA() {
        return this._len;
    }

    public int nextNNA(int rid) {
        return rid + 1;
    }

    public int nonnas(int[] res) {
        for (int i = 0; i < this._len; ++i) {
            res[i] = i;
        }
        return this._len;
    }

    double min() {
        return Double.NaN;
    }

    double max() {
        return Double.NaN;
    }

    public final NewChunk inflate() {
        return this.extractRows(new NewChunk(this), 0, this._len);
    }

    public Chunk nextChunk() {
        return this._vec.nextChunk(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._start + ".." + (this._start + (long)this._len - 1L) + "]";
    }

    public long byteSize() {
        long s = this._mem == null ? 0L : (long)this._mem.length;
        s += 68L;
        if (this._chk2 != null) {
            s += this._chk2.byteSize();
        }
        return s;
    }

    public final AutoBuffer write_impl(AutoBuffer bb) {
        return bb.putA1(this._mem);
    }

    @Override
    public byte[] asBytes() {
        return this._mem;
    }

    @Override
    public final Chunk reloadFromBytes(byte[] ary) {
        this._mem = ary;
        this.initFromBytes();
        return this;
    }

    protected abstract void initFromBytes();

    public final Chunk read_impl(AutoBuffer ab) {
        this._mem = ab.getA1();
        this.initFromBytes();
        return this;
    }

    public byte precision() {
        return -1;
    }

    public final void reportBrokenCategorical(int i, int j, long l, int[] cmap, int levels) {
        int k;
        StringBuilder sb = new StringBuilder("Categorical renumber task, column # " + i + ": Found OOB index " + l + " (expected 0 - " + cmap.length + ", global domain has " + levels + " levels) pulled from " + this.getClass().getSimpleName() + "\n");
        for (k = 0; k < Math.min(5, this._len); ++k) {
            sb.append("at8_abs[" + ((long)k + this._start) + "] = " + this.atd(k) + ", _chk2 = " + (this._chk2 != null ? Double.valueOf(this._chk2.atd(k)) : "") + "\n");
        }
        sb.append("...\n");
        for (k = Math.max(k, j - 2); k < Math.min(this._len, j + 2); ++k) {
            sb.append("at8_abs[" + ((long)k + this._start) + "] = " + this.atd(k) + ", _chk2 = " + (this._chk2 != null ? Double.valueOf(this._chk2.atd(k)) : "") + "\n");
        }
        sb.append("...\n");
        for (k = Math.max(k, this._len - 5); k < this._len; ++k) {
            sb.append("at8_abs[" + ((long)k + this._start) + "] = " + this.atd(k) + ", _chk2 = " + (this._chk2 != null ? Double.valueOf(this._chk2.atd(k)) : "") + "\n");
        }
        throw new RuntimeException(sb.toString());
    }

    public abstract <T extends ChunkVisitor> T processRows(T var1, int var2, int var3);

    public abstract <T extends ChunkVisitor> T processRows(T var1, int[] var2);

    public NewChunk extractRows(NewChunk nc, int from, int to) {
        return this.processRows(new ChunkVisitor.NewChunkVisitor((NewChunk)nc), (int)from, (int)to)._nc;
    }

    public NewChunk extractRows(NewChunk nc, int[] rows) {
        return this.processRows(new ChunkVisitor.NewChunkVisitor((NewChunk)nc), (int[])rows)._nc;
    }

    public NewChunk extractRows(NewChunk nc, int row) {
        return this.processRows(new ChunkVisitor.NewChunkVisitor((NewChunk)nc), (int)row, (int)(row + 1))._nc;
    }

    public double[] getDoubles(double[] vals, int from, int to) {
        return this.getDoubles(vals, from, to, Double.NaN);
    }

    public double[] getDoubles(double[] vals, int from, int to, double NA) {
        return this.processRows(new ChunkVisitor.DoubleAryVisitor((double[])vals, (double)NA), (int)from, (int)to).vals;
    }

    public int[] getIntegers(int[] vals, int from, int to, int NA) {
        return this.processRows(new ChunkVisitor.IntAryVisitor((int[])vals, (int)NA), (int)from, (int)to).vals;
    }

    public double[] getDoubles(double[] vals, int[] ids) {
        return this.processRows(new ChunkVisitor.DoubleAryVisitor((double[])vals), (int[])ids).vals;
    }

    public int getSparseDoubles(double[] vals, int[] ids) {
        return this.getSparseDoubles(vals, ids, Double.NaN);
    }

    public int getSparseDoubles(double[] vals, int[] ids, double NA) {
        return this.processRows(new ChunkVisitor.SparseDoubleAryVisitor(vals, ids, this.isSparseNA(), NA), 0, this._len).sparseLen();
    }

    static class WrongType
    extends IllegalArgumentException {
        private final Class<?> expected;
        private final Class<?> actual;

        public WrongType(Class<?> expected, Class<?> actual) {
            super("Expected: " + expected + ", actual: " + actual);
            this.expected = expected;
            this.actual = actual;
        }
    }
}

