/*
 * Decompiled with CFR 0.152.
 */
package water.network;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import water.H2O;
import water.network.SSLContextException;
import water.network.SSLProperties;
import water.network.SSLSocketChannel;
import water.util.Log;

public class SSLSocketChannelFactory {
    private SSLContext sslContext = null;
    private SSLProperties properties = null;

    public SSLSocketChannelFactory() throws SSLContextException {
        try {
            SSLProperties props = new SSLProperties();
            props.load(new FileInputStream(H2O.ARGS.internal_security_conf));
            this.init(props);
        }
        catch (IOException e) {
            Log.err("Failed to initialized SSL context.", e);
            throw new SSLContextException("Failed to initialized SSL context.", e);
        }
    }

    public SSLSocketChannelFactory(SSLProperties props) throws SSLContextException {
        this.init(props);
    }

    private void init(SSLProperties props) throws SSLContextException {
        this.properties = props;
        try {
            if (this.requiredParamsPresent()) {
                this.sslContext = SSLContext.getInstance(this.properties.h2o_ssl_protocol());
                this.sslContext.init(this.keyManager(), this.trustManager(), null);
            } else {
                this.sslContext = SSLContext.getDefault();
            }
        }
        catch (NoSuchAlgorithmException e) {
            Log.err("Failed to initialized SSL context.", e);
            throw new SSLContextException("Failed to initialized SSL context.", e);
        }
        catch (IOException e) {
            Log.err("Failed to initialized SSL context.", e);
            throw new SSLContextException("Failed to initialized SSL context.", e);
        }
        catch (UnrecoverableKeyException e) {
            Log.err("Failed to initialized SSL context.", e);
            throw new SSLContextException("Failed to initialized SSL context.", e);
        }
        catch (KeyStoreException e) {
            Log.err("Failed to initialized SSL context.", e);
            throw new SSLContextException("Failed to initialized SSL context.", e);
        }
        catch (KeyManagementException e) {
            Log.err("Failed to initialized SSL context.", e);
            throw new SSLContextException("Failed to initialized SSL context.", e);
        }
        catch (CertificateException e) {
            Log.err("Failed to initialized SSL context.", e);
            throw new SSLContextException("Failed to initialized SSL context.", e);
        }
    }

    private boolean requiredParamsPresent() {
        return null != this.properties.h2o_ssl_jks_internal() && null != this.properties.h2o_ssl_jks_password();
    }

    private TrustManager[] trustManager() throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        KeyStore ksTrust = KeyStore.getInstance("JKS");
        ksTrust.load(new FileInputStream(this.properties.h2o_ssl_jts()), this.properties.h2o_ssl_jts_password().toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ksTrust);
        return tmf.getTrustManagers();
    }

    private KeyManager[] keyManager() throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore ksKeys = KeyStore.getInstance("JKS");
        ksKeys.load(new FileInputStream(this.properties.h2o_ssl_jks_internal()), this.properties.h2o_ssl_jks_password().toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ksKeys, this.properties.h2o_ssl_jks_password().toCharArray());
        return kmf.getKeyManagers();
    }

    public ByteChannel wrapClientChannel(SocketChannel channel, String host, int port) throws IOException {
        SSLEngine sslEngine = this.sslContext.createSSLEngine(host, port);
        sslEngine.setUseClientMode(false);
        if (null != this.properties.h2o_ssl_enabled_algorithms()) {
            sslEngine.setEnabledCipherSuites(this.properties.h2o_ssl_enabled_algorithms());
        }
        return new SSLSocketChannel(channel, sslEngine);
    }

    public ByteChannel wrapServerChannel(SocketChannel channel) throws IOException {
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        sslEngine.setUseClientMode(true);
        if (null != this.properties.h2o_ssl_enabled_algorithms()) {
            sslEngine.setEnabledCipherSuites(this.properties.h2o_ssl_enabled_algorithms());
        }
        return new SSLSocketChannel(channel, sslEngine);
    }
}

