/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import water.DKV;
import water.Key;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.ByteVec;
import water.fvec.FileVec;
import water.fvec.Frame;
import water.util.Log;
import water.util.UnsafeUtils;

abstract class ZipUtil {
    ZipUtil() {
    }

    static byte[] getFirstUnzippedBytes(ByteVec bv) {
        try {
            byte[] bits = bv.getFirstBytes();
            return ZipUtil.unzipBytes(bits, ZipUtil.guessCompressionMethod(bits), 0x400000);
        }
        catch (Exception e) {
            Log.debug("Cannot get unzipped bytes from ByteVec!", e);
            return null;
        }
    }

    static boolean isZipDirectory(Key key) {
        Object ice = DKV.getGet(key);
        if (ice == null) {
            throw new H2OIllegalArgumentException("Missing data", "Did not find any data under key " + key);
        }
        ByteVec bv = (ByteVec)(ice instanceof ByteVec ? ice : ((Frame)ice).vecs()[0]);
        return ZipUtil.isZipDirectory(bv);
    }

    static boolean isZipDirectory(ByteVec bv) {
        byte[] bits = bv.getFirstBytes();
        Compression compressionMethod = ZipUtil.guessCompressionMethod(bits);
        try {
            if (compressionMethod == Compression.ZIP) {
                ByteArrayInputStream bais = new ByteArrayInputStream(bits);
                ZipInputStream zis = new ZipInputStream(bais);
                ZipEntry ze = zis.getNextEntry();
                boolean isDir = ze.isDirectory();
                zis.close();
                return isDir;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    static ArrayList<String> getFileNames(ByteVec bv) {
        ArrayList<String> fileList = new ArrayList<String>();
        if (bv instanceof FileVec) {
            String strPath = FileVec.getPathForKey(((FileVec)bv)._key);
            try {
                ZipFile zipFile = new ZipFile(strPath);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory()) continue;
                    fileList.add(entry.getName());
                }
                zipFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return fileList;
    }

    static float getDecompressionRatio(ByteVec bv) {
        long totalSize = 0L;
        long totalCompSize = 0L;
        if (bv instanceof FileVec) {
            String strPath = FileVec.getPathForKey(((FileVec)bv)._key);
            try {
                ZipFile zipFile = new ZipFile(strPath);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory()) continue;
                    totalSize += entry.getSize();
                    totalCompSize += entry.getCompressedSize();
                }
                zipFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (totalCompSize == 0L) {
            return 1.0f;
        }
        return totalSize / totalCompSize;
    }

    static Compression guessCompressionMethod(byte[] bits) {
        if (bits.length > 30 && (long)UnsafeUtils.get4(bits, 0) == 67324752L) {
            return Compression.ZIP;
        }
        if (bits.length > 2 && (UnsafeUtils.get2(bits, 0) & 0xFFFF) == 35615) {
            return Compression.GZIP;
        }
        return Compression.NONE;
    }

    static float decompressionRatio(ByteVec bv) {
        byte[] zips = bv.getFirstBytes();
        Compression cpr = ZipUtil.guessCompressionMethod(zips);
        if (cpr == Compression.NONE) {
            return 1.0f;
        }
        if (cpr == Compression.ZIP) {
            ByteArrayInputStream bais = new ByteArrayInputStream(zips);
            ZipInputStream zis = new ZipInputStream(bais);
            ZipEntry ze = null;
            try {
                ze = zis.getNextEntry();
                boolean isDir = ze.isDirectory();
                if (isDir) {
                    return ZipUtil.getDecompressionRatio(bv);
                }
                byte[] bits = ZipUtil.unzipBytes(zips, cpr, 0x400000);
                return bits.length / zips.length;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            byte[] bits = ZipUtil.unzipBytes(zips, cpr, 0x400000);
            return bits.length / zips.length;
        }
        return 1.0f;
    }

    static byte[] unzipBytes(byte[] bs, Compression cmp, int chkSize) {
        if (cmp == Compression.NONE) {
            return bs;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bs);
        InputStream is = null;
        try {
            if (cmp == Compression.ZIP) {
                ZipInputStream zis = new ZipInputStream(bais);
                ZipEntry ze = zis.getNextEntry();
                if (ze == null || ze.isDirectory()) {
                    zis.getNextEntry();
                }
                is = zis;
            } else {
                assert (cmp == Compression.GZIP);
                is = new GZIPInputStream(bais);
            }
            bs = new byte[bs.length * 2];
            int off = 0;
            while (off < bs.length) {
                int len = is.read(bs, off, bs.length - off);
                if (len < 0) {
                    break;
                }
                if ((off += len) != bs.length) continue;
                if (bs.length >= chkSize) {
                    break;
                }
                bs = Arrays.copyOf(bs, bs.length * 2);
            }
        }
        catch (IOException ioe) {
            throw Log.throwErr(ioe);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return bs;
    }

    static byte[] unzipForHeader(byte[] bs, int chkSize) {
        ZipInputStream zis;
        ByteArrayInputStream bais = new ByteArrayInputStream(bs);
        ZipInputStream is = zis = new ZipInputStream(bais);
        int off = 0;
        try {
            while (off < bs.length) {
                int len = 0;
                len = ((InputStream)is).read(bs, off, bs.length - off);
                if (len >= 0) {
                    if ((off += len) != bs.length) continue;
                    if (bs.length < chkSize) {
                        bs = Arrays.copyOf(bs, bs.length * 2);
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            ((InputStream)is).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bs;
    }

    public static enum Compression {
        NONE,
        ZIP,
        GZIP;

    }
}

