/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.operators;

import java.util.Arrays;
import water.Futures;
import water.H2O;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;
import water.rapids.vals.ValNum;
import water.rapids.vals.ValRow;
import water.util.ArrayUtils;

public abstract class AstBinOp
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"leftArg", "rightArg"};
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Val left = stk.track(asts[1].exec(env));
        Val rite = stk.track(asts[2].exec(env));
        return this.prim_apply(left, rite);
    }

    public Val prim_apply(Val left, Val rite) {
        switch (left.type()) {
            case 1: {
                double dlf = left.getNum();
                switch (rite.type()) {
                    case 1: {
                        return new ValNum(this.op(dlf, rite.getNum()));
                    }
                    case 2: {
                        return new ValNum(this.op(dlf, rite.getNums()[0]));
                    }
                    case 5: {
                        return this.scalar_op_frame(dlf, rite.getFrame());
                    }
                    case 6: {
                        double[] lft = new double[rite.getRow().length];
                        Arrays.fill(lft, dlf);
                        return this.row_op_row(lft, rite.getRow(), ((ValRow)rite).getNames());
                    }
                    case 3: {
                        throw H2O.unimpl();
                    }
                    case 4: {
                        throw H2O.unimpl();
                    }
                }
                throw H2O.unimpl();
            }
            case 2: {
                double ddlf = left.getNums()[0];
                switch (rite.type()) {
                    case 1: {
                        return new ValNum(this.op(ddlf, rite.getNum()));
                    }
                    case 2: {
                        return new ValNum(this.op(ddlf, rite.getNums()[0]));
                    }
                    case 5: {
                        return this.scalar_op_frame(ddlf, rite.getFrame());
                    }
                    case 6: {
                        double[] lft = new double[rite.getRow().length];
                        Arrays.fill(lft, ddlf);
                        return this.row_op_row(lft, rite.getRow(), ((ValRow)rite).getNames());
                    }
                    case 3: {
                        throw H2O.unimpl();
                    }
                    case 4: {
                        throw H2O.unimpl();
                    }
                }
                throw H2O.unimpl();
            }
            case 5: {
                Frame flf = left.getFrame();
                switch (rite.type()) {
                    case 1: {
                        return this.frame_op_scalar(flf, rite.getNum());
                    }
                    case 2: {
                        return this.frame_op_scalar(flf, rite.getNums()[0]);
                    }
                    case 3: {
                        return this.frame_op_scalar(flf, rite.getStr());
                    }
                    case 4: {
                        return this.frame_op_scalar(flf, rite.getStrs()[0]);
                    }
                    case 5: {
                        return this.frame_op_frame(flf, rite.getFrame());
                    }
                }
                throw H2O.unimpl();
            }
            case 3: {
                String slf = left.getStr();
                switch (rite.type()) {
                    case 1: {
                        throw H2O.unimpl();
                    }
                    case 2: {
                        throw H2O.unimpl();
                    }
                    case 3: {
                        throw H2O.unimpl();
                    }
                    case 4: {
                        throw H2O.unimpl();
                    }
                    case 5: {
                        return this.scalar_op_frame(slf, rite.getFrame());
                    }
                }
                throw H2O.unimpl();
            }
            case 4: {
                String sslf = left.getStrs()[0];
                switch (rite.type()) {
                    case 1: {
                        throw H2O.unimpl();
                    }
                    case 2: {
                        throw H2O.unimpl();
                    }
                    case 3: {
                        throw H2O.unimpl();
                    }
                    case 4: {
                        throw H2O.unimpl();
                    }
                    case 5: {
                        return this.scalar_op_frame(sslf, rite.getFrame());
                    }
                }
                throw H2O.unimpl();
            }
            case 6: {
                double[] dslf = left.getRow();
                switch (rite.type()) {
                    case 1: {
                        double[] right = new double[dslf.length];
                        Arrays.fill(right, rite.getNum());
                        return this.row_op_row(dslf, right, ((ValRow)left).getNames());
                    }
                    case 6: {
                        return this.row_op_row(dslf, rite.getRow(), ((ValRow)rite).getNames());
                    }
                    case 5: {
                        return this.row_op_row(dslf, rite.getRow(), rite.getFrame().names());
                    }
                }
                throw H2O.unimpl();
            }
        }
        throw H2O.unimpl();
    }

    public abstract double op(double var1, double var3);

    public double str_op(BufferedString l, BufferedString r) {
        throw H2O.fail();
    }

    private ValFrame scalar_op_frame(final double d, Frame fr) {
        Frame res = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] cress) {
                for (int c = 0; c < chks.length; ++c) {
                    Chunk chk = chks[c];
                    NewChunk cres = cress[c];
                    for (int i = 0; i < chk._len; ++i) {
                        cres.addNum(AstBinOp.this.op(d, chk.atd(i)));
                    }
                }
            }
        }.doAll(fr.numCols(), (byte)3, fr)).outputFrame(fr._names, null);
        return this.cleanCategorical(fr, res);
    }

    public ValFrame frame_op_scalar(Frame fr, final double d) {
        Frame res = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] cress) {
                for (int c = 0; c < chks.length; ++c) {
                    Chunk chk = chks[c];
                    NewChunk cres = cress[c];
                    for (int i = 0; i < chk._len; ++i) {
                        cres.addNum(AstBinOp.this.op(chk.atd(i), d));
                    }
                }
            }
        }.doAll(fr.numCols(), (byte)3, fr)).outputFrame(fr._names, null);
        return this.cleanCategorical(fr, res);
    }

    private ValFrame cleanCategorical(Frame oldfr, Frame newfr) {
        boolean categoricalOK = this.categoricalOK();
        Vec[] oldvecs = oldfr.vecs();
        Vec[] newvecs = newfr.vecs();
        Futures fs = new Futures();
        for (int i = 0; i < oldvecs.length; ++i) {
            if (!oldvecs[i].isCategorical() || categoricalOK) continue;
            Vec cv = newvecs[i].makeCon(Double.NaN);
            newfr.replace(i, cv).remove(fs);
        }
        fs.blockForPending();
        return new ValFrame(newfr);
    }

    private ValFrame frame_op_scalar(Frame fr, final String str) {
        Frame res = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] cress) {
                BufferedString vstr = new BufferedString();
                for (int c = 0; c < chks.length; ++c) {
                    int i;
                    Chunk chk = chks[c];
                    NewChunk cres = cress[c];
                    Vec vec = chk.vec();
                    if (vec.isString()) {
                        BufferedString conStr = new BufferedString(str);
                        for (int i2 = 0; i2 < chk._len; ++i2) {
                            cres.addNum(AstBinOp.this.str_op(chk.atStr(vstr, i2), conStr));
                        }
                        continue;
                    }
                    if (vec.isCategorical()) {
                        double d = ArrayUtils.find(vec.domain(), str);
                        for (i = 0; i < chk._len; ++i) {
                            cres.addNum(AstBinOp.this.op(chk.atd(i), d));
                        }
                        continue;
                    }
                    double d = AstBinOp.this.op(1.0, 2.0);
                    for (i = 0; i < chk._len; ++i) {
                        cres.addNum(d);
                    }
                }
            }
        }.doAll(fr.numCols(), (byte)3, fr)).outputFrame(fr._names, null);
        return new ValFrame(res);
    }

    private ValFrame scalar_op_frame(final String str, Frame fr) {
        Frame res = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] cress) {
                BufferedString vstr = new BufferedString();
                for (int c = 0; c < chks.length; ++c) {
                    int i;
                    Chunk chk = chks[c];
                    NewChunk cres = cress[c];
                    Vec vec = chk.vec();
                    if (vec.isString()) {
                        BufferedString conStr = new BufferedString(str);
                        for (int i2 = 0; i2 < chk._len; ++i2) {
                            cres.addNum(AstBinOp.this.str_op(conStr, chk.atStr(vstr, i2)));
                        }
                        continue;
                    }
                    if (vec.isCategorical()) {
                        double d = ArrayUtils.find(vec.domain(), str);
                        for (i = 0; i < chk._len; ++i) {
                            cres.addNum(AstBinOp.this.op(d, chk.atd(i)));
                        }
                        continue;
                    }
                    double d = AstBinOp.this.op(1.0, 2.0);
                    for (i = 0; i < chk._len; ++i) {
                        cres.addNum(d);
                    }
                }
            }
        }.doAll(fr.numCols(), (byte)3, fr)).outputFrame(fr._names, null);
        return new ValFrame(res);
    }

    private ValFrame frame_op_frame(Frame lf, Frame rt) {
        if (lf.numRows() != rt.numRows()) {
            if (lf.numRows() == 1L || rt.numRows() == 1L) {
                if (lf.numCols() != rt.numCols()) {
                    throw new IllegalArgumentException("Frames must have same columns, found " + lf.numCols() + " columns and " + rt.numCols() + " columns.");
                }
                return this.frame_op_row(lf, rt);
            }
            throw new IllegalArgumentException("Frames must have same rows, found " + lf.numRows() + " rows and " + rt.numRows() + " rows.");
        }
        if (lf.numCols() == 0) {
            return new ValFrame(lf);
        }
        if (rt.numCols() == 0) {
            return new ValFrame(rt);
        }
        if (lf.numCols() == 1 && rt.numCols() > 1) {
            return this.vec_op_frame(lf.vecs()[0], rt);
        }
        if (rt.numCols() == 1 && lf.numCols() > 1) {
            return this.frame_op_vec(lf, rt.vecs()[0]);
        }
        if (lf.numCols() != rt.numCols()) {
            throw new IllegalArgumentException("Frames must have same columns, found " + lf.numCols() + " columns and " + rt.numCols() + " columns.");
        }
        Frame res = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] cress) {
                BufferedString lfstr = new BufferedString();
                BufferedString rtstr = new BufferedString();
                assert (cress.length << 1 == chks.length);
                for (int c = 0; c < cress.length; ++c) {
                    int i;
                    Chunk clf = chks[c];
                    Chunk crt = chks[c + cress.length];
                    NewChunk cres = cress[c];
                    if (clf.vec().isString()) {
                        for (i = 0; i < clf._len; ++i) {
                            cres.addNum(AstBinOp.this.str_op(clf.atStr(lfstr, i), crt.atStr(rtstr, i)));
                        }
                        continue;
                    }
                    for (i = 0; i < clf._len; ++i) {
                        cres.addNum(AstBinOp.this.op(clf.atd(i), crt.atd(i)));
                    }
                }
            }
        }.doAll(lf.numCols(), (byte)3, new Frame(lf).add(rt))).outputFrame(lf._names, null);
        return this.cleanCategorical(lf, res);
    }

    private ValFrame frame_op_row(Frame lf, Frame row) {
        final double[] rawRow = new double[row.numCols()];
        for (int i = 0; i < rawRow.length; ++i) {
            rawRow[i] = row.vec(i).isNumeric() || row.vec(i).isTime() ? row.vec(i).at(0L) : Double.NaN;
        }
        Frame res = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] cress) {
                for (int c = 0; c < cress.length; ++c) {
                    Chunk clf = chks[c];
                    NewChunk cres = cress[c];
                    for (int r = 0; r < clf._len; ++r) {
                        if (clf.vec().isString()) {
                            cres.addNum(Double.NaN);
                            continue;
                        }
                        cres.addNum(AstBinOp.this.op(clf.atd(r), rawRow[c]));
                    }
                }
            }
        }.doAll(lf.numCols(), (byte)3, lf)).outputFrame(lf._names, null);
        return this.cleanCategorical(lf, res);
    }

    private ValRow row_op_row(double[] lf, double[] rt, String[] names) {
        double[] res = new double[lf.length];
        for (int i = 0; i < lf.length; ++i) {
            res[i] = this.op(lf[i], rt[i]);
        }
        return new ValRow(res, names);
    }

    private ValFrame vec_op_frame(Vec vec, Frame fr) {
        Frame rt = new Frame(fr);
        rt.add("", vec);
        Frame res = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] cress) {
                assert (cress.length == chks.length - 1);
                Chunk clf = chks[cress.length];
                for (int c = 0; c < cress.length; ++c) {
                    Chunk crt = chks[c];
                    NewChunk cres = cress[c];
                    for (int i = 0; i < clf._len; ++i) {
                        cres.addNum(AstBinOp.this.op(clf.atd(i), crt.atd(i)));
                    }
                }
            }
        }.doAll(fr.numCols(), (byte)3, rt)).outputFrame(fr._names, null);
        return this.cleanCategorical(fr, res);
    }

    private ValFrame frame_op_vec(Frame fr, Vec vec) {
        Frame lf = new Frame(fr);
        lf.add("", vec);
        Frame res = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] cress) {
                assert (cress.length == chks.length - 1);
                Chunk crt = chks[cress.length];
                for (int c = 0; c < cress.length; ++c) {
                    Chunk clf = chks[c];
                    NewChunk cres = cress[c];
                    for (int i = 0; i < clf._len; ++i) {
                        cres.addNum(AstBinOp.this.op(clf.atd(i), crt.atd(i)));
                    }
                }
            }
        }.doAll(fr.numCols(), (byte)3, lf)).outputFrame(fr._names, null);
        return this.cleanCategorical(fr, res);
    }

    public boolean categoricalOK() {
        return false;
    }
}

