/*
 * Decompiled with CFR 0.152.
 */
package hex.grid;

import hex.ScoreKeeper;
import water.Iced;
import water.fvec.Frame;

public class HyperSpaceSearchCriteria
extends Iced {
    public final Strategy _strategy;

    public final Strategy strategy() {
        return this._strategy;
    }

    public ScoreKeeper.StoppingMetric stopping_metric() {
        return ScoreKeeper.StoppingMetric.AUTO;
    }

    public HyperSpaceSearchCriteria(Strategy strategy) {
        this._strategy = strategy;
    }

    public static final class RandomDiscreteValueSearchCriteria
    extends HyperSpaceSearchCriteria {
        private long _seed = -1L;
        private int _max_models = 0;
        private double _max_runtime_secs = 0.0;
        private int _stopping_rounds = 0;
        private ScoreKeeper.StoppingMetric _stopping_metric = ScoreKeeper.StoppingMetric.AUTO;
        public double _stopping_tolerance = 0.001;

        public long seed() {
            return this._seed;
        }

        public int max_models() {
            return this._max_models;
        }

        public double max_runtime_secs() {
            return this._max_runtime_secs;
        }

        public int stopping_rounds() {
            return this._stopping_rounds;
        }

        @Override
        public ScoreKeeper.StoppingMetric stopping_metric() {
            return this._stopping_metric;
        }

        public double stopping_tolerance() {
            return this._stopping_tolerance;
        }

        public static double default_stopping_tolerance_for_frame(Frame frame) {
            return Math.min(0.05, Math.max(0.001, 1.0 / Math.sqrt((1.0 - frame.naFraction()) * (double)frame.numRows())));
        }

        public void set_default_stopping_tolerance_for_frame(Frame frame) {
            this._stopping_tolerance = RandomDiscreteValueSearchCriteria.default_stopping_tolerance_for_frame(frame);
        }

        public RandomDiscreteValueSearchCriteria() {
            super(Strategy.RandomDiscrete);
        }

        public void set_seed(long _seed) {
            this._seed = _seed;
        }

        public void set_max_models(int _max_models) {
            this._max_models = _max_models;
        }

        public void set_max_runtime_secs(double _max_runtime_secs) {
            this._max_runtime_secs = _max_runtime_secs;
        }

        public void set_stopping_rounds(int _stopping_rounds) {
            this._stopping_rounds = _stopping_rounds;
        }

        public void set_stopping_metric(ScoreKeeper.StoppingMetric _stopping_metric) {
            this._stopping_metric = _stopping_metric;
        }

        public void set_stopping_tolerance(double _stopping_tolerance) {
            this._stopping_tolerance = _stopping_tolerance;
        }
    }

    public static final class CartesianSearchCriteria
    extends HyperSpaceSearchCriteria {
        public CartesianSearchCriteria() {
            super(Strategy.Cartesian);
        }
    }

    public static enum Strategy {
        Unknown,
        Cartesian,
        RandomDiscrete;

    }
}

