/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.DatagramChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Random;
import water.DKV;
import water.Freezable;
import water.Futures;
import water.H2O;
import water.H2ONode;
import water.Key;
import water.Keyed;
import water.MemoryManager;
import water.TimeLine;
import water.TypeMap;
import water.UDP;
import water.Value;
import water.init.NetworkInit;
import water.network.SocketChannelUtils;
import water.util.Log;
import water.util.MathUtils;
import water.util.SB;
import water.util.StringUtils;
import water.util.TwoDimTable;

public final class AutoBuffer {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    ByteBuffer _bb;
    public String sourceName = "???";
    private Channel _chan;
    private InputStream _is;
    private short[] _typeMap;
    private int _oldPrior = -1;
    final H2ONode _h2o;
    private boolean _read;
    private boolean _firstPage;
    int _size;
    long _time_start_ms;
    long _time_close_ms;
    long _time_io_ns;
    final byte _persist;
    static final int MTU = 1492;
    static final Random RANDOM_TCP_DROP = null;
    static final Charset UTF_8 = Charset.forName("UTF-8");
    private byte _msg_priority;
    private static final boolean DEBUG = Boolean.getBoolean("h2o.find-ByteBuffer-leaks");
    private static long HWM = 0L;
    static BBPool BBP_SML = new BBPool(2048);
    static BBPool BBP_BIG = new BBPool(65536);
    public static int TCP_BUF_SIZ = AutoBuffer.BBP_BIG._size;
    static final String JSON_NAN = "NaN";
    static final String JSON_POS_INF = "Infinity";
    static final String JSON_NEG_INF = "-Infinity";

    public boolean isClosed() {
        return this._bb == null;
    }

    AutoBuffer(DatagramChannel sock) throws IOException {
        InetAddress address;
        this._chan = null;
        this._bb = BBP_SML.make();
        this._read = true;
        this._firstPage = true;
        Inet4Address addr = null;
        SocketAddress sad = sock.receive(this._bb);
        if (sad instanceof InetSocketAddress && (address = ((InetSocketAddress)sad).getAddress()) instanceof Inet4Address) {
            addr = (Inet4Address)address;
        }
        this._size = this._bb.position();
        this._bb.flip();
        if (addr == null) {
            throw new RuntimeException("Unhandled socket type: " + sad);
        }
        this._h2o = H2ONode.intern(addr, this.getPort());
        this._firstPage = true;
        assert (this._h2o != null);
        this._persist = 0;
    }

    AutoBuffer(ByteChannel sock, InetAddress remoteAddress) throws IOException {
        this._chan = sock;
        this.raisePriority();
        this._bb = BBP_BIG.make();
        this._bb.flip();
        this._read = true;
        this._firstPage = true;
        this._h2o = remoteAddress != null ? H2ONode.intern(remoteAddress, this.getPort()) : null;
        this._firstPage = true;
        this._time_start_ms = System.currentTimeMillis();
        this._persist = (byte)7;
    }

    AutoBuffer(H2ONode h2o, byte priority) {
        this._bb = H2O.ARGS.useUDP ? BBP_SML.make() : ByteBuffer.wrap(new byte[16]).order(ByteOrder.nativeOrder());
        this._chan = null;
        this._h2o = h2o;
        this._read = false;
        this._firstPage = true;
        assert (this._h2o != null);
        this._time_start_ms = System.currentTimeMillis();
        this._persist = (byte)7;
        this._msg_priority = priority;
    }

    public AutoBuffer(FileChannel fc, boolean read, byte persist) {
        this._bb = BBP_BIG.make();
        this._chan = fc;
        this._h2o = null;
        this._read = read;
        if (read) {
            this._bb.flip();
        }
        this._time_start_ms = System.currentTimeMillis();
        this._persist = persist;
    }

    AutoBuffer(DatagramPacket pack) {
        this._size = pack.getLength();
        this._bb = ByteBuffer.wrap(pack.getData(), 0, pack.getLength()).order(ByteOrder.nativeOrder());
        this._bb.position(0);
        this._read = true;
        this._firstPage = true;
        this._chan = null;
        this._h2o = H2ONode.intern(pack.getAddress(), this.getPort());
        this._persist = 0;
    }

    AutoBuffer(H2ONode h2o, byte[] buf, int off, int len) {
        assert (buf != null) : "null fed to ByteBuffer.wrap";
        this._h2o = h2o;
        this._bb = ByteBuffer.wrap(buf, off, len).order(ByteOrder.nativeOrder());
        this._chan = null;
        this._read = true;
        this._firstPage = true;
        this._persist = 0;
        this._size = len;
    }

    public AutoBuffer(byte[] buf) {
        this(null, buf, 0, buf.length);
    }

    public AutoBuffer() {
        this._bb = ByteBuffer.wrap(new byte[16]).order(ByteOrder.nativeOrder());
        this._chan = null;
        this._h2o = null;
        this._read = false;
        this._firstPage = true;
        this._persist = 0;
    }

    public AutoBuffer(int len) {
        this._bb = ByteBuffer.wrap(MemoryManager.malloc1(len)).order(ByteOrder.nativeOrder());
        this._chan = null;
        this._h2o = null;
        this._read = false;
        this._firstPage = true;
        this._persist = 0;
    }

    public AutoBuffer(OutputStream os, boolean persist) {
        this._bb = ByteBuffer.wrap(MemoryManager.malloc1(AutoBuffer.BBP_BIG._size)).order(ByteOrder.nativeOrder());
        this._read = false;
        this._chan = Channels.newChannel(os);
        this._h2o = null;
        this._firstPage = true;
        this._persist = 0;
        if (persist) {
            this.put1(28).put1(237).putStr(H2O.ABV.projectVersion()).putAStr(TypeMap.CLAZZES);
        } else {
            this.put1(0);
        }
    }

    public AutoBuffer(InputStream is) {
        this._chan = null;
        this._h2o = null;
        this._firstPage = true;
        this._persist = 0;
        this._read = true;
        this._bb = ByteBuffer.wrap(MemoryManager.malloc1(AutoBuffer.BBP_BIG._size)).order(ByteOrder.nativeOrder());
        this._bb.flip();
        this._is = is;
        int b = this.get1U();
        if (b == 0) {
            return;
        }
        int magic = this.get1U();
        if (b != 28 || magic != 237) {
            throw new IllegalArgumentException("Missing magic number 0x1CED at stream start");
        }
        String version = this.getStr();
        if (!version.equals(H2O.ABV.projectVersion())) {
            throw new IllegalArgumentException("Found version " + version + ", but running version " + H2O.ABV.projectVersion());
        }
        String[] typeMap = this.getAStr();
        this._typeMap = new short[typeMap.length];
        for (int i = 0; i < typeMap.length; ++i) {
            this._typeMap[i] = (short)(typeMap[i] == null ? 0 : TypeMap.onIce(typeMap[i]));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[AB ").append(this._read ? "read " : "write ");
        sb.append(this._firstPage ? "first " : "2nd ").append(this._h2o);
        sb.append(" ").append(Value.nameOfPersist(this._persist));
        if (this._bb != null) {
            sb.append(" 0 <= ").append(this._bb.position()).append(" <= ").append(this._bb.limit());
        }
        if (this._bb != null) {
            sb.append(" <= ").append(this._bb.capacity());
        }
        return sb.append("]").toString();
    }

    private int bbFree() {
        if (this._bb != null && this._bb.isDirect()) {
            BBPool.FREE(this._bb);
        }
        this._bb = null;
        return 0;
    }

    public final int close() {
        block31: {
            if (this.isClosed()) {
                return 0;
            }
            assert (this._h2o != null || this._chan != null || this._is != null);
            try {
                if (this._chan == null) {
                    if (this._read) {
                        if (this._is != null) {
                            this._is.close();
                        }
                        int n = 0;
                        return n;
                    }
                    if (this._bb.position() < 1492) {
                        int n = this.udpSend();
                        return n;
                    }
                }
                if (this.hasTCP()) {
                    try {
                        if (this._read) {
                            int x = this.get1U();
                            assert (x == 171) : "AB.close instead of 0xab sentinel got " + x + ", " + this;
                            assert (this._chan != null);
                            SocketChannelUtils.underlyingSocketChannel(this._chan).socket().getOutputStream().write(205);
                        } else {
                            this.put1(171);
                            this.sendPartial();
                            assert (this._chan != null);
                            int x = SocketChannelUtils.underlyingSocketChannel(this._chan).socket().getInputStream().read();
                            if (x == -1) {
                                throw new IOException("Other side closed connection before handshake byte read");
                            }
                            assert (x == 205) : "Handshake; writer expected a 0xcd from reader but got " + x;
                        }
                        break block31;
                    }
                    catch (IOException ioe) {
                        try {
                            this._chan.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this._chan = null;
                        throw ioe;
                    }
                    finally {
                        if (!this._read) {
                            this._h2o.freeTCPSocket((ByteChannel)this._chan);
                        }
                        this.restorePriority();
                    }
                }
                if (!this._read) {
                    this.sendPartial();
                }
                this._chan.close();
                this._chan = null;
            }
            catch (IOException e) {
                throw new AutoBufferException(e);
            }
            finally {
                this.bbFree();
                this._time_close_ms = System.currentTimeMillis();
                assert (this.isClosed());
            }
        }
        return 0;
    }

    private void tcpOpen() throws IOException {
        assert (this._firstPage && this._bb.limit() >= 7);
        assert (this._chan == null);
        this._chan = this._h2o.getTCPSocket();
        this.raisePriority();
    }

    void drainClose() {
        if (this.isClosed()) {
            return;
        }
        Channel chan = this._chan;
        assert (this._h2o != null || chan != null);
        if (chan != null) {
            try {
                chan.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._chan = null;
            if (!this._read && SocketChannelUtils.isSocketChannel(chan)) {
                this._h2o.freeTCPSocket((ByteChannel)chan);
            }
        }
        this.restorePriority();
        this.bbFree();
        this._time_close_ms = System.currentTimeMillis();
        assert (this.isClosed());
    }

    boolean hasTCP() {
        assert (!this.isClosed());
        return SocketChannelUtils.isSocketChannel(this._chan) || this._h2o != null && this._bb.position() >= 1492;
    }

    int size() {
        return this._size;
    }

    public int position() {
        return this._bb.position();
    }

    public AutoBuffer position(int p) {
        this._bb.position(p);
        return this;
    }

    public void skip(int skip) {
        this._bb.position(this._bb.position() + skip);
    }

    public final byte[] buf() {
        assert (this._h2o == null && this._chan == null && !this._read && !this._bb.isDirect());
        return MemoryManager.arrayCopyOfRange(this._bb.array(), this._bb.arrayOffset(), this._bb.position());
    }

    public final byte[] bufClose() {
        byte[] res = this._bb.array();
        this.bbFree();
        return res;
    }

    private void raisePriority() {
        if (this._oldPrior == -1) {
            assert (SocketChannelUtils.isSocketChannel(this._chan));
            this._oldPrior = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(9);
        }
    }

    private void restorePriority() {
        if (this._oldPrior == -1) {
            return;
        }
        Thread.currentThread().setPriority(this._oldPrior);
        this._oldPrior = -1;
    }

    private int udpSend() throws IOException {
        assert (this._chan == null);
        TimeLine.record_send(this, false);
        this._size = this._bb.position();
        assert (this._size < AutoBuffer.BBP_SML._size);
        this._bb.flip();
        if (this._h2o == H2O.SELF) {
            NetworkInit.multicast(this._bb, this._msg_priority);
        } else if (H2O.ARGS.useUDP) {
            NetworkInit.CLOUD_DGRAM.send(this._bb, this._h2o._key);
        } else {
            this._h2o.sendMessage(this._bb, this._msg_priority);
        }
        return 0;
    }

    AutoBuffer clearForWriting(byte priority) {
        assert (this._read);
        this._read = false;
        this._msg_priority = priority;
        this._bb.clear();
        this._firstPage = true;
        return this;
    }

    public AutoBuffer flipForReading() {
        assert (!this._read);
        this._read = true;
        this._bb.flip();
        this._firstPage = true;
        return this;
    }

    private ByteBuffer getSp(int sz) {
        return sz > this._bb.remaining() ? this.getImpl(sz) : this._bb;
    }

    private ByteBuffer getSz(int sz) {
        assert (this._firstPage) : "getSz() is only valid for early UDP bytes";
        if (sz > this._bb.limit()) {
            this.getImpl(sz);
        }
        this._bb.position(sz);
        return this._bb;
    }

    private ByteBuffer getImpl(int sz) {
        assert (this._read) : "Reading from a buffer in write mode";
        this._bb.compact();
        assert (this._bb.position() + sz <= this._bb.capacity()) : "(" + this._bb.position() + "+" + sz + " <= " + this._bb.capacity() + ")";
        long ns = System.nanoTime();
        while (this._bb.position() < sz) {
            try {
                int res = this.readAnInt();
                if (res <= 0) {
                    throw new AutoBufferException(new EOFException("Reading " + sz + " bytes, AB=" + this));
                }
                if (this._is != null) {
                    this._bb.position(this._bb.position() + res);
                }
                this._size += res;
            }
            catch (IOException e) {
                if (e.getMessage().equals("An existing connection was forcibly closed by the remote host")) {
                    throw new AutoBufferException(e);
                }
                if (e.getMessage().equals("An established connection was aborted by the software in your host machine")) {
                    throw new AutoBufferException(e);
                }
                throw Log.throwErr(e);
            }
        }
        this._time_io_ns += System.nanoTime() - ns;
        this._bb.flip();
        this._firstPage = false;
        return this._bb;
    }

    private int readAnInt() throws IOException {
        if (this._is == null) {
            return ((ReadableByteChannel)this._chan).read(this._bb);
        }
        byte[] array = this._bb.array();
        int position = this._bb.position();
        int remaining = this._bb.remaining();
        try {
            return this._is.read(array, position, remaining);
        }
        catch (IOException ioe) {
            throw new IOException("Failed reading " + remaining + " bytes into buffer[" + array.length + "] at " + position + " from " + this.sourceName + " " + this._is, ioe);
        }
    }

    private ByteBuffer putSp(int sz) {
        assert (!this._read);
        if (sz > this._bb.remaining()) {
            if (this._h2o == null && this._chan == null || this._bb.hasArray() && this._bb.capacity() < AutoBuffer.BBP_BIG._size) {
                this.expandByteBuffer(sz);
            } else {
                this.sendPartial();
            }
            assert (sz <= this._bb.remaining());
        }
        return this._bb;
    }

    private ByteBuffer sendPartial() {
        this._size += this._bb.position();
        if (this._chan == null) {
            TimeLine.record_send(this, true);
        }
        this._bb.flip();
        try {
            if (this._chan == null) {
                this.tcpOpen();
            }
            long ns = System.nanoTime();
            while (this._bb.hasRemaining()) {
                ((WritableByteChannel)this._chan).write(this._bb);
                if (RANDOM_TCP_DROP == null || !SocketChannelUtils.isSocketChannel(this._chan) || RANDOM_TCP_DROP.nextInt(100) != 0) continue;
                throw new IOException("Random TCP Write Fail");
            }
            this._time_io_ns += System.nanoTime() - ns;
        }
        catch (IOException e) {
            throw new AutoBufferException(e);
        }
        this._firstPage = false;
        this._bb.clear();
        return this._bb;
    }

    private ByteBuffer expandByteBuffer(int sizeHint) {
        long needed = (long)sizeHint - (long)this._bb.remaining() + (long)this._bb.capacity();
        if (this._h2o == null && this._chan == null || this._bb.hasArray() && needed < 1492L) {
            if (needed > 0x7FFFFFF7L) {
                throw new IllegalArgumentException("Cannot allocate more than 2GB array: sizeHint=" + sizeHint + ", " + "needed=" + needed + ", bb.remaining()=" + this._bb.remaining() + ", bb.capacity()=" + this._bb.capacity());
            }
            byte[] ary = this._bb.array();
            int newLen = (int)Math.min(1L << MathUtils.log2(needed) + 1, 0x7FFFFFF7L);
            int oldpos = this._bb.position();
            this._bb = ByteBuffer.wrap(MemoryManager.arrayCopyOfRange(ary, 0, newLen), oldpos, newLen - oldpos).order(ByteOrder.nativeOrder());
        } else if (this._bb.capacity() != AutoBuffer.BBP_BIG._size) {
            int oldPos = this._bb.position();
            this._bb.flip();
            this._bb = BBP_BIG.make().put(this._bb);
            this._bb.position(oldPos);
        }
        return this._bb;
    }

    public String getStr(int off, int len) {
        return new String(this._bb.array(), this._bb.arrayOffset() + off, len, UTF_8);
    }

    public boolean getZ() {
        return this.get1() != 0;
    }

    public byte get1() {
        return this.getSp(1).get();
    }

    public int get1U() {
        return this.get1() & 0xFF;
    }

    public char get2() {
        return this.getSp(2).getChar();
    }

    public short get2s() {
        return this.getSp(2).getShort();
    }

    public int get3() {
        this.getSp(3);
        return this.get1U() | this.get1U() << 8 | this.get1U() << 16;
    }

    public int get4() {
        return this.getSp(4).getInt();
    }

    public float get4f() {
        return this.getSp(4).getFloat();
    }

    public long get8() {
        return this.getSp(8).getLong();
    }

    public double get8d() {
        return this.getSp(8).getDouble();
    }

    int get1U(int off) {
        return this._bb.get(off) & 0xFF;
    }

    int get4(int off) {
        return this._bb.getInt(off);
    }

    long get8(int off) {
        return this._bb.getLong(off);
    }

    public AutoBuffer putZ(boolean b) {
        return this.put1(b ? 1 : 0);
    }

    public AutoBuffer put1(int b) {
        assert (b >= -128 && b <= 255) : "" + b + " is not a byte";
        this.putSp(1).put((byte)b);
        return this;
    }

    public AutoBuffer put2(char c) {
        this.putSp(2).putChar(c);
        return this;
    }

    public AutoBuffer put2(short s) {
        this.putSp(2).putShort(s);
        return this;
    }

    public AutoBuffer put2s(short s) {
        return this.put2(s);
    }

    public AutoBuffer put3(int x) {
        assert (-16777216 <= x && x < 0x1000000);
        return this.put1(x & 0xFF).put1(x >> 8 & 0xFF).put1(x >> 16);
    }

    public AutoBuffer put4(int i) {
        this.putSp(4).putInt(i);
        return this;
    }

    public AutoBuffer put4f(float f) {
        this.putSp(4).putFloat(f);
        return this;
    }

    public AutoBuffer put8(long l) {
        this.putSp(8).putLong(l);
        return this;
    }

    public AutoBuffer put8d(double d) {
        this.putSp(8).putDouble(d);
        return this;
    }

    public AutoBuffer put(Freezable f) {
        if (f == null) {
            return this.putInt(TypeMap.NULL);
        }
        assert (f.frozenType() > 0) : "No TypeMap for " + f.getClass().getName();
        this.putInt(f.frozenType());
        return f.write(this);
    }

    public <T extends Freezable> T get() {
        int id = this.getInt();
        if (id == TypeMap.NULL) {
            return null;
        }
        if (this._is != null) {
            id = this._typeMap[id];
        }
        return TypeMap.newFreezable(id).read(this);
    }

    public <T extends Freezable> T get(Class<T> tc) {
        int id = this.getInt();
        if (id == TypeMap.NULL) {
            return null;
        }
        if (this._is != null) {
            id = this._typeMap[id];
        }
        assert (tc.isInstance(TypeMap.theFreezable(id))) : tc.getName() + " != " + TypeMap.theFreezable(id).getClass().getName() + ", id = " + id;
        return TypeMap.newFreezable(id).read(this);
    }

    public AutoBuffer putKey(Key k) {
        if (k == null) {
            return this;
        }
        Keyed kd = (Keyed)DKV.getGet(k);
        this.put(kd);
        return kd == null ? this : kd.writeAll_impl(this);
    }

    public Keyed getKey(Key k, Futures fs) {
        return k == null ? null : this.getKey(fs);
    }

    public Keyed getKey(Futures fs) {
        Keyed kd = this.get(Keyed.class);
        if (kd == null) {
            return null;
        }
        DKV.put(kd, fs);
        return kd.readAll_impl(this, fs);
    }

    public AutoBuffer putInt(int x) {
        if (0 <= x + 1 && x + 1 <= 253) {
            return this.put1(x + 1);
        }
        if (Short.MIN_VALUE <= x && x <= Short.MAX_VALUE) {
            return this.put1(255).put2((short)x);
        }
        return this.put1(254).put4(x);
    }

    int getInt() {
        int x = this.get1U();
        if (x <= 253) {
            return x - 1;
        }
        if (x == 255) {
            return (short)this.get2();
        }
        assert (x == 254);
        return this.get4();
    }

    long putZA(Object[] A) {
        int y;
        int x;
        if (A == null) {
            this.putInt(-1);
            return 0L;
        }
        for (x = 0; x < A.length && A[x] == null; ++x) {
        }
        for (y = A.length; y > x && A[y - 1] == null; --y) {
        }
        this.putInt(x);
        this.putInt(y - x);
        if (y > x) {
            this.putInt(A.length - y);
        }
        return (long)x << 32 | (long)(y - x);
    }

    long getZA() {
        int x = this.getInt();
        if (x == -1) {
            return -1L;
        }
        int nz = this.getInt();
        return (long)x << 32 | (long)nz;
    }

    public AutoBuffer putAEnum(Enum[] enums) {
        long xy = this.putZA(enums);
        if (xy == -1L) {
            return this;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        for (int i = x; i < x + y; ++i) {
            this.putEnum(enums[i]);
        }
        return this;
    }

    public <E extends Enum> E[] getAEnum(E[] values) {
        long xy = this.getZA();
        if (xy == -1L) {
            return null;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        int z = y == 0 ? 0 : this.getInt();
        Enum[] ts = (Enum[])Array.newInstance(values.getClass().getComponentType(), x + y + z);
        for (int i = x; i < x + y; ++i) {
            ts[i] = this.getEnum((Enum[])values);
        }
        return ts;
    }

    public AutoBuffer putA(Freezable[] fs) {
        long xy = this.putZA(fs);
        if (xy == -1L) {
            return this;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        for (int i = x; i < x + y; ++i) {
            this.put(fs[i]);
        }
        return this;
    }

    public AutoBuffer putAA(Freezable[][] fs) {
        long xy = this.putZA((Object[])fs);
        if (xy == -1L) {
            return this;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        for (int i = x; i < x + y; ++i) {
            this.putA(fs[i]);
        }
        return this;
    }

    public AutoBuffer putAAA(Freezable[][][] fs) {
        long xy = this.putZA((Object[])fs);
        if (xy == -1L) {
            return this;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        for (int i = x; i < x + y; ++i) {
            this.putAA(fs[i]);
        }
        return this;
    }

    public <T extends Freezable> T[] getA(Class<T> tc) {
        long xy = this.getZA();
        if (xy == -1L) {
            return null;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        int z = y == 0 ? 0 : this.getInt();
        Freezable[] ts = (Freezable[])Array.newInstance(tc, x + y + z);
        for (int i = x; i < x + y; ++i) {
            ts[i] = this.get(tc);
        }
        return ts;
    }

    public <T extends Freezable> T[][] getAA(Class<T> tc) {
        long xy = this.getZA();
        if (xy == -1L) {
            return null;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        int z = y == 0 ? 0 : this.getInt();
        Class<?> tcA = Array.newInstance(tc, 0).getClass();
        Freezable[][] ts = (Freezable[][])Array.newInstance(tcA, x + y + z);
        for (int i = x; i < x + y; ++i) {
            ts[i] = this.getA(tc);
        }
        return ts;
    }

    public <T extends Freezable> T[][][] getAAA(Class<T> tc) {
        long xy = this.getZA();
        if (xy == -1L) {
            return null;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        int z = y == 0 ? 0 : this.getInt();
        Class<?> tcA = Array.newInstance(tc, 0).getClass();
        Class<?> tcAA = Array.newInstance(tcA, 0).getClass();
        Freezable[][][] ts = (Freezable[][][])Array.newInstance(tcAA, x + y + z);
        for (int i = x; i < x + y; ++i) {
            ts[i] = this.getAA(tc);
        }
        return ts;
    }

    public AutoBuffer putAStr(String[] fs) {
        long xy = this.putZA(fs);
        if (xy == -1L) {
            return this;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        for (int i = x; i < x + y; ++i) {
            this.putStr(fs[i]);
        }
        return this;
    }

    public String[] getAStr() {
        long xy = this.getZA();
        if (xy == -1L) {
            return null;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        int z = y == 0 ? 0 : this.getInt();
        String[] ts = new String[x + y + z];
        for (int i = x; i < x + y; ++i) {
            ts[i] = this.getStr();
        }
        return ts;
    }

    public AutoBuffer putAAStr(String[][] fs) {
        long xy = this.putZA((Object[])fs);
        if (xy == -1L) {
            return this;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        for (int i = x; i < x + y; ++i) {
            this.putAStr(fs[i]);
        }
        return this;
    }

    public String[][] getAAStr() {
        long xy = this.getZA();
        if (xy == -1L) {
            return null;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        int z = y == 0 ? 0 : this.getInt();
        String[][] ts = new String[x + y + z][];
        for (int i = x; i < x + y; ++i) {
            ts[i] = this.getAStr();
        }
        return ts;
    }

    int read(byte[] buf, int off, int len) {
        int sz = Math.min(this._bb.remaining(), len);
        this._bb.get(buf, off, sz);
        return sz;
    }

    int getCtrl() {
        return this.getSz(1).get(0) & 0xFF;
    }

    int getPort() {
        return this.getSz(3).getChar(1);
    }

    int getTask() {
        return this.getSz(7).getInt(3);
    }

    int getFlag() {
        return this.getSz(8).get(7);
    }

    AutoBuffer putUdp(UDP.udp type) {
        assert (this._bb.position() == 0);
        this.putSp(this._bb.position() + 1 + 2);
        this._bb.put((byte)type.ordinal());
        this._bb.putChar((char)H2O.H2O_PORT);
        return this;
    }

    AutoBuffer putTask(UDP.udp type, int tasknum) {
        return this.putUdp(type).put4(tasknum);
    }

    AutoBuffer putTask(int ctrl, int tasknum) {
        assert (this._bb.position() == 0);
        this.putSp(this._bb.position() + 1 + 2 + 4);
        this._bb.put((byte)ctrl).putChar((char)H2O.H2O_PORT).putInt(tasknum);
        return this;
    }

    public boolean[] getAZ() {
        int len = this.getInt();
        if (len == -1) {
            return null;
        }
        boolean[] r = new boolean[len];
        for (int i = 0; i < len; ++i) {
            r[i] = this.getZ();
        }
        return r;
    }

    public byte[] getA1() {
        int len = this.getInt();
        return len == -1 ? null : this.getA1(len);
    }

    public byte[] getA1(int len) {
        byte[] buf = MemoryManager.malloc1(len);
        int sofar = 0;
        while (sofar < len) {
            int more = Math.min(this._bb.remaining(), len - sofar);
            this._bb.get(buf, sofar, more);
            if ((sofar += more) >= len) continue;
            this.getSp(Math.min(this._bb.capacity(), len - sofar));
        }
        return buf;
    }

    public short[] getA2() {
        int len = this.getInt();
        if (len == -1) {
            return null;
        }
        short[] buf = MemoryManager.malloc2(len);
        int sofar = 0;
        while (sofar < buf.length) {
            ShortBuffer as = this._bb.asShortBuffer();
            int more = Math.min(as.remaining(), len - sofar);
            as.get(buf, sofar, more);
            this._bb.position(this._bb.position() + as.position() * 2);
            if ((sofar += more) >= len) continue;
            this.getSp(Math.min(this._bb.capacity() - 1, (len - sofar) * 2));
        }
        return buf;
    }

    public int[] getA4() {
        int len = this.getInt();
        if (len == -1) {
            return null;
        }
        int[] buf = MemoryManager.malloc4(len);
        int sofar = 0;
        while (sofar < buf.length) {
            IntBuffer as = this._bb.asIntBuffer();
            int more = Math.min(as.remaining(), len - sofar);
            as.get(buf, sofar, more);
            this._bb.position(this._bb.position() + as.position() * 4);
            if ((sofar += more) >= len) continue;
            this.getSp(Math.min(this._bb.capacity() - 3, (len - sofar) * 4));
        }
        return buf;
    }

    public float[] getA4f() {
        int len = this.getInt();
        if (len == -1) {
            return null;
        }
        float[] buf = MemoryManager.malloc4f(len);
        int sofar = 0;
        while (sofar < buf.length) {
            FloatBuffer as = this._bb.asFloatBuffer();
            int more = Math.min(as.remaining(), len - sofar);
            as.get(buf, sofar, more);
            this._bb.position(this._bb.position() + as.position() * 4);
            if ((sofar += more) >= len) continue;
            this.getSp(Math.min(this._bb.capacity() - 3, (len - sofar) * 4));
        }
        return buf;
    }

    public long[] getA8() {
        int x = this.getInt();
        if (x == -1) {
            return null;
        }
        int y = this.getInt();
        int z = y == 0 ? 0 : this.getInt();
        long[] buf = MemoryManager.malloc8(x + y + z);
        switch (this.get1U()) {
            case 1: {
                for (int i = x; i < x + y; ++i) {
                    buf[i] = this.get1U();
                }
                return buf;
            }
            case 2: {
                for (int i = x; i < x + y; ++i) {
                    buf[i] = (short)this.get2();
                }
                return buf;
            }
            case 4: {
                for (int i = x; i < x + y; ++i) {
                    buf[i] = this.get4();
                }
                return buf;
            }
            case 8: {
                break;
            }
            default: {
                throw H2O.fail();
            }
        }
        int sofar = x;
        while (sofar < x + y) {
            LongBuffer as = this._bb.asLongBuffer();
            int more = Math.min(as.remaining(), x + y - sofar);
            as.get(buf, sofar, more);
            this._bb.position(this._bb.position() + as.position() * 8);
            if ((sofar += more) >= x + y) continue;
            this.getSp(Math.min(this._bb.capacity() - 7, (x + y - sofar) * 8));
        }
        return buf;
    }

    public double[] getA8d() {
        int len = this.getInt();
        if (len == -1) {
            return null;
        }
        double[] buf = MemoryManager.malloc8d(len);
        int sofar = 0;
        while (sofar < len) {
            DoubleBuffer as = this._bb.asDoubleBuffer();
            int more = Math.min(as.remaining(), len - sofar);
            as.get(buf, sofar, more);
            this._bb.position(this._bb.position() + as.position() * 8);
            if ((sofar += more) >= len) continue;
            this.getSp(Math.min(this._bb.capacity() - 7, (len - sofar) * 8));
        }
        return buf;
    }

    public byte[][] getAA1() {
        long xy = this.getZA();
        if (xy == -1L) {
            return null;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        int z = y == 0 ? 0 : this.getInt();
        byte[][] ary = new byte[x + y + z][];
        for (int i = x; i < x + y; ++i) {
            ary[i] = this.getA1();
        }
        return ary;
    }

    public short[][] getAA2() {
        long xy = this.getZA();
        if (xy == -1L) {
            return null;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        int z = y == 0 ? 0 : this.getInt();
        short[][] ary = new short[x + y + z][];
        for (int i = x; i < x + y; ++i) {
            ary[i] = this.getA2();
        }
        return ary;
    }

    public int[][] getAA4() {
        long xy = this.getZA();
        if (xy == -1L) {
            return null;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        int z = y == 0 ? 0 : this.getInt();
        int[][] ary = new int[x + y + z][];
        for (int i = x; i < x + y; ++i) {
            ary[i] = this.getA4();
        }
        return ary;
    }

    public float[][] getAA4f() {
        long xy = this.getZA();
        if (xy == -1L) {
            return null;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        int z = y == 0 ? 0 : this.getInt();
        float[][] ary = new float[x + y + z][];
        for (int i = x; i < x + y; ++i) {
            ary[i] = this.getA4f();
        }
        return ary;
    }

    public long[][] getAA8() {
        long xy = this.getZA();
        if (xy == -1L) {
            return null;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        int z = y == 0 ? 0 : this.getInt();
        long[][] ary = new long[x + y + z][];
        for (int i = x; i < x + y; ++i) {
            ary[i] = this.getA8();
        }
        return ary;
    }

    public double[][] getAA8d() {
        long xy = this.getZA();
        if (xy == -1L) {
            return null;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        int z = y == 0 ? 0 : this.getInt();
        double[][] ary = new double[x + y + z][];
        for (int i = x; i < x + y; ++i) {
            ary[i] = this.getA8d();
        }
        return ary;
    }

    public int[][][] getAAA4() {
        long xy = this.getZA();
        if (xy == -1L) {
            return null;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        int z = y == 0 ? 0 : this.getInt();
        int[][][] ary = new int[x + y + z][][];
        for (int i = x; i < x + y; ++i) {
            ary[i] = this.getAA4();
        }
        return ary;
    }

    public long[][][] getAAA8() {
        long xy = this.getZA();
        if (xy == -1L) {
            return null;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        int z = y == 0 ? 0 : this.getInt();
        long[][][] ary = new long[x + y + z][][];
        for (int i = x; i < x + y; ++i) {
            ary[i] = this.getAA8();
        }
        return ary;
    }

    public double[][][] getAAA8d() {
        long xy = this.getZA();
        if (xy == -1L) {
            return null;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        int z = y == 0 ? 0 : this.getInt();
        double[][][] ary = new double[x + y + z][][];
        for (int i = x; i < x + y; ++i) {
            ary[i] = this.getAA8d();
        }
        return ary;
    }

    public String getStr() {
        int len = this.getInt();
        return len == -1 ? null : new String(this.getA1(len), UTF_8);
    }

    public <E extends Enum> E getEnum(E[] values) {
        byte idx = this.get1();
        return idx == -1 ? null : (E)values[idx];
    }

    public AutoBuffer putAZ(boolean[] ary) {
        if (ary == null) {
            return this.putInt(-1);
        }
        this.putInt(ary.length);
        for (boolean anAry : ary) {
            this.putZ(anAry);
        }
        return this;
    }

    public AutoBuffer putA1(byte[] ary) {
        if (ary == null) {
            return this.putInt(-1);
        }
        this.putInt(ary.length);
        return this.putA1(ary, ary.length);
    }

    public AutoBuffer putA1(byte[] ary, int length) {
        return this.putA1(ary, 0, length);
    }

    public AutoBuffer putA1(byte[] ary, int sofar, int length) {
        if (length - sofar > this._bb.remaining()) {
            this.expandByteBuffer(length - sofar);
        }
        while (sofar < length) {
            int len = Math.min(length - sofar, this._bb.remaining());
            this._bb.put(ary, sofar, len);
            if ((sofar += len) >= length) continue;
            this.sendPartial();
        }
        return this;
    }

    AutoBuffer putA2(short[] ary) {
        if (ary == null) {
            return this.putInt(-1);
        }
        this.putInt(ary.length);
        if (ary.length * 2 > this._bb.remaining()) {
            this.expandByteBuffer(ary.length * 2);
        }
        int sofar = 0;
        while (sofar < ary.length) {
            ShortBuffer sb = this._bb.asShortBuffer();
            int len = Math.min(ary.length - sofar, sb.remaining());
            sb.put(ary, sofar, len);
            this._bb.position(this._bb.position() + sb.position() * 2);
            if ((sofar += len) >= ary.length) continue;
            this.sendPartial();
        }
        return this;
    }

    public AutoBuffer putA4(int[] ary) {
        if (ary == null) {
            return this.putInt(-1);
        }
        this.putInt(ary.length);
        if (ary.length * 4 > this._bb.remaining()) {
            this.expandByteBuffer(ary.length * 4);
        }
        int sofar = 0;
        while (sofar < ary.length) {
            IntBuffer ib = this._bb.asIntBuffer();
            int len = Math.min(ary.length - sofar, ib.remaining());
            ib.put(ary, sofar, len);
            this._bb.position(this._bb.position() + ib.position() * 4);
            if ((sofar += len) >= ary.length) continue;
            this.sendPartial();
        }
        return this;
    }

    public AutoBuffer putA8(long[] ary) {
        int i;
        int y;
        int x;
        if (ary == null) {
            return this.putInt(-1);
        }
        for (x = 0; x < ary.length && ary[x] == 0L; ++x) {
        }
        for (y = ary.length; y > x && ary[y - 1] == 0L; --y) {
        }
        int nzlen = y - x;
        this.putInt(x);
        this.putInt(nzlen);
        if (nzlen > 0) {
            this.putInt(ary.length - y);
        }
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        for (i = x; i < y; ++i) {
            if (ary[i] < min) {
                min = ary[i];
            }
            if (ary[i] <= max) continue;
            max = ary[i];
        }
        if (0L <= min && max < 256L) {
            this.put1(1);
            for (i = x; i < y; ++i) {
                this.put1((int)ary[i]);
            }
            return this;
        }
        if (-32768L <= min && max < 32767L) {
            this.put1(2);
            for (i = x; i < y; ++i) {
                this.put2((short)ary[i]);
            }
            return this;
        }
        if (Integer.MIN_VALUE <= min && max < Integer.MAX_VALUE) {
            this.put1(4);
            for (i = x; i < y; ++i) {
                this.put4((int)ary[i]);
            }
            return this;
        }
        this.put1(8);
        int sofar = x;
        if ((y - sofar) * 8 > this._bb.remaining()) {
            this.expandByteBuffer(ary.length * 8);
        }
        while (sofar < y) {
            LongBuffer lb = this._bb.asLongBuffer();
            int len = Math.min(y - sofar, lb.remaining());
            lb.put(ary, sofar, len);
            this._bb.position(this._bb.position() + lb.position() * 8);
            if ((sofar += len) >= y) continue;
            this.sendPartial();
        }
        return this;
    }

    public AutoBuffer putA4f(float[] ary) {
        if (ary == null) {
            return this.putInt(-1);
        }
        this.putInt(ary.length);
        if (ary.length * 4 > this._bb.remaining()) {
            this.expandByteBuffer(ary.length * 4);
        }
        int sofar = 0;
        while (sofar < ary.length) {
            FloatBuffer fb = this._bb.asFloatBuffer();
            int len = Math.min(ary.length - sofar, fb.remaining());
            fb.put(ary, sofar, len);
            this._bb.position(this._bb.position() + fb.position() * 4);
            if ((sofar += len) >= ary.length) continue;
            this.sendPartial();
        }
        return this;
    }

    public AutoBuffer putA8d(double[] ary) {
        if (ary == null) {
            return this.putInt(-1);
        }
        this.putInt(ary.length);
        if (ary.length * 8 > this._bb.remaining()) {
            this.expandByteBuffer(ary.length * 8);
        }
        int sofar = 0;
        while (sofar < ary.length) {
            DoubleBuffer db = this._bb.asDoubleBuffer();
            int len = Math.min(ary.length - sofar, db.remaining());
            db.put(ary, sofar, len);
            this._bb.position(this._bb.position() + db.position() * 8);
            if ((sofar += len) >= ary.length) continue;
            this.sendPartial();
        }
        return this;
    }

    public AutoBuffer putAA1(byte[][] ary) {
        long xy = this.putZA((Object[])ary);
        if (xy == -1L) {
            return this;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        for (int i = x; i < x + y; ++i) {
            this.putA1(ary[i]);
        }
        return this;
    }

    AutoBuffer putAA2(short[][] ary) {
        long xy = this.putZA((Object[])ary);
        if (xy == -1L) {
            return this;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        for (int i = x; i < x + y; ++i) {
            this.putA2(ary[i]);
        }
        return this;
    }

    public AutoBuffer putAA4(int[][] ary) {
        long xy = this.putZA((Object[])ary);
        if (xy == -1L) {
            return this;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        for (int i = x; i < x + y; ++i) {
            this.putA4(ary[i]);
        }
        return this;
    }

    public AutoBuffer putAA4f(float[][] ary) {
        long xy = this.putZA((Object[])ary);
        if (xy == -1L) {
            return this;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        for (int i = x; i < x + y; ++i) {
            this.putA4f(ary[i]);
        }
        return this;
    }

    public AutoBuffer putAA8(long[][] ary) {
        long xy = this.putZA((Object[])ary);
        if (xy == -1L) {
            return this;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        for (int i = x; i < x + y; ++i) {
            this.putA8(ary[i]);
        }
        return this;
    }

    public AutoBuffer putAA8d(double[][] ary) {
        long xy = this.putZA((Object[])ary);
        if (xy == -1L) {
            return this;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        for (int i = x; i < x + y; ++i) {
            this.putA8d(ary[i]);
        }
        return this;
    }

    public AutoBuffer putAAA4(int[][][] ary) {
        long xy = this.putZA((Object[])ary);
        if (xy == -1L) {
            return this;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        for (int i = x; i < x + y; ++i) {
            this.putAA4(ary[i]);
        }
        return this;
    }

    public AutoBuffer putAAA8(long[][][] ary) {
        long xy = this.putZA((Object[])ary);
        if (xy == -1L) {
            return this;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        for (int i = x; i < x + y; ++i) {
            this.putAA8(ary[i]);
        }
        return this;
    }

    public AutoBuffer putAAA8d(double[][][] ary) {
        long xy = this.putZA((Object[])ary);
        if (xy == -1L) {
            return this;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        for (int i = x; i < x + y; ++i) {
            this.putAA8d(ary[i]);
        }
        return this;
    }

    public AutoBuffer putStr(String s) {
        if (s == null) {
            return this.putInt(-1);
        }
        return this.putA1(StringUtils.bytesOf(s));
    }

    public AutoBuffer putEnum(Enum x) {
        return this.put1(x == null ? -1 : x.ordinal());
    }

    public static byte[] javaSerializeWritePojo(Object o) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(bos);
            out.writeObject(o);
            out.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw Log.throwErr(e);
        }
    }

    public static Object javaSerializeReadPojo(byte[] bytes) {
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
            Object o = ois.readObject();
            return o;
        }
        catch (IOException e) {
            String className = AutoBuffer.nameOfClass(bytes);
            throw Log.throwErr(new RuntimeException("Failed to deserialize " + className, e));
        }
        catch (ClassNotFoundException e) {
            throw Log.throwErr(e);
        }
    }

    static String nameOfClass(byte[] bytes) {
        if (bytes == null) {
            return "(null)";
        }
        if (bytes.length < 11) {
            return "(no name)";
        }
        int nameSize = Math.min(40, Math.max(3, bytes[7]));
        return new String(bytes, 8, Math.min(nameSize, bytes.length - 8));
    }

    public AutoBuffer putSer(Object obj) {
        if (obj == null) {
            return this.putA1(null);
        }
        return this.putA1(AutoBuffer.javaSerializeWritePojo(obj));
    }

    public AutoBuffer putASer(Object[] fs) {
        long xy = this.putZA(fs);
        if (xy == -1L) {
            return this;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        for (int i = x; i < x + y; ++i) {
            this.putSer(fs[i]);
        }
        return this;
    }

    public AutoBuffer putAASer(Object[][] fs) {
        long xy = this.putZA((Object[])fs);
        if (xy == -1L) {
            return this;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        for (int i = x; i < x + y; ++i) {
            this.putASer(fs[i]);
        }
        return this;
    }

    public AutoBuffer putAAASer(Object[][][] fs) {
        long xy = this.putZA((Object[])fs);
        if (xy == -1L) {
            return this;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        for (int i = x; i < x + y; ++i) {
            this.putAASer(fs[i]);
        }
        return this;
    }

    public Object getSer() {
        byte[] ba = this.getA1();
        return ba == null ? null : AutoBuffer.javaSerializeReadPojo(ba);
    }

    public <T> T getSer(Class<T> tc) {
        return (T)this.getSer();
    }

    public <T> T[] getASer(Class<T> tc) {
        long xy = this.getZA();
        if (xy == -1L) {
            return null;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        int z = y == 0 ? 0 : this.getInt();
        Object[] ts = (Object[])Array.newInstance(tc, x + y + z);
        for (int i = x; i < x + y; ++i) {
            ts[i] = this.getSer(tc);
        }
        return ts;
    }

    public <T> T[][] getAASer(Class<T> tc) {
        long xy = this.getZA();
        if (xy == -1L) {
            return null;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        int z = y == 0 ? 0 : this.getInt();
        Object[][] ts = (Object[][])Array.newInstance(tc, x + y + z);
        for (int i = x; i < x + y; ++i) {
            ts[i] = this.getASer(tc);
        }
        return ts;
    }

    public <T> T[][][] getAAASer(Class<T> tc) {
        long xy = this.getZA();
        if (xy == -1L) {
            return null;
        }
        int x = (int)(xy >> 32);
        int y = (int)xy;
        int z = y == 0 ? 0 : this.getInt();
        Object[][][] ts = (Object[][][])Array.newInstance(tc, x + y + z);
        for (int i = x; i < x + y; ++i) {
            ts[i] = this.getAASer(tc);
        }
        return ts;
    }

    public AutoBuffer putJNULL() {
        return this.put1(110).put1(117).put1(108).put1(108);
    }

    private AutoBuffer putJStr(String s) {
        byte[] b = StringUtils.bytesOf(s);
        int off = 0;
        for (int i = 0; i < b.length; ++i) {
            int j;
            if (b[i] == 92 || b[i] == 34) {
                this.putA1(b, off, i);
                this.put1(92);
                off = i;
            }
            if (b[i] == 8) {
                this.putA1(b, off, i);
                this.put1(92);
                this.put1(98);
                off = i + 1;
                continue;
            }
            if (b[i] == 12) {
                this.putA1(b, off, i);
                this.put1(92);
                this.put1(102);
                off = i + 1;
                continue;
            }
            if (b[i] == 10) {
                this.putA1(b, off, i);
                this.put1(92);
                this.put1(110);
                off = i + 1;
                continue;
            }
            if (b[i] == 13) {
                this.putA1(b, off, i);
                this.put1(92);
                this.put1(114);
                off = i + 1;
                continue;
            }
            if (b[i] == 9) {
                this.putA1(b, off, i);
                this.put1(92);
                this.put1(116);
                off = i + 1;
                continue;
            }
            if (b[i] == 127) {
                this.putA1(b, off, i);
                this.put1(92);
                this.put1(117);
                this.put1(48);
                this.put1(48);
                this.put1(55);
                this.put1(102);
                off = i + 1;
                continue;
            }
            if (b[i] < 0 || b[i] >= 32) continue;
            String hexStr = Integer.toHexString(b[i]);
            this.putA1(b, off, i);
            this.put1(92);
            this.put1(117);
            for (j = 0; j < 4 - hexStr.length(); ++j) {
                this.put1(48);
            }
            for (j = 0; j < hexStr.length(); ++j) {
                this.put1(hexStr.charAt(hexStr.length() - j - 1));
            }
            off = i + 1;
        }
        return this.putA1(b, off, b.length);
    }

    public AutoBuffer putJSONStrUnquoted(String s) {
        return s == null ? this.putJNULL() : this.putJStr(s);
    }

    public AutoBuffer putJSONStrUnquoted(String name, String s) {
        return s == null ? this.putJSONStr(name).put1(58).putJNULL() : this.putJSONStr(name).put1(58).putJStr(s);
    }

    public AutoBuffer putJSONName(String s) {
        return this.put1(34).putJStr(s).put1(34);
    }

    public AutoBuffer putJSONStr(String s) {
        return s == null ? this.putJNULL() : this.putJSONName(s);
    }

    public AutoBuffer putJSONAStr(String[] ss) {
        if (ss == null) {
            return this.putJNULL();
        }
        this.put1(91);
        for (int i = 0; i < ss.length; ++i) {
            if (i > 0) {
                this.put1(44);
            }
            this.putJSONStr(ss[i]);
        }
        return this.put1(93);
    }

    private AutoBuffer putJSONAAStr(String[][] sss) {
        if (sss == null) {
            return this.putJNULL();
        }
        this.put1(91);
        for (int i = 0; i < sss.length; ++i) {
            if (i > 0) {
                this.put1(44);
            }
            this.putJSONAStr(sss[i]);
        }
        return this.put1(93);
    }

    public AutoBuffer putJSONStr(String name, String s) {
        return this.putJSONStr(name).put1(58).putJSONStr(s);
    }

    public AutoBuffer putJSONAStr(String name, String[] ss) {
        return this.putJSONStr(name).put1(58).putJSONAStr(ss);
    }

    public AutoBuffer putJSONAAStr(String name, String[][] sss) {
        return this.putJSONStr(name).put1(58).putJSONAAStr(sss);
    }

    public AutoBuffer putJSONSer(String name, Object o) {
        return this.putJSONStr(name).put1(58).putJNULL();
    }

    public AutoBuffer putJSONASer(String name, Object[] oo) {
        return this.putJSONStr(name).put1(58).putJNULL();
    }

    public AutoBuffer putJSONAASer(String name, Object[][] ooo) {
        return this.putJSONStr(name).put1(58).putJNULL();
    }

    public AutoBuffer putJSONAAASer(String name, Object[][][] oooo) {
        return this.putJSONStr(name).put1(58).putJNULL();
    }

    public AutoBuffer putJSONAZ(String name, boolean[] f) {
        return this.putJSONStr(name).put1(58).putJSONAZ(f);
    }

    public AutoBuffer putJSON(Freezable ice) {
        return ice == null ? this.putJNULL() : ice.writeJSON(this);
    }

    public AutoBuffer putJSONA(Freezable[] fs) {
        if (fs == null) {
            return this.putJNULL();
        }
        this.put1(91);
        for (int i = 0; i < fs.length; ++i) {
            if (i > 0) {
                this.put1(44);
            }
            this.putJSON(fs[i]);
        }
        return this.put1(93);
    }

    public AutoBuffer putJSONAA(Freezable[][] fs) {
        if (fs == null) {
            return this.putJNULL();
        }
        this.put1(91);
        for (int i = 0; i < fs.length; ++i) {
            if (i > 0) {
                this.put1(44);
            }
            this.putJSONA(fs[i]);
        }
        return this.put1(93);
    }

    public AutoBuffer putJSONAAA(Freezable[][][] fs) {
        if (fs == null) {
            return this.putJNULL();
        }
        this.put1(91);
        for (int i = 0; i < fs.length; ++i) {
            if (i > 0) {
                this.put1(44);
            }
            this.putJSONAA(fs[i]);
        }
        return this.put1(93);
    }

    public AutoBuffer putJSON(String name, Freezable f) {
        return this.putJSONStr(name).put1(58).putJSON(f);
    }

    public AutoBuffer putJSONA(String name, Freezable[] f) {
        return this.putJSONStr(name).put1(58).putJSONA(f);
    }

    public AutoBuffer putJSONAA(String name, Freezable[][] f) {
        return this.putJSONStr(name).put1(58).putJSONAA(f);
    }

    public AutoBuffer putJSONAAA(String name, Freezable[][][] f) {
        return this.putJSONStr(name).put1(58).putJSONAAA(f);
    }

    public AutoBuffer putJSONZ(String name, boolean value) {
        return this.putJSONStr(name).put1(58).putJStr("" + value);
    }

    private AutoBuffer putJSONAZ(boolean[] b) {
        if (b == null) {
            return this.putJNULL();
        }
        this.put1(91);
        for (int i = 0; i < b.length; ++i) {
            if (i > 0) {
                this.put1(44);
            }
            this.putJStr("" + b[i]);
        }
        return this.put1(93);
    }

    private AutoBuffer putJInt(int i) {
        byte[] b = StringUtils.toBytes(i);
        return this.putA1(b, b.length);
    }

    public AutoBuffer putJSON1(byte b) {
        return this.putJInt(b);
    }

    public AutoBuffer putJSONA1(byte[] ary) {
        if (ary == null) {
            return this.putJNULL();
        }
        this.put1(91);
        for (int i = 0; i < ary.length; ++i) {
            if (i > 0) {
                this.put1(44);
            }
            this.putJSON1(ary[i]);
        }
        return this.put1(93);
    }

    private AutoBuffer putJSONAA1(byte[][] ary) {
        if (ary == null) {
            return this.putJNULL();
        }
        this.put1(91);
        for (int i = 0; i < ary.length; ++i) {
            if (i > 0) {
                this.put1(44);
            }
            this.putJSONA1(ary[i]);
        }
        return this.put1(93);
    }

    public AutoBuffer putJSON1(String name, byte b) {
        return this.putJSONStr(name).put1(58).putJSON1(b);
    }

    public AutoBuffer putJSONA1(String name, byte[] b) {
        return this.putJSONStr(name).put1(58).putJSONA1(b);
    }

    public AutoBuffer putJSONAA1(String name, byte[][] b) {
        return this.putJSONStr(name).put1(58).putJSONAA1(b);
    }

    public AutoBuffer putJSONAEnum(String name, Enum[] enums) {
        return this.putJSONStr(name).put1(58).putJSONAEnum(enums);
    }

    public AutoBuffer putJSONAEnum(Enum[] enums) {
        if (enums == null) {
            return this.putJNULL();
        }
        this.put1(91);
        for (int i = 0; i < enums.length; ++i) {
            if (i > 0) {
                this.put1(44);
            }
            this.putJSONEnum(enums[i]);
        }
        return this.put1(93);
    }

    AutoBuffer putJSON2(char c) {
        return this.putJSON4(c);
    }

    AutoBuffer putJSON2(String name, char c) {
        return this.putJSONStr(name).put1(58).putJSON2(c);
    }

    AutoBuffer putJSON2(short c) {
        return this.putJSON4(c);
    }

    AutoBuffer putJSON2(String name, short c) {
        return this.putJSONStr(name).put1(58).putJSON2(c);
    }

    public AutoBuffer putJSONA2(String name, short[] ary) {
        return this.putJSONStr(name).put1(58).putJSONA2(ary);
    }

    AutoBuffer putJSONA2(short[] ary) {
        if (ary == null) {
            return this.putJNULL();
        }
        this.put1(91);
        for (int i = 0; i < ary.length; ++i) {
            if (i > 0) {
                this.put1(44);
            }
            this.putJSON2(ary[i]);
        }
        return this.put1(93);
    }

    AutoBuffer putJSON8(long l) {
        return this.putJStr(Long.toString(l));
    }

    AutoBuffer putJSONA8(long[] ary) {
        if (ary == null) {
            return this.putJNULL();
        }
        this.put1(91);
        for (int i = 0; i < ary.length; ++i) {
            if (i > 0) {
                this.put1(44);
            }
            this.putJSON8(ary[i]);
        }
        return this.put1(93);
    }

    AutoBuffer putJSONAA8(long[][] ary) {
        if (ary == null) {
            return this.putJNULL();
        }
        this.put1(91);
        for (int i = 0; i < ary.length; ++i) {
            if (i > 0) {
                this.put1(44);
            }
            this.putJSONA8(ary[i]);
        }
        return this.put1(93);
    }

    AutoBuffer putJSONAAA8(long[][][] ary) {
        if (ary == null) {
            return this.putJNULL();
        }
        this.put1(91);
        for (int i = 0; i < ary.length; ++i) {
            if (i > 0) {
                this.put1(44);
            }
            this.putJSONAA8(ary[i]);
        }
        return this.put1(93);
    }

    AutoBuffer putJSONEnum(Enum e) {
        return e == null ? this.putJNULL() : this.put1(34).putJStr(e.toString()).put1(34);
    }

    public AutoBuffer putJSON8(String name, long l) {
        return this.putJSONStr(name).put1(58).putJSON8(l);
    }

    public AutoBuffer putJSONEnum(String name, Enum e) {
        return this.putJSONStr(name).put1(58).putJSONEnum(e);
    }

    public AutoBuffer putJSONA8(String name, long[] ary) {
        return this.putJSONStr(name).put1(58).putJSONA8(ary);
    }

    public AutoBuffer putJSONAA8(String name, long[][] ary) {
        return this.putJSONStr(name).put1(58).putJSONAA8(ary);
    }

    public AutoBuffer putJSONAAA8(String name, long[][][] ary) {
        return this.putJSONStr(name).put1(58).putJSONAAA8(ary);
    }

    public AutoBuffer putJSON4(int i) {
        return this.putJStr(Integer.toString(i));
    }

    AutoBuffer putJSONA4(int[] a) {
        if (a == null) {
            return this.putJNULL();
        }
        this.put1(91);
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                this.put1(44);
            }
            this.putJSON4(a[i]);
        }
        return this.put1(93);
    }

    AutoBuffer putJSONAA4(int[][] a) {
        if (a == null) {
            return this.putJNULL();
        }
        this.put1(91);
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                this.put1(44);
            }
            this.putJSONA4(a[i]);
        }
        return this.put1(93);
    }

    AutoBuffer putJSONAAA4(int[][][] a) {
        if (a == null) {
            return this.putJNULL();
        }
        this.put1(91);
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                this.put1(44);
            }
            this.putJSONAA4(a[i]);
        }
        return this.put1(93);
    }

    public AutoBuffer putJSON4(String name, int i) {
        return this.putJSONStr(name).put1(58).putJSON4(i);
    }

    public AutoBuffer putJSONA4(String name, int[] a) {
        return this.putJSONStr(name).put1(58).putJSONA4(a);
    }

    public AutoBuffer putJSONAA4(String name, int[][] a) {
        return this.putJSONStr(name).put1(58).putJSONAA4(a);
    }

    public AutoBuffer putJSONAAA4(String name, int[][][] a) {
        return this.putJSONStr(name).put1(58).putJSONAAA4(a);
    }

    AutoBuffer putJSON4f(float f) {
        return f == Float.POSITIVE_INFINITY ? this.putJSONStr(JSON_POS_INF) : (f == Float.NEGATIVE_INFINITY ? this.putJSONStr(JSON_NEG_INF) : (Float.isNaN(f) ? this.putJSONStr(JSON_NAN) : this.putJStr(Float.toString(f))));
    }

    public AutoBuffer putJSON4f(String name, float f) {
        return this.putJSONStr(name).put1(58).putJSON4f(f);
    }

    AutoBuffer putJSONA4f(float[] a) {
        if (a == null) {
            return this.putJNULL();
        }
        this.put1(91);
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                this.put1(44);
            }
            this.putJSON4f(a[i]);
        }
        return this.put1(93);
    }

    public AutoBuffer putJSONA4f(String name, float[] a) {
        this.putJSONStr(name).put1(58);
        return this.putJSONA4f(a);
    }

    AutoBuffer putJSONAA4f(String name, float[][] a) {
        this.putJSONStr(name).put1(58);
        if (a == null) {
            return this.putJNULL();
        }
        this.put1(91);
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                this.put1(44);
            }
            this.putJSONA4f(a[i]);
        }
        return this.put1(93);
    }

    AutoBuffer putJSON8d(double d) {
        if (TwoDimTable.isEmpty(d)) {
            return this.putJNULL();
        }
        return d == Double.POSITIVE_INFINITY ? this.putJSONStr(JSON_POS_INF) : (d == Double.NEGATIVE_INFINITY ? this.putJSONStr(JSON_NEG_INF) : (Double.isNaN(d) ? this.putJSONStr(JSON_NAN) : this.putJStr(Double.toString(d))));
    }

    public AutoBuffer putJSON8d(String name, double d) {
        return this.putJSONStr(name).put1(58).putJSON8d(d);
    }

    public AutoBuffer putJSONA8d(String name, double[] a) {
        return this.putJSONStr(name).put1(58).putJSONA8d(a);
    }

    public AutoBuffer putJSONAA8d(String name, double[][] a) {
        return this.putJSONStr(name).put1(58).putJSONAA8d(a);
    }

    public AutoBuffer putJSONAAA8d(String name, double[][][] a) {
        return this.putJSONStr(name).put1(58).putJSONAAA8d(a);
    }

    public AutoBuffer putJSONA8d(double[] a) {
        if (a == null) {
            return this.putJNULL();
        }
        this.put1(91);
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                this.put1(44);
            }
            this.putJSON8d(a[i]);
        }
        return this.put1(93);
    }

    public AutoBuffer putJSONAA8d(double[][] a) {
        if (a == null) {
            return this.putJNULL();
        }
        this.put1(91);
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                this.put1(44);
            }
            this.putJSONA8d(a[i]);
        }
        return this.put1(93);
    }

    AutoBuffer putJSONAAA8d(double[][][] ary) {
        if (ary == null) {
            return this.putJNULL();
        }
        this.put1(91);
        for (int i = 0; i < ary.length; ++i) {
            if (i > 0) {
                this.put1(44);
            }
            this.putJSONAA8d(ary[i]);
        }
        return this.put1(93);
    }

    public static class AutoBufferException
    extends RuntimeException {
        public final IOException _ioe;

        AutoBufferException(IOException ioe) {
            this._ioe = ioe;
        }
    }

    static class BBPool {
        long _made;
        long _cached;
        long _freed;
        long _numer;
        long _denom;
        long _goal = 4 * H2O.NUMCPUS;
        long _lastGoal;
        final ArrayList<ByteBuffer> _bbs = new ArrayList();
        final int _size;

        BBPool(int sz) {
            this._size = sz;
        }

        private ByteBuffer stats(ByteBuffer bb) {
            if (!DEBUG) {
                return bb;
            }
            if ((this._made + this._cached & 0xFFL) != 255L) {
                return bb;
            }
            long now = System.currentTimeMillis();
            if (now < HWM) {
                return bb;
            }
            HWM = now + 1000L;
            SB sb = new SB();
            sb.p("BB").p(this == BBP_BIG ? 1 : 0).p(" made=").p(this._made).p(" -freed=").p(this._freed).p(", cache hit=").p(this._cached).p(" ratio=").p(this._numer / this._denom).p(", goal=").p(this._goal).p(" cache size=").p(this._bbs.size()).nl();
            for (int i = 0; i < 126; ++i) {
                int x = H2O.getWrkQueueSize(i);
                if (x <= 0) continue;
                sb.p('Q').p(i).p('=').p(x).p(' ');
            }
            Log.warn(sb.nl().toString());
            return bb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ByteBuffer make() {
            while (true) {
                ByteBuffer bb = null;
                Object object = this._bbs;
                synchronized (object) {
                    int sz = this._bbs.size();
                    if (sz > 0) {
                        bb = this._bbs.remove(sz - 1);
                        ++this._cached;
                        ++this._numer;
                    }
                }
                if (bb != null) {
                    return this.stats(bb);
                }
                try {
                    bb = ByteBuffer.allocateDirect(this._size).order(ByteOrder.nativeOrder());
                    object = this;
                    synchronized (object) {
                        ++this._made;
                        ++this._denom;
                        this._goal = Math.max(this._goal, this._made - this._freed);
                        this._lastGoal = System.nanoTime();
                    }
                    return this.stats(bb);
                }
                catch (OutOfMemoryError oome) {
                    if (!"Direct buffer memory".equals(oome.getMessage())) {
                        throw oome;
                    }
                    System.out.println("OOM DBB - Sleeping & retrying");
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void free(ByteBuffer bb) {
            long ratio = this._numer / (this._denom + 1L);
            ArrayList<ByteBuffer> arrayList = this._bbs;
            synchronized (arrayList) {
                if (ratio < 100L || (long)this._bbs.size() < this._goal) {
                    bb.clear();
                    this._bbs.add(bb);
                } else {
                    ++this._freed;
                }
                long now = System.nanoTime();
                if (now - this._lastGoal > 1000000000L) {
                    long denom;
                    this._lastGoal = now;
                    if (ratio > 110L) {
                        this._goal = Math.max((long)(4 * H2O.NUMCPUS), (long)((double)this._goal * 0.99));
                    }
                    if ((denom = (long)(0.99 * (double)this._denom)) > 10L) {
                        this._numer = (long)(0.99 * (double)this._numer);
                        this._denom = denom;
                    }
                }
            }
        }

        static int FREE(ByteBuffer bb) {
            if (bb.isDirect()) {
                (bb.capacity() == AutoBuffer.BBP_BIG._size ? BBP_BIG : BBP_SML).free(bb);
            }
            return 0;
        }
    }
}

