/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.mungers;

import java.util.Arrays;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.ast.params.AstNum;
import water.rapids.ast.params.AstNumList;
import water.rapids.ast.params.AstStr;
import water.rapids.ast.params.AstStrList;
import water.rapids.vals.ValFrame;
import water.util.MathUtils;

public class AstCut
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "breaks", "labels", "include_lowest", "right", "digits"};
    }

    @Override
    public int nargs() {
        return 7;
    }

    @Override
    public String str() {
        return "cut";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        double[] cuts = this.check(asts[2]);
        Arrays.sort(cuts);
        String[] labels = this.check2(asts[3]);
        final boolean lowest = asts[4].exec(env).getNum() == 1.0;
        final boolean rite = asts[5].exec(env).getNum() == 1.0;
        int digits = Math.min((int)asts[6].exec(env).getNum(), 12);
        if (fr.vecs().length != 1 || fr.vecs()[0].isCategorical()) {
            throw new IllegalArgumentException("First argument must be a numeric column vector");
        }
        double fmin = fr.anyVec().min();
        double fmax = fr.anyVec().max();
        int nbins = cuts.length - 1;
        if (nbins == 0) {
            if (cuts[0] < 2.0) {
                throw new IllegalArgumentException("The number of cuts must be >= 2. Got: " + cuts[0]);
            }
            nbins = (int)Math.floor(cuts[0]);
            double width = (fmax - fmin) / (double)nbins;
            cuts = new double[nbins];
            cuts[0] = fmin - 0.001 * (fmax - fmin);
            for (int i = 1; i < cuts.length; ++i) {
                cuts[i] = i == cuts.length - 1 ? fmax + 0.001 * (fmax - fmin) : fmin + (double)i * width;
            }
        }
        if (labels != null && labels.length != nbins) {
            throw new IllegalArgumentException("`labels` vector does not match the number of cuts.");
        }
        final double[] cutz = cuts;
        for (int i = 0; i < cuts.length; ++i) {
            cuts[i] = Math.floor(cuts[i] * Math.pow(10.0, digits) + 0.5) / Math.pow(10.0, digits);
        }
        String[][] domains = new String[1][nbins];
        if (labels == null) {
            domains[0][0] = (lowest ? "[" : this.left(rite)) + cuts[0] + "," + cuts[1] + this.rite(rite);
            for (int i = 1; i < cuts.length - 1; ++i) {
                domains[0][i] = this.left(rite) + cuts[i] + "," + cuts[i + 1] + this.rite(rite);
            }
        } else {
            domains[0] = labels;
        }
        Frame fr2 = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk c, NewChunk nc) {
                int rows = c._len;
                block0: for (int r = 0; r < rows; ++r) {
                    double x = c.atd(r);
                    if (Double.isNaN(x) || lowest && x < cutz[0] || !lowest && (x < cutz[0] || MathUtils.equalsWithinOneSmallUlp(x, cutz[0])) || rite && x > cutz[cutz.length - 1] || !rite && (x > cutz[cutz.length - 1] || MathUtils.equalsWithinOneSmallUlp(x, cutz[cutz.length - 1]))) {
                        nc.addNum(Double.NaN);
                        continue;
                    }
                    for (int i = 1; i < cutz.length; ++i) {
                        if (rite) {
                            if (!(x <= cutz[i])) continue;
                            nc.addNum(i - 1);
                            continue block0;
                        }
                        if (!(x < cutz[i])) continue;
                        nc.addNum(i - 1);
                        continue block0;
                    }
                }
            }
        }.doAll(1, (byte)3, fr)).outputFrame(fr.names(), domains);
        return new ValFrame(fr2);
    }

    private String left(boolean rite) {
        return rite ? "(" : "[";
    }

    private String rite(boolean rite) {
        return rite ? "]" : ")";
    }

    private double[] check(AstRoot ast) {
        double[] n;
        if (ast instanceof AstNumList) {
            n = ((AstNumList)ast).expand();
        } else if (ast instanceof AstNum) {
            n = new double[]{((AstNum)ast).getNum()};
        } else {
            throw new IllegalArgumentException("Requires a number-list, but found a " + ast.getClass());
        }
        return n;
    }

    private String[] check2(AstRoot ast) {
        String[] s = null;
        if (ast instanceof AstStrList) {
            s = ((AstStrList)ast)._strs;
        } else if (ast instanceof AstStr) {
            s = new String[]{ast.str()};
        }
        return s;
    }
}

