/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import water.DTask;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.RPC;
import water.util.Log;
import water.util.StringUtils;

public class GetLogsFromNode
extends Iced {
    static final int MB = 0x100000;
    static final int MAX_SIZE = 0x1900000;
    public int nodeidx;
    public byte[] bytes;

    public void doIt() {
        if (this.nodeidx == -1) {
            GetLogsTask t = new GetLogsTask();
            t.doIt();
            this.bytes = t._bytes;
        } else {
            H2ONode node = H2O.CLOUD._memary[this.nodeidx];
            GetLogsTask t = new GetLogsTask();
            Log.trace("GetLogsTask starting to node " + this.nodeidx + "...");
            new RPC<GetLogsTask>(node, t).call().get();
            Log.trace("GetLogsTask completed to node " + this.nodeidx);
            this.bytes = t._bytes;
        }
    }

    private static class GetLogsTask
    extends DTask<GetLogsTask> {
        private byte[] _bytes = null;

        public GetLogsTask() {
            super((byte)119);
        }

        public void doIt() {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ZipOutputStream zos = new ZipOutputStream(baos);
                this.zipDir(Log.LOG_DIR, baos, zos);
                zos.close();
                baos.close();
                this._bytes = baos.toByteArray();
            }
            catch (Exception e) {
                this._bytes = StringUtils.toBytes(e);
            }
        }

        @Override
        public void compute2() {
            this.doIt();
            this.tryComplete();
        }

        private void zipDir(String dir2zip, ByteArrayOutputStream baos, ZipOutputStream zos) throws IOException {
            try {
                File zipDir = new File(dir2zip);
                String[] dirList = zipDir.list();
                byte[] readBuffer = new byte[4096];
                int bytesIn = 0;
                for (int i = 0; i < dirList.length; ++i) {
                    File f = new File(zipDir, dirList[i]);
                    if (f.isDirectory()) {
                        String filePath = f.getPath();
                        this.zipDir(filePath, baos, zos);
                        continue;
                    }
                    if (f.toString().endsWith(".jar")) continue;
                    FileInputStream fis = new FileInputStream(f);
                    ZipEntry anEntry = new ZipEntry(f.getPath());
                    anEntry.setTime(f.lastModified());
                    zos.putNextEntry(anEntry);
                    boolean stopEarlyBecauseTooMuchData = false;
                    while ((bytesIn = fis.read(readBuffer)) != -1) {
                        zos.write(readBuffer, 0, bytesIn);
                        if (baos.size() <= 0x1900000) continue;
                        stopEarlyBecauseTooMuchData = true;
                        break;
                    }
                    fis.close();
                    zos.closeEntry();
                    if (!stopEarlyBecauseTooMuchData) continue;
                    Log.warn("GetLogsTask stopEarlyBecauseTooMuchData");
                    break;
                }
            }
            catch (Exception e) {
                Log.warn(e);
            }
        }
    }
}

