/*
 * Decompiled with CFR 0.152.
 */
package water;

import com.brsanthu.googleanalytics.DefaultRequest;
import com.brsanthu.googleanalytics.GoogleAnalytics;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import jsr166y.CountedCompleter;
import jsr166y.ForkJoinPool;
import jsr166y.ForkJoinTask;
import jsr166y.ForkJoinWorkerThread;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import water.AbstractH2OExtension;
import water.AutoBuffer;
import water.Cleaner;
import water.DTask;
import water.ExtensionManager;
import water.Freezable;
import water.Futures;
import water.H2ONode;
import water.HeartBeatThread;
import water.Icer;
import water.JettyHTTPD;
import water.Job;
import water.Key;
import water.MultiReceiverThread;
import water.Paxos;
import water.RPC;
import water.Scope;
import water.TCPReceiverThread;
import water.TypeMap;
import water.UDPRebooted;
import water.UDPReceiverThread;
import water.UDPTimeOutThread;
import water.Value;
import water.api.Handler;
import water.api.RequestServer;
import water.exceptions.H2OFailException;
import water.exceptions.H2OIllegalArgumentException;
import water.init.AbstractBuildVersion;
import water.init.AbstractEmbeddedH2OConfig;
import water.init.JarHash;
import water.init.NetworkInit;
import water.init.NodePersistentStorage;
import water.nbhm.NonBlockingHashMap;
import water.parser.DecryptionTool;
import water.parser.ParserService;
import water.persist.PersistManager;
import water.util.GAUtils;
import water.util.Log;
import water.util.NetworkUtils;
import water.util.OSUtils;
import water.util.PrettyPrint;

public final class H2O {
    public static final String DEFAULT_JKS_PASS = "h2oh2o";
    public static final OptArgs ARGS = new OptArgs();
    public static GoogleAnalytics GA;
    public static int CLIENT_TYPE_GA_CUST_DIM;
    public static int CLIENT_ID_GA_CUST_DIM;
    public static volatile AbstractEmbeddedH2OConfig embeddedH2OConfig;
    private static volatile boolean _shutdownRequested;
    public static final AbstractBuildVersion ABV;
    private static boolean _haveInheritedLog4jConfiguration;
    private static ArrayList<AboutEntry> aboutEntries;
    private static AtomicLong nextModelNum;
    private static volatile long lastTimeSomethingHappenedMillis;
    private static volatile AtomicInteger activeRapidsExecs;
    public static final AtomicLong START_TIME_MILLIS;
    public static final int NUMCPUS;
    public static final long PID;
    private static final ExtensionManager extManager;
    public static final byte MAX_PRIORITY = 126;
    public static final byte ACK_ACK_PRIORITY = 126;
    public static final byte FETCH_ACK_PRIORITY = 125;
    public static final byte ACK_PRIORITY = 124;
    public static final byte DESERIAL_PRIORITY = 123;
    public static final byte INVALIDATE_PRIORITY = 123;
    public static final byte GET_KEY_PRIORITY = 122;
    public static final byte PUT_KEY_PRIORITY = 121;
    public static final byte ATOMIC_PRIORITY = 120;
    public static final byte GUI_PRIORITY = 119;
    public static final byte MIN_HI_PRIORITY = 119;
    public static final byte MIN_PRIORITY = 0;
    private static final PrioritizedForkJoinPool[] FJPS;
    public static int LOW_PRIORITY_API_WORK;
    public static String LOW_PRIORITY_API_WORK_CLASS;
    public static int H2O_PORT;
    public static int API_PORT;
    public static MulticastSocket CLOUD_MULTICAST_SOCKET;
    public static NetworkInterface CLOUD_MULTICAST_IF;
    public static InetAddress CLOUD_MULTICAST_GROUP;
    public static int CLOUD_MULTICAST_PORT;
    public static H2ONode SELF;
    public static InetAddress SELF_ADDRESS;
    static final boolean IS_IPV6;
    public static URI ICE_ROOT;
    private static HashSet<H2ONode> STATIC_H2OS;
    private static Map<String, H2ONode> CLIENTS_MAP;
    private static final H2O[] CLOUDS;
    static final String DEBUG_ARG = "h2o.debug";
    static final boolean DEBUG;
    public static final long CLUSTER_ID;
    private static JettyHTTPD jetty;
    public static volatile H2O CLOUD;
    public final H2ONode[] _memary;
    private final HashMap<String, Integer> _node_ip_to_index;
    final int _hash;
    final char _idx;
    public static final NonBlockingHashMap<Key, Value> STORE;
    private static PersistManager _PM;
    private static NodePersistentStorage NPS;

    public static void printHelp() {
        String defaultFlowDirMessage = H2O.DEFAULT_FLOW_DIR() == null ? "          (The default is none; saving flows not available.)\n" : "          (The default is '" + H2O.DEFAULT_FLOW_DIR() + "'.)\n";
        String s = "\nUsage:  java [-Xmx<size>] -jar h2o.jar [options]\n        (Note that every option has a default and is optional.)\n\n    -h | -help\n          Print this help.\n\n    -version\n          Print version info and exit.\n\n    -name <h2oCloudName>\n          Cloud name used for discovery of other nodes.\n          Nodes with the same cloud name will form an H2O cloud\n          (also known as an H2O cluster).\n\n    -flatfile <flatFileName>\n          Configuration file explicitly listing H2O cloud node members.\n\n    -ip <ipAddressOfNode>\n          IP address of this node.\n\n    -port <port>\n          Port number for this node (note: port+1 is also used).\n          (The default port is " + H2O.ARGS.port + ".)\n" + "\n" + "    -network <IPv4network1Specification>[,<IPv4network2Specification> ...]\n" + "          The IP address discovery code will bind to the first interface\n" + "          that matches one of the networks in the comma-separated list.\n" + "          Use instead of -ip when a broad range of addresses is legal.\n" + "          (Example network specification: '10.1.2.0/24' allows 256 legal\n" + "          possibilities.)\n" + "\n" + "    -ice_root <fileSystemPath>\n" + "          The directory where H2O spills temporary data to disk.\n" + "\n" + "    -log_dir <fileSystemPath>\n" + "          The directory where H2O writes logs to disk.\n" + "          (This usually has a good default that you need not change.)\n" + "\n" + "    -log_level <TRACE,DEBUG,INFO,WARN,ERRR,FATAL>\n" + "          Write messages at this logging level, or above.  Default is INFO." + "\n" + "\n" + "    -flow_dir <server side directory or HDFS directory>\n" + "          The directory where H2O stores saved flows.\n" + defaultFlowDirMessage + "\n" + "    -nthreads <#threads>\n" + "          Maximum number of threads in the low priority batch-work queue.\n" + "          (The default is " + (char)Runtime.getRuntime().availableProcessors() + ".)\n" + "\n" + "    -client\n" + "          Launch H2O node in client mode.\n" + "\n" + "    -context_path <context_path>\n" + "          The context path for jetty.\n" + "\n" + "Authentication options:\n" + "\n" + "    -jks <filename>\n" + "          Java keystore file\n" + "\n" + "    -jks_pass <password>\n" + "          (Default is '" + DEFAULT_JKS_PASS + "')\n" + "\n" + "    -hash_login\n" + "          Use Jetty HashLoginService\n" + "\n" + "    -ldap_login\n" + "          Use Jetty LdapLoginService\n" + "\n" + "    -kerberos_login\n" + "          Use Kerberos LoginService\n" + "\n" + "    -pam_login\n" + "          Use PAM LoginService\n" + "\n" + "    -login_conf <filename>\n" + "          LoginService configuration file\n" + "\n" + "    -form_auth\n" + "          Enables Form-based authentication for Flow (default is Basic authentication)\n" + "\n" + "    -session_timeout <minutes>\n" + "          Specifies the number of minutes that a session can remain idle before the server invalidates\n" + "          the session and requests a new login. Requires '-form_auth'. Default is no timeout\n" + "\n" + "    -internal_security_conf <filename>\n" + "          Path (absolute or relative) to a file containing all internal security related configurations\n" + "\n" + "Cloud formation behavior:\n" + "\n" + "    New H2O nodes join together to form a cloud at startup time.\n" + "    Once a cloud is given work to perform, it locks out new members\n" + "    from joining.\n" + "\n" + "Examples:\n" + "\n" + "    Start an H2O node with 4GB of memory and a default cloud name:\n" + "        $ java -Xmx4g -jar h2o.jar\n" + "\n" + "    Start an H2O node with 6GB of memory and a specify the cloud name:\n" + "        $ java -Xmx6g -jar h2o.jar -name MyCloud\n" + "\n" + "    Start an H2O cloud with three 2GB nodes and a default cloud name:\n" + "        $ java -Xmx2g -jar h2o.jar &\n" + "        $ java -Xmx2g -jar h2o.jar &\n" + "        $ java -Xmx2g -jar h2o.jar &\n" + "\n";
        System.out.print(s);
        for (AbstractH2OExtension e : extManager.getCoreExtensions()) {
            e.printHelp();
        }
    }

    public static void parseFailed(String message) {
        System.out.println("");
        System.out.println("ERROR: " + message);
        System.out.println("");
        H2O.printHelp();
        H2O.exit(1);
    }

    static void parseArguments(String[] args) {
        for (AbstractH2OExtension e : extManager.getCoreExtensions()) {
            args = e.parseArguments(args);
        }
        H2O.parseH2OArgumentsTo(args, ARGS);
    }

    static OptArgs parseH2OArgumentsTo(String[] args, OptArgs trgt) {
        for (int i = 0; i < args.length; ++i) {
            OptString s = new OptString(args[i]);
            if (s.matches("h") || s.matches("help")) {
                trgt.help = true;
                continue;
            }
            if (s.matches("version")) {
                trgt.version = true;
                continue;
            }
            if (s.matches("name")) {
                i = s.incrementAndCheck(i, args);
                trgt.name = args[i];
                continue;
            }
            if (s.matches("flatfile")) {
                i = s.incrementAndCheck(i, args);
                trgt.flatfile = args[i];
                continue;
            }
            if (s.matches("port")) {
                i = s.incrementAndCheck(i, args);
                trgt.port = s.parsePort(args[i]);
                continue;
            }
            if (s.matches("baseport")) {
                i = s.incrementAndCheck(i, args);
                trgt.baseport = s.parsePort(args[i]);
                continue;
            }
            if (s.matches("ip")) {
                i = s.incrementAndCheck(i, args);
                trgt.ip = args[i];
                continue;
            }
            if (s.matches("web_ip")) {
                i = s.incrementAndCheck(i, args);
                trgt.web_ip = args[i];
                continue;
            }
            if (s.matches("network")) {
                i = s.incrementAndCheck(i, args);
                trgt.network = args[i];
                continue;
            }
            if (s.matches("client")) {
                trgt.client = true;
                continue;
            }
            if (s.matches("user_name")) {
                i = s.incrementAndCheck(i, args);
                trgt.user_name = args[i];
                continue;
            }
            if (s.matches("ice_root")) {
                i = s.incrementAndCheck(i, args);
                trgt.ice_root = args[i];
                continue;
            }
            if (s.matches("log_dir")) {
                i = s.incrementAndCheck(i, args);
                trgt.log_dir = args[i];
                continue;
            }
            if (s.matches("flow_dir")) {
                i = s.incrementAndCheck(i, args);
                trgt.flow_dir = args[i];
                continue;
            }
            if (s.matches("disable_web")) {
                trgt.disable_web = true;
                continue;
            }
            if (s.matches("context_path")) {
                String value = args[i = s.incrementAndCheck(i, args)];
                trgt.context_path = value.startsWith("/") ? (value.trim().length() == 1 ? "" : value) : "/" + value;
                continue;
            }
            if (s.matches("nthreads")) {
                int nthreads = s.parseInt(args[i = s.incrementAndCheck(i, args)]);
                if (nthreads < 1) continue;
                if (nthreads > Short.MAX_VALUE) {
                    throw H2O.unimpl("Can't handle more than 32767 threads.");
                }
                trgt.nthreads = (short)nthreads;
                continue;
            }
            if (s.matches("hdfs_config")) {
                i = s.incrementAndCheck(i, args);
                trgt.hdfs_config = args[i];
                continue;
            }
            if (s.matches("hdfs_skip")) {
                trgt.hdfs_skip = true;
                continue;
            }
            if (s.matches("aws_credentials")) {
                i = s.incrementAndCheck(i, args);
                trgt.aws_credentials = args[i];
                continue;
            }
            if (s.matches("ga_hadoop_ver")) {
                i = s.incrementAndCheck(i, args);
                trgt.ga_hadoop_ver = args[i];
                continue;
            }
            if (s.matches("ga_opt_out")) {
                if (i + 1 < args.length && args[i + 1].equals("yes")) {
                    ++i;
                }
                trgt.ga_opt_out = true;
                continue;
            }
            if (s.matches("log_level")) {
                i = s.incrementAndCheck(i, args);
                trgt.log_level = args[i];
                continue;
            }
            if (s.matches("random_udp_drop")) {
                trgt.random_udp_drop = true;
                continue;
            }
            if (s.matches("md5skip")) {
                trgt.md5skip = true;
                continue;
            }
            if (s.matches("quiet")) {
                trgt.quiet = true;
                continue;
            }
            if (s.matches("useUDP")) {
                trgt.useUDP = true;
                continue;
            }
            if (s.matches("cleaner")) {
                trgt.cleaner = true;
                continue;
            }
            if (s.matches("jks")) {
                i = s.incrementAndCheck(i, args);
                trgt.jks = args[i];
                continue;
            }
            if (s.matches("jks_pass")) {
                i = s.incrementAndCheck(i, args);
                trgt.jks_pass = args[i];
                continue;
            }
            if (s.matches("hash_login")) {
                trgt.hash_login = true;
                continue;
            }
            if (s.matches("ldap_login")) {
                trgt.ldap_login = true;
                continue;
            }
            if (s.matches("kerberos_login")) {
                trgt.kerberos_login = true;
                continue;
            }
            if (s.matches("pam_login")) {
                trgt.pam_login = true;
                continue;
            }
            if (s.matches("login_conf")) {
                i = s.incrementAndCheck(i, args);
                trgt.login_conf = args[i];
                continue;
            }
            if (s.matches("form_auth")) {
                trgt.form_auth = true;
                continue;
            }
            if (s.matches("session_timeout")) {
                i = s.incrementAndCheck(i, args);
                trgt.session_timeout_spec = args[i];
                try {
                    trgt.session_timeout = Integer.parseInt(args[i]);
                }
                catch (Exception exception) {}
                continue;
            }
            if (s.matches("internal_security_conf")) {
                i = s.incrementAndCheck(i, args);
                trgt.internal_security_conf = args[i];
                continue;
            }
            if (s.matches("decrypt_tool")) {
                i = s.incrementAndCheck(i, args);
                trgt.decrypt_tool = args[i];
                continue;
            }
            if (s.matches("no_latest_check")) {
                trgt.noLatestCheck = true;
                continue;
            }
            H2O.parseFailed("Unknown argument (" + s + ")");
        }
        return trgt;
    }

    private static void validateArguments() {
        if (H2O.ARGS.jks != null && !new File(H2O.ARGS.jks).exists()) {
            H2O.parseFailed("File does not exist: " + H2O.ARGS.jks);
        }
        if (H2O.ARGS.login_conf != null && !new File(H2O.ARGS.login_conf).exists()) {
            H2O.parseFailed("File does not exist: " + H2O.ARGS.login_conf);
        }
        int login_arg_count = 0;
        if (H2O.ARGS.hash_login) {
            ++login_arg_count;
        }
        if (H2O.ARGS.ldap_login) {
            ++login_arg_count;
        }
        if (H2O.ARGS.kerberos_login) {
            ++login_arg_count;
        }
        if (H2O.ARGS.pam_login) {
            ++login_arg_count;
        }
        if (login_arg_count > 1) {
            H2O.parseFailed("Can only specify one of -hash_login, -ldap_login, -kerberos_login and -pam_login");
        }
        if (H2O.ARGS.hash_login || H2O.ARGS.ldap_login || H2O.ARGS.kerberos_login || H2O.ARGS.pam_login) {
            if (H2O.ARGS.login_conf == null) {
                H2O.parseFailed("Must specify -login_conf argument");
            }
        } else if (H2O.ARGS.form_auth) {
            H2O.parseFailed("No login method was specified. Form-based authentication can only be used in conjunction with of a LoginService.\nPick a LoginService by specifying '-<method>_login' option.");
        }
        if (H2O.ARGS.session_timeout_spec != null) {
            if (!H2O.ARGS.form_auth) {
                H2O.parseFailed("Session timeout can only be enabled for Form based authentication (use -form_auth)");
            }
            if (H2O.ARGS.session_timeout <= 0) {
                H2O.parseFailed("Invalid session timeout specification (" + H2O.ARGS.session_timeout + ")");
            }
        }
        for (AbstractH2OExtension e : extManager.getCoreExtensions()) {
            e.validateArguments();
        }
    }

    public static void setEmbeddedH2OConfig(AbstractEmbeddedH2OConfig c) {
        embeddedH2OConfig = c;
    }

    public static AbstractEmbeddedH2OConfig getEmbeddedH2OConfig() {
        return embeddedH2OConfig;
    }

    public static void notifyAboutCloudSize(InetAddress ip, int port, int size) {
        if (embeddedH2OConfig == null) {
            return;
        }
        embeddedH2OConfig.notifyAboutCloudSize(ip, port, size);
    }

    public static void closeAll() {
        try {
            NetworkInit._udpSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            H2O.getJetty().stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            NetworkInit._tcpSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PersistManager PM = H2O.getPM();
        if (PM != null) {
            PM.getIce().cleanUp();
        }
    }

    public static void exit(int status) {
        if (embeddedH2OConfig != null) {
            embeddedH2OConfig.exit(status);
        }
        Log.flushStdout();
        System.exit(status);
    }

    public static void shutdown(int status) {
        if (status == 0) {
            H2O.orderlyShutdown();
        }
        UDPRebooted.T.error.send(SELF);
        H2O.exit(status);
    }

    public static int orderlyShutdown() {
        return H2O.orderlyShutdown(-1);
    }

    public static int orderlyShutdown(int timeout) {
        boolean[] confirmations = new boolean[CLOUD.size()];
        if (SELF.index() >= 0) {
            confirmations[H2O.SELF.index()] = true;
        }
        Futures fs = new Futures();
        for (H2ONode n : H2O.CLOUD._memary) {
            if (n == SELF) continue;
            fs.add(new RPC<UDPRebooted.ShutdownTsk>(n, new UDPRebooted.ShutdownTsk(SELF, n.index(), 1000, confirmations, 0)).call());
        }
        if (timeout > 0) {
            try {
                Thread.sleep(timeout);
            }
            catch (Exception arr$) {}
        } else {
            fs.blockForPending();
        }
        int failedToShutdown = 0;
        for (boolean b : confirmations) {
            if (b) continue;
            ++failedToShutdown;
        }
        return failedToShutdown;
    }

    public static void requestShutdown() {
        _shutdownRequested = true;
    }

    public static boolean getShutdownRequested() {
        return _shutdownRequested;
    }

    public static boolean haveInheritedLog4jConfiguration() {
        return _haveInheritedLog4jConfiguration;
    }

    public static void configureLogging() {
        if (LogManager.getCurrentLoggers().hasMoreElements()) {
            _haveInheritedLog4jConfiguration = true;
            return;
        }
        if (System.getProperty("log4j.configuration") != null) {
            _haveInheritedLog4jConfiguration = true;
            return;
        }
        Properties p = new Properties();
        p.setProperty("log4j.rootCategory", "WARN, console");
        p.setProperty("log4j.logger.org.eclipse.jetty", "WARN");
        p.setProperty("log4j.appender.console", "org.apache.log4j.ConsoleAppender");
        p.setProperty("log4j.appender.console.layout", "org.apache.log4j.PatternLayout");
        p.setProperty("log4j.appender.console.layout.ConversionPattern", "%m%n");
        PropertyConfigurator.configure((Properties)p);
        System.setProperty("org.eclipse.jetty.LEVEL", "WARN");
        System.setProperty("org.eclipse.jetty.util.log.class", "org.eclipse.jetty.util.log.StdErrLog");
    }

    public static void addAboutEntry(String name, String value) {
        AboutEntry e = new AboutEntry(name, value);
        aboutEntries.add(e);
    }

    public static ArrayList<AboutEntry> getAboutEntries() {
        return aboutEntries;
    }

    public static synchronized String calcNextUniqueModelId(String desc) {
        StringBuilder sb = new StringBuilder();
        sb.append(desc).append("_model_");
        String source = JettyHTTPD.getUserAgent();
        if (source != null) {
            StringBuilder ua = new StringBuilder();
            if (source.contains("Safari")) {
                ua.append("safari");
            } else if (source.contains("Python")) {
                ua.append("python");
            } else {
                for (int i = 0; i < source.length(); ++i) {
                    char c = source.charAt(i);
                    if (c >= 'a' && c <= 'z') {
                        ua.append(c);
                        continue;
                    }
                    if (c < 'A' || c > 'Z') break;
                    ua.append(c);
                }
            }
            if (ua.toString().length() > 0) {
                sb.append(ua.toString()).append("_");
            }
        }
        long n = nextModelNum.addAndGet(1L);
        sb.append(Long.toString(CLUSTER_ID)).append("_").append(Long.toString(n));
        return sb.toString();
    }

    public static long getIdleTimeMillis() {
        long latestEndTimeMillis = -1L;
        if (activeRapidsExecs.get() > 0) {
            H2O.updateNotIdle();
        } else {
            Job[] jobs = Job.jobs();
            for (int i = jobs.length - 1; i >= 0; --i) {
                Job j = jobs[i];
                if (j.isRunning()) {
                    H2O.updateNotIdle();
                    break;
                }
                if (j.end_time() <= latestEndTimeMillis) continue;
                latestEndTimeMillis = j.end_time();
            }
        }
        long latestTimeMillis = Math.max(latestEndTimeMillis, lastTimeSomethingHappenedMillis);
        long now = System.currentTimeMillis();
        long deltaMillis = now - latestTimeMillis;
        if (deltaMillis < 0L) {
            deltaMillis = 0L;
        }
        return deltaMillis;
    }

    public static void updateNotIdle() {
        lastTimeSomethingHappenedMillis = System.currentTimeMillis();
    }

    public static void incrementActiveRapidsCounter() {
        H2O.updateNotIdle();
        activeRapidsExecs.incrementAndGet();
    }

    public static void decrementActiveRapidsCounter() {
        H2O.updateNotIdle();
        activeRapidsExecs.decrementAndGet();
    }

    public static H2OIllegalArgumentException unimpl() {
        return new H2OIllegalArgumentException("unimplemented");
    }

    public static H2OIllegalArgumentException unimpl(String msg) {
        return new H2OIllegalArgumentException("unimplemented: " + msg);
    }

    public static H2OFailException fail(String msg, Throwable cause) {
        Log.fatal(msg);
        if (null != cause) {
            Log.fatal(cause);
        }
        Log.fatal("Stacktrace: ");
        Log.fatal(Arrays.toString(Thread.currentThread().getStackTrace()));
        H2O.shutdown(-1);
        return new H2OFailException(msg);
    }

    public static H2OFailException fail() {
        return H2O.fail("Unknown code failure");
    }

    public static H2OFailException fail(String msg) {
        return H2O.fail(msg, null);
    }

    public static String technote(int number, String message) {
        return message + "\n\n" + "For more information visit:\n" + "  http://jira.h2o.ai/browse/TN-" + Integer.toString(number);
    }

    public static String technote(int[] numbers, String message) {
        StringBuilder sb = new StringBuilder().append(message).append("\n").append("\n").append("For more information visit:\n");
        for (int number : numbers) {
            sb.append("  http://jira.h2o.ai/browse/TN-").append(Integer.toString(number)).append("\n");
        }
        return sb.toString();
    }

    static int getWrkQueueSize(int i) {
        return FJPS[i] == null ? -1 : FJPS[i].getQueuedSubmissionCount();
    }

    static int getWrkThrPoolSize(int i) {
        return FJPS[i] == null ? -1 : FJPS[i].getPoolSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static <T extends H2OCountedCompleter> T submitTask(T task) {
        byte priority = task.priority();
        if (priority < LOW_PRIORITY_API_WORK) {
            LOW_PRIORITY_API_WORK_CLASS = task.getClass().toString();
        }
        if (!$assertionsDisabled) {
            if (0 > priority) throw new AssertionError((Object)("priority " + priority + " is out of range, expected range is < " + 0 + "," + 126 + ">"));
            if (priority > 126) {
                throw new AssertionError((Object)("priority " + priority + " is out of range, expected range is < " + 0 + "," + 126 + ">"));
            }
        }
        if (FJPS[priority] == null) {
            Class<H2O> clazz = H2O.class;
            // MONITORENTER : water.H2O.class
            if (FJPS[priority] == null) {
                H2O.FJPS[priority] = new PrioritizedForkJoinPool(priority, -1);
            }
            // MONITOREXIT : clazz
        }
        FJPS[priority].submit(task);
        return task;
    }

    public static String getIpPortString() {
        return H2O.ARGS.disable_web ? "" : SELF_ADDRESS.getHostAddress() + ":" + API_PORT;
    }

    public static String getURL(String schema) {
        return H2O.getURL(schema, SELF_ADDRESS, API_PORT, H2O.ARGS.context_path);
    }

    public static String getURL(String schema, InetAddress address, int port, String contextPath) {
        return String.format(address instanceof Inet6Address ? "%s://[%s]:%d%s" : "%s://%s:%d%s", schema, address.getHostAddress(), port, contextPath);
    }

    public static String DEFAULT_ICE_ROOT() {
        String u2;
        String username = System.getProperty("user.name");
        if (username == null) {
            username = "";
        }
        if ((u2 = username.replaceAll(" ", "_")).length() == 0) {
            u2 = "unknown";
        }
        return "/tmp/h2o-" + u2;
    }

    public static String DEFAULT_FLOW_DIR() {
        String flow_dir = null;
        try {
            if (H2O.ARGS.ga_hadoop_ver != null) {
                String s;
                PersistManager pm = H2O.getPM();
                if (pm != null && pm.exists(s = pm.getHdfsHomeDirectory())) {
                    flow_dir = s;
                }
                if (flow_dir != null) {
                    flow_dir = flow_dir + "/h2oflows";
                }
            } else {
                flow_dir = System.getProperty("user.home") + File.separator + "h2oflows";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flow_dir;
    }

    public static void setJetty(JettyHTTPD value) {
        jetty = value;
    }

    public static JettyHTTPD getJetty() {
        return jetty;
    }

    private static void printAndLogVersion(String[] arguments) {
        String latestVersion = H2O.ARGS.noLatestCheck ? "?" : ABV.getLatestH2OVersion();
        Log.init(H2O.ARGS.log_level, H2O.ARGS.quiet);
        Log.info("----- H2O started " + (H2O.ARGS.client ? "(client)" : "") + " -----");
        Log.info("Build git branch: " + ABV.branchName());
        Log.info("Build git hash: " + ABV.lastCommitHash());
        Log.info("Build git describe: " + ABV.describe());
        Log.info("Build project version: " + ABV.projectVersion() + " (latest version: " + latestVersion + ")");
        Log.info("Build age: " + PrettyPrint.toAge(ABV.compiledOnDate(), new Date()));
        Log.info("Built by: '" + ABV.compiledBy() + "'");
        Log.info("Built on: '" + ABV.compiledOn() + "'");
        if (ABV.isTooOld()) {
            Log.warn("\n*** Your H2O version is too old! Please download the latest version " + latestVersion + " from http://h2o.ai/download/ ***");
            Log.warn("");
        }
        for (AbstractH2OExtension e : extManager.getCoreExtensions()) {
            String n = e.getExtensionName() + " ";
            AbstractBuildVersion abv = e.getBuildVersion();
            Log.info(n + "Build git branch: ", abv.branchName());
            Log.info(n + "Build git hash: ", abv.lastCommitHash());
            Log.info(n + "Build git describe: ", abv.describe());
            Log.info(n + "Build project version: ", abv.projectVersion());
            Log.info(n + "Built by: ", abv.compiledBy());
            Log.info(n + "Built on: ", abv.compiledOn());
        }
        Log.info("Processed H2O arguments: ", Arrays.toString(arguments));
        Runtime runtime = Runtime.getRuntime();
        Log.info("Java availableProcessors: " + runtime.availableProcessors());
        Log.info("Java heap totalMemory: " + PrettyPrint.bytes(runtime.totalMemory()));
        Log.info("Java heap maxMemory: " + PrettyPrint.bytes(runtime.maxMemory()));
        Log.info("Java version: Java " + System.getProperty("java.version") + " (from " + System.getProperty("java.vendor") + ")");
        List<String> launchStrings = ManagementFactory.getRuntimeMXBean().getInputArguments();
        Log.info("JVM launch parameters: " + launchStrings);
        Log.info("OS version: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")");
        long totalMemory = OSUtils.getTotalPhysicalMemory();
        Log.info("Machine physical memory: " + (totalMemory == -1L ? "NA" : PrettyPrint.bytes(totalMemory)));
    }

    private static void startGAStartupReport() {
        new GAStartupReportThread().start();
    }

    private static void startLocalNode() {
        NetworkInit.initializeNetworkSockets();
        if (!H2O.ARGS.client && STATIC_H2OS != null && !STATIC_H2OS.contains(SELF)) {
            Log.warn("Flatfile configuration does not include self: " + SELF + " but contains " + STATIC_H2OS);
            STATIC_H2OS.add(SELF);
        }
        Log.info("H2O cloud name: '" + H2O.ARGS.name + "' on " + SELF + (H2O.ARGS.flatfile == null ? ", discovery address " + CLOUD_MULTICAST_GROUP + ":" + CLOUD_MULTICAST_PORT : ", static configuration based on -flatfile " + H2O.ARGS.flatfile));
        if (!H2O.ARGS.disable_web) {
            Log.info("If you have trouble connecting, try SSH tunneling from your local machine (e.g., via port 55555):\n  1. Open a terminal and run 'ssh -L 55555:localhost:" + API_PORT + " " + System.getProperty("user.name") + "@" + SELF_ADDRESS.getHostAddress() + "'\n" + "  2. Point your browser to " + jetty.getScheme() + "://localhost:55555");
        }
        H2O.SELF._heartbeat._jar_md5 = JarHash.JARHASH;
        H2O.SELF._heartbeat._client = H2O.ARGS.client;
        H2O.SELF._heartbeat._cloud_name_hash = H2O.ARGS.name.hashCode();
        if (H2O.ARGS.client) {
            H2O.reportClient(SELF);
        }
    }

    private static void startNetworkServices() {
        UDPRebooted.T.reboot.broadcast();
        if (H2O.ARGS.useUDP) {
            new UDPReceiverThread(NetworkInit._udpSocket).start();
            new UDPTimeOutThread().start();
            new H2ONode.AckAckTimeOutThread().start();
        }
        new MultiReceiverThread().start();
        Cleaner.THE_CLEANER.start();
        new TCPReceiverThread(NetworkInit._tcpSocket).start();
    }

    @Deprecated
    public static void register(String method_url, Class<? extends Handler> hclass, String method, String apiName, String summary) {
        Log.warn("The H2O.register method is deprecated and will be removed in the next major release.Please register REST API endpoints as part of their corresponding REST API extensions!");
        RequestServer.registerEndpoint(apiName, method_url, hclass, method, summary);
    }

    public static void registerResourceRoot(File f) {
        JarHash.registerResourceRoot(f);
    }

    @Deprecated
    public static void finalizeRegistration() {
        H2O.startServingRestApi();
    }

    public static void startServingRestApi() {
        if (!H2O.ARGS.disable_web) {
            jetty.acceptRequests();
        }
    }

    public H2ONode getNodeByIpPort(String ipPort) {
        if (this._node_ip_to_index != null) {
            Integer index = this._node_ip_to_index.get(ipPort);
            if (index != null) {
                if (index == -1) {
                    return SELF;
                }
                if (index < -1 || index >= this._memary.length) {
                    throw new RuntimeException("Mapping from node id to node index contains: " + index + ", however this node" + "does not exist!");
                }
                return this._memary[index];
            }
            return null;
        }
        return null;
    }

    H2O(H2ONode[] h2os, int hash, int idx) {
        this._memary = h2os;
        Arrays.sort(this._memary);
        this._node_ip_to_index = new HashMap();
        for (H2ONode node : this._memary) {
            this._node_ip_to_index.put(node.getIpPortString(), node.index());
        }
        this._hash = hash;
        this._idx = (char)(idx & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set_next_Cloud(H2ONode[] h2os, int hash) {
        H2O h2O = this;
        synchronized (h2O) {
            int idx = this._idx + '\u0001';
            if (idx == 256) {
                idx = 1;
            }
            H2O.CLOUDS[idx] = CLOUD = new H2O(h2os, hash, idx);
        }
        H2O.SELF._heartbeat._cloud_size = (char)CLOUD.size();
    }

    static boolean larger(int nnn, int old) {
        assert (0 <= nnn && nnn <= 255);
        assert (0 <= old && old <= 255);
        return (nnn - old & 0xFF) < 64;
    }

    public final int size() {
        return this._memary.length;
    }

    final H2ONode leader() {
        return this._memary[0];
    }

    int nidx(H2ONode h2o) {
        return Arrays.binarySearch(this._memary, h2o);
    }

    boolean contains(H2ONode h2o) {
        return this.nidx(h2o) >= 0;
    }

    public String toString() {
        return Arrays.toString(this._memary);
    }

    public H2ONode[] members() {
        return this._memary;
    }

    public long free_mem() {
        long memsz = 0L;
        for (H2ONode h2o : H2O.CLOUD._memary) {
            memsz += h2o._heartbeat.get_free_mem();
        }
        return memsz;
    }

    public boolean healthy() {
        long now = System.currentTimeMillis();
        for (H2ONode node : CLOUD.members()) {
            if (node.isHealthy(now)) continue;
            return false;
        }
        return true;
    }

    public static void waitForCloudSize(int x, long ms) {
        long start = System.currentTimeMillis();
        while (!(System.currentTimeMillis() - start >= ms || CLOUD.size() >= x && Paxos._commonKnowledge)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (CLOUD.size() < x) {
            throw new RuntimeException("Cloud size under " + x);
        }
    }

    public static int getCloudSize() {
        if (!Paxos._commonKnowledge) {
            return -1;
        }
        return CLOUD.size();
    }

    public static void joinOthers() {
        long start = System.currentTimeMillis();
        while (!(System.currentTimeMillis() - start >= 2000L || CLOUD.size() > 1 && Paxos._commonKnowledge)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static void initializePersistence() {
        _PM = new PersistManager(ICE_ROOT);
    }

    public static Value putIfMatch(Key key, Value val, Value old) {
        Value res;
        if (old != null) {
            key = old._key;
        }
        if (val != null) {
            assert (val._key.equals(key));
            if (val._key != key) {
                val._key = key;
            }
        }
        if ((res = STORE.putIfMatchUnlocked(key, val, old)) != old) {
            return res;
        }
        if (old != null && val == null) {
            old.removePersist();
        }
        if (val != null) {
            Cleaner.dirty_store();
            if (old == null) {
                Scope.track_internal(key);
            }
        }
        return old;
    }

    public static void raw_remove(Key key) {
        Value v = STORE.remove(key);
        if (v != null) {
            v.removePersist();
        }
    }

    public static void raw_clear() {
        STORE.clear();
    }

    public static boolean containsKey(Key key) {
        return STORE.get(key) != null;
    }

    static Key getk(Key key) {
        return STORE.getk(key);
    }

    public static Set<Key> localKeySet() {
        return STORE.keySet();
    }

    static Collection<Value> values() {
        return STORE.values();
    }

    public static int store_size() {
        return STORE.size();
    }

    public static String STOREtoString() {
        int[] cnts = new int[1];
        Object[] kvs = STORE.raw_array();
        for (int i = 2; i < kvs.length; i += 2) {
            Object ov = kvs[i + 1];
            if (!(ov instanceof Value)) continue;
            Value val = (Value)ov;
            if (val.isNull()) {
                Value.STORE_get(val._key);
                continue;
            }
            int t = val.type();
            while (t >= cnts.length) {
                cnts = Arrays.copyOf(cnts, cnts.length << 1);
            }
            int n = t;
            cnts[n] = cnts[n] + 1;
        }
        StringBuilder sb = new StringBuilder();
        for (int t = 0; t < cnts.length; ++t) {
            if (cnts[t] == 0) continue;
            sb.append(String.format("-%30s %5d\n", TypeMap.CLAZZES[t], cnts[t]));
        }
        return sb.toString();
    }

    public static PersistManager getPM() {
        return _PM;
    }

    public static NodePersistentStorage getNPS() {
        return NPS;
    }

    public static void gc() {
        for (H2ONode node : H2O.CLOUD._memary) {
            class GCTask
            extends DTask<GCTask> {
                public GCTask() {
                    super((byte)119);
                }

                @Override
                public void compute2() {
                    Log.info("Calling System.gc() now...");
                    System.gc();
                    Log.info("System.gc() finished");
                    this.tryComplete();
                }
            }
            GCTask t = new GCTask();
            new RPC<GCTask>(node, t).call().get();
        }
    }

    public static boolean checkUnsupportedJava() {
        String version = System.getProperty("java.version");
        if (!(version == null || version.startsWith("1.6") || version.startsWith("1.7") || version.startsWith("1.8"))) {
            System.err.println("Only Java 1.6-1.8 supported, version is " + version);
            return true;
        }
        String vmName = System.getProperty("java.vm.name");
        if (vmName != null && vmName.equals("GNU libgcj")) {
            System.err.println("GNU gcj is not supported");
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        List<String> gaidList;
        H2O.configureLogging();
        extManager.registerCoreExtensions();
        extManager.registerListenerExtensions();
        long time0 = System.currentTimeMillis();
        if (H2O.checkUnsupportedJava()) {
            throw new RuntimeException("Unsupported Java version");
        }
        if (!START_TIME_MILLIS.compareAndSet(0L, System.currentTimeMillis())) {
            return;
        }
        ArrayList<String> args2 = new ArrayList<String>(Arrays.asList(args));
        for (Object p : System.getProperties().keySet()) {
            String s = (String)p;
            if (!s.startsWith("ai.h2o.")) continue;
            args2.add("-" + s.substring(7));
            if (s.substring(7).equals("ga_opt_out") || System.getProperty(s).isEmpty()) continue;
            args2.add(System.getProperty(s));
        }
        String[] arguments = args2.toArray(args);
        H2O.parseArguments(arguments);
        long time1 = System.currentTimeMillis();
        String ice = H2O.DEFAULT_ICE_ROOT();
        if (H2O.ARGS.ice_root != null) {
            ice = H2O.ARGS.ice_root.replace("\\", "/");
        }
        try {
            ICE_ROOT = new URI(ice);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("Invalid ice_root: " + ice + ", " + ex.getMessage());
        }
        long time2 = System.currentTimeMillis();
        H2O.printAndLogVersion(arguments);
        if (H2O.ARGS.version) {
            Log.flushStdout();
            H2O.exit(0);
        }
        if (H2O.ARGS.help) {
            H2O.printHelp();
            H2O.exit(0);
        }
        H2O.validateArguments();
        Log.info("X-h2o-cluster-id: " + CLUSTER_ID);
        Log.info("User name: '" + H2O.ARGS.user_name + "'");
        long time3 = System.currentTimeMillis();
        if (new File(".h2o_no_collect").exists() || new File(System.getProperty("user.home") + File.separator + ".h2o_no_collect").exists() || H2O.ARGS.ga_opt_out || (gaidList = JarHash.getResourcesList("gaid")).contains("CRAN") || ABV.isDevVersion()) {
            GA = null;
            Log.info("Opted out of sending usage metrics.");
        } else {
            try {
                GA = new GoogleAnalytics("UA-56665317-1", "H2O", ABV.projectVersion());
                DefaultRequest defReq = GA.getDefaultRequest();
                String gaid = null;
                if (gaidList.size() > 0) {
                    if (gaidList.size() > 1) {
                        Log.debug("More than once resource seen in gaid dir.");
                    }
                    for (String str : gaidList) {
                        if (!str.matches("........-....-....-....-............") || str.equals("XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX")) continue;
                        gaid = str;
                        break;
                    }
                }
                if (gaid == null) {
                    gaid = defReq.clientId();
                    gaid = gaid.replaceFirst("........-", "ANONYMOU-");
                }
                defReq.customDimension(CLIENT_ID_GA_CUST_DIM, gaid);
                GA.setDefaultRequest(defReq);
            }
            catch (Throwable t) {
                StackTraceElement[] stes;
                Log.POST(11, t.toString());
                for (StackTraceElement ste : stes = t.getStackTrace()) {
                    Log.POST(11, ste.toString());
                }
            }
        }
        long time4 = System.currentTimeMillis();
        Log.info("IPv6 stack selected: " + IS_IPV6);
        SELF_ADDRESS = NetworkInit.findInetAddressForSelf();
        if (!IS_IPV6 && SELF_ADDRESS instanceof Inet6Address) {
            Log.err("IPv4 network stack specified but IPv6 address found: " + SELF_ADDRESS + "\n" + "Please specify JVM flags -Djava.net.preferIPv6Addresses=true and -Djava.net.preferIPv4Addresses=false to select IPv6 stack");
            H2O.exit(-1);
        }
        if (IS_IPV6 && SELF_ADDRESS instanceof Inet4Address) {
            Log.err("IPv6 network stack specified but IPv4 address found: " + SELF_ADDRESS);
            H2O.exit(-1);
        }
        long time5 = System.currentTimeMillis();
        H2O.startLocalNode();
        long time6 = System.currentTimeMillis();
        for (AbstractH2OExtension ext : extManager.getCoreExtensions()) {
            ext.onLocalNodeStarted();
        }
        try {
            String logDir = Log.getLogDir();
            Log.info("Log dir: '" + logDir + "'");
        }
        catch (Exception e) {
            Log.info("Log dir: (Log4j configuration inherited)");
        }
        Log.info("Cur dir: '" + System.getProperty("user.dir") + "'");
        long time7 = System.currentTimeMillis();
        RuntimeMXBean rtBean = ManagementFactory.getRuntimeMXBean();
        Log.debug("H2O launch parameters: " + ARGS.toString());
        Log.debug("Boot class path: " + rtBean.getBootClassPath());
        Log.debug("Java class path: " + rtBean.getClassPath());
        Log.debug("Java library path: " + rtBean.getLibraryPath());
        long time8 = System.currentTimeMillis();
        H2O.initializePersistence();
        String flow_dir = H2O.ARGS.flow_dir != null ? H2O.ARGS.flow_dir : H2O.DEFAULT_FLOW_DIR();
        if (flow_dir != null) {
            flow_dir = flow_dir.replace("\\", "/");
            Log.info("Flow dir: '" + flow_dir + "'");
        } else {
            Log.info("Flow dir is undefined; saving flows not available");
        }
        NPS = new NodePersistentStorage(flow_dir);
        long time9 = System.currentTimeMillis();
        H2O.startNetworkServices();
        Log.trace("Network services started");
        long time10 = System.currentTimeMillis();
        Paxos.doHeartbeat(SELF);
        assert (H2O.SELF._heartbeat._cloud_hash != 0 || H2O.ARGS.client);
        new HeartBeatThread().start();
        long time11 = System.currentTimeMillis();
        if (GA != null) {
            H2O.startGAStartupReport();
        }
        Log.info("Registered parsers: " + Arrays.toString(ParserService.INSTANCE.getAllProviderNames(true)));
        long time12 = System.currentTimeMillis();
        Log.debug("Timing within H2O.main():");
        Log.debug("    Args parsing & validation: " + (time1 - time0) + "ms");
        Log.debug("    Get ICE root: " + (time2 - time1) + "ms");
        Log.debug("    Print log version: " + (time3 - time2) + "ms");
        Log.debug("    Register GA: " + (time4 - time3) + "ms");
        Log.debug("    Detect network address: " + (time5 - time4) + "ms");
        Log.debug("    Start local node: " + (time6 - time5) + "ms");
        Log.debug("    Extensions onLocalNodeStarted(): " + (time7 - time6) + "ms");
        Log.debug("    RuntimeMxBean: " + (time8 - time7) + "ms");
        Log.debug("    Initialize persistence layer: " + (time9 - time8) + "ms");
        Log.debug("    Start network services: " + (time10 - time9) + "ms");
        Log.debug("    Cloud up: " + (time11 - time10) + "ms");
        Log.debug("    Start GA: " + (time12 - time11) + "ms");
    }

    private static long getCurrentPID() {
        try {
            String n = ManagementFactory.getRuntimeMXBean().getName();
            int i = n.indexOf(64);
            if (i != -1) {
                return Long.parseLong(n.substring(0, i));
            }
            return -1L;
        }
        catch (Throwable ignore) {
            return -1L;
        }
    }

    public static void die(String s) {
        Log.fatal(s);
        H2O.exit(-1);
    }

    public static boolean addNodeToFlatfile(H2ONode node) {
        assert (H2O.isFlatfileEnabled()) : "Trying to use flatfile, but flatfile is not enabled!";
        return STATIC_H2OS.add(node);
    }

    public static boolean removeNodeFromFlatfile(H2ONode node) {
        assert (H2O.isFlatfileEnabled()) : "Trying to use flatfile, but flatfile is not enabled!";
        return STATIC_H2OS.remove(node);
    }

    public static boolean isNodeInFlatfile(H2ONode node) {
        assert (H2O.isFlatfileEnabled()) : "Trying to use flatfile, but flatfile is not enabled!";
        return STATIC_H2OS.contains(node);
    }

    public static boolean isFlatfileEnabled() {
        return STATIC_H2OS != null;
    }

    public static void setFlatfile(HashSet<H2ONode> nodes) {
        STATIC_H2OS = nodes;
    }

    public static HashSet<H2ONode> getFlatfile() {
        return (HashSet)STATIC_H2OS.clone();
    }

    public static H2ONode reportClient(H2ONode client) {
        H2ONode oldClient = CLIENTS_MAP.put(client.getIpPortString(), client);
        if (oldClient == null) {
            Log.info("New client discovered at " + client);
        }
        return oldClient;
    }

    public static H2ONode removeClient(H2ONode client) {
        return CLIENTS_MAP.remove(client.getIpPortString());
    }

    public static HashSet<H2ONode> getClients() {
        return new HashSet<H2ONode>(CLIENTS_MAP.values());
    }

    public static H2ONode getClientByIPPort(String ipPort) {
        return CLIENTS_MAP.get(ipPort);
    }

    public static Key<DecryptionTool> defaultDecryptionTool() {
        return H2O.ARGS.decrypt_tool != null ? Key.make(H2O.ARGS.decrypt_tool) : null;
    }

    static {
        CLIENT_TYPE_GA_CUST_DIM = 1;
        CLIENT_ID_GA_CUST_DIM = 2;
        _shutdownRequested = false;
        AbstractBuildVersion abv = AbstractBuildVersion.UNKNOWN_VERSION;
        try {
            Class<?> klass = Class.forName("water.init.BuildVersion");
            Constructor<?> constructor = klass.getConstructor(new Class[0]);
            abv = (AbstractBuildVersion)constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ABV = abv;
        _haveInheritedLog4jConfiguration = false;
        aboutEntries = new ArrayList();
        nextModelNum = new AtomicLong(0L);
        lastTimeSomethingHappenedMillis = System.currentTimeMillis();
        activeRapidsExecs = new AtomicInteger();
        START_TIME_MILLIS = new AtomicLong();
        NUMCPUS = Runtime.getRuntime().availableProcessors();
        PID = H2O.getCurrentPID();
        extManager = ExtensionManager.getInstance();
        FJPS = new PrioritizedForkJoinPool[127];
        H2O.FJPS[126] = new PrioritizedForkJoinPool(126, 1);
        for (int i = 120; i < 126; ++i) {
            H2O.FJPS[i] = new PrioritizedForkJoinPool(i, 4);
        }
        H2O.FJPS[119] = new PrioritizedForkJoinPool(119, 2);
        SELF = null;
        IS_IPV6 = NetworkUtils.isIPv6Preferred() && !NetworkUtils.isIPv4Preferred();
        STATIC_H2OS = null;
        CLIENTS_MAP = new ConcurrentHashMap<String, H2ONode>();
        CLOUDS = new H2O[256];
        DEBUG = System.getProperty(DEBUG_ARG) != null;
        CLUSTER_ID = System.currentTimeMillis();
        CLOUD = new H2O(new H2ONode[0], 0, 0);
        STORE = new NonBlockingHashMap();
    }

    public static class GAStartupReportThread
    extends Thread {
        private final int sleepMillis = 150000;

        public GAStartupReportThread() {
            super("GAStartupReport");
            this.setDaemon(true);
            this.setPriority(8);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(150000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            GAUtils.logStartup();
        }
    }

    public static abstract class H2OCallback<T extends H2OCountedCompleter>
    extends H2OCountedCompleter {
        public H2OCallback() {
        }

        public H2OCallback(H2OCountedCompleter cc) {
            super(cc);
        }

        @Override
        public void compute2() {
            throw H2O.fail();
        }

        @Override
        public void onCompletion(CountedCompleter caller) {
            this.callback((H2OCountedCompleter)caller);
        }

        public abstract void callback(T var1);
    }

    public static abstract class H2OCountedCompleter<T extends H2OCountedCompleter>
    extends CountedCompleter
    implements Cloneable,
    Freezable<T> {
        private byte _priority;
        private short _ice_id;

        @Override
        public byte[] asBytes() {
            return new AutoBuffer().put(this).buf();
        }

        @Override
        public T reloadFromBytes(byte[] ary) {
            return (T)this.read(new AutoBuffer(ary));
        }

        public H2OCountedCompleter() {
            this(null);
        }

        private static byte computePriority(H2OCountedCompleter completer) {
            byte currThrPrior = H2OCountedCompleter.currThrPriority();
            if (completer == null) {
                return (byte)(currThrPrior + 1);
            }
            return (byte)Math.max(currThrPrior, completer.priority());
        }

        protected H2OCountedCompleter(H2OCountedCompleter completer) {
            this(completer, H2OCountedCompleter.computePriority(completer));
        }

        protected H2OCountedCompleter(byte prior) {
            this(null, prior);
        }

        protected H2OCountedCompleter(H2OCountedCompleter completer, byte prior) {
            super(completer);
            this._priority = prior;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void compute() {
            block12: {
                FJWThr t = (FJWThr)Thread.currentThread();
                int pp = ((PrioritizedForkJoinPool)t.getPool())._priority;
                ForkJoinTask h2o = null;
                boolean set_t_prior = false;
                try {
                    assert (this.priority() == pp) : " wrong priority for task " + this.getClass().getSimpleName() + ", expected " + this.priority() + ", but got " + pp;
                    assert (t._priority <= pp);
                    int p2 = Math.max(pp, 119);
                    for (int p = 126; p > p2; --p) {
                        if (FJPS[p] == null || (h2o = FJPS[p].poll2()) == null) continue;
                        t._priority = p++;
                        t.setPriority(9);
                        set_t_prior = true;
                        ((H2OCountedCompleter)h2o).compute2();
                    }
                }
                catch (Throwable ex) {
                    if (h2o != null) {
                        h2o.completeExceptionally(ex);
                        break block12;
                    }
                    ex.printStackTrace();
                    throw ex;
                }
                finally {
                    t._priority = pp;
                    if (pp == 0 && set_t_prior) {
                        t.setPriority(4);
                    }
                }
            }
            if (this instanceof DTask) {
                this.icer().compute1(this);
            } else {
                this.compute2();
            }
        }

        public void compute1() {
            this.compute2();
        }

        public void compute2() {
        }

        protected final byte priority() {
            return this._priority;
        }

        @Override
        public final T clone() {
            try {
                return (T)((H2OCountedCompleter)super.clone());
            }
            catch (CloneNotSupportedException e) {
                throw Log.throwErr(e);
            }
        }

        protected static byte currThrPriority() {
            Thread cThr = Thread.currentThread();
            return (byte)(cThr instanceof FJWThr ? ((FJWThr)cThr)._priority : 0);
        }

        protected Icer<T> icer() {
            int tyid;
            short id = this._ice_id;
            if (id != 0 && id != 0) assert (id == (tyid = TypeMap.onIce(this))) : "incorrectly cashed id " + id + ", typemap has " + tyid + ", type = " + this.getClass().getName();
            return TypeMap.getIcer((int)(id != 0 ? id : (this._ice_id = (short)TypeMap.onIce(this))), this);
        }

        @Override
        public final AutoBuffer write(AutoBuffer ab) {
            return this.icer().write(ab, this);
        }

        @Override
        public final AutoBuffer writeJSON(AutoBuffer ab) {
            return this.icer().writeJSON(ab, this);
        }

        @Override
        public final T read(AutoBuffer ab) {
            return (T)this.icer().read(ab, this);
        }

        @Override
        public final T readJSON(AutoBuffer ab) {
            return (T)this.icer().readJSON(ab, this);
        }

        @Override
        public final int frozenType() {
            return this.icer().frozenType();
        }
    }

    public static abstract class H2OFuture<T>
    implements Future<T> {
        public final T getResult() {
            try {
                return (T)this.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class PrioritizedForkJoinPool
    extends ForkJoinPool {
        final int _priority;

        private PrioritizedForkJoinPool(int p, int cap) {
            super(H2O.ARGS.nthreads <= 0 ? NUMCPUS : (int)H2O.ARGS.nthreads, new FJWThrFact(cap), null, p >= 119);
            this._priority = p;
        }

        private H2OCountedCompleter poll2() {
            return (H2OCountedCompleter)this.pollSubmission();
        }
    }

    static class FJWThrFact
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        private final int _cap;

        FJWThrFact(int cap) {
            this._cap = cap;
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            int cap = this._cap == -1 ? 4 * NUMCPUS : this._cap;
            return pool.getPoolSize() <= cap ? new FJWThr(pool) : null;
        }
    }

    public static class FJWThr
    extends ForkJoinWorkerThread {
        public int _priority;

        FJWThr(ForkJoinPool pool) {
            super(pool);
            this._priority = ((PrioritizedForkJoinPool)pool)._priority;
            this.setPriority(this._priority == 1 ? 4 : 9);
            this.setName("FJ-" + this._priority + "-" + this.getPoolIndex());
        }
    }

    public static class AboutEntry {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        AboutEntry(String n, String v) {
            this.name = n;
            this.value = v;
        }
    }

    public static class OptString {
        final String _s;
        String _lastMatchedFor;

        public OptString(String s) {
            this._s = s;
        }

        public boolean matches(String s) {
            this._lastMatchedFor = s;
            if (this._s.equals("-" + s)) {
                return true;
            }
            return this._s.equals("--" + s);
        }

        public int incrementAndCheck(int i, String[] args) {
            if (++i >= args.length) {
                H2O.parseFailed(this._lastMatchedFor + " not specified");
            }
            return i;
        }

        public int parseInt(String a) {
            try {
                return Integer.parseInt(a);
            }
            catch (Exception exception) {
                H2O.parseFailed("Argument " + this._lastMatchedFor + " must be an integer (was given '" + a + "')");
                return 0;
            }
        }

        public int parsePort(String portString) {
            int portNum = this.parseInt(portString);
            if (portNum < 0 || portNum > 65535) {
                H2O.parseFailed("Argument " + this._lastMatchedFor + " must be an integer between 0 and 65535");
                return 0;
            }
            return portNum;
        }

        public String toString() {
            return this._s;
        }
    }

    public static class OptArgs
    extends BaseArgs {
        public static final String SYSTEM_PROP_PREFIX = "sys.ai.h2o.";
        public static final String SYSTEM_DEBUG_CORS = "sys.ai.h2o.debug.cors";
        public boolean help = false;
        public boolean version = false;
        public String name = System.getProperty("user.name");
        public String flatfile;
        public String ice_root;
        public boolean cleaner = false;
        public short nthreads = (short)Runtime.getRuntime().availableProcessors();
        public String log_dir;
        public String flow_dir;
        public boolean disable_web = false;
        public boolean client;
        public String hdfs_config = null;
        public boolean hdfs_skip = false;
        public String aws_credentials = null;
        public String ga_hadoop_ver = null;
        public boolean ga_opt_out = false;
        public String log_level;
        public boolean random_udp_drop;
        public boolean md5skip = false;
        public boolean quiet = false;
        public boolean useUDP = false;
        public boolean noLatestCheck = false;

        public String toString() {
            StringBuilder result = new StringBuilder();
            Field[] fields = this.getClass().getDeclaredFields();
            result.append("[ ");
            for (Field field : fields) {
                try {
                    result.append(field.getName());
                    result.append(": ");
                    result.append(field.get(this));
                    result.append(", ");
                }
                catch (IllegalAccessException ex) {
                    Log.err(ex);
                }
            }
            result.deleteCharAt(result.length() - 2);
            result.deleteCharAt(result.length() - 1);
            result.append(" ]");
            return result.toString();
        }

        public boolean launchedWithHadoopJar() {
            return this.hdfs_skip;
        }
    }

    public static class BaseArgs {
        public String jks = null;
        public String jks_pass = "h2oh2o";
        public boolean hash_login = false;
        public boolean ldap_login = false;
        public boolean kerberos_login = false;
        public boolean pam_login = false;
        public String login_conf = null;
        public boolean form_auth = false;
        String session_timeout_spec = null;
        public int session_timeout = 0;
        public String user_name = System.getProperty("user.name");
        public String internal_security_conf = null;
        public boolean internal_security_enabled = false;
        public String decrypt_tool = null;
        public int port;
        public int baseport = 54321;
        public String web_ip = null;
        public String ip;
        public String network;
        public String context_path = "";
    }
}

