/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.io.File;
import water.ExtensionManager;
import water.H2O;
import water.util.Log;

public class H2OStarter {
    public static void start(String[] args, String relativeResourcePath, boolean finalizeRestRegistration) {
        long time0 = System.currentTimeMillis();
        H2O.main(args);
        if (!H2O.ARGS.disable_web) {
            H2O.registerResourceRoot(new File(relativeResourcePath + File.separator + "h2o-web/src/main/resources/www"));
            H2O.registerResourceRoot(new File(relativeResourcePath + File.separator + "h2o-core/src/main/resources/www"));
            ExtensionManager.getInstance().registerRestApiExtensions();
            if (finalizeRestRegistration) {
                H2O.startServingRestApi();
            }
        }
        long timeF = System.currentTimeMillis();
        Log.info("H2O started in " + (timeF - time0) + "ms");
        if (!H2O.ARGS.disable_web) {
            Log.info("");
            Log.info("Open H2O Flow in your web browser: " + H2O.getURL(H2O.getJetty().getScheme()));
            Log.info("");
        }
    }

    public static void start(String[] args, String relativeResourcePath) {
        H2OStarter.start(args, relativeResourcePath, true);
    }

    public static void start(String[] args, boolean finalizeRestRegistration) {
        H2OStarter.start(args, System.getProperty("user.dir"), finalizeRestRegistration);
    }
}

