/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.reducers;

import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValNum;

public class AstAll
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    public String str() {
        return "all";
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public ValNum apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Val val = stk.track(asts[1].exec(env));
        if (val.isNum()) {
            return new ValNum(val.getNum() == 0.0 ? 0.0 : 1.0);
        }
        for (Vec vec : val.getFrame().vecs()) {
            if (vec.nzCnt() + vec.naCnt() >= vec.length()) continue;
            return new ValNum(0.0);
        }
        return new ValNum(1.0);
    }
}

