/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.time;

import java.util.Set;
import org.joda.time.DateTimeZone;
import water.parser.ParseTime;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValStr;

public class AstSetTimeZone
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"tz"};
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "setTimeZone";
    }

    @Override
    public ValStr apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        String tz = asts[1].exec(env).getStr();
        Set idSet = DateTimeZone.getAvailableIDs();
        if (!idSet.contains(tz)) {
            throw new IllegalArgumentException("Unacceptable timezone " + tz + " given.  For a list of acceptable names, use listTimezone().");
        }
        ParseTime.setTimezone(tz);
        return new ValStr(tz);
    }
}

