/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.transforms;

import org.apache.commons.lang.ArrayUtils;
import water.DKV;
import water.H2O;
import water.fvec.Frame;
import water.rapids.Session;
import water.rapids.ast.AstExec;
import water.rapids.ast.AstParameter;
import water.rapids.ast.params.AstId;
import water.rapids.transforms.Transform;

public class H2OColOp
extends Transform<H2OColOp> {
    protected final String _fun;
    private final String _oldCol;
    private String[] _newCol;
    private String _newColTypes;
    boolean _multiColReturn;

    public H2OColOp(String name, String ast, boolean inplace, String[] newNames) {
        super(name, ast, inplace, newNames);
        this._fun = this._ast._asts[0].str();
        this._oldCol = ((AstExec)this._ast._asts[1])._asts[2].str();
        this.setupParams();
    }

    private void setupParams() {
        String[] args = this._ast.getArgs();
        if (args != null && args.length > 1) {
            for (int i = 1; i < args.length; ++i) {
                this.setupParamsImpl(i, args);
            }
        }
    }

    protected void setupParamsImpl(int i, String[] args) {
        this._params.put(args[i], (AstParameter)this._ast._asts[i + 1]);
    }

    @Override
    public Transform<H2OColOp> fit(Frame f) {
        return this;
    }

    @Override
    protected Frame transformImpl(Frame f) {
        ((AstExec)this._ast._asts[1])._asts[1] = new AstId(f);
        Session ses = new Session();
        Frame fr = ses.exec(this._ast, null).getFrame();
        this._newCol = this._newNames == null ? new String[fr.numCols()] : this._newNames;
        this._newColTypes = H2OColOp.toJavaPrimitive(fr.anyVec().get_type_str());
        this._multiColReturn = fr.numCols() > 1;
        if (this._multiColReturn) {
            for (int i = 0; i < this._newCol.length; ++i) {
                if (this._newNames == null) {
                    this._newCol[i] = f.uniquify(i > 0 ? this._newCol[i - 1] : this._oldCol);
                }
                f.add(this._newCol[i], fr.vec(i));
            }
            if (this._inplace) {
                f.remove(f.find(this._oldCol)).remove();
            }
        } else {
            String[] stringArray;
            if (this._newNames == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this._inplace ? this._oldCol : f.uniquify(this._oldCol);
            } else {
                stringArray = this._newCol = this._newCol;
            }
            if (this._inplace) {
                f.replace(f.find(this._oldCol), fr.anyVec()).remove();
            } else {
                f.add(this._newNames == null ? this._newCol[0] : this._newNames[0], fr.anyVec());
            }
        }
        DKV.put(f);
        return f;
    }

    @Override
    Frame inverseTransform(Frame f) {
        throw H2O.unimpl();
    }

    @Override
    public String genClassImpl() {
        String typeCast;
        String string = typeCast = this._inTypes[ArrayUtils.indexOf((Object[])this._inNames, (Object)this._oldCol)].equals("Numeric") ? "Double" : "String";
        if (this._multiColReturn) {
            StringBuilder sb = new StringBuilder("    @Override public RowData transform(RowData row) {\n" + (this.paramIsRow() ? this.addRowParam() : "") + "     " + this._newColTypes + "[] res = GenMunger." + this.lookup(this._fun) + "((" + typeCast + ")row.get(\"" + this._oldCol + "\"), _params);\n");
            for (int i = 0; i < this._newCol.length; ++i) {
                sb.append("      row.put(\"" + this._newCol[i] + "\",(" + i + ">=res.length)?\"\":res[" + i + "]);\n");
            }
            sb.append("      return row;\n    }\n");
            return sb.toString();
        }
        return "    @Override public RowData transform(RowData row) {\n" + (this.paramIsRow() ? this.addRowParam() : "") + "      " + this._newColTypes + " res = GenMunger." + this.lookup(this._fun) + "((" + typeCast + ")row.get(\"" + this._oldCol + "\"), _params);\n" + "      row.put(\"" + this._newCol[0] + "\", res);\n" + "      return row;\n" + "    }\n";
    }

    protected boolean paramIsRow() {
        return false;
    }

    protected String addRowParam() {
        return "";
    }

    protected String lookup(String op) {
        return op.replaceAll("\\.", "");
    }
}

