/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import hex.Interaction;
import hex.Model;
import hex.ToEigenVec;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import jsr166y.CountedCompleter;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NFSFileVec;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.ParseDataset;
import water.parser.ParseSetup;
import water.util.ArrayUtils;
import water.util.ChunkSummary;
import water.util.IcedHashMap;
import water.util.Log;
import water.util.MathUtils;
import water.util.RandomUtils;
import water.util.VecUtils;

public class FrameUtils {
    public static Frame parseFrame(Key okey, File ... files) throws IOException {
        if (files == null || files.length == 0) {
            throw new IllegalArgumentException("List of files is empty!");
        }
        for (File f : files) {
            if (f.exists()) continue;
            throw new FileNotFoundException("File not found " + f);
        }
        if (okey == null) {
            okey = Key.make(files[0].getName());
        }
        Key[] inKeys = new Key[files.length];
        for (int i = 0; i < files.length; ++i) {
            inKeys[i] = NFSFileVec.make((File)files[i])._key;
        }
        return ParseDataset.parse(okey, inKeys);
    }

    public static Frame parseFrame(Key okey, URI ... uris) throws IOException {
        return FrameUtils.parseFrame(okey, null, uris);
    }

    public static Frame parseFrame(Key okey, ParseSetup parseSetup, URI ... uris) throws IOException {
        if (uris == null || uris.length == 0) {
            throw new IllegalArgumentException("List of uris is empty!");
        }
        if (okey == null) {
            okey = Key.make(uris[0].toString());
        }
        Key[] inKeys = new Key[uris.length];
        for (int i = 0; i < uris.length; ++i) {
            inKeys[i] = H2O.getPM().anyURIToKey(uris[i]);
        }
        return parseSetup != null ? ParseDataset.parse(okey, inKeys, true, ParseSetup.guessSetup(inKeys, parseSetup)) : ParseDataset.parse(okey, inKeys);
    }

    public static ParseSetup guessParserSetup(ParseSetup userParserSetup, URI ... uris) throws IOException {
        Key[] inKeys = new Key[uris.length];
        for (int i = 0; i < uris.length; ++i) {
            inKeys[i] = H2O.getPM().anyURIToKey(uris[i]);
        }
        return ParseSetup.guessSetup(inKeys, userParserSetup);
    }

    public static Frame categoricalEncoder(Frame dataset, String[] skipCols, Model.Parameters.CategoricalEncodingScheme scheme, ToEigenVec tev, int maxLevels) {
        switch (scheme) {
            case AUTO: 
            case Enum: 
            case SortByResponse: 
            case OneHotInternal: {
                return dataset;
            }
            case OneHotExplicit: {
                return new CategoricalOneHotEncoder(dataset, skipCols).exec().get();
            }
            case Binary: {
                return new CategoricalBinaryEncoder(dataset, skipCols).exec().get();
            }
            case EnumLimited: {
                return new CategoricalEnumLimitedEncoder(maxLevels, dataset, skipCols).exec().get();
            }
            case Eigen: {
                return new CategoricalEigenEncoder(tev, dataset, skipCols).exec().get();
            }
            case LabelEncoder: {
                return new CategoricalLabelEncoder(dataset, skipCols).exec().get();
            }
        }
        throw H2O.unimpl();
    }

    public static void printTopCategoricalLevels(Frame fr, boolean warn, int topK) {
        String[][] domains = fr.domains();
        String[] names = fr.names();
        int len = domains.length;
        int[] levels = new int[len];
        for (int i = 0; i < len; ++i) {
            levels[i] = domains[i] != null ? domains[i].length : 0;
        }
        Arrays.sort(levels);
        if (levels[len - 1] > 0) {
            int levelcutoff = levels[len - 1 - Math.min(topK, len - 1)];
            int count = 0;
            for (int i = 0; i < len && count < topK; ++count, ++i) {
                if (domains[i] == null || domains[i].length < levelcutoff) continue;
                if (warn) {
                    Log.warn("Categorical feature '" + names[i] + "' has cardinality " + domains[i].length + ".");
                    continue;
                }
                Log.info("Categorical feature '" + names[i] + "' has cardinality " + domains[i].length + ".");
            }
        }
    }

    public static double[] asDoubles(Vec v) {
        if (v.length() > 100000L) {
            throw new IllegalArgumentException("Vec is too big to be extracted into array");
        }
        return ((Vec2ArryTsk)new Vec2ArryTsk((int)((int)v.length())).doAll((Vec[])new Vec[]{v})).res;
    }

    public static int[] asInts(Vec v) {
        if (v.length() > 100000L) {
            throw new IllegalArgumentException("Vec is too big to be extracted into array");
        }
        return ((Vec2IntArryTsk)new Vec2IntArryTsk((int)((int)v.length())).doAll((Vec[])new Vec[]{v})).res;
    }

    public static ChunkSummary chunkSummary(Frame fr) {
        return (ChunkSummary)new ChunkSummary().doAll(fr);
    }

    public static Key[] generateNumKeys(Key mk, int num) {
        return FrameUtils.generateNumKeys(mk, num, "_part");
    }

    public static Key[] generateNumKeys(Key mk, int num, String delim) {
        Key[] ks = new Key[num];
        String n = mk != null ? mk.toString() : "noname";
        String suffix = "";
        if (n.endsWith(".hex")) {
            n = n.substring(0, n.length() - 4);
            suffix = ".hex";
        }
        for (int i = 0; i < num; ++i) {
            ks[i] = Key.make(n + delim + i + suffix);
        }
        return ks;
    }

    public static double sparseRatio(Chunk[] chks) {
        double cnt = 0.0;
        double reg = 1.0 / (double)chks.length;
        for (Chunk c : chks) {
            if (c.isSparseNA()) {
                cnt += (double)c.sparseLenNA() / (double)c.len();
                continue;
            }
            if (c.isSparseZero()) {
                cnt += (double)c.sparseLenZero() / (double)c.len();
                continue;
            }
            cnt += 1.0;
        }
        return cnt * reg;
    }

    public static double sparseRatio(Frame fr) {
        double reg = 1.0 / (double)fr.numCols();
        double res = 0.0;
        for (Vec v : fr.vecs()) {
            res += v.sparseRatio();
        }
        return res * reg;
    }

    public static void cleanUp(IcedHashMap<Key, String> toDelete) {
        Futures fs = new Futures();
        for (Key k : toDelete.keySet()) {
            k.remove(fs);
        }
        fs.blockForPending();
        toDelete.clear();
    }

    public static void shrinkDomainsToObservedSubset(Frame frameToModifyInPlace) {
        for (Vec v : frameToModifyInPlace.vecs()) {
            if (!v.isCategorical()) continue;
            long[] uniques = v.min() >= 0.0 && v.max() < 2.147483643E9 ? ((VecUtils.CollectDomainFast)new VecUtils.CollectDomainFast((int)v.max()).doAll(v)).domain() : ((VecUtils.CollectIntegerDomain)new VecUtils.CollectIntegerDomain().doAll(v)).domain();
            String[] newDomain = new String[uniques.length];
            final int[] fromTo = new int[(int)ArrayUtils.maxValue(uniques) + 1];
            for (int i = 0; i < newDomain.length; ++i) {
                newDomain[i] = v.domain()[(int)uniques[i]];
                fromTo[(int)uniques[i]] = i;
            }
            new MRTask(){

                @Override
                public void map(Chunk c) {
                    for (int i = 0; i < c._len; ++i) {
                        if (c.isNA(i)) continue;
                        c.set(i, fromTo[(int)c.at8(i)]);
                    }
                }
            }.doAll(v);
            v.setDomain(newDomain);
        }
    }

    public static class CategoricalEigenEncoder {
        final Frame _frame;
        Job<Frame> _job;
        final String[] _skipCols;
        final ToEigenVec _tev;

        public CategoricalEigenEncoder(ToEigenVec tev, Frame dataset, String[] skipCols) {
            this._frame = dataset;
            this._skipCols = skipCols;
            this._tev = tev;
        }

        public Job<Frame> exec() {
            if (this._frame == null) {
                throw new IllegalArgumentException("Frame doesn't exist.");
            }
            Key<Frame> destKey = Key.makeSystem(Key.make().toString());
            this._job = new Job(destKey, Frame.class.getName(), "CategoricalEigenEncoder");
            int workAmount = this._frame.lastVec().nChunks();
            return this._job.start(new CategoricalEigenEncoderDriver(this._tev, this._frame, destKey, this._skipCols), workAmount);
        }

        class CategoricalEigenEncoderDriver
        extends H2O.H2OCountedCompleter {
            final Frame _frame;
            final Key<Frame> _destKey;
            final String[] _skipCols;
            final ToEigenVec _tev;

            CategoricalEigenEncoderDriver(ToEigenVec tev, Frame frame, Key<Frame> destKey, String[] skipCols) {
                this._tev = tev;
                this._frame = frame;
                this._destKey = destKey;
                this._skipCols = skipCols;
                assert (this._tev != null) : "Override toEigenVec for this Algo!";
            }

            @Override
            public void compute2() {
                int i;
                Vec[] frameVecs = this._frame.vecs();
                Vec[] extraVecs = new Vec[this._skipCols == null ? 0 : this._skipCols.length];
                for (int i2 = 0; i2 < extraVecs.length; ++i2) {
                    Vec v;
                    Vec vec = v = this._skipCols == null || this._skipCols.length <= i2 ? null : this._frame.vec(this._skipCols[i2]);
                    if (v == null) continue;
                    extraVecs[i2] = v;
                }
                Frame outputFrame = new Frame(this._destKey);
                for (i = 0; i < frameVecs.length; ++i) {
                    if (this._skipCols != null && ArrayUtils.find(this._skipCols, this._frame._names[i]) >= 0) continue;
                    if (frameVecs[i].isCategorical()) {
                        outputFrame.add(this._frame.name(i) + ".Eigen", this._tev.toEigenVec(frameVecs[i]));
                        continue;
                    }
                    outputFrame.add(this._frame.name(i), frameVecs[i].makeCopy());
                }
                for (i = 0; i < extraVecs.length; ++i) {
                    if (extraVecs[i] == null) continue;
                    outputFrame.add(this._skipCols[i], extraVecs[i].makeCopy());
                }
                DKV.put(outputFrame);
                this.tryComplete();
            }
        }
    }

    public static class CategoricalEnumLimitedEncoder {
        final Frame _frame;
        Job<Frame> _job;
        final String[] _skipCols;
        final int _maxLevels;

        public CategoricalEnumLimitedEncoder(int maxLevels, Frame dataset, String[] skipCols) {
            this._frame = dataset;
            this._skipCols = skipCols;
            this._maxLevels = maxLevels;
        }

        public Job<Frame> exec() {
            if (this._frame == null) {
                throw new IllegalArgumentException("Frame doesn't exist.");
            }
            Key<Frame> destKey = Key.makeSystem(Key.make().toString());
            this._job = new Job(destKey, Frame.class.getName(), "CategoricalEnumLimited");
            int workAmount = this._frame.lastVec().nChunks();
            return this._job.start(new CategoricalEnumLimitedDriver(this._frame, destKey, this._skipCols), workAmount);
        }

        class CategoricalEnumLimitedDriver
        extends H2O.H2OCountedCompleter {
            final Frame _frame;
            final Key<Frame> _destKey;
            final String[] _skipCols;

            CategoricalEnumLimitedDriver(Frame frame, Key<Frame> destKey, String[] skipCols) {
                this._frame = frame;
                this._destKey = destKey;
                this._skipCols = skipCols;
            }

            @Override
            public void compute2() {
                int i;
                Vec[] frameVecs = this._frame.vecs();
                Vec[] extraVecs = new Vec[this._skipCols == null ? 0 : this._skipCols.length];
                for (int i2 = 0; i2 < extraVecs.length; ++i2) {
                    Vec v;
                    Vec vec = v = this._skipCols == null || this._skipCols.length <= i2 ? null : this._frame.vec(this._skipCols[i2]);
                    if (v == null) continue;
                    extraVecs[i2] = v;
                }
                Frame outputFrame = new Frame(this._destKey);
                for (i = 0; i < frameVecs.length; ++i) {
                    Vec src = frameVecs[i];
                    if (this._skipCols != null && ArrayUtils.find(this._skipCols, this._frame._names[i]) >= 0) continue;
                    if (src.cardinality() > CategoricalEnumLimitedEncoder.this._maxLevels) {
                        Key<Frame> source = Key.make();
                        Key<Frame> dest = Key.make();
                        Frame train = new Frame(source, new String[]{"enum"}, new Vec[]{src});
                        DKV.put(train);
                        Log.info("Reducing the cardinality of a categorical column with " + src.cardinality() + " levels to " + CategoricalEnumLimitedEncoder.this._maxLevels);
                        Interaction inter = new Interaction();
                        inter._source_frame = train._key;
                        inter._max_factors = CategoricalEnumLimitedEncoder.this._maxLevels;
                        inter._min_occurrence = 2;
                        inter._pairwise = false;
                        inter._factor_columns = train.names();
                        train = inter.execImpl(dest).get();
                        outputFrame.add(this._frame.name(i) + ".top_" + CategoricalEnumLimitedEncoder.this._maxLevels + "_levels", train.anyVec().makeCopy());
                        train.remove();
                        DKV.remove(source);
                        continue;
                    }
                    outputFrame.add(this._frame.name(i), frameVecs[i].makeCopy());
                }
                for (i = 0; i < extraVecs.length; ++i) {
                    if (extraVecs[i] == null) continue;
                    outputFrame.add(this._skipCols[i], extraVecs[i].makeCopy());
                }
                DKV.put(outputFrame);
                this.tryComplete();
            }
        }
    }

    public static class CategoricalBinaryEncoder
    extends Iced {
        final Frame _frame;
        Job<Frame> _job;
        final String[] _skipCols;

        public CategoricalBinaryEncoder(Frame dataset, String[] skipCols) {
            this._frame = dataset;
            this._skipCols = skipCols;
        }

        public Job<Frame> exec() {
            if (this._frame == null) {
                throw new IllegalArgumentException("Frame doesn't exist.");
            }
            Key<Frame> destKey = Key.makeSystem(Key.make().toString());
            this._job = new Job(destKey, Frame.class.getName(), "CategoricalBinaryEncoder");
            int workAmount = this._frame.lastVec().nChunks();
            return this._job.start(new CategoricalBinaryEncoderDriver(this._frame, destKey, this._skipCols), workAmount);
        }

        class CategoricalBinaryEncoderDriver
        extends H2O.H2OCountedCompleter {
            final Frame _frame;
            final Key<Frame> _destKey;
            final String[] _skipCols;

            CategoricalBinaryEncoderDriver(Frame frame, Key<Frame> destKey, String[] skipCols) {
                this._frame = frame;
                this._destKey = destKey;
                this._skipCols = skipCols;
            }

            @Override
            public void compute2() {
                Vec[] extraVecs;
                Vec[] frameVecs = this._frame.vecs();
                int numCategoricals = 0;
                for (int i = 0; i < frameVecs.length; ++i) {
                    if (!frameVecs[i].isCategorical() || this._skipCols != null && ArrayUtils.find(this._skipCols, this._frame._names[i]) != -1) continue;
                    ++numCategoricals;
                }
                Vec[] vecArray = extraVecs = this._skipCols == null ? null : new Vec[this._skipCols.length];
                if (extraVecs != null) {
                    for (int i = 0; i < extraVecs.length; ++i) {
                        Vec v = this._frame.vec(this._skipCols[i]);
                        if (v == null) continue;
                        extraVecs[i] = v;
                    }
                }
                Frame categoricalFrame = new Frame(new Vec[0]);
                Frame outputFrame = new Frame(this._destKey);
                int[] binaryCategorySizes = new int[numCategoricals];
                int numOutputColumns = 0;
                int j = 0;
                for (int i = 0; i < frameVecs.length; ++i) {
                    if (this._skipCols != null && ArrayUtils.find(this._skipCols, this._frame._names[i]) >= 0) continue;
                    int numCategories = frameVecs[i].cardinality();
                    if (numCategories > 0) {
                        categoricalFrame.add(this._frame.name(i), frameVecs[i]);
                        binaryCategorySizes[j] = 1 + MathUtils.log2(numCategories - 1 + 1);
                        numOutputColumns += binaryCategorySizes[j];
                        ++j;
                        continue;
                    }
                    outputFrame.add(this._frame.name(i), frameVecs[i].makeCopy());
                }
                BinaryConverter mrtask = new BinaryConverter(binaryCategorySizes);
                Frame binaryCols = ((BinaryConverter)mrtask.doAll(numOutputColumns, (byte)3, categoricalFrame)).outputFrame();
                int i = 0;
                int j2 = 0;
                while (i < binaryCategorySizes.length) {
                    for (int k = 0; k < binaryCategorySizes[i]; ++k) {
                        binaryCols._names[j2 + k] = categoricalFrame.name(i) + ":" + k;
                    }
                    j2 += binaryCategorySizes[i++];
                }
                outputFrame.add(binaryCols);
                if (this._skipCols != null) {
                    for (i = 0; i < extraVecs.length; ++i) {
                        if (extraVecs[i] == null) continue;
                        outputFrame.add(this._skipCols[i], extraVecs[i].makeCopy());
                    }
                }
                DKV.put(outputFrame);
                this.tryComplete();
            }

            class BinaryConverter
            extends MRTask<BinaryConverter> {
                int[] _categorySizes;

                public BinaryConverter(int[] categorySizes) {
                    this._categorySizes = categorySizes;
                }

                @Override
                public void map(Chunk[] cs, NewChunk[] ncs) {
                    int targetColOffset = 0;
                    for (int iCol = 0; iCol < cs.length; ++iCol) {
                        Chunk col = cs[iCol];
                        int numTargetColumns = this._categorySizes[iCol];
                        for (int iRow = 0; iRow < col._len; ++iRow) {
                            long val = col.isNA(iRow) ? 0L : 1L + col.at8(iRow);
                            for (int j = 0; j < numTargetColumns; ++j) {
                                ncs[targetColOffset + j].addNum(val & 1L, 0);
                                val >>>= 1;
                            }
                            assert (val == 0L) : "";
                        }
                        targetColOffset += numTargetColumns;
                    }
                }
            }
        }
    }

    public static class CategoricalLabelEncoder
    extends Iced {
        final Frame _frame;
        Job<Frame> _job;
        final String[] _skipCols;

        public CategoricalLabelEncoder(Frame dataset, String[] skipCols) {
            this._frame = dataset;
            this._skipCols = skipCols;
        }

        public Job<Frame> exec() {
            if (this._frame == null) {
                throw new IllegalArgumentException("Frame doesn't exist.");
            }
            Key<Frame> destKey = Key.makeSystem(Key.make().toString());
            this._job = new Job(destKey, Frame.class.getName(), "CategoricalLabelEncoder");
            int workAmount = this._frame.lastVec().nChunks();
            return this._job.start(new CategoricalLabelEncoderDriver(this._frame, destKey, this._skipCols), workAmount);
        }

        class CategoricalLabelEncoderDriver
        extends H2O.H2OCountedCompleter {
            final Frame _frame;
            final Key<Frame> _destKey;
            final String[] _skipCols;

            CategoricalLabelEncoderDriver(Frame frame, Key<Frame> destKey, String[] skipCols) {
                this._frame = frame;
                this._destKey = destKey;
                this._skipCols = skipCols;
            }

            @Override
            public void compute2() {
                int i;
                Vec[] extraVecs;
                Vec[] frameVecs = this._frame.vecs();
                Vec[] vecArray = extraVecs = this._skipCols == null ? null : new Vec[this._skipCols.length];
                if (extraVecs != null) {
                    for (int i2 = 0; i2 < extraVecs.length; ++i2) {
                        Vec v = this._frame.vec(this._skipCols[i2]);
                        if (v == null) continue;
                        extraVecs[i2] = v;
                    }
                }
                Frame outputFrame = new Frame(this._destKey);
                boolean j = false;
                for (i = 0; i < frameVecs.length; ++i) {
                    if (this._skipCols != null && ArrayUtils.find(this._skipCols, this._frame._names[i]) >= 0) continue;
                    int numCategories = frameVecs[i].cardinality();
                    if (numCategories > 0) {
                        outputFrame.add(this._frame.name(i), frameVecs[i].toNumericVec());
                        continue;
                    }
                    outputFrame.add(this._frame.name(i), frameVecs[i].makeCopy());
                }
                if (this._skipCols != null) {
                    for (i = 0; i < extraVecs.length; ++i) {
                        if (extraVecs[i] == null) continue;
                        outputFrame.add(this._skipCols[i], extraVecs[i].makeCopy());
                    }
                }
                DKV.put(outputFrame);
                this.tryComplete();
            }
        }
    }

    public static class CategoricalOneHotEncoder
    extends Iced {
        final Frame _frame;
        Job<Frame> _job;
        final String[] _skipCols;

        public CategoricalOneHotEncoder(Frame dataset, String[] skipCols) {
            this._frame = dataset;
            this._skipCols = skipCols;
        }

        public Job<Frame> exec() {
            if (this._frame == null) {
                throw new IllegalArgumentException("Frame doesn't exist.");
            }
            Key<Frame> destKey = Key.makeSystem(Key.make().toString());
            this._job = new Job(destKey, Frame.class.getName(), "CategoricalOneHotEncoder");
            int workAmount = this._frame.lastVec().nChunks();
            return this._job.start(new CategoricalOneHotEncoderDriver(this._frame, destKey, this._skipCols), workAmount);
        }

        class CategoricalOneHotEncoderDriver
        extends H2O.H2OCountedCompleter {
            final Frame _frame;
            final Key<Frame> _destKey;
            final String[] _skipCols;

            CategoricalOneHotEncoderDriver(Frame frame, Key<Frame> destKey, String[] skipCols) {
                this._frame = frame;
                this._destKey = destKey;
                this._skipCols = skipCols;
            }

            @Override
            public void compute2() {
                Vec[] frameVecs = this._frame.vecs();
                int numCategoricals = 0;
                for (int i = 0; i < frameVecs.length; ++i) {
                    if (!frameVecs[i].isCategorical() || ArrayUtils.find(this._skipCols, this._frame._names[i]) != -1) continue;
                    ++numCategoricals;
                }
                Vec[] extraVecs = new Vec[this._skipCols.length];
                for (int i = 0; i < extraVecs.length; ++i) {
                    Vec v = this._frame.vec(this._skipCols[i]);
                    if (v == null) continue;
                    extraVecs[i] = v;
                }
                Frame categoricalFrame = new Frame(new Vec[0]);
                Frame outputFrame = new Frame(this._destKey);
                int[] categorySizes = new int[numCategoricals];
                int numOutputColumns = 0;
                ArrayList<String> catnames = new ArrayList<String>();
                int j = 0;
                for (int i = 0; i < frameVecs.length; ++i) {
                    if (ArrayUtils.find(this._skipCols, this._frame._names[i]) >= 0) continue;
                    int numCategories = frameVecs[i].cardinality();
                    if (numCategories > 0) {
                        categoricalFrame.add(this._frame.name(i), frameVecs[i]);
                        categorySizes[j] = numCategories + 1;
                        numOutputColumns += categorySizes[j];
                        for (int k = 0; k < categorySizes[j] - 1; ++k) {
                            catnames.add(this._frame.name(i) + "." + this._frame.vec(i).domain()[k]);
                        }
                        catnames.add(this._frame.name(i) + ".missing(NA)");
                        ++j;
                        continue;
                    }
                    outputFrame.add(this._frame.name(i), frameVecs[i].makeCopy());
                }
                OneHotConverter mrtask = new OneHotConverter(categorySizes);
                Frame binaryCols = ((OneHotConverter)mrtask.doAll(numOutputColumns, (byte)3, categoricalFrame)).outputFrame();
                binaryCols.setNames(catnames.toArray(new String[0]));
                outputFrame.add(binaryCols);
                for (int i = 0; i < extraVecs.length; ++i) {
                    if (extraVecs[i] == null) continue;
                    outputFrame.add(this._skipCols[i], extraVecs[i].makeCopy());
                }
                DKV.put(outputFrame);
                this.tryComplete();
            }

            class OneHotConverter
            extends MRTask<OneHotConverter> {
                int[] _categorySizes;

                public OneHotConverter(int[] categorySizes) {
                    this._categorySizes = categorySizes;
                }

                @Override
                public void map(Chunk[] cs, NewChunk[] ncs) {
                    int targetColOffset = 0;
                    for (int iCol = 0; iCol < cs.length; ++iCol) {
                        Chunk col = cs[iCol];
                        int numTargetColumns = this._categorySizes[iCol];
                        for (int iRow = 0; iRow < col._len; ++iRow) {
                            long val = col.isNA(iRow) ? (long)(numTargetColumns - 1) : col.at8(iRow);
                            for (int j = 0; j < numTargetColumns; ++j) {
                                ncs[targetColOffset + j].addNum(val == (long)j ? 1L : 0L, 0);
                            }
                        }
                        targetColOffset += numTargetColumns;
                    }
                }
            }
        }
    }

    public static class ExportTaskDriver
    extends H2O.H2OCountedCompleter<ExportTaskDriver> {
        private static long DEFAULT_TARGET_PART_SIZE = 0x8000000L;
        private static int AUTO_PARTS_MAX = 128;
        final Frame _frame;
        final String _path;
        final String _frameName;
        final boolean _overwrite;
        final Job _j;
        int _nParts;

        public ExportTaskDriver(Frame frame, String path, String frameName, boolean overwrite, Job j, int nParts) {
            this._frame = frame;
            this._path = path;
            this._frameName = frameName;
            this._overwrite = overwrite;
            this._j = j;
            this._nParts = nParts;
        }

        @Override
        public void compute2() {
            this._frame.read_lock(this._j._key);
            if (this._nParts == 1) {
                Frame.CSVStream is = new Frame.CSVStream(this._frame, true, false);
                this.exportCSVStream(is, this._path, 0);
                this.tryComplete();
            } else {
                if (this._nParts < 0) {
                    this._nParts = this.calculateNParts();
                    assert (this._nParts > 0);
                }
                int nChunksPerPart = (this._frame.anyVec().nChunks() - 1) / this._nParts + 1;
                new PartExportTask(this, this._frame._names, nChunksPerPart).dfork(this._frame);
            }
        }

        @Override
        public void onCompletion(CountedCompleter caller) {
            this._frame.unlock(this._j);
        }

        @Override
        public boolean onExceptionalCompletion(Throwable t, CountedCompleter caller) {
            this._frame.unlock(this._j);
            return super.onExceptionalCompletion(t, caller);
        }

        private int calculateNParts() {
            EstimateSizeTask estSize = (EstimateSizeTask)((EstimateSizeTask)new EstimateSizeTask().dfork(this._frame)).getResult();
            Log.debug("Estimator result: ", estSize);
            int nParts = Math.max((int)(estSize._size / DEFAULT_TARGET_PART_SIZE), H2O.CLOUD.size() + 1);
            if (nParts > AUTO_PARTS_MAX) {
                Log.debug("Recommended number of part files (" + nParts + ") exceeds maximum limit " + AUTO_PARTS_MAX + ". " + "Number of part files is limited to avoid slow downs when importing back to H2O.");
                nParts = AUTO_PARTS_MAX;
            }
            Log.info("For file of estimated size " + estSize + "B determined number of parts: " + this._nParts);
            return nParts;
        }

        private long copyCSVStream(Frame.CSVStream is, OutputStream os, int firstChkIdx, int buffer_size) throws IOException {
            int count;
            long len = 0L;
            byte[] bytes = new byte[buffer_size];
            int curChkIdx = firstChkIdx;
            while ((count = is.read(bytes, 0, buffer_size)) > 0) {
                len += (long)count;
                os.write(bytes, 0, count);
                int workDone = is._curChkIdx - curChkIdx;
                if (workDone <= 0) continue;
                if (this._j.stop_requested()) {
                    throw new Job.JobCancelledException();
                }
                this._j.update(workDone);
                curChkIdx = is._curChkIdx;
            }
            return len;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void exportCSVStream(Frame.CSVStream is, String path, int firstChkIdx) {
            block13: {
                OutputStream os = null;
                long written = -1L;
                try {
                    os = H2O.getPM().create(path, this._overwrite);
                    written = this.copyCSVStream(is, os, firstChkIdx, 0x400000);
                    if (os == null) break block13;
                }
                catch (IOException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        if (os != null) {
                            try {
                                os.flush();
                                os.close();
                                Log.info("Written " + written + " bytes of key '" + this._frameName + "' to " + this._path + ".");
                            }
                            catch (Exception e2) {
                                Log.err(e2);
                            }
                        }
                        try {
                            is.close();
                            throw throwable;
                        }
                        catch (Exception e3) {
                            Log.err(e3);
                        }
                        throw throwable;
                    }
                }
                try {
                    os.flush();
                    os.close();
                    Log.info("Written " + written + " bytes of key '" + this._frameName + "' to " + this._path + ".");
                }
                catch (Exception e) {
                    Log.err(e);
                }
            }
            try {
                is.close();
                return;
            }
            catch (Exception e) {
                Log.err(e);
                return;
            }
        }

        class PartExportTask
        extends MRTask<PartExportTask> {
            final String[] _colNames;
            final int _length;

            PartExportTask(H2O.H2OCountedCompleter<?> completer, String[] colNames, int length) {
                super(completer);
                this._colNames = colNames;
                this._length = length;
            }

            @Override
            public void map(Chunk[] cs) {
                Chunk anyChunk = cs[0];
                if (anyChunk.cidx() % this._length > 0) {
                    return;
                }
                int partIdx = anyChunk.cidx() / this._length;
                String partPath = ExportTaskDriver.this._path + "/part-m-" + String.valueOf(100000 + partIdx).substring(1);
                Frame.CSVStream is = new Frame.CSVStream(cs, this._colNames, this._length, false);
                ExportTaskDriver.this.exportCSVStream(is, partPath, anyChunk.cidx());
            }

            @Override
            protected void setupLocal() {
                boolean created = H2O.getPM().mkdirs(ExportTaskDriver.this._path);
                if (!created) {
                    Log.warn("Path ", ExportTaskDriver.this._path, " was not created.");
                }
            }
        }

        class EstimateSizeTask
        extends MRTask<EstimateSizeTask> {
            int _nNonEmpty;
            long _size;

            EstimateSizeTask() {
            }

            @Override
            public void map(Chunk[] cs) {
                if (cs[0]._len == 0) {
                    return;
                }
                Frame.CSVStream is = new Frame.CSVStream(cs, null, 1, false);
                try {
                    ++this._nNonEmpty;
                    this._size += (long)(is.getCurrentRowSize() * cs[0]._len);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        Log.err(e);
                    }
                }
            }

            @Override
            public void reduce(EstimateSizeTask mrt) {
                this._nNonEmpty += mrt._nNonEmpty;
                this._size += mrt._size;
            }

            public String toString() {
                return "EstimateSizeTask{_nNonEmpty=" + this._nNonEmpty + ", _size=" + this._size + '}';
            }
        }
    }

    public static class WeightedMean
    extends MRTask<WeightedMean> {
        private double _wresponse;
        private double _wsum;

        public double weightedMean() {
            return this._wsum == 0.0 ? 0.0 : this._wresponse / this._wsum;
        }

        @Override
        public void map(Chunk response, Chunk weight, Chunk offset) {
            for (int i = 0; i < response._len; ++i) {
                double w;
                if (response.isNA(i) || (w = weight.atd(i)) == 0.0) continue;
                this._wresponse += w * (response.atd(i) - offset.atd(i));
                this._wsum += w;
            }
        }

        @Override
        public void reduce(WeightedMean mrt) {
            this._wresponse += mrt._wresponse;
            this._wsum += mrt._wsum;
        }
    }

    public static class MissingInserter
    extends Iced {
        Job<Frame> _job;
        final Key<Frame> _dataset;
        final double _fraction;
        final long _seed;

        public MissingInserter(Key<Frame> frame, long seed, double frac) {
            this._dataset = frame;
            this._seed = seed;
            this._fraction = frac;
        }

        public Job<Frame> execImpl() {
            this._job = new Job<Frame>(this._dataset, Frame.class.getName(), "MissingValueInserter");
            if (DKV.get(this._dataset) == null) {
                throw new IllegalArgumentException("Invalid Frame key " + this._dataset + " (Frame doesn't exist).");
            }
            if (this._fraction < 0.0 || this._fraction > 1.0) {
                throw new IllegalArgumentException("fraction must be between 0 and 1.");
            }
            Frame frame = (Frame)DKV.getGet(this._dataset);
            MissingInserterDriver mid = new MissingInserterDriver(frame);
            int work = frame.vecs()[0].nChunks();
            return this._job.start(mid, work);
        }

        class MissingInserterDriver
        extends H2O.H2OCountedCompleter {
            final transient Frame _frame;

            MissingInserterDriver(Frame frame) {
                this._frame = frame;
            }

            @Override
            public void compute2() {
                new MRTask(){

                    @Override
                    public void map(Chunk[] cs) {
                        Random rng = RandomUtils.getRNG(0L);
                        for (int c = 0; c < cs.length; ++c) {
                            for (int r = 0; r < cs[c]._len; ++r) {
                                rng.setSeed(MissingInserter.this._seed + (long)(1234 * c) ^ 1723L * (cs[c].start() + (long)r));
                                if (!(rng.nextDouble() < MissingInserter.this._fraction)) continue;
                                cs[c].setNA(r);
                            }
                        }
                        MissingInserter.this._job.update(1L);
                    }
                }.doAll(this._frame);
                this.tryComplete();
            }
        }
    }

    private static class Vec2IntArryTsk
    extends MRTask<Vec2IntArryTsk> {
        final int N;
        public int[] res;

        public Vec2IntArryTsk(int N) {
            this.N = N;
        }

        @Override
        public void setupLocal() {
            this.res = MemoryManager.malloc4(this.N);
        }

        @Override
        public void map(Chunk c) {
            int off = (int)c.start();
            int i = 0;
            while (i < c._len) {
                this.res[off + i] = (int)c.at8(i);
                i = c.nextNZ(i);
            }
        }

        @Override
        public void reduce(Vec2IntArryTsk other) {
            if (this.res != other.res) {
                for (int i = 0; i < this.res.length; ++i) {
                    assert (this.res[i] == 0 || other.res[i] == 0);
                    int n = i;
                    this.res[n] = this.res[n] + other.res[i];
                }
            }
        }
    }

    public static class Vecs2ArryTsk
    extends MRTask<Vecs2ArryTsk> {
        final int dim1;
        final int dim2;
        public double[][] res;

        public Vecs2ArryTsk(int dim1, int dim2) {
            this.dim1 = dim1;
            this.dim2 = dim2;
        }

        @Override
        public void setupLocal() {
            this.res = MemoryManager.malloc8d(this.dim1, this.dim2);
        }

        @Override
        public void map(Chunk[] c) {
            int off = (int)c[0].start();
            for (int colIndex = 0; colIndex < this.dim2; ++colIndex) {
                for (int rowIndex = 0; rowIndex < this.dim1; ++rowIndex) {
                    this.res[off + rowIndex][colIndex] = c[colIndex].atd(rowIndex);
                }
            }
        }

        @Override
        public void reduce(Vecs2ArryTsk other) {
            ArrayUtils.add(this.res, other.res);
        }
    }

    public static class Vec2ArryTsk
    extends MRTask<Vec2ArryTsk> {
        final int N;
        public double[] res;

        public Vec2ArryTsk(int N) {
            this.N = N;
        }

        @Override
        public void setupLocal() {
            this.res = MemoryManager.malloc8d(this.N);
        }

        @Override
        public void map(Chunk c) {
            int off = (int)c.start();
            int i = 0;
            while (i < c._len) {
                this.res[off + i] = c.atd(i);
                i = c.nextNZ(i);
            }
        }

        @Override
        public void reduce(Vec2ArryTsk other) {
            if (this.res != other.res) {
                for (int i = 0; i < this.res.length; ++i) {
                    assert (this.res[i] == 0.0 || other.res[i] == 0.0);
                    int n = i;
                    this.res[n] = this.res[n] + other.res[i];
                }
            }
        }
    }
}

