/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import com.brsanthu.googleanalytics.EventHit;
import com.brsanthu.googleanalytics.GoogleAnalyticsRequest;
import com.brsanthu.googleanalytics.ScreenViewHit;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import water.H2O;
import water.H2ONode;

public class GAUtils {
    public static void logRequest(String uri, Properties header) {
        if (H2O.GA != null && header != null) {
            int idx;
            if (uri.contains("/NodePersistentStorage") || uri.contains("/Metadata")) {
                return;
            }
            if ((uri.contains("/Frames/") || uri.contains("/DKV/") || uri.contains("/Models/") || uri.contains("/Models.java/") || uri.contains("/Predictions/")) && (idx = StringUtils.ordinalIndexOf((String)uri, (String)"/", (int)3)) > 0) {
                uri = uri.substring(0, idx);
            }
            if (header.getProperty("user-agent") != null) {
                H2O.GA.postAsync((GoogleAnalyticsRequest)new ScreenViewHit(uri).customDimension(H2O.CLIENT_TYPE_GA_CUST_DIM, header.getProperty("user-agent")));
            } else {
                H2O.GA.postAsync((GoogleAnalyticsRequest)new ScreenViewHit(uri));
            }
        }
    }

    public static void logParse(long totalParseSize, int fileCount, int colCount) {
        if (H2O.GA != null) {
            int parseSize = (int)(totalParseSize >> 20);
            H2O.GA.postAsync((GoogleAnalyticsRequest)new EventHit("File I/O", "Read", "Total size (MB)", Integer.valueOf(parseSize)));
            GAUtils.postRange("File I/O", "Read", "Total size (MB)", new int[]{100, 500, 1000, 5000, 10000, 50000, 100000, 500000, 1000000, 5000000}, parseSize);
            H2O.GA.postAsync((GoogleAnalyticsRequest)new EventHit("File I/O", "Read", "File count", Integer.valueOf(fileCount)));
            H2O.GA.postAsync((GoogleAnalyticsRequest)new EventHit("File I/O", "Read", "Column count", Integer.valueOf(colCount)));
            GAUtils.postRange("File I/O", "Read", "Column count", new int[]{100, 500, 1000, 5000, 10000, 50000, 100000, 500000}, colCount);
        }
    }

    public static void logStartup() {
        if (H2O.GA != null && H2O.SELF == H2O.CLOUD._memary[0]) {
            int cloudSize = H2O.CLOUD.size();
            H2O.GA.postAsync((GoogleAnalyticsRequest)new EventHit("System startup info", "Cloud", "Cloud size", Integer.valueOf(cloudSize)));
            if (cloudSize > 1) {
                H2O.GA.postAsync((GoogleAnalyticsRequest)new EventHit("System startup info", "Cloud", "Multi-node cloud size", Integer.valueOf(cloudSize)));
            }
            GAUtils.postRange("System startup info", "Cloud", "Cloud size", new int[]{2, 3, 4, 5, 10, 20, 30, 40, 50, 60}, cloudSize);
            if (H2O.ARGS.ga_hadoop_ver != null) {
                H2O.GA.postAsync((GoogleAnalyticsRequest)new EventHit("System startup info", "Hadoop version", H2O.ARGS.ga_hadoop_ver));
            } else if (H2O.CLOUD.size() > 1) {
                H2O.GA.postAsync((GoogleAnalyticsRequest)new EventHit("System startup info", "Hadoop version", "Non-hadoop cloud"));
            }
            int totMem = 0;
            for (H2ONode node : H2O.CLOUD.members()) {
                totMem = (int)((long)totMem + (node._heartbeat.get_free_mem() >> 20));
            }
            H2O.GA.postAsync((GoogleAnalyticsRequest)new EventHit("System startup info", "Memory", "Total Cloud Memory (GB)", Integer.valueOf(totMem >>= 10)));
            GAUtils.postRange("System startup info", "Memory", "Total Cloud Memory (GB)", new int[]{8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096}, totMem);
        }
    }

    private static void postRange(String category, String action, String label, int[] range, int value) {
        if (value < range[0]) {
            label = label + " < " + range[0];
        } else if (value >= range[range.length - 1]) {
            label = label + " >= " + range[0];
        } else {
            int i;
            for (i = 0; i < range.length - 2 && (value < range[i] || value >= range[i + 1]); ++i) {
            }
            label = label + " [" + range[i] + " " + range[i + 1] + ")";
        }
        H2O.GA.postAsync((GoogleAnalyticsRequest)new EventHit(category, action, label, Integer.valueOf(value)));
    }
}

