/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.advmath;

import water.DKV;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.ast.prims.mungers.AstGroup;
import water.rapids.vals.ValFrame;
import water.util.IcedHashMap;

public class AstUnique
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "unique";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Vec v;
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        Vec vec0 = fr.vec(0);
        if (fr.numCols() != 1) {
            throw new IllegalArgumentException("Unique applies to a single column only.");
        }
        if (vec0.isCategorical()) {
            v = Vec.makeSeq(0L, vec0.domain().length, true);
            v.setDomain(vec0.domain());
            DKV.put(v);
        } else {
            UniqTask t = (UniqTask)new UniqTask().doAll(fr);
            int nUniq = t._uniq.size();
            final AstGroup.G[] uniq = t._uniq.keySet().toArray(new AstGroup.G[nUniq]);
            v = Vec.makeZero((long)nUniq, vec0.get_type());
            new MRTask(){

                @Override
                public void map(Chunk c) {
                    int start = (int)c.start();
                    for (int i = 0; i < c._len; ++i) {
                        c.set(i, uniq[i + start]._gs[0]);
                    }
                }
            }.doAll(v);
        }
        return new ValFrame(new Frame(v));
    }

    private static class UniqTask
    extends MRTask<UniqTask> {
        IcedHashMap<AstGroup.G, String> _uniq;

        private UniqTask() {
        }

        @Override
        public void map(Chunk[] c) {
            this._uniq = new IcedHashMap();
            AstGroup.G g = new AstGroup.G(1, null);
            for (int i = 0; i < c[0]._len; ++i) {
                g.fill(i, c, new int[]{0});
                String s_old = this._uniq.putIfAbsent(g, "");
                if (s_old != null) continue;
                g = new AstGroup.G(1, null);
            }
        }

        @Override
        public void reduce(UniqTask t) {
            if (this._uniq != t._uniq) {
                IcedHashMap<AstGroup.G, String> l = this._uniq;
                IcedHashMap<AstGroup.G, String> r = t._uniq;
                if (l.size() < r.size()) {
                    l = r;
                    r = this._uniq;
                }
                for (AstGroup.G rg : r.keySet()) {
                    l.putIfAbsent(rg, "");
                }
                this._uniq = l;
                t._uniq = null;
            }
        }
    }
}

