/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CollectionUtils {
    public static <K, V> Map<K, V> createMap(K[] keys, V[] values) {
        assert (keys.length == values.length) : "Lengths of keys and values should be the same";
        HashMap<K, V> res = new HashMap<K, V>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            res.put(keys[i], values[i]);
        }
        return res;
    }

    public static byte[] unboxBytes(Collection<Byte> coll) {
        byte[] res = new byte[coll.size()];
        int i = 0;
        for (Byte elem : coll) {
            res[i++] = elem;
        }
        return res;
    }

    public static String[] unboxStrings(Collection<String> coll) {
        return coll.toArray(new String[coll.size()]);
    }

    public static String[][] unboxStringArrays(Collection<String[]> coll) {
        return (String[][])coll.toArray((T[])new String[coll.size()][]);
    }
}

