/*
 * Decompiled with CFR 0.152.
 */
package water;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.FormAuthenticator;
import org.eclipse.jetty.server.Authentication;

class DelegatingAuthenticator
implements Authenticator {
    private BasicAuthenticator _basicAuth;
    private FormAuthenticator _formAuth;

    DelegatingAuthenticator(BasicAuthenticator basicAuth, FormAuthenticator formAuth) {
        this._basicAuth = basicAuth;
        this._formAuth = formAuth;
    }

    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        this._basicAuth.setConfiguration(configuration);
        this._formAuth.setConfiguration(configuration);
    }

    public String getAuthMethod() {
        return "FORM_PREFERRED";
    }

    public void prepareRequest(ServletRequest servletRequest) {
    }

    public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean mandatory) throws ServerAuthException {
        if (DelegatingAuthenticator.isBrowserAgent((HttpServletRequest)request)) {
            return this._formAuth.validateRequest(request, response, mandatory);
        }
        return this._basicAuth.validateRequest(request, response, mandatory);
    }

    private static boolean isBrowserAgent(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        return userAgent != null && (userAgent.startsWith("Mozilla/") || userAgent.startsWith("Opera/"));
    }

    public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }
}

