/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.concurrent.atomic.AtomicInteger;
import jsr166y.CountedCompleter;
import jsr166y.ForkJoinTask;
import water.H2O;
import water.Job;

public class ParallelizationTask<T extends H2O.H2OCountedCompleter<T>>
extends H2O.H2OCountedCompleter {
    private final AtomicInteger _ctr;
    private static int DEFAULT_MAX_PARALLEL_TASKS = -1;
    private final T[] _tasks;
    private final Job _j;
    private transient int _maxParallelTasks;

    public ParallelizationTask(T[] tasks, Job j) {
        this((H2O.H2OCountedCompleter[])tasks, DEFAULT_MAX_PARALLEL_TASKS, j);
    }

    public ParallelizationTask(T[] tasks, int maxParallelTasks, Job j) {
        this._maxParallelTasks = maxParallelTasks > 0 ? maxParallelTasks : (int)H2O.SELF._heartbeat._num_cpus;
        this._ctr = new AtomicInteger(this._maxParallelTasks - 1);
        this._tasks = tasks;
        this._j = j;
    }

    @Override
    public void compute2() {
        int nTasks = this._tasks.length;
        this.addToPendingCount(nTasks - 1);
        for (int i = 0; i < Math.min(this._maxParallelTasks, nTasks); ++i) {
            this.asyncVecTask(i);
        }
    }

    private void asyncVecTask(int task) {
        ((CountedCompleter)this._tasks[task]).setCompleter(new Callback());
        ((ForkJoinTask)this._tasks[task]).fork();
    }

    private class Callback
    extends H2O.H2OCallback {
        public Callback() {
            super(ParallelizationTask.this);
        }

        public void callback(H2O.H2OCountedCompleter cc) {
            int i;
            if (ParallelizationTask.this._j != null) {
                ParallelizationTask.this._j.update(1L);
            }
            if ((i = ParallelizationTask.this._ctr.incrementAndGet()) < ParallelizationTask.this._tasks.length) {
                ParallelizationTask.this.asyncVecTask(i);
            }
        }
    }
}

