/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.Arrays;
import java.util.HashMap;
import water.AutoBuffer;
import water.DKV;
import water.H2O;
import water.Key;
import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.fvec.WrappedVec;
import water.util.ArrayUtils;

public class CategoricalWrappedVec
extends WrappedVec {
    int[] _map;
    int _p = 0;

    public CategoricalWrappedVec(Key key, int rowLayout, String[] toDomain, Key masterVecKey) {
        super((Key<Vec>)key, rowLayout, masterVecKey);
        this.computeMap(this.masterVec().domain(), toDomain, this.masterVec().isBad());
        DKV.put(this);
    }

    private CategoricalWrappedVec(Key key) {
        super((Key<Vec>)key, Vec.ESPC.rowLayout(key, new long[]{0L}), null, null);
    }

    public static int[] computeMap(String[] from, String[] to) {
        Key<Vec> key = Vec.newKey();
        CategoricalWrappedVec tmp = new CategoricalWrappedVec((Key)key);
        tmp.computeMap(from, to, false);
        return tmp._map;
    }

    @Override
    public Chunk chunkForChunkIdx(int cidx) {
        return new CategoricalWrappedChunk(this.masterVec().chunkForChunkIdx(cidx), this);
    }

    void computeMap(String[] from, String[] to, boolean fromIsBad) {
        int extra;
        if (from == to || Arrays.equals(from, to)) {
            this._map = ArrayUtils.seq(0, to.length);
            this.setDomain(to);
            return;
        }
        if (from == null) {
            this.setDomain(to);
            if (fromIsBad) {
                this._map = new int[0];
                return;
            }
            int min = Integer.valueOf(to[0]);
            int max = Integer.valueOf(to[to.length - 1]);
            Vec mvec = this.masterVec();
            if (!(mvec.isInt() && mvec.min() >= (double)min && mvec.max() <= (double)max)) {
                throw new NumberFormatException();
            }
            if (Integer.valueOf(to[0]) < 0) {
                this._p = Math.max(0, max);
                this._map = new int[this._p + -1 * min + 1];
                int i = 0;
                while (i < to.length) {
                    int v = Integer.valueOf(to[i]);
                    if (v < 0) {
                        v = -1 * v + this._p;
                    }
                    this._map[v] = i++;
                }
                return;
            }
            this._map = new int[max + 1];
            for (int i = 0; i < to.length; ++i) {
                this._map[Integer.valueOf((String)to[i]).intValue()] = i;
            }
            return;
        }
        this._map = new int[from.length];
        if (to == null) {
            for (int i = 0; i < from.length; ++i) {
                this._map[i] = Integer.valueOf(from[i]);
            }
            return;
        }
        HashMap<String, Integer> h = new HashMap<String, Integer>();
        for (int i = 0; i < to.length; ++i) {
            h.put(to[i], i);
        }
        String[] ss = to;
        int actualLen = extra = to.length;
        for (int j = 0; j < from.length; ++j) {
            Integer x = (Integer)h.get(from[j]);
            if (x != null) {
                this._map[j] = x;
                continue;
            }
            this._map[j] = extra++;
            if (extra > ss.length) {
                ss = Arrays.copyOf(ss, 2 * ss.length);
            }
            ss[extra - 1] = from[j];
            actualLen = extra;
        }
        this.setDomain(Arrays.copyOf(ss, actualLen));
    }

    @Override
    public Vec doCopy() {
        return new CategoricalWrappedVec((Key)this.group().addVec(), this._rowLayout, this.domain(), this._masterVecKey);
    }

    public static class CategoricalWrappedChunk
    extends Chunk {
        public final transient Chunk _c;
        final transient int[] _map;
        final transient int _p;

        CategoricalWrappedChunk(Chunk c, CategoricalWrappedVec vec) {
            this._c = c;
            this.set_len(this._c._len);
            this._start = this._c._start;
            this._vec = vec;
            this._cidx = this._c._cidx;
            this._map = vec._map;
            this._p = vec._p;
        }

        @Override
        protected double atd_impl(int idx) {
            return this._c.isNA_impl(idx) ? Double.NaN : (double)this.at8_impl(idx);
        }

        @Override
        protected long at8_impl(int idx) {
            int at8 = (int)this._c.at8_impl(idx);
            if (at8 >= 0) {
                return this._map[at8];
            }
            return this._map[-1 * at8 + this._p];
        }

        @Override
        protected boolean isNA_impl(int idx) {
            return this._c.isNA_impl(idx);
        }

        @Override
        boolean set_impl(int idx, long l) {
            return false;
        }

        @Override
        boolean set_impl(int idx, double d) {
            return false;
        }

        @Override
        boolean set_impl(int idx, float f) {
            return false;
        }

        @Override
        boolean setNA_impl(int idx) {
            return false;
        }

        public ChunkVisitor processRows(ChunkVisitor nc, int from, int to) {
            for (int i = from; i < to; ++i) {
                if (this.isNA(i)) {
                    nc.addNAs(1);
                    continue;
                }
                nc.addValue(this.at8(i));
            }
            return nc;
        }

        public ChunkVisitor processRows(ChunkVisitor nc, int ... rows) {
            for (int i : rows) {
                if (this.isNA(i)) {
                    nc.addNAs(1);
                    continue;
                }
                nc.addValue(this.at8(i));
            }
            return nc;
        }

        public static AutoBuffer write_impl(CategoricalWrappedVec v, AutoBuffer bb) {
            throw H2O.fail();
        }

        @Override
        protected final void initFromBytes() {
            throw H2O.fail();
        }

        @Override
        public boolean hasNA() {
            return false;
        }

        @Override
        public Chunk deepCopy() {
            return this.extractRows(new NewChunk(this), 0, this._c._len).compress();
        }
    }
}

