/*
 * Decompiled with CFR 0.152.
 */
package water.init;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import water.AutoBuffer;
import water.H2O;
import water.H2ONode;
import water.JettyHTTPD;
import water.Paxos;
import water.init.AbstractEmbeddedH2OConfig;
import water.init.HostnameGuesser;
import water.util.Log;
import water.util.NetworkUtils;
import water.util.StringUtils;

public class NetworkInit {
    public static DatagramChannel _udpSocket;
    public static ServerSocketChannel _tcpSocket;
    public static DatagramChannel CLOUD_DGRAM;

    public static InetAddress findInetAddressForSelf() throws Error {
        if (H2O.SELF_ADDRESS != null) {
            return H2O.SELF_ADDRESS;
        }
        try {
            return HostnameGuesser.findInetAddressForSelf(H2O.ARGS.ip, H2O.ARGS.network);
        }
        catch (HostnameGuesser.HostnameGuessingException e) {
            if (e.getCause() != null) {
                Log.err(e.getCause());
            } else {
                Log.err(e.getMessage());
            }
            H2O.exit(-1);
            assert (false);
            return null;
        }
    }

    public static void initializeNetworkSockets() {
        int n = H2O.API_PORT = H2O.ARGS.port == 0 ? H2O.ARGS.baseport : H2O.ARGS.port;
        if (H2O.getJetty() == null && !H2O.ARGS.disable_web) {
            H2O.setJetty(new JettyHTTPD());
        }
        ServerSocket apiSocket = null;
        while (true) {
            H2O.H2O_PORT = H2O.API_PORT + 1;
            try {
                if (!H2O.ARGS.disable_web) {
                    apiSocket = H2O.ARGS.web_ip == null ? new ServerSocket(H2O.API_PORT) : new ServerSocket(H2O.API_PORT, -1, NetworkInit.getInetAddress(H2O.ARGS.web_ip));
                    apiSocket.setReuseAddress(true);
                }
                _udpSocket = DatagramChannel.open();
                _udpSocket.socket().setReuseAddress(true);
                InetSocketAddress isa = new InetSocketAddress(H2O.SELF_ADDRESS, H2O.H2O_PORT);
                _udpSocket.socket().bind(isa);
                _tcpSocket = ServerSocketChannel.open();
                _tcpSocket.socket().setReceiveBufferSize(AutoBuffer.TCP_BUF_SIZ);
                _tcpSocket.socket().bind(isa);
                if (H2O.ARGS.disable_web) break;
                apiSocket.close();
                H2O.getJetty().start(H2O.ARGS.web_ip, H2O.API_PORT);
            }
            catch (Exception e) {
                for (Throwable ee = e; ee != null; ee = ee.getCause()) {
                    if (!(ee instanceof GeneralSecurityException)) continue;
                    throw new RuntimeException("Jetty Server initialization failed (check keystore password)", e);
                }
                Log.trace("Cannot allocate API port " + H2O.API_PORT + " because of following exception: ", e);
                if (apiSocket != null) {
                    try {
                        apiSocket.close();
                    }
                    catch (IOException ohwell) {
                        Log.err(ohwell);
                    }
                }
                if (_udpSocket != null) {
                    try {
                        _udpSocket.close();
                    }
                    catch (IOException ohwell) {
                        // empty catch block
                    }
                }
                if (_tcpSocket != null) {
                    try {
                        _tcpSocket.close();
                    }
                    catch (IOException ohwell) {
                        // empty catch block
                    }
                }
                apiSocket = null;
                _udpSocket = null;
                _tcpSocket = null;
                if (H2O.ARGS.port != 0) {
                    H2O.die("On " + H2O.SELF_ADDRESS + " some of the required ports " + H2O.ARGS.port + ", " + (H2O.ARGS.port + 1) + " are not available, change -port PORT and try again.");
                }
                if ((H2O.API_PORT += 2) <= 65536) continue;
                Log.err("Cannot find free port for " + H2O.SELF_ADDRESS + " from baseport = " + H2O.ARGS.baseport);
                H2O.exit(-1);
                continue;
            }
            break;
        }
        boolean isIPv6 = H2O.SELF_ADDRESS instanceof Inet6Address;
        H2O.SELF = H2ONode.self(H2O.SELF_ADDRESS);
        if (!H2O.ARGS.disable_web) {
            Log.info("Internal communication uses port: ", H2O.H2O_PORT, "\nListening for HTTP and REST traffic on " + H2O.getURL(H2O.getJetty().getScheme()) + "/");
        }
        try {
            Log.debug("Interface MTU: ", NetworkInterface.getByInetAddress(H2O.SELF_ADDRESS).getMTU());
        }
        catch (SocketException se) {
            Log.debug("No MTU due to SocketException. " + se.toString());
        }
        String embeddedConfigFlatfile = null;
        AbstractEmbeddedH2OConfig ec = H2O.getEmbeddedH2OConfig();
        if (ec != null) {
            ec.notifyAboutEmbeddedWebServerIpPort(H2O.SELF_ADDRESS, H2O.API_PORT);
            if (ec.providesFlatfile()) {
                try {
                    embeddedConfigFlatfile = ec.fetchFlatfile();
                }
                catch (Exception e) {
                    Log.err("Failed to get embedded config flatfile");
                    Log.err(e);
                    H2O.exit(1);
                }
            }
        }
        if (embeddedConfigFlatfile != null) {
            H2O.setFlatfile(NetworkInit.parseFlatFileFromString(embeddedConfigFlatfile));
        } else {
            H2O.setFlatfile(NetworkInit.parseFlatFile(H2O.ARGS.flatfile));
        }
        int hash = H2O.ARGS.name.hashCode();
        try {
            H2O.CLOUD_MULTICAST_GROUP = isIPv6 ? NetworkUtils.getIPv6MulticastGroup(hash, NetworkUtils.getIPv6Scope(H2O.SELF_ADDRESS)) : NetworkUtils.getIPv4MulticastGroup(hash);
        }
        catch (UnknownHostException e) {
            Log.err("Cannot get multicast group address for " + H2O.SELF_ADDRESS);
            Log.throwErr(e);
        }
        H2O.CLOUD_MULTICAST_PORT = NetworkUtils.getMulticastPort(hash);
    }

    private static InetAddress getInetAddress(String ip) {
        if (ip == null) {
            return null;
        }
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(ip);
        }
        catch (UnknownHostException e) {
            Log.err(e);
            H2O.exit(-1);
        }
        return addr;
    }

    public static void multicast(ByteBuffer bb, byte priority) {
        try {
            NetworkInit.multicast2(bb, priority);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void multicast2(ByteBuffer bb, byte priority) {
        if (!H2O.isFlatfileEnabled()) {
            byte[] buf = new byte[bb.remaining()];
            bb.get(buf);
            Class<H2O> clazz = H2O.class;
            synchronized (H2O.class) {
                block17: {
                    assert (H2O.CLOUD_MULTICAST_IF != null);
                    try {
                        if (H2O.CLOUD_MULTICAST_SOCKET == null) {
                            H2O.CLOUD_MULTICAST_SOCKET = new MulticastSocket();
                            H2O.CLOUD_MULTICAST_SOCKET.setTimeToLive(2);
                            H2O.CLOUD_MULTICAST_SOCKET.setNetworkInterface(H2O.CLOUD_MULTICAST_IF);
                        }
                        H2O.CLOUD_MULTICAST_SOCKET.send(new DatagramPacket(buf, buf.length, H2O.CLOUD_MULTICAST_GROUP, H2O.CLOUD_MULTICAST_PORT));
                    }
                    catch (Exception e) {
                        if (H2O.CLOUD_MULTICAST_SOCKET == null) break block17;
                        try {
                            H2O.CLOUD_MULTICAST_SOCKET.close();
                        }
                        catch (Exception e2) {
                            Log.err("Got", e2);
                        }
                        finally {
                            H2O.CLOUD_MULTICAST_SOCKET = null;
                        }
                    }
                }
                // ** MonitorExit[var3_4] (shouldn't be in output)
            }
        }
        Set<H2ONode> nodes = H2O.getFlatfile();
        nodes.addAll(Paxos.PROPOSED.values());
        bb.mark();
        for (H2ONode h2o : nodes) {
            if (h2o._removed_from_cloud) continue;
            try {
                bb.reset();
                if (H2O.ARGS.useUDP) {
                    CLOUD_DGRAM.send(bb, h2o._key);
                    continue;
                }
                h2o.sendMessage(bb, priority);
            }
            catch (IOException e) {
                Log.warn("Multicast Error to " + h2o, e);
            }
        }
    }

    private static HashSet<H2ONode> parseFlatFile(String fname) {
        if (fname == null) {
            return null;
        }
        File f = new File(fname);
        if (!f.exists()) {
            Log.warn("-flatfile specified but not found: " + fname);
            return null;
        }
        HashSet<H2ONode> h2os = new HashSet<H2ONode>();
        List<FlatFileEntry> list = NetworkInit.parseFlatFile(f);
        for (FlatFileEntry entry : list) {
            h2os.add(H2ONode.intern(entry.inet, entry.port + 1));
        }
        return h2os;
    }

    static HashSet<H2ONode> parseFlatFileFromString(String s) {
        HashSet<H2ONode> h2os = new HashSet<H2ONode>();
        ByteArrayInputStream is = new ByteArrayInputStream(StringUtils.bytesOf(s));
        List<FlatFileEntry> list = NetworkInit.parseFlatFile(is);
        for (FlatFileEntry entry : list) {
            h2os.add(H2ONode.intern(entry.inet, entry.port + 1));
        }
        return h2os;
    }

    static List<FlatFileEntry> parseFlatFile(File f) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
        }
        catch (Exception e) {
            H2O.die(e.toString());
        }
        return NetworkInit.parseFlatFile(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<FlatFileEntry> parseFlatFile(InputStream is) {
        ArrayList<FlatFileEntry> list = new ArrayList<FlatFileEntry>();
        BufferedReader br = null;
        int port = H2O.ARGS.port;
        try {
            br = new BufferedReader(new InputStreamReader(is));
            String strLine = null;
            while ((strLine = br.readLine()) != null) {
                if ((strLine = strLine.trim()).startsWith("#") || strLine.isEmpty()) continue;
                String ip = null;
                String portStr = null;
                int slashIdx = strLine.indexOf(47);
                int colonIdx = strLine.lastIndexOf(58);
                if (slashIdx == -1 && colonIdx == -1) {
                    ip = strLine;
                } else if (slashIdx == -1) {
                    ip = strLine.substring(0, colonIdx);
                    portStr = strLine.substring(colonIdx + 1);
                } else if (colonIdx == -1) {
                    ip = strLine.substring(slashIdx + 1);
                } else if (slashIdx > colonIdx) {
                    H2O.die("Invalid format, must be [name/]ip[:port], not '" + strLine + "'");
                } else {
                    ip = strLine.substring(slashIdx + 1, colonIdx);
                    portStr = strLine.substring(colonIdx + 1);
                }
                InetAddress inet = InetAddress.getByName(ip);
                if (portStr != null && !portStr.equals("")) {
                    try {
                        port = Integer.decode(portStr);
                    }
                    catch (NumberFormatException nfe) {
                        H2O.die("Invalid port #: " + portStr);
                    }
                }
                FlatFileEntry entry = new FlatFileEntry();
                entry.inet = inet;
                entry.port = port;
                list.add(entry);
            }
        }
        catch (Exception e) {
            H2O.die(e.toString());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return list;
    }

    static class FlatFileEntry {
        InetAddress inet;
        int port;

        FlatFileEntry() {
        }
    }
}

