/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import water.H2O;
import water.Key;
import water.MRTask;
import water.Value;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.UploadFileVec;
import water.persist.Persist;
import water.persist.PersistFS;
import water.persist.PersistNFS;
import water.util.FileUtils;
import water.util.Log;

public class PersistManager {
    public static final int MAX_BACKENDS = 8;
    static final String PROP_ENABLE_HDFS_FALLBACK = "sys.ai.h2o.persist.enable.hdfs.fallback";
    private Persist[] I = new Persist[8];
    private PersistStatsEntry[] stats = new PersistStatsEntry[8];

    public PersistStatsEntry[] getStats() {
        return this.stats;
    }

    public boolean isHdfsPath(String path) {
        String s = path.toLowerCase();
        return s.startsWith("hdfs:") || s.startsWith("s3:") || s.startsWith("s3n:") || s.startsWith("s3a:") || s.startsWith("maprfs:") || PersistManager.useHdfsAsFallback() && this.I[2] != null && this.I[2].canHandle(path);
    }

    private void validateHdfsConfigured() {
        if (this.I[2] == null) {
            throw new H2OIllegalArgumentException("HDFS, S3, S3N, and S3A support is not configured");
        }
    }

    public PersistManager(URI iceRoot) {
        Constructor<?> constructor;
        Class<?> klass;
        for (int i = 0; i < this.stats.length; ++i) {
            this.stats[i] = new PersistStatsEntry();
        }
        if (iceRoot == null) {
            Log.err("ice_root must be specified.  Exiting.");
            H2O.exit(1);
        }
        PersistFS ice = null;
        boolean windowsPath = iceRoot.toString().matches("^[a-zA-Z]:.*");
        if (windowsPath) {
            ice = new PersistFS(new File(iceRoot.toString()));
        } else if (iceRoot.getScheme() == null || "file".equals(iceRoot.getScheme())) {
            ice = new PersistFS(new File(iceRoot.getPath()));
        } else if ("hdfs".equals(iceRoot.getScheme())) {
            Log.err("HDFS ice_root not yet supported.  Exiting.");
            H2O.exit(1);
        }
        this.I[1] = ice;
        this.I[4] = new PersistNFS();
        try {
            klass = Class.forName("water.persist.PersistHdfs");
            constructor = klass.getConstructor(new Class[0]);
            this.I[2] = (Persist)constructor.newInstance(new Object[0]);
            Log.info("HDFS subsystem successfully initialized");
        }
        catch (Throwable ignore) {
            Log.info("HDFS subsystem not available");
        }
        try {
            klass = Class.forName("water.persist.PersistS3");
            constructor = klass.getConstructor(new Class[0]);
            this.I[3] = (Persist)constructor.newInstance(new Object[0]);
            Log.info("S3 subsystem successfully initialized");
        }
        catch (Throwable ignore) {
            Log.info("S3 subsystem not available");
        }
    }

    public void store(int backend, Value v) throws IOException {
        this.stats[backend].store_count.incrementAndGet();
        this.I[backend].store(v);
    }

    public void delete(int backend, Value v) {
        this.stats[backend].delete_count.incrementAndGet();
        this.I[backend].delete(v);
    }

    public byte[] load(int backend, Value v) throws IOException {
        this.stats[backend].load_count.incrementAndGet();
        byte[] arr = this.I[backend].load(v);
        this.stats[backend].load_bytes.addAndGet(arr.length);
        return arr;
    }

    public Persist getIce() {
        return this.I[1];
    }

    public final Key anyURIToKey(URI uri) throws IOException {
        Key ikey = null;
        String scheme = uri.getScheme();
        if ("s3".equals(scheme)) {
            ikey = this.I[3].uriToKey(uri);
        } else if ("hdfs".equals(scheme)) {
            ikey = this.I[2].uriToKey(uri);
        } else if ("s3".equals(scheme) || "s3n".equals(scheme) || "s3a".equals(scheme)) {
            ikey = this.I[2].uriToKey(uri);
        } else if ("file".equals(scheme) || scheme == null) {
            ikey = this.I[4].uriToKey(uri);
        } else if (PersistManager.useHdfsAsFallback() && this.I[2].canHandle(uri.toString())) {
            ikey = this.I[2].uriToKey(uri);
        } else {
            throw new H2OIllegalArgumentException("Unsupported schema '" + scheme + "' for given uri " + uri);
        }
        return ikey;
    }

    private static boolean httpUrlExists(String URLName) {
        try {
            HttpURLConnection con = (HttpURLConnection)new URL(URLName).openConnection();
            con.setInstanceFollowRedirects(false);
            con.setRequestMethod("HEAD");
            return con.getResponseCode() == 200;
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<String> calcTypeaheadMatches(String filter, int limit) {
        String s = filter.toLowerCase();
        if (s.startsWith("http:") || s.startsWith("https:")) {
            if (PersistManager.httpUrlExists(filter)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(filter);
                return arrayList;
            }
            return new ArrayList<String>();
        }
        if (s.startsWith("s3://")) {
            return this.I[3].calcTypeaheadMatches(filter, limit);
        }
        if (s.startsWith("hdfs:") || s.startsWith("s3n:") || s.startsWith("s3a:") || s.startsWith("maprfs:") || PersistManager.useHdfsAsFallback() && this.I[2] != null && this.I[2].canHandle(s)) {
            if (this.I[2] == null) {
                throw new H2OIllegalArgumentException("HDFS, S3, S3N, and S3A support is not configured");
            }
            return this.I[2].calcTypeaheadMatches(filter, limit);
        }
        return this.I[4].calcTypeaheadMatches(filter, limit);
    }

    public void importFiles(String path, String pattern, ArrayList<String> files, ArrayList<String> keys, ArrayList<String> fails, ArrayList<String> dels) {
        URI uri = FileUtils.getURI(path);
        String scheme = uri.getScheme();
        if (scheme == null || "file".equals(scheme)) {
            this.I[4].importFiles(path, pattern, files, keys, fails, dels);
        } else if ("http".equals(scheme) || "https".equals(scheme)) {
            try {
                URL url = new URL(path);
                Key destination_key = Key.make(path);
                InputStream is = url.openStream();
                UploadFileVec.ReadPutStats stats = new UploadFileVec.ReadPutStats();
                UploadFileVec.readPut(destination_key, is, stats);
                files.add(path);
                keys.add(destination_key.toString());
            }
            catch (Throwable e) {
                fails.add(path);
            }
        } else if ("s3".equals(scheme)) {
            if (this.I[3] == null) {
                throw new H2OIllegalArgumentException("S3 support is not configured");
            }
            this.I[3].importFiles(path, pattern, files, keys, fails, dels);
        } else if ("hdfs".equals(scheme) || "s3n:".equals(scheme) || "s3a:".equals(scheme) || "maprfs:".equals(scheme) || PersistManager.useHdfsAsFallback() && this.I[2] != null && this.I[2].canHandle(path)) {
            if (this.I[2] == null) {
                throw new H2OIllegalArgumentException("HDFS, S3N, and S3A support is not configured");
            }
            this.I[2].importFiles(path, pattern, files, keys, fails, dels);
        }
        if (pattern != null && !pattern.isEmpty()) {
            files.retainAll(this.matchPattern(path, files, pattern));
            keys.retainAll(this.matchPattern(path, keys, pattern));
            if (!fails.isEmpty()) {
                fails.retainAll(this.matchPattern(path, fails, pattern));
            }
        }
    }

    public String getHdfsHomeDirectory() {
        if (this.I[2] == null) {
            return null;
        }
        return this.I[2].getHomeDirectory();
    }

    public Persist.PersistEntry[] list(String path) {
        if (this.isHdfsPath(path)) {
            this.validateHdfsConfigured();
            Persist.PersistEntry[] arr = this.I[2].list(path);
            return arr;
        }
        File dir = new File(path);
        File[] files = dir.listFiles();
        if (files == null) {
            return new Persist.PersistEntry[0];
        }
        ArrayList<Persist.PersistEntry> arr = new ArrayList<Persist.PersistEntry>();
        for (File f : files) {
            Persist.PersistEntry entry = new Persist.PersistEntry(f.getName(), f.length(), f.lastModified());
            arr.add(entry);
        }
        return arr.toArray(new Persist.PersistEntry[arr.size()]);
    }

    public boolean exists(String path) {
        if (this.isHdfsPath(path)) {
            this.validateHdfsConfigured();
            boolean b = this.I[2].exists(path);
            return b;
        }
        File f = new File(path);
        return f.exists();
    }

    public boolean isDirectory(String path) {
        if (this.isHdfsPath(path)) {
            this.validateHdfsConfigured();
            boolean b = this.I[2].isDirectory(path);
            return b;
        }
        File f = new File(path);
        return f.isDirectory();
    }

    public boolean isEmptyDirectoryAllNodes(String path) {
        if (this.isHdfsPath(path)) {
            this.validateHdfsConfigured();
            if (!this.I[2].exists(path)) {
                return true;
            }
            if (!this.I[2].isDirectory(path)) {
                return false;
            }
            Persist.PersistEntry[] content = this.I[2].list(path);
            return content == null || content.length == 0;
        }
        return ((CheckLocalDirTask)new CheckLocalDirTask((String)path).doAllNodes())._result;
    }

    public long length(String path) {
        if (this.isHdfsPath(path)) {
            this.validateHdfsConfigured();
            long l = this.I[2].length(path);
            return l;
        }
        File f = new File(path);
        if (!f.exists()) {
            throw new IllegalArgumentException("File not found (" + path + ")");
        }
        return f.length();
    }

    public InputStream open(String path) {
        if (this.isHdfsPath(path)) {
            this.validateHdfsConfigured();
            InputStream os = this.I[2].open(path);
            return os;
        }
        try {
            File f = new File(path);
            return new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("File not found (" + path + ")");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean mkdirs(String path) {
        if (this.isHdfsPath(path)) {
            this.validateHdfsConfigured();
            boolean b = this.I[2].mkdirs(path);
            return b;
        }
        File f = new File(path);
        boolean b = f.mkdirs();
        return b;
    }

    public boolean rename(String fromPath, String toPath) {
        if (this.isHdfsPath(fromPath) || this.isHdfsPath(toPath)) {
            this.validateHdfsConfigured();
            boolean b = this.I[2].rename(fromPath, toPath);
            return b;
        }
        File f = new File(fromPath);
        File t = new File(toPath);
        boolean b = f.renameTo(t);
        return b;
    }

    public OutputStream create(String path, boolean overwrite) {
        if (this.isHdfsPath(path)) {
            this.validateHdfsConfigured();
            return this.I[2].create(path, overwrite);
        }
        try {
            File f;
            if (!overwrite && (f = new File(path)).exists()) {
                throw new IllegalArgumentException("File already exists (" + path + ")");
            }
            return new FileOutputStream(path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean delete(String path) {
        if (this.isHdfsPath(path)) {
            this.validateHdfsConfigured();
            boolean b = this.I[2].delete(path);
            return b;
        }
        File f = new File(path);
        boolean b = f.delete();
        return b;
    }

    public Persist getPersistForURI(URI uri) {
        String scheme = uri.getScheme();
        boolean windowsPath = scheme.matches("^[a-zA-Z]$");
        if (windowsPath) {
            return this.I[1];
        }
        if (scheme != null) {
            switch (scheme) {
                case "file": {
                    return this.I[1];
                }
                case "hdfs": 
                case "s3n": 
                case "s3a": {
                    return this.I[2];
                }
                case "s3": {
                    return this.I[3];
                }
            }
            if (PersistManager.useHdfsAsFallback() && this.I[2] != null && this.I[2].canHandle(uri.toString())) {
                return this.I[2];
            }
            throw new IllegalArgumentException("Cannot find persist manager for scheme " + scheme);
        }
        return this.I[1];
    }

    public ArrayList<String> matchPattern(String prefix, ArrayList<String> fileList, String matchStr) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern pattern = Pattern.compile(matchStr);
        if (matchStr != null) {
            for (String s : fileList) {
                Matcher matcher = pattern.matcher(PersistManager.afterPrefix(s, prefix));
                if (!matcher.find()) continue;
                result.add(s);
            }
        }
        return result;
    }

    private static String afterPrefix(String wholeString, String substring) {
        int posSubstring = wholeString.lastIndexOf(substring);
        if (posSubstring == -1) {
            return "";
        }
        int adjustedPosSubstring = posSubstring + substring.length();
        if (adjustedPosSubstring >= wholeString.length()) {
            return "";
        }
        return wholeString.substring(adjustedPosSubstring);
    }

    static boolean useHdfsAsFallback() {
        return System.getProperty(PROP_ENABLE_HDFS_FALLBACK, "true").equals("true");
    }

    private static class CheckLocalDirTask
    extends MRTask<CheckLocalDirTask> {
        String _path;
        boolean _result;

        CheckLocalDirTask(String _path) {
            this._path = _path;
        }

        @Override
        public void reduce(CheckLocalDirTask mrt) {
            this._result = this._result && mrt._result;
        }

        @Override
        protected void setupLocal() {
            File[] content;
            File f = new File(this._path);
            this._result = !f.exists() ? true : (f.isDirectory() ? (content = f.listFiles()) != null && content.length == 0 : false);
        }
    }

    public static class PersistStatsEntry {
        public AtomicLong store_count = new AtomicLong();
        public AtomicLong store_bytes = new AtomicLong();
        public AtomicLong delete_count = new AtomicLong();
        public AtomicLong load_count = new AtomicLong();
        public AtomicLong load_bytes = new AtomicLong();
    }

    public static class Schemes {
        public static final String FILE = "file";
        public static final String HDFS = "hdfs";
        public static final String S3 = "s3";
        public static final String S3N = "s3n";
        public static final String S3A = "s3a";
        public static final String NFS = "nfs";
    }
}

