/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.mungers;

import java.util.Arrays;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstParameter;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;
import water.rapids.vals.ValRow;

public class AstColSlice
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "cols"};
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "cols";
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Val v = stk.track(asts[1].exec(env));
        AstParameter col_list = (AstParameter)asts[2];
        if (v instanceof ValRow) {
            ValRow vv = (ValRow)v;
            return vv.slice(col_list.columns(vv.getNames()));
        }
        Frame src = v.getFrame();
        int[] cols = AstColSlice.col_select(src.names(), col_list);
        Frame dst = new Frame(new Vec[0]);
        Vec[] vecs = src.vecs();
        for (int col : cols) {
            dst.add(src._names[col], vecs[col]);
        }
        return new ValFrame(dst);
    }

    public static int[] col_select(String[] names, AstParameter col_selector) {
        int[] cols = col_selector.columns(names);
        if (cols.length == 0) {
            return cols;
        }
        if (cols[0] >= 0) {
            if (cols[cols.length - 1] >= names.length) {
                throw new IllegalArgumentException("Column must be an integer from 0 to " + (names.length - 1));
            }
            return cols;
        }
        int[] pos = new int[names.length];
        for (int col : cols) {
            if (0 > -col - 1 || -col - 1 >= names.length) continue;
            pos[-col - 1] = -1;
        }
        int j = 0;
        for (int i = 0; i < names.length; ++i) {
            if (pos[i] != 0) continue;
            pos[j++] = i;
        }
        return Arrays.copyOfRange(pos, 0, j);
    }
}

