/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.Model;
import hex.genmodel.utils.StringEscapeUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.joda.time.DateTime;
import water.H2O;
import water.Keyed;
import water.api.SchemaServer;
import water.api.StreamWriter;
import water.api.schemas3.ModelSchemaV3;
import water.util.StringUtils;

public abstract class ModelMojoWriter<M extends Model<M, P, O>, P extends Model.Parameters, O extends Model.Output>
extends StreamWriter {
    protected M model;
    private String targetdir;
    private StringBuilder tmpfile;
    private String tmpname;
    private ZipOutputStream zos;
    private Map<String, String> lkv;

    public ModelMojoWriter() {
    }

    public ModelMojoWriter(M model) {
        this.model = model;
        this.lkv = new LinkedHashMap<String, String>(20);
    }

    public abstract String mojoVersion();

    protected abstract void writeModelData() throws IOException;

    protected final void writekv(String key, Object value) throws IOException {
        String valStr;
        String string = valStr = value == null ? "null" : value.toString();
        if (valStr.contains("\n")) {
            throw new IOException("The `value` must not contain newline characters, got: " + valStr);
        }
        if (this.lkv.containsKey(key)) {
            throw new IOException("Key " + key + " was already written");
        }
        this.lkv.put(key, valStr);
    }

    protected final void writekv(String key, int[] value) throws IOException {
        this.writekv(key, Arrays.toString(value));
    }

    protected final void writekv(String key, double[] value) throws IOException {
        this.writekv(key, Arrays.toString(value));
    }

    protected final void writekv(String key, float[] value) throws IOException {
        this.writekv(key, Arrays.toString(value));
    }

    protected final void writeblob(String filename, byte[] blob) throws IOException {
        ZipEntry archiveEntry = new ZipEntry(this.targetdir + filename);
        archiveEntry.setSize(blob.length);
        this.zos.putNextEntry(archiveEntry);
        this.zos.write(blob);
        this.zos.closeEntry();
    }

    protected final void startWritingTextFile(String filename) {
        assert (this.tmpfile == null) : "Previous text file was not closed";
        this.tmpfile = new StringBuilder();
        this.tmpname = filename;
    }

    protected final void writeln(String s, boolean escapeNewlines) {
        assert (this.tmpfile != null) : "No text file is currently being written";
        this.tmpfile.append(escapeNewlines ? StringEscapeUtils.escapeNewlines((String)s) : s);
        this.tmpfile.append('\n');
    }

    protected final void writeln(String s) {
        this.writeln(s, false);
    }

    protected final void finishWritingTextFile() throws IOException {
        assert (this.tmpfile != null) : "No text file is currently being written";
        this.writeblob(this.tmpname, StringUtils.toBytes(this.tmpfile));
        this.tmpfile = null;
    }

    @Override
    public final void writeTo(OutputStream os) {
        ZipOutputStream zos = new ZipOutputStream(os);
        try {
            this.writeTo(zos);
            zos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void writeTo(ZipOutputStream zos) throws IOException {
        this.writeTo(zos, "");
    }

    public final void writeTo(ZipOutputStream zos, String zipDirectory) throws IOException {
        this.initWriting(zos, zipDirectory);
        this.addCommonModelInfo();
        this.writeModelData();
        this.writeModelInfo();
        this.writeDomains();
        this.writeModelDetails();
        this.writeModelDetailsReadme();
    }

    private void initWriting(ZipOutputStream zos, String targetdir) {
        this.zos = zos;
        this.targetdir = targetdir;
    }

    private void addCommonModelInfo() throws IOException {
        int n_categoricals = 0;
        for (String[] domain : ((Model)this.model).scoringDomains()) {
            if (domain == null) continue;
            ++n_categoricals;
        }
        this.writekv("h2o_version", H2O.ABV.projectVersion());
        this.writekv("mojo_version", this.mojoVersion());
        this.writekv("license", "Apache License Version 2.0");
        this.writekv("algo", ((Model.Parameters)((Model)this.model)._parms).algoName().toLowerCase());
        this.writekv("algorithm", ((Model.Parameters)((Model)this.model)._parms).fullName());
        this.writekv("endianness", ByteOrder.nativeOrder());
        this.writekv("category", ((Model.Output)((Model)this.model)._output).getModelCategory());
        this.writekv("uuid", ((Keyed)this.model).checksum());
        this.writekv("supervised", ((Model.Output)((Model)this.model)._output).isSupervised());
        this.writekv("n_features", ((Model.Output)((Model)this.model)._output).nfeatures());
        this.writekv("n_classes", ((Model.Output)((Model)this.model)._output).nclasses());
        this.writekv("n_columns", ((Model.Output)((Model)this.model)._output)._names.length);
        this.writekv("n_domains", n_categoricals);
        this.writekv("balance_classes", ((Model.Parameters)((Model)this.model)._parms)._balance_classes);
        this.writekv("default_threshold", ((Model)this.model).defaultThreshold());
        this.writekv("prior_class_distrib", Arrays.toString(((Model.Output)((Model)this.model)._output)._priorClassDist));
        this.writekv("model_class_distrib", Arrays.toString(((Model.Output)((Model)this.model)._output)._modelClassDist));
        this.writekv("timestamp", new DateTime().toString());
    }

    private void writeModelInfo() throws IOException {
        this.startWritingTextFile("model.ini");
        this.writeln("[info]");
        for (Map.Entry<String, String> kv : this.lkv.entrySet()) {
            this.writeln(kv.getKey() + " = " + kv.getValue());
        }
        this.writeln("\n[columns]");
        for (String name : ((Model.Output)((Model)this.model)._output)._names) {
            this.writeln(name);
        }
        this.writeln("\n[domains]");
        String format = "%d: %d d%03d.txt";
        int domIndex = 0;
        String[][] domains = ((Model)this.model).scoringDomains();
        for (int colIndex = 0; colIndex < domains.length; ++colIndex) {
            if (domains[colIndex] == null) continue;
            this.writeln(String.format(format, colIndex, domains[colIndex].length, domIndex++));
        }
        this.finishWritingTextFile();
    }

    private void writeDomains() throws IOException {
        int domIndex = 0;
        for (String[] domain : ((Model)this.model).scoringDomains()) {
            if (domain == null) continue;
            this.startWritingTextFile(String.format("domains/d%03d.txt", domIndex++));
            for (String category : domain) {
                this.writeln(category.replaceAll("\n", "\\n"));
            }
            this.finishWritingTextFile();
        }
    }

    private void writeModelDetails() throws IOException {
        ModelSchemaV3 modelSchema = (ModelSchemaV3)SchemaServer.schema(3, this.model).fillFromImpl(this.model);
        this.startWritingTextFile("experimental/modelDetails.json");
        this.writeln(modelSchema.toJsonString());
        this.finishWritingTextFile();
    }

    private void writeModelDetailsReadme() throws IOException {
        this.startWritingTextFile("experimental/README.md");
        this.writeln("Outputting model information in JSON is an experimental feature and we appreciate any feedback.\nThe contents of this folder may change with another version of H2O.");
        this.finishWritingTextFile();
    }
}

