/*
 * Decompiled with CFR 0.152.
 */
package water;

import water.AutoBuffer;
import water.H2O;
import water.RPC;
import water.TimeLine;
import water.UDPAck;
import water.UDPAckAck;
import water.UDPClientEvent;
import water.UDPFetchAck;
import water.UDPHeartbeat;
import water.UDPNack;
import water.UDPRebooted;
import water.Value;
import water.util.UnsafeUtils;

public abstract class UDP {
    static final char[] cs = new char[32];
    private static final byte[] pbuf = new byte[16];

    public static udp getUdp(int id) {
        return udp.UDPS[id];
    }

    abstract AutoBuffer call(AutoBuffer var1);

    static char hex(int x) {
        return (char)(x + ((x &= 0xF) < 10 ? 48 : 87));
    }

    String print16(AutoBuffer ab) {
        for (int i = 0; i < 16; ++i) {
            int b = ab.get1U();
            UDP.cs[i << 1] = UDP.hex(b >> 4);
            UDP.cs[(i << 1) + 1] = UDP.hex(b);
        }
        return new String(cs);
    }

    public static String printx16(long lo, long hi) {
        UnsafeUtils.set8(pbuf, 0, lo);
        UnsafeUtils.set8(pbuf, 8, hi);
        return udp.UDPS[(int)(lo & 0xFFL)]._udp.print16(new AutoBuffer(pbuf));
    }

    private static class IO_record
    extends UDP {
        private IO_record() {
        }

        @Override
        AutoBuffer call(AutoBuffer ab) {
            throw H2O.fail();
        }

        @Override
        String print16(AutoBuffer ab) {
            int flavor = ab.get1U(3);
            int iotime = ab.get4(4);
            int size = ab.get4(8);
            return "I/O " + Value.nameOfPersist(flavor) + " " + iotime + "ms " + size + "b";
        }
    }

    public static enum udp {
        bad(false, null, -1),
        heartbeat(true, new UDPHeartbeat(), 126),
        rebooted(true, new UDPRebooted(), 126),
        timeline(false, new TimeLine(), 126),
        client_event(true, new UDPClientEvent(), 126),
        ackack(false, new UDPAckAck(), 126),
        fetchack(false, new UDPFetchAck(), 125),
        ack(false, new UDPAck(), 124),
        nack(false, new UDPNack(), 124),
        exec(false, new RPC.RemoteHandler(), 123),
        i_o(false, new IO_record(), -1);

        final UDP _udp;
        final byte _prior;
        final boolean _paxos;
        static udp[] UDPS;

        private udp(boolean paxos, UDP udp2, byte prior) {
            this._paxos = paxos;
            this._udp = udp2;
            this._prior = prior;
        }

        static {
            UDPS = udp.values();
        }
    }
}

