/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import water.DKV;
import water.H2O;
import water.H2OError;
import water.H2OModelBuilderError;
import water.H2ONode;
import water.JettyHTTPD;
import water.RPC;
import water.UDPRebooted;
import water.api.Handler;
import water.api.HandlerFactory;
import water.api.NanoResponse;
import water.api.NanoStreamResponse;
import water.api.RequestType;
import water.api.RequestUri;
import water.api.RestApiContext;
import water.api.RestApiHandler;
import water.api.Route;
import water.api.Schema;
import water.api.SpecifiesHttpResponseCode;
import water.api.StreamingSchema;
import water.api.schemas3.H2OErrorV3;
import water.api.schemas3.H2OModelBuilderErrorV3;
import water.api.schemas99.AssemblyV99;
import water.exceptions.H2OAbstractRuntimeException;
import water.exceptions.H2OFailException;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.exceptions.H2ONotFoundArgumentException;
import water.init.JarHash;
import water.init.NodePersistentStorage;
import water.nbhm.NonBlockingHashMap;
import water.rapids.Assembly;
import water.util.GAUtils;
import water.util.GetLogsFromNode;
import water.util.HttpResponseStatus;
import water.util.IcedHashMapGeneric;
import water.util.JCodeGen;
import water.util.Log;
import water.util.PojoUtils;
import water.util.StringUtils;

public class RequestServer
extends HttpServlet {
    public static final int H2O_REST_API_VERSION = 3;
    private static RouteTree routesTree = new RouteTree("");
    private static ArrayList<Route> routesList = new ArrayList(150);
    private static HttpLogFilter[] _filters = new HttpLogFilter[]{RequestServer.defaultFilter()};
    public static final String HTTP_OK = "200 OK";
    public static final String HTTP_CREATED = "201 Created";
    public static final String HTTP_ACCEPTED = "202 Accepted";
    public static final String HTTP_NO_CONTENT = "204 No Content";
    public static final String HTTP_PARTIAL_CONTENT = "206 Partial Content";
    public static final String HTTP_REDIRECT = "301 Moved Permanently";
    public static final String HTTP_NOT_MODIFIED = "304 Not Modified";
    public static final String HTTP_BAD_REQUEST = "400 Bad Request";
    public static final String HTTP_UNAUTHORIZED = "401 Unauthorized";
    public static final String HTTP_FORBIDDEN = "403 Forbidden";
    public static final String HTTP_NOT_FOUND = "404 Not Found";
    public static final String HTTP_BAD_METHOD = "405 Method Not Allowed";
    public static final String HTTP_PRECONDITION_FAILED = "412 Precondition Failed";
    public static final String HTTP_TOO_LONG_REQUEST = "414 Request-URI Too Long";
    public static final String HTTP_RANGE_NOT_SATISFIABLE = "416 Requested Range Not Satisfiable";
    public static final String HTTP_TEAPOT = "418 I'm a Teapot";
    public static final String HTTP_THROTTLE = "429 Too Many Requests";
    public static final String HTTP_INTERNAL_ERROR = "500 Internal Server Error";
    public static final String HTTP_NOT_IMPLEMENTED = "501 Not Implemented";
    public static final String HTTP_SERVICE_NOT_AVAILABLE = "503 Service Unavailable";
    public static final String MIME_PLAINTEXT = "text/plain";
    public static final String MIME_HTML = "text/html";
    public static final String MIME_CSS = "text/css";
    public static final String MIME_JSON = "application/json";
    public static final String MIME_JS = "application/javascript";
    public static final String MIME_JPEG = "image/jpeg";
    public static final String MIME_PNG = "image/png";
    public static final String MIME_SVG = "image/svg+xml";
    public static final String MIME_GIF = "image/gif";
    public static final String MIME_WOFF = "application/x-font-woff";
    public static final String MIME_DEFAULT_BINARY = "application/octet-stream";
    public static final String MIME_XML = "text/xml";
    private static final NonBlockingHashMap<String, byte[]> _cache = new NonBlockingHashMap();

    public static int numRoutes() {
        return routesList.size();
    }

    public static ArrayList<Route> routes() {
        return routesList;
    }

    public static Route lookupRoute(RequestUri uri) {
        return routesTree.lookup(uri, null);
    }

    public static void setFilters(HttpLogFilter ... filters) {
        _filters = filters;
    }

    public static int numRoutes(int version) {
        int count = 0;
        for (Route route : routesList) {
            if (route.getVersion() != version) continue;
            ++count;
        }
        return count;
    }

    public static Route registerEndpoint(String api_name, String method_uri, Class<? extends Handler> handler_class, String handler_method, String summary) {
        String[] spl = method_uri.split(" ");
        assert (spl.length == 2) : "Unexpected method_uri parameter: " + method_uri;
        return RequestServer.registerEndpoint(api_name, spl[0], spl[1], handler_class, handler_method, summary, HandlerFactory.DEFAULT);
    }

    public static Route registerEndpoint(String api_name, String http_method, String url, Class<? extends Handler> handler_class, String handler_method, String summary, HandlerFactory handler_factory) {
        assert (api_name != null) : "api_name should not be null";
        try {
            RequestUri uri = new RequestUri(http_method, url);
            Route route = new Route(uri, api_name, summary, handler_class, handler_method, handler_factory);
            routesTree.add(uri, route);
            routesList.add(route);
            return route;
        }
        catch (MalformedURLException e) {
            throw H2O.fail(e.getMessage());
        }
    }

    public static Route registerEndpoint(String method_uri, Class<? extends RestApiHandler> handler_clz) {
        try {
            RestApiHandler handler = handler_clz.newInstance();
            return RequestServer.registerEndpoint(handler.name(), method_uri, handler_clz, null, handler.help());
        }
        catch (Exception e) {
            throw H2O.fail(e.getMessage());
        }
    }

    protected void doGet(HttpServletRequest rq, HttpServletResponse rs) {
        this.doGeneric("GET", rq, rs);
    }

    protected void doPut(HttpServletRequest rq, HttpServletResponse rs) {
        this.doGeneric("PUT", rq, rs);
    }

    protected void doPost(HttpServletRequest rq, HttpServletResponse rs) {
        this.doGeneric("POST", rq, rs);
    }

    protected void doHead(HttpServletRequest rq, HttpServletResponse rs) {
        this.doGeneric("HEAD", rq, rs);
    }

    protected void doDelete(HttpServletRequest rq, HttpServletResponse rs) {
        this.doGeneric("DELETE", rq, rs);
    }

    protected void doOptions(HttpServletRequest rq, HttpServletResponse rs) {
        if (System.getProperty("sys.ai.h2o.debug.cors") != null) {
            rs.setHeader("Access-Control-Allow-Origin", "*");
            rs.setHeader("Access-Control-Allow-Headers", "Content-Type");
            rs.setStatus(200);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGeneric(String method, HttpServletRequest request, HttpServletResponse response) {
        try {
            JettyHTTPD.startTransaction(request.getHeader("User-Agent"));
            String uri = request.getServletPath();
            Properties headers = new Properties();
            Enumeration en = request.getHeaderNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String value = request.getHeader(key);
                headers.put(key, value);
            }
            String contentType = request.getContentType();
            Properties parms = new Properties();
            String postBody = null;
            if (System.getProperty("sys.ai.h2o.debug.cors") != null) {
                response.setHeader("Access-Control-Allow-Origin", "*");
                response.setHeader("Access-Control-Allow-Headers", "Content-Type");
            }
            if (contentType != null && contentType.startsWith(MIME_JSON)) {
                StringBuffer jb = new StringBuffer();
                String line = null;
                try {
                    BufferedReader reader = request.getReader();
                    while ((line = reader.readLine()) != null) {
                        jb.append(line);
                    }
                }
                catch (Exception e) {
                    throw new H2OIllegalArgumentException("Exception reading POST body JSON for URL: " + uri);
                }
                postBody = jb.toString();
            } else {
                Map parameterMap = request.getParameterMap();
                for (Map.Entry entry : parameterMap.entrySet()) {
                    String key = (String)entry.getKey();
                    String[] values = (String[])entry.getValue();
                    if (values.length == 1) {
                        parms.put(key, values[0]);
                        continue;
                    }
                    if (values.length <= 1) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append("[");
                    boolean first = true;
                    for (String value : values) {
                        if (!first) {
                            sb.append(",");
                        }
                        sb.append("\"").append(value).append("\"");
                        first = false;
                    }
                    sb.append("]");
                    parms.put(key, sb.toString());
                }
            }
            NanoResponse resp = RequestServer.serve(uri, method, headers, parms, postBody);
            String choppedNanoStatus = resp.status.substring(0, 3);
            assert (choppedNanoStatus.length() == 3);
            int sc = Integer.parseInt(choppedNanoStatus);
            JettyHTTPD.setResponseStatus(response, sc);
            response.setContentType(resp.mimeType);
            Properties header = resp.header;
            Enumeration<Object> en2 = header.keys();
            while (en2.hasMoreElements()) {
                String key = (String)en2.nextElement();
                String value = header.getProperty(key);
                response.setHeader(key, value);
            }
            resp.writeTo((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                JettyHTTPD.setResponseStatus(response, 500);
                Log.err(e);
            }
            catch (Throwable throwable) {
                JettyHTTPD.logRequest(method, request, response);
                if (H2O.getShutdownRequested()) {
                    new Thread(){

                        @Override
                        public void run() {
                            boolean[] confirmations = new boolean[H2O.CLOUD.size()];
                            if (H2O.SELF.index() >= 0) {
                                confirmations[H2O.SELF.index()] = true;
                            }
                            for (H2ONode n : H2O.CLOUD._memary) {
                                if (n == H2O.SELF) continue;
                                new RPC<UDPRebooted.ShutdownTsk>(n, new UDPRebooted.ShutdownTsk(H2O.SELF, n.index(), 1000, confirmations, 0)).call();
                            }
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (Exception arr$) {
                                // empty catch block
                            }
                            int failedToShutdown = 0;
                            for (boolean b : confirmations) {
                                if (b) continue;
                                ++failedToShutdown;
                            }
                            Log.info("Orderly shutdown: " + (failedToShutdown > 0 ? failedToShutdown + " nodes failed to shut down! " : "") + " Shutting down now.");
                            H2O.closeAll();
                            H2O.exit(failedToShutdown);
                        }
                    }.start();
                }
                JettyHTTPD.endTransaction();
                throw throwable;
            }
            JettyHTTPD.logRequest(method, request, response);
            if (H2O.getShutdownRequested()) {
                new /* invalid duplicate definition of identical inner class */.start();
            }
            JettyHTTPD.endTransaction();
        }
        JettyHTTPD.logRequest(method, request, response);
        if (H2O.getShutdownRequested()) {
            new /* invalid duplicate definition of identical inner class */.start();
        }
        JettyHTTPD.endTransaction();
    }

    public static NanoResponse serve(String url, String method, Properties header, Properties parms, String post_body) {
        try {
            Thread.currentThread().setPriority(9);
            RequestType type = RequestType.requestType(url);
            RequestUri uri = new RequestUri(method, url);
            RequestServer.maybeLogRequest(uri, header, parms);
            NanoResponse special = RequestServer.maybeServeSpecial(uri);
            if (special != null) {
                return special;
            }
            Route route = routesTree.lookup(uri, parms);
            if (url.startsWith("/3/Frames/")) {
                int i;
                if ((url.toLowerCase().endsWith("/overwrite/true") || url.toLowerCase().endsWith("/overwrite/false")) && url.contains("/export/")) {
                    i = url.indexOf("/export/");
                    boolean force = url.toLowerCase().endsWith("true");
                    parms.put("frame_id", url.substring(10, i));
                    parms.put("path", url.substring(i + 8, url.length() - 15 - (force ? 0 : 1)));
                    parms.put("force", force ? "true" : "false");
                    route = RequestServer.findRouteByApiName("exportFrame_deprecated");
                } else if (url.endsWith("/export")) {
                    parms.put("frame_id", url.substring(10, url.length() - 7));
                    route = RequestServer.findRouteByApiName("exportFrame");
                } else if (url.endsWith("/summary") && url.contains("/columns/")) {
                    i = url.indexOf("/columns/");
                    parms.put("frame_id", url.substring(10, i));
                    parms.put("column", url.substring(i + 9, url.length() - 8));
                    route = RequestServer.findRouteByApiName("frameColumnSummary");
                } else if (url.endsWith("/domain") && url.contains("/columns/")) {
                    i = url.indexOf("/columns/");
                    parms.put("frame_id", url.substring(10, i));
                    parms.put("column", url.substring(i + 9, url.length() - 7));
                    route = RequestServer.findRouteByApiName("frameColumnDomain");
                } else if (url.contains("/columns/")) {
                    i = url.indexOf("/columns/");
                    parms.put("frame_id", url.substring(10, i));
                    parms.put("column", url.substring(i + 9));
                    route = RequestServer.findRouteByApiName("frameColumn");
                } else if (url.endsWith("/summary")) {
                    parms.put("frame_id", url.substring(10, url.length() - 8));
                    route = RequestServer.findRouteByApiName("frameSummary");
                } else if (url.endsWith("/light")) {
                    parms.put("frame_id", url.substring(10, url.length() - "/light".length()));
                    route = RequestServer.findRouteByApiName("lightFrame");
                } else if (url.endsWith("/columns")) {
                    parms.put("frame_id", url.substring(10, url.length() - 8));
                    route = RequestServer.findRouteByApiName("frameColumns");
                } else {
                    parms.put("frame_id", url.substring(10));
                    route = RequestServer.findRouteByApiName(method.equals("DELETE") ? "deleteFrame" : "frame");
                }
            } else if (url.startsWith("/3/ModelMetrics/predictions_frame/")) {
                route = RequestServer.findRouteByApiName("makeMetrics");
            }
            if (route == null) {
                if (uri.isGetMethod()) {
                    return RequestServer.getResource(type, url);
                }
                return RequestServer.response404(method + " " + url, type);
            }
            Schema response = route._handler.handle(uri.getVersion(), route, parms, post_body);
            PojoUtils.filterFields(response, (String)parms.get("_include_fields"), (String)parms.get("_exclude_fields"));
            return RequestServer.serveSchema(response, type);
        }
        catch (H2OFailException e) {
            H2OError error = e.toH2OError(url);
            Log.fatal("Caught exception (fatal to the cluster): " + error.toString());
            throw H2O.fail(RequestServer.serveError(error).toString());
        }
        catch (H2OModelBuilderIllegalArgumentException e) {
            H2OModelBuilderError error = e.toH2OError(url);
            Log.warn("Caught exception: " + error.toString());
            return RequestServer.serveSchema(new H2OModelBuilderErrorV3().fillFromImpl(error), RequestType.json);
        }
        catch (H2OAbstractRuntimeException e) {
            H2OError error = e.toH2OError(url);
            Log.warn("Caught exception: " + error.toString());
            return RequestServer.serveError(error);
        }
        catch (AssertionError e) {
            H2OError error = new H2OError(System.currentTimeMillis(), url, ((Throwable)((Object)e)).toString(), ((Throwable)((Object)e)).toString(), HttpResponseStatus.INTERNAL_SERVER_ERROR.getCode(), new IcedHashMapGeneric.IcedHashMapStringObject(), (Throwable)((Object)e));
            Log.err("Caught assertion error: " + error.toString());
            return RequestServer.serveError(error);
        }
        catch (Exception e) {
            H2OError error = new H2OError(e, url);
            if (e instanceof IllegalArgumentException || e instanceof FileNotFoundException || e instanceof MalformedURLException) {
                error._http_status = HttpResponseStatus.BAD_REQUEST.getCode();
            }
            Log.err("Caught exception: " + error.toString() + ";parms=" + parms);
            return RequestServer.serveError(error);
        }
    }

    private static void maybeLogRequest(RequestUri uri, Properties header, Properties parms) {
        for (HttpLogFilter f : _filters) {
            if (!f.filter(uri, header, parms)) continue;
            return;
        }
        String url = uri.getUrl();
        Log.info(uri + ", parms: " + parms);
        GAUtils.logRequest(url, header);
    }

    public static HttpLogFilter defaultFilter() {
        return new HttpLogFilter(){

            @Override
            public boolean filter(RequestUri uri, Properties header, Properties parms) {
                String url = uri.getUrl();
                if (url.endsWith(".css") || url.endsWith(".js") || url.endsWith(".png") || url.endsWith(".ico")) {
                    return true;
                }
                String[] path = uri.getPath();
                return path[2].equals("Cloud") || path[2].equals("Jobs") && uri.isGetMethod() || path[2].equals("Log") || path[2].equals("Progress") || path[2].equals("Typeahead") || path[2].equals("WaterMeterCpuTicks") || path[2].equals("DecryptionSetup");
            }
        };
    }

    private static Route findRouteByApiName(String apiName) {
        for (Route route : routesList) {
            if (!route._api_name.equals(apiName)) continue;
            return route;
        }
        return null;
    }

    private static NanoResponse maybeServeSpecial(RequestUri uri) {
        assert (uri != null);
        if (uri.isHeadMethod() && uri.getUrl().equals("/")) {
            return new NanoResponse(HTTP_OK, MIME_PLAINTEXT, "");
        }
        if (uri.isGetMethod()) {
            String[] path = uri.getPath();
            if (path[2].equals("")) {
                return RequestServer.redirectToFlow();
            }
            if (path[2].equals("Logs") && path[3].equals("download")) {
                return RequestServer.downloadLogs();
            }
            if (path[2].equals("NodePersistentStorage.bin") && path.length == 6) {
                return RequestServer.downloadNps(path[3], path[4]);
            }
        }
        return null;
    }

    private static NanoResponse response404(String what, RequestType type) {
        H2ONotFoundArgumentException e = new H2ONotFoundArgumentException(what + " not found", what + " not found");
        H2OError error = e.toH2OError(what);
        Log.warn(error._dev_msg);
        return RequestServer.serveError(error);
    }

    private static NanoResponse serveSchema(Schema s, RequestType type) {
        String http_response_header = H2OError.httpStatusHeader(HttpResponseStatus.OK.getCode());
        if (s instanceof SpecifiesHttpResponseCode) {
            http_response_header = H2OError.httpStatusHeader(((SpecifiesHttpResponseCode)((Object)s)).httpStatus());
        }
        if (s instanceof SpecifiesHttpResponseCode && HttpResponseStatus.OK.getCode() != ((SpecifiesHttpResponseCode)((Object)s)).httpStatus()) {
            type = RequestType.json;
        }
        if (s instanceof H2OErrorV3) {
            return new NanoResponse(http_response_header, MIME_JSON, s.toJsonString());
        }
        if (s instanceof StreamingSchema) {
            StreamingSchema ss = (StreamingSchema)s;
            NanoStreamResponse r = new NanoStreamResponse(http_response_header, MIME_DEFAULT_BINARY, ss.getStreamWriter());
            r.addHeader("Content-Disposition", "attachment; filename=\"" + ss.getFilename() + "\"");
            return r;
        }
        switch (type) {
            case html: 
            case json: {
                return new NanoResponse(http_response_header, MIME_JSON, s.toJsonString());
            }
            case xml: {
                throw H2O.unimpl("Unknown type: " + type.toString());
            }
            case java: {
                if (s instanceof AssemblyV99) {
                    Assembly ass = (Assembly)DKV.getGet(((AssemblyV99)s).assembly_id);
                    NanoResponse r = new NanoResponse(http_response_header, MIME_DEFAULT_BINARY, ass.toJava(((AssemblyV99)s).pojo_name));
                    r.addHeader("Content-Disposition", "attachment; filename=\"" + JCodeGen.toJavaId(((AssemblyV99)s).pojo_name) + ".java\"");
                    return r;
                }
                throw new H2OIllegalArgumentException("Cannot generate java for type: " + s.getClass().getSimpleName());
            }
        }
        throw H2O.unimpl("Unknown type to serveSchema(): " + (Object)((Object)type));
    }

    private static NanoResponse serveError(H2OError error) {
        return RequestServer.serveSchema(new H2OErrorV3().fillFromImpl(error), RequestType.json);
    }

    private static NanoResponse redirectToFlow() {
        NanoResponse res = new NanoResponse(HTTP_REDIRECT, MIME_PLAINTEXT, "");
        res.addHeader("Location", H2O.ARGS.context_path + "/flow/index.html");
        return res;
    }

    private static NanoResponse downloadNps(String categoryName, String keyName) {
        NodePersistentStorage nps = H2O.getNPS();
        AtomicLong length = new AtomicLong();
        InputStream is = nps.get(categoryName, keyName, length);
        NanoResponse res = new NanoResponse(HTTP_OK, MIME_DEFAULT_BINARY, is);
        res.addHeader("Content-Length", Long.toString(length.get()));
        res.addHeader("Content-Disposition", "attachment; filename=" + keyName + ".flow");
        return res;
    }

    private static NanoResponse downloadLogs() {
        byte[] finalZipByteArray;
        Log.info("\nCollecting logs.");
        H2ONode[] members = H2O.CLOUD.members();
        byte[][] perNodeZipByteArray = new byte[members.length][];
        byte[] clientNodeByteArray = null;
        for (int i = 0; i < members.length; ++i) {
            byte[] bytes;
            try {
                if (members[i].isHealthy()) {
                    GetLogsFromNode g = new GetLogsFromNode();
                    g.nodeidx = i;
                    g.doIt();
                    bytes = g.bytes;
                } else {
                    bytes = StringUtils.bytesOf("Node not healthy");
                }
            }
            catch (Exception e) {
                bytes = StringUtils.toBytes(e);
            }
            perNodeZipByteArray[i] = bytes;
        }
        if (H2O.ARGS.client) {
            byte[] bytes;
            try {
                GetLogsFromNode g = new GetLogsFromNode();
                g.nodeidx = -1;
                g.doIt();
                bytes = g.bytes;
            }
            catch (Exception e) {
                bytes = StringUtils.toBytes(e);
            }
            clientNodeByteArray = bytes;
        }
        String outputFileStem = RequestServer.getOutputLogStem();
        try {
            finalZipByteArray = RequestServer.zipLogs(perNodeZipByteArray, clientNodeByteArray, outputFileStem);
        }
        catch (Exception e) {
            finalZipByteArray = StringUtils.toBytes(e);
        }
        NanoResponse res = new NanoResponse(HTTP_OK, MIME_DEFAULT_BINARY, new ByteArrayInputStream(finalZipByteArray));
        res.addHeader("Content-Length", Long.toString(finalZipByteArray.length));
        res.addHeader("Content-Disposition", "attachment; filename=" + outputFileStem + ".zip");
        return res;
    }

    private static String getOutputLogStem() {
        String pattern = "yyyyMMdd_hhmmss";
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        String now = formatter.format(new Date());
        return "h2ologs_" + now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] zipLogs(byte[][] results, byte[] clientResult, String topDir) throws IOException {
        int l = 0;
        assert (H2O.CLOUD._memary.length == results.length) : "Unexpected change in the cloud!";
        for (byte[] result : results) {
            l += result.length;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(l);
        ZipOutputStream zos = new ZipOutputStream(baos);
        ZipEntry zde = new ZipEntry(topDir + File.separator);
        zos.putNextEntry(zde);
        try {
            for (int i = 0; i < results.length; ++i) {
                String filename = topDir + File.separator + "node" + i + "_" + H2O.CLOUD._memary[i].getIpPortString().replace(':', '_').replace('/', '_') + ".zip";
                ZipEntry ze = new ZipEntry(filename);
                zos.putNextEntry(ze);
                zos.write(results[i]);
                zos.closeEntry();
            }
            if (clientResult != null) {
                String filename = topDir + File.separator + "driver.zip";
                ZipEntry ze = new ZipEntry(filename);
                zos.putNextEntry(ze);
                zos.write(clientResult);
                zos.closeEntry();
            }
            zos.closeEntry();
        }
        finally {
            zos.close();
        }
        return baos.toByteArray();
    }

    private static NanoResponse getResource(RequestType request_type, String url) {
        String mime;
        byte[] bytes = _cache.get(url);
        if (bytes == null) {
            try (InputStream resource2 = JarHash.getResource2(url);){
                if (resource2 != null) {
                    try {
                        bytes = RequestServer.toByteArray(resource2);
                    }
                    catch (IOException e) {
                        Log.err(e);
                    }
                }
            }
            catch (IOException resource2) {
                // empty catch block
            }
        }
        if (bytes == null || bytes.length == 0) {
            return RequestServer.response404("Resource " + url, request_type);
        }
        int i = url.lastIndexOf(46);
        switch (url.substring(i + 1)) {
            case "js": {
                mime = MIME_JS;
                break;
            }
            case "css": {
                mime = MIME_CSS;
                break;
            }
            case "htm": 
            case "html": {
                mime = MIME_HTML;
                break;
            }
            case "jpg": 
            case "jpeg": {
                mime = MIME_JPEG;
                break;
            }
            case "png": {
                mime = MIME_PNG;
                break;
            }
            case "svg": {
                mime = MIME_SVG;
                break;
            }
            case "gif": {
                mime = MIME_GIF;
                break;
            }
            case "woff": {
                mime = MIME_WOFF;
                break;
            }
            default: {
                mime = MIME_DEFAULT_BINARY;
            }
        }
        NanoResponse res = new NanoResponse(HTTP_OK, mime, new ByteArrayInputStream(bytes));
        res.addHeader("Content-Length", Long.toString(bytes.length));
        return res;
    }

    private static byte[] toByteArray(InputStream is) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = is.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    public static class DummyRestApiContext
    implements RestApiContext {
        private Set<Schema> allSchemas = new HashSet<Schema>();

        @Override
        public Route registerEndpoint(String apiName, String methodUri, Class<? extends Handler> handlerClass, String handlerMethod, String summary) {
            return RequestServer.registerEndpoint(apiName, methodUri, handlerClass, handlerMethod, summary);
        }

        @Override
        public Route registerEndpoint(String apiName, String httpMethod, String url, Class<? extends Handler> handlerClass, String handlerMethod, String summary, HandlerFactory handlerFactory) {
            return RequestServer.registerEndpoint(apiName, httpMethod, url, handlerClass, handlerMethod, summary, handlerFactory);
        }

        @Override
        public Route registerEndpoint(String methodUri, Class<? extends RestApiHandler> handlerClass) {
            return RequestServer.registerEndpoint(methodUri, handlerClass);
        }

        @Override
        public void registerSchema(Schema ... schemas) {
            for (Schema schema : schemas) {
                this.allSchemas.add(schema);
            }
        }

        public Schema[] getAllSchemas() {
            return this.allSchemas.toArray(new Schema[0]);
        }
    }

    private static class RouteTree {
        private String root;
        private boolean isWildcard;
        private HashMap<String, RouteTree> branches;
        private Route leaf;

        public RouteTree(String token) {
            this.isWildcard = RouteTree.isWildcardToken(token);
            this.root = this.isWildcard ? "*" : token;
            this.branches = new HashMap();
            this.leaf = null;
        }

        public void add(RequestUri uri, Route route) {
            String[] path = uri.getPath();
            this.addByPath(path, 0, route);
        }

        public Route lookup(RequestUri uri, Properties parms) {
            if (!uri.isApiUrl()) {
                return null;
            }
            String[] path = uri.getPath();
            ArrayList<String> path_params = new ArrayList<String>(3);
            Route route = this.lookupByPath(path, 0, path_params);
            if (parms != null && route != null) {
                String[] param_names = route._path_params;
                assert (path_params.size() == param_names.length);
                for (int i = 0; i < param_names.length; ++i) {
                    parms.put(param_names[i], path_params.get(i));
                }
            }
            return route;
        }

        private void addByPath(String[] path, int index, Route route) {
            if (index + 1 < path.length) {
                String nextToken;
                String string = nextToken = RouteTree.isWildcardToken(path[index + 1]) ? "*" : path[index + 1];
                if (!this.branches.containsKey(nextToken)) {
                    this.branches.put(nextToken, new RouteTree(nextToken));
                }
                this.branches.get(nextToken).addByPath(path, index + 1, route);
            } else {
                assert (this.leaf == null) : "Duplicate path encountered: " + Arrays.toString(path);
                this.leaf = route;
            }
        }

        private Route lookupByPath(String[] path, int index, ArrayList<String> path_params) {
            assert (this.isWildcard || this.root.equals(path[index]));
            if (index + 1 < path.length) {
                Route route;
                String nextToken = path[index + 1];
                if (this.branches.containsKey(nextToken) && (route = this.branches.get(nextToken).lookupByPath(path, index + 1, path_params)) != null) {
                    return route;
                }
                if (this.branches.containsKey("*")) {
                    path_params.add(path[index + 1]);
                    route = this.branches.get("*").lookupByPath(path, index + 1, path_params);
                    if (route != null) {
                        return route;
                    }
                    path_params.remove(path_params.size() - 1);
                }
                if (index == path.length - 2) {
                    int v = Integer.parseInt(nextToken);
                    for (String key : this.branches.keySet()) {
                        if (this.branches.get((Object)key).leaf == null || Integer.parseInt(key) > v) continue;
                        RouteTree newBranch = new RouteTree(nextToken);
                        newBranch.leaf = this.branches.get((Object)key).leaf;
                        this.branches.put(nextToken, newBranch);
                        return newBranch.leaf;
                    }
                }
            } else {
                return this.leaf;
            }
            return null;
        }

        private static boolean isWildcardToken(String token) {
            return token.equals("*") || token.startsWith("{") && token.endsWith("}");
        }
    }

    public static interface HttpLogFilter {
        public boolean filter(RequestUri var1, Properties var2, Properties var3);
    }
}

