/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.util.PrettyPrint;
import water.util.UnsafeUtils;

public abstract class CSChunk
extends Chunk {
    protected static final int _OFF = 16;
    private transient double _scale;
    private transient long _bias;
    private transient boolean _isDecimal;

    CSChunk(byte[] bs, long bias, int scale, int szLog) {
        this._mem = bs;
        this._start = -1L;
        this.set_len(this._mem.length - 16 >> szLog);
        this._bias = bias;
        UnsafeUtils.set8(this._mem, 0, bias);
        UnsafeUtils.set4(this._mem, 8, scale);
        this._scale = PrettyPrint.pow10(1L, scale);
        UnsafeUtils.set4(this._mem, 12, szLog);
    }

    protected void setDecimal() {
        this._isDecimal = true;
        this._scale = PrettyPrint.pow10(1L, -UnsafeUtils.get4(this._mem, 8));
        UnsafeUtils.set4(this._mem, 12, -UnsafeUtils.get4(this._mem, 12) - 1);
    }

    private int getSzLog() {
        int x = UnsafeUtils.get4(this._mem, 12);
        return x < 0 ? -x - 1 : x;
    }

    public final double scale() {
        return this._isDecimal ? 1.0 / this._scale : this._scale;
    }

    @Override
    public final byte precision() {
        return (byte)Math.max(UnsafeUtils.get4(this._mem, 8), 0);
    }

    protected final double getD(int x, int NA) {
        return this.getD(x, NA, Double.NaN);
    }

    protected final double getD(int x, int NA, double naImpute) {
        return x == NA ? naImpute : (this._isDecimal ? (double)(this._bias + (long)x) / this._scale : (double)(this._bias + (long)x) * this._scale);
    }

    @Override
    public final boolean hasFloat() {
        return this._isDecimal || this._scale < 1.0;
    }

    @Override
    public final void initFromBytes() {
        this._start = -1L;
        this._cidx = -1;
        this.set_len(this._mem.length - 16 >> this.getSzLog());
        this._bias = UnsafeUtils.get8(this._mem, 0);
        int x = UnsafeUtils.get4(this._mem, 8);
        int szLog = UnsafeUtils.get4(this._mem, 12);
        this._isDecimal = szLog < 0;
        this._scale = PrettyPrint.pow10(1L, this._isDecimal ? -x : x);
    }

    @Override
    protected final long at8_impl(int i) {
        double res = this.atd_impl(i);
        if (Double.isNaN(res)) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return (long)res;
    }

    @Override
    public final boolean set_impl(int idx, long l) {
        double d = l;
        if (d != (double)l) {
            return false;
        }
        return this.set_impl(idx, d);
    }

    @Override
    public final boolean set_impl(int idx, float f) {
        return this.set_impl(idx, (double)f);
    }

    protected final int getScaledValue(double d, int NA) {
        assert (!Double.isNaN(d)) : "NaN should be handled separately";
        return (int)((this._isDecimal ? d * this._scale : d / this._scale) - (double)this._bias);
    }

    @Override
    public final <T extends ChunkVisitor> T processRows(T v, int from, int to) {
        if (v.expandedVals()) {
            this.processRows2(v, from, to, this._bias, UnsafeUtils.get4(this._mem, 8));
        } else {
            this.processRows2(v, from, to);
        }
        return v;
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v, int[] ids) {
        if (v.expandedVals()) {
            this.processRows2(v, ids, this._bias, UnsafeUtils.get4(this._mem, 8));
        } else {
            this.processRows2(v, ids);
        }
        return v;
    }

    protected abstract <T extends ChunkVisitor> T processRows2(T var1, int var2, int var3, long var4, int var6);

    protected abstract <T extends ChunkVisitor> T processRows2(T var1, int var2, int var3);

    protected abstract <T extends ChunkVisitor> T processRows2(T var1, int[] var2, long var3, int var5);

    protected abstract <T extends ChunkVisitor> T processRows2(T var1, int[] var2);
}

