/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import water.DKV;
import water.Futures;
import water.H2O;
import water.H2ONode;
import water.Key;
import water.MRTask;
import water.RPC;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.BinaryMerge;
import water.rapids.RadixOrder;
import water.rapids.SingleThreadRadixOrder;
import water.rapids.SplitByMSBLocal;

public class Merge {
    public static Frame sort(Frame fr, int[] cols) {
        int numCol = cols.length;
        int[] ascending = new int[numCol];
        Arrays.fill(ascending, 1);
        return Merge.sort(fr, cols, ascending);
    }

    public static Frame sort(Frame fr, int[] cols, int[] ascending) {
        if (cols.length == 0) {
            return fr;
        }
        for (int col : cols) {
            if (col >= 0 && col < fr.numCols()) continue;
            throw new IllegalArgumentException("Column " + col + " is out of range of " + fr.numCols());
        }
        int[][] id_maps = new int[cols.length][];
        for (int i = 0; i < cols.length; ++i) {
            Vec vec = fr.vec(cols[i]);
            if (!vec.isCategorical()) continue;
            String[] domain = vec.domain();
            id_maps[i] = new int[domain.length];
            for (int j = 0; j < domain.length; ++j) {
                id_maps[i][j] = j;
            }
        }
        return Merge.merge(fr, new Frame(new Vec[0]), cols, new int[0], true, id_maps, ascending, new int[0]);
    }

    public static Frame merge(Frame leftFrame, Frame riteFrame, int[] leftCols, int[] riteCols, boolean allLeft, int[][] id_maps) {
        int[] ascendingR;
        int[] ascendingL;
        if (leftCols != null && leftCols.length > 0) {
            ascendingL = new int[leftCols.length];
            Arrays.fill(ascendingL, 1);
        } else {
            ascendingL = new int[]{};
        }
        if (riteCols != null && riteCols.length > 0) {
            ascendingR = new int[riteCols.length];
            Arrays.fill(ascendingR, 1);
        } else {
            ascendingR = new int[]{};
        }
        return Merge.merge(leftFrame, riteFrame, leftCols, riteCols, allLeft, id_maps, ascendingL, ascendingR);
    }

    public static Frame merge(Frame leftFrame, Frame riteFrame, int[] leftCols, int[] riteCols, boolean allLeft, int[][] id_maps, int[] ascendingL, int[] ascendingR) {
        int j;
        int leftMSB;
        boolean leftRangeAboveRightMax;
        boolean riteBaseExceedsleftBase;
        boolean hasRite = riteCols.length > 0;
        for (int i = 0; i < id_maps.length; ++i) {
            if (id_maps[i] == null) continue;
            assert ((double)id_maps[i].length >= leftFrame.vec(leftCols[i]).max() + 1.0);
            if (!hasRite) continue;
            int right_max = (int)riteFrame.vec(riteCols[i]).max();
            for (int j2 = 0; j2 < id_maps[i].length; ++j2) {
                assert (id_maps[i][j2] >= 0);
                if (id_maps[i][j2] <= right_max) continue;
                id_maps[i][j2] = -1;
            }
        }
        RadixOrder leftIndex = Merge.createIndex(true, leftFrame, leftCols, id_maps, ascendingL);
        RadixOrder riteIndex = Merge.createIndex(false, riteFrame, riteCols, id_maps, ascendingR);
        System.out.print("Making BinaryMerge RPC calls ... ");
        long t0 = System.nanoTime();
        ArrayList<BinaryMerge> bmList = new ArrayList<BinaryMerge>();
        Futures fs = new Futures();
        int leftShift = leftIndex._shift[0];
        BigInteger leftBase = leftIndex._base[0];
        int riteShift = hasRite ? riteIndex._shift[0] : -1;
        BigInteger riteBase = hasRite ? riteIndex._base[0] : leftBase;
        long leftMSBfrom = riteBase.subtract(leftBase).shiftRight(leftShift).longValue();
        boolean bl = riteBaseExceedsleftBase = riteBase.compareTo(leftBase) > 0;
        if (riteBaseExceedsleftBase) {
            assert (leftMSBfrom >= 0L);
            if (leftMSBfrom > 255L) {
                leftMSBfrom = 256L;
            }
            if (allLeft) {
                int leftMSB2 = 0;
                while ((long)leftMSB2 < leftMSBfrom) {
                    BinaryMerge bm = new BinaryMerge(new BinaryMerge.FFSB(leftFrame, leftMSB2, leftShift, leftIndex._bytesUsed, leftIndex._base), new BinaryMerge.FFSB(riteFrame, -1, riteShift, riteIndex._bytesUsed, riteIndex._base), true);
                    bmList.add(bm);
                    fs.add(new RPC<BinaryMerge>(SplitByMSBLocal.ownerOfMSB(leftMSB2), bm).call());
                    ++leftMSB2;
                }
            }
        } else {
            assert (leftMSBfrom <= 0L);
            leftMSBfrom = 0L;
        }
        BigInteger rightS = BigInteger.valueOf(256L << riteShift);
        long leftMSBto = riteBase.add(rightS).subtract(BigInteger.ONE).subtract(leftBase).shiftRight(leftShift).longValue();
        boolean bl2 = leftIndex._isCategorical[0] ? leftBase.add(BigInteger.valueOf(256L << leftShift)).compareTo(riteBase.add(rightS)) > 0 : (leftRangeAboveRightMax = leftBase.add(BigInteger.valueOf(256L << leftShift)).compareTo(riteBase.add(rightS)) >= 0);
        if (leftRangeAboveRightMax) {
            assert (leftMSBto <= 255L);
            if (leftMSBto < 0L) {
                leftMSBto = -1L;
            }
            if (allLeft) {
                for (leftMSB = (int)leftMSBto + 1; leftMSB <= 255; ++leftMSB) {
                    BinaryMerge bm = new BinaryMerge(new BinaryMerge.FFSB(leftFrame, leftMSB, leftShift, leftIndex._bytesUsed, leftIndex._base), new BinaryMerge.FFSB(riteFrame, -1, riteShift, riteIndex._bytesUsed, riteIndex._base), true);
                    bmList.add(bm);
                    fs.add(new RPC<BinaryMerge>(SplitByMSBLocal.ownerOfMSB(leftMSB), bm).call());
                }
            }
        } else {
            assert (leftMSBto >= 255L);
            leftMSBto = 255L;
        }
        leftMSB = (int)leftMSBfrom;
        while ((long)leftMSB <= leftMSBto) {
            assert (leftMSB >= 0);
            assert (leftMSB <= 255);
            long leftFrom = ((long)leftMSB << leftShift) - 1L + leftBase.longValue();
            long leftTo = ((long)leftMSB + 1L << leftShift) - 1L + leftBase.longValue() - 1L;
            int rightMSBfrom = (int)(leftFrom - riteBase.longValue() + 1L >> riteShift);
            int rightMSBto = (int)(leftTo - riteBase.longValue() + 1L >> riteShift);
            if (rightMSBfrom < 0) {
                rightMSBfrom = 0;
            }
            assert (rightMSBfrom <= 255);
            if (rightMSBto > 255) {
                rightMSBto = 255;
            }
            assert (rightMSBto >= rightMSBfrom);
            for (int rightMSB = rightMSBfrom; rightMSB <= rightMSBto; ++rightMSB) {
                BinaryMerge bm = new BinaryMerge(new BinaryMerge.FFSB(leftFrame, leftMSB, leftShift, leftIndex._bytesUsed, leftIndex._base), new BinaryMerge.FFSB(riteFrame, rightMSB, riteShift, riteIndex._bytesUsed, riteIndex._base), allLeft);
                bmList.add(bm);
                H2ONode node = SplitByMSBLocal.ownerOfMSB(rightMSB);
                fs.add(new RPC<BinaryMerge>(node, bm).call());
            }
            ++leftMSB;
        }
        System.out.println("took: " + String.format("%.3f", (double)(System.nanoTime() - t0) / 1.0E9));
        t0 = System.nanoTime();
        System.out.println("Sending BinaryMerge async RPC calls in a queue ... ");
        fs.blockForPending();
        System.out.println("took: " + (double)(System.nanoTime() - t0) / 1.0E9);
        System.out.print("Removing DKV keys of left and right index.  ... ");
        t0 = System.nanoTime();
        for (int msb = 0; msb < 256; ++msb) {
            for (int isLeft = 0; isLeft < 2; ++isLeft) {
                Key k = SingleThreadRadixOrder.getSortedOXHeaderKey(isLeft != 0, msb);
                SingleThreadRadixOrder.OXHeader oxheader = (SingleThreadRadixOrder.OXHeader)DKV.getGet(k);
                DKV.remove(k);
                if (oxheader == null) continue;
                for (int b = 0; b < oxheader._nBatch; ++b) {
                    k = SplitByMSBLocal.getSortedOXbatchKey(isLeft != 0, msb, b);
                    DKV.remove(k);
                }
            }
        }
        System.out.println("took: " + (double)(System.nanoTime() - t0) / 1.0E9);
        System.out.print("Allocating and populating chunk info (e.g. size and batch number) ...");
        t0 = System.nanoTime();
        long ansN = 0L;
        int numChunks = 0;
        for (BinaryMerge thisbm : bmList) {
            if (thisbm._numRowsInResult <= 0L) continue;
            numChunks += thisbm._chunkSizes.length;
            ansN += thisbm._numRowsInResult;
        }
        long[] chunkSizes = new long[numChunks];
        int[] chunkLeftMSB = new int[numChunks];
        int[] chunkRightMSB = new int[numChunks];
        int[] chunkBatch = new int[numChunks];
        int k = 0;
        for (BinaryMerge thisbm : bmList) {
            if (thisbm._numRowsInResult == 0L) continue;
            int[] thisChunkSizes = thisbm._chunkSizes;
            int j3 = 0;
            while (j3 < thisChunkSizes.length) {
                chunkSizes[k] = thisChunkSizes[j3];
                chunkLeftMSB[k] = thisbm._leftSB._msb;
                chunkRightMSB[k] = thisbm._riteSB._msb;
                chunkBatch[k] = j3++;
                ++k;
            }
        }
        System.out.println("took: " + (double)(System.nanoTime() - t0) / 1.0E9);
        System.out.print("Allocating and populated espc ...");
        t0 = System.nanoTime();
        long[] espc = new long[chunkSizes.length + 1];
        int i = 0;
        long sum = 0L;
        for (long s : chunkSizes) {
            espc[i++] = sum;
            sum += s;
        }
        espc[espc.length - 1] = sum;
        System.out.println("took: " + (double)(System.nanoTime() - t0) / 1.0E9);
        assert (sum == ansN);
        System.out.print("Allocating dummy vecs/chunks of the final frame ...");
        t0 = System.nanoTime();
        int numJoinCols = hasRite ? leftIndex._bytesUsed.length : 0;
        int numLeftCols = leftFrame.numCols();
        int numColsInResult = numLeftCols + riteFrame.numCols() - numJoinCols;
        byte[] types = new byte[numColsInResult];
        String[][] doms = new String[numColsInResult][];
        String[] names = new String[numColsInResult];
        for (j = 0; j < numLeftCols; ++j) {
            types[j] = leftFrame.vec(j).get_type();
            doms[j] = leftFrame.domains()[j];
            names[j] = leftFrame.names()[j];
        }
        for (j = 0; j < riteFrame.numCols() - numJoinCols; ++j) {
            types[numLeftCols + j] = riteFrame.vec(j + numJoinCols).get_type();
            doms[numLeftCols + j] = riteFrame.domains()[j + numJoinCols];
            names[numLeftCols + j] = riteFrame.names()[j + numJoinCols];
        }
        Key<Vec> key = Vec.newKey();
        Vec[] vecs = new Vec(key, Vec.ESPC.rowLayout(key, espc)).makeCons(numColsInResult, 0L, doms, types);
        System.out.println("took: " + (double)(System.nanoTime() - t0) / 1.0E9);
        System.out.print("Finally stitch together by overwriting dummies ...");
        t0 = System.nanoTime();
        Frame fr = new Frame(names, vecs);
        ChunkStitcher ff = new ChunkStitcher(chunkSizes, chunkLeftMSB, chunkRightMSB, chunkBatch);
        ff.doAll(fr);
        System.out.println("took: " + (double)(System.nanoTime() - t0) / 1.0E9);
        return fr;
    }

    private static RadixOrder createIndex(boolean isLeft, Frame fr, int[] cols, int[][] id_maps, int[] ascending) {
        System.out.println("\nCreating " + (isLeft ? "left" : "right") + " index ...");
        long t0 = System.nanoTime();
        RadixOrder idxTask = new RadixOrder(fr, isLeft, cols, id_maps, ascending);
        H2O.submitTask(idxTask);
        idxTask.join();
        System.out.println("***\n*** Creating " + (isLeft ? "left" : "right") + " index took: " + (double)(System.nanoTime() - t0) / 1.0E9 + "\n***\n");
        return idxTask;
    }

    static class ChunkStitcher
    extends MRTask<ChunkStitcher> {
        final long[] _chunkSizes;
        final int[] _chunkLeftMSB;
        final int[] _chunkRightMSB;
        final int[] _chunkBatch;

        ChunkStitcher(long[] chunkSizes, int[] chunkLeftMSB, int[] chunkRightMSB, int[] chunkBatch) {
            this._chunkSizes = chunkSizes;
            this._chunkLeftMSB = chunkLeftMSB;
            this._chunkRightMSB = chunkRightMSB;
            this._chunkBatch = chunkBatch;
        }

        @Override
        public void map(Chunk[] cs) {
            int chkIdx = cs[0].cidx();
            Futures fs = new Futures();
            for (int i = 0; i < cs.length; ++i) {
                Key destKey = cs[i].vec().chunkKey(chkIdx);
                assert ((long)cs[i].len() == this._chunkSizes[chkIdx]);
                Key k = BinaryMerge.getKeyForMSBComboPerCol(this._chunkLeftMSB[chkIdx], this._chunkRightMSB[chkIdx], i, this._chunkBatch[chkIdx]);
                Chunk ck = (Chunk)DKV.getGet(k);
                DKV.put(destKey, ck, fs, true);
                DKV.remove(k);
            }
            fs.blockForPending();
        }
    }
}

