/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Hashtable;
import water.DKV;
import water.Futures;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.rapids.RadixCount;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.MathUtils;
import water.util.PrettyPrint;

class SplitByMSBLocal
extends MRTask<SplitByMSBLocal> {
    private final boolean _isLeft;
    private final int _shift;
    private final int _batchSize;
    private final int[] _bytesUsed;
    private final int _keySize;
    private final BigInteger[] _base;
    private final int[] _col;
    private final Key _linkTwoMRTask;
    private final int[][] _id_maps;
    private final int[] _ascending;
    private transient long[][] _counts;
    private transient long[][][] _o;
    private transient byte[][][] _x;
    private long _numRowsOnThisNode;
    static Hashtable<Key, SplitByMSBLocal> MOVESHASH = new Hashtable();

    SplitByMSBLocal(boolean isLeft, BigInteger[] base, int shift, int keySize, int batchSize, int[] bytesUsed, int[] col, Key linkTwoMRTask, int[][] id_maps, int[] ascending) {
        this._isLeft = isLeft;
        this._shift = shift;
        this._batchSize = batchSize;
        this._bytesUsed = bytesUsed;
        this._col = col;
        this._base = base;
        this._keySize = keySize;
        this._linkTwoMRTask = linkTwoMRTask;
        this._id_maps = id_maps;
        this._ascending = ascending;
    }

    @Override
    protected void setupLocal() {
        int msb;
        Key k = RadixCount.getKey(this._isLeft, this._col[0], H2O.SELF);
        this._counts = ((RadixCount.Long2DArray)DKV.getGet((Key)k))._val;
        DKV.remove(k);
        long[] MSBhist = new long[256];
        int nc = this._fr.anyVec().nChunks();
        assert (nc == this._counts.length);
        for (int c = 0; c < nc; ++c) {
            if (this._counts[c] == null) continue;
            for (int h = 0; h < 256; ++h) {
                int n = h;
                MSBhist[n] = MSBhist[n] + this._counts[c][h];
            }
        }
        this._numRowsOnThisNode = ArrayUtils.sum(MSBhist);
        if (ArrayUtils.maxValue(MSBhist) > Math.max(1000L, this._fr.numRows() / 20L / (long)H2O.CLOUD.size())) {
            Log.warn("RadixOrder(): load balancing on this node not optimal (max value should be <= " + Math.max(1000L, this._fr.numRows() / 20L / (long)H2O.CLOUD.size()) + " " + Arrays.toString(MSBhist) + ")");
        }
        System.out.print("Allocating _o and _x buckets on this node with known size up front ... ");
        long t0 = System.nanoTime();
        this._o = new long[256][][];
        this._x = new byte[256][][];
        for (msb = 0; msb < 256; ++msb) {
            if (MSBhist[msb] == 0L) continue;
            int nbatch = (int)((MSBhist[msb] - 1L) / (long)this._batchSize + 1L);
            int lastSize = (int)(MSBhist[msb] - (long)((nbatch - 1) * this._batchSize));
            assert (nbatch > 0);
            assert (lastSize > 0);
            this._o[msb] = new long[nbatch][];
            this._x[msb] = new byte[nbatch][];
            for (int b = 0; b < nbatch - 1; ++b) {
                this._o[msb][b] = new long[this._batchSize];
                this._x[msb][b] = new byte[this._batchSize * this._keySize];
            }
            this._o[msb][b] = new long[lastSize];
            this._x[msb][b] = new byte[lastSize * this._keySize];
        }
        System.out.println("done in " + (double)(System.nanoTime() - t0) / 1.0E9);
        for (msb = 0; msb < 256; ++msb) {
            long rollSum = 0L;
            for (int c = 0; c < nc; ++c) {
                if (this._counts[c] == null) continue;
                long tmp = this._counts[c][msb];
                this._counts[c][msb] = rollSum;
                rollSum += tmp;
            }
        }
        MOVESHASH.put(this._linkTwoMRTask, this);
    }

    @Override
    public void map(Chunk[] chk) {
        long[] myCounts = this._counts[chk[0].cidx()];
        if (myCounts == null) {
            System.out.println("myCounts empty for chunk " + chk[0].cidx());
            return;
        }
        boolean[] isIntCols = new boolean[chk.length];
        for (int c = 0; c < chk.length; ++c) {
            isIntCols[c] = chk[c].vec().isCategorical() || chk[c].vec().isInt();
        }
        for (int r = 0; r < chk[0]._len; ++r) {
            long target;
            int MSBvalue = 0;
            BigInteger thisx = BigInteger.ZERO;
            if (!chk[0].isNA(r)) {
                if (this._isLeft && this._id_maps[0] != null) {
                    thisx = BigInteger.valueOf(this._id_maps[0][(int)chk[0].at8(r)] + 1);
                    MSBvalue = thisx.shiftRight(this._shift).intValue();
                } else {
                    thisx = isIntCols[0] ? BigInteger.valueOf((long)this._ascending[0] * chk[0].at8(r)).subtract(this._base[0]).add(BigInteger.ONE) : MathUtils.convertDouble2BigInteger((double)this._ascending[0] * chk[0].atd(r)).subtract(this._base[0]).add(BigInteger.ONE);
                    MSBvalue = thisx.shiftRight(this._shift).intValue();
                }
            }
            int n = MSBvalue;
            myCounts[n] = myCounts[n] + 1L;
            int batch = (int)(target / (long)this._batchSize);
            int offset = (int)(target % (long)this._batchSize);
            assert (this._o[MSBvalue] != null);
            this._o[MSBvalue][batch][offset] = (long)r + chk[0].start();
            byte[] this_x = this._x[MSBvalue][batch];
            offset *= this._keySize;
            byte[] keyArray = thisx.toByteArray();
            int offIndex = keyArray.length > 8 ? -1 : this._bytesUsed[0] - keyArray.length;
            int endLen = this._bytesUsed[0] - (keyArray.length > 8 ? 8 : keyArray.length);
            for (int i = this._bytesUsed[0] - 1; i >= endLen && i >= 0; --i) {
                this_x[offset + i] = keyArray[i - offIndex];
            }
            for (int c = 1; c < chk.length; ++c) {
                offset += this._bytesUsed[c - 1];
                if (chk[c].isNA(r)) continue;
                thisx = this._isLeft && this._id_maps[c] != null ? BigInteger.valueOf(this._id_maps[c][(int)chk[c].at8(r)] + 1) : (isIntCols[c] ? BigInteger.valueOf((long)this._ascending[c] * chk[c].at8(r)).subtract(this._base[c]).add(BigInteger.ONE) : MathUtils.convertDouble2BigInteger((double)this._ascending[c] * chk[c].atd(r)).subtract(this._base[c]).add(BigInteger.ONE));
                keyArray = thisx.toByteArray();
                offIndex = keyArray.length > 8 ? -1 : this._bytesUsed[c] - keyArray.length;
                endLen = this._bytesUsed[c] - (keyArray.length > 8 ? 8 : keyArray.length);
                for (int i = this._bytesUsed[c] - 1; i >= endLen && i >= 0; --i) {
                    this_x[offset + i] = keyArray[i - offIndex];
                }
            }
        }
    }

    static H2ONode ownerOfMSB(int MSBvalue) {
        return H2O.CLOUD._memary[MSBvalue % H2O.CLOUD.size()];
    }

    static Key getNodeOXbatchKey(boolean isLeft, int MSBvalue, int node, int batch) {
        return Key.make("__radix_order__NodeOXbatch_MSB" + MSBvalue + "_node" + node + "_batch" + batch + (isLeft ? "_LEFT" : "_RIGHT"), (byte)1, (byte)31, false, SplitByMSBLocal.ownerOfMSB(MSBvalue));
    }

    static Key getSortedOXbatchKey(boolean isLeft, int MSBvalue, int batch) {
        return Key.make("__radix_order__SortedOXbatch_MSB" + MSBvalue + "_batch" + batch + (isLeft ? "_LEFT" : "_RIGHT"), (byte)1, (byte)31, false, SplitByMSBLocal.ownerOfMSB(MSBvalue));
    }

    static Key getMSBNodeHeaderKey(boolean isLeft, int MSBvalue, int node) {
        return Key.make("__radix_order__OXNodeHeader_MSB" + MSBvalue + "_node" + node + (isLeft ? "_LEFT" : "_RIGHT"), (byte)1, (byte)31, false, SplitByMSBLocal.ownerOfMSB(MSBvalue));
    }

    void sendSplitMSB() {
        System.out.print("Starting SendSplitMSB on this node (keySize is " + this._keySize + " as [");
        for (int bs : this._bytesUsed) {
            System.out.print(" " + bs);
        }
        System.out.println(" ]) ...");
        long t0 = System.nanoTime();
        Futures myfs = new Futures();
        for (int msb = 0; msb < this._o.length; ++msb) {
            if (this._o[msb] == null) continue;
            myfs.add(H2O.submitTask(new SendOne(msb, myfs)));
        }
        myfs.blockForPending();
        double timeTaken = (double)(System.nanoTime() - t0) / 1.0E9;
        long bytes = this._numRowsOnThisNode * (long)(8 + this._keySize) + 64L;
        System.out.println("took : " + timeTaken);
        System.out.println("  DKV.put " + PrettyPrint.bytes(bytes) + " @ " + String.format("%.3f", (double)bytes / timeTaken / 1.073741824E9) + " GByte/sec  [10Gbit = 1.25GByte/sec]");
    }

    class SendOne
    extends H2O.H2OCountedCompleter<SendOne> {
        private final int _msb;
        private final Futures _myfs;

        SendOne(int msb, Futures myfs) {
            this._msb = msb;
            this._myfs = myfs;
        }

        @Override
        public void compute2() {
            int numChunks = 0;
            for (long[] cnts : SplitByMSBLocal.this._counts) {
                if (cnts == null) continue;
                ++numChunks;
            }
            int[] msbNodeChunkCounts = new int[numChunks];
            int j = 0;
            long lastCount = 0L;
            for (long[] cnts : SplitByMSBLocal.this._counts) {
                if (cnts == null) continue;
                if (cnts[this._msb] == 0L) {
                    msbNodeChunkCounts[j] = 0;
                } else {
                    msbNodeChunkCounts[j] = (int)(cnts[this._msb] - lastCount);
                    lastCount = cnts[this._msb];
                }
                ++j;
            }
            MSBNodeHeader msbh = new MSBNodeHeader(msbNodeChunkCounts);
            DKV.put(SplitByMSBLocal.getMSBNodeHeaderKey(SplitByMSBLocal.this._isLeft, this._msb, H2O.SELF.index()), msbh, this._myfs, true);
            for (int b = 0; b < SplitByMSBLocal.this._o[this._msb].length; ++b) {
                OXbatch ox = new OXbatch(SplitByMSBLocal.this._o[this._msb][b], SplitByMSBLocal.this._x[this._msb][b]);
                DKV.put(SplitByMSBLocal.getNodeOXbatchKey(SplitByMSBLocal.this._isLeft, this._msb, H2O.SELF.index(), b), ox, this._myfs, true);
            }
            this.tryComplete();
        }
    }

    static class MSBNodeHeader
    extends Iced {
        int[] _MSBnodeChunkCounts;

        MSBNodeHeader(int[] MSBnodeChunkCounts) {
            this._MSBnodeChunkCounts = MSBnodeChunkCounts;
        }
    }

    static class OXbatch
    extends Iced {
        final long[] _o;
        final byte[] _x;

        OXbatch(long[] o, byte[] x) {
            this._o = o;
            this._x = x;
        }
    }
}

