/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.mungers;

import java.util.ArrayList;
import java.util.Arrays;
import water.H2O;
import water.Iced;
import water.Key;
import water.MRTask;
import water.fvec.CategoricalWrappedVec;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Env;
import water.rapids.Merge;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.ast.params.AstNum;
import water.rapids.ast.params.AstNumList;
import water.rapids.vals.ValFrame;
import water.util.IcedHashMap;

public class AstMerge
extends AstPrimitive {
    static final int MAX_HASH_SIZE = 120000000;

    @Override
    public String[] args() {
        return new String[]{"left", "rite", "all_left", "all_rite", "by_left", "by_right", "method"};
    }

    @Override
    public String str() {
        return "merge";
    }

    @Override
    public int nargs() {
        return 8;
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame hashed;
        Frame l = stk.track(asts[1].exec(env)).getFrame();
        Frame r = stk.track(asts[2].exec(env)).getFrame();
        boolean allLeft = asts[3].exec(env).getNum() == 1.0;
        boolean allRite = asts[4].exec(env).getNum() == 1.0;
        int[] byLeft = this.check(asts[5]);
        int[] byRite = this.check(asts[6]);
        String method = asts[7].exec(env).getStr();
        if (byLeft.length == 0) {
            int i;
            assert (byRite.length == 0);
            ArrayList<Integer> leftTmp = new ArrayList<Integer>();
            ArrayList<Integer> riteTmp = new ArrayList<Integer>();
            for (i = 0; i < l._names.length; ++i) {
                int idx = r.find(l._names[i]);
                if (idx == -1) continue;
                leftTmp.add(i);
                riteTmp.add(idx);
            }
            if (leftTmp.size() == 0) {
                throw new IllegalArgumentException("No join columns specified and there are no common names");
            }
            byLeft = new int[leftTmp.size()];
            byRite = new int[riteTmp.size()];
            for (i = 0; i < byLeft.length; ++i) {
                byLeft[i] = (Integer)leftTmp.get(i);
                byRite[i] = (Integer)riteTmp.get(i);
            }
        }
        if (byLeft.length != byRite.length) {
            throw new IllegalArgumentException("byLeft and byRight are not the same length");
        }
        int ncols = byLeft.length;
        l.moveFirst(byLeft);
        r.moveFirst(byRite);
        for (int i = 0; i < ncols; ++i) {
            Vec lv = l.vecs()[i];
            Vec rv = r.vecs()[i];
            if (lv.get_type() != rv.get_type()) {
                throw new IllegalArgumentException("Merging columns must be the same type, column " + l._names[ncols] + " found types " + lv.get_type_str() + " and " + rv.get_type_str());
            }
            if (lv.isString()) {
                throw new IllegalArgumentException("Cannot merge Strings; flip toCategoricalVec first");
            }
            if (!lv.isString() || !method.equals("auto")) continue;
            method = "hash";
        }
        new MRTask(){

            @Override
            public void setupLocal() {
                System.gc();
            }
        }.doAllNodes();
        if (method.equals("radix") || method.equals("auto")) {
            int index;
            if (allLeft && allRite) {
                throw new IllegalArgumentException("all.x=TRUE and all.y=TRUE is not supported.  Choose one only.");
            }
            boolean onlyLeftAllOff = allLeft && !allRite || !allRite;
            int[][] id_maps = new int[ncols][];
            for (int i = 0; i < ncols; ++i) {
                Vec rv;
                Vec lv = onlyLeftAllOff ? l.vec(i) : r.vec(i);
                Vec vec = rv = onlyLeftAllOff ? r.vec(i) : l.vec(i);
                if (rv.isString()) {
                    throw new IllegalArgumentException("Your right/y frame contains String columns.  Flip toCategoricalVec first or choose the hash method instead.");
                }
                if (!(onlyLeftAllOff ? lv.isCategorical() : rv.isCategorical())) continue;
                assert (!onlyLeftAllOff ? lv.isCategorical() : rv.isCategorical());
                id_maps[i] = onlyLeftAllOff ? CategoricalWrappedVec.computeMap(lv.domain(), rv.domain()) : CategoricalWrappedVec.computeMap(rv.domain(), lv.domain());
            }
            if (onlyLeftAllOff) {
                return this.sortingMerge(l, r, allLeft, allRite, ncols, id_maps);
            }
            ValFrame tempFrame = this.sortingMerge(r, l, allRite, allLeft, ncols, id_maps);
            Frame mergedFrame = tempFrame.getFrame();
            int allColNum = mergedFrame.numCols();
            int[] colMapping = new int[allColNum];
            for (int index2 = 0; index2 < ncols; ++index2) {
                colMapping[index2] = index2;
            }
            int offset = r.numCols() - ncols;
            for (index = ncols; index < l.numCols(); ++index) {
                colMapping[index] = offset + index;
            }
            offset = l.numCols() - ncols;
            for (index = l.numCols(); index < allColNum; ++index) {
                colMapping[index] = index - offset;
            }
            mergedFrame.reOrder(colMapping);
            return tempFrame;
        }
        boolean walkLeft = allLeft == allRite ? l.numRows() > r.numRows() : allLeft;
        Frame walked = walkLeft ? l : r;
        Frame frame = hashed = walkLeft ? r : l;
        if (!walkLeft) {
            boolean tmp = allLeft;
            allLeft = allRite;
            allRite = tmp;
        }
        int[][] id_maps = new int[ncols][];
        for (int i = 0; i < ncols; ++i) {
            Vec lv = walked.vecs()[i];
            if (!lv.isCategorical()) continue;
            id_maps[i] = CategoricalWrappedVec.computeMap(hashed.vecs()[i].domain(), lv.domain());
        }
        MergeSet ms = (MergeSet)new MergeSet(ncols, id_maps, allRite).doAll(hashed);
        final Key uniq = ms._uniq;
        IcedHashMap<Row, String> rows = ((MergeSet)MergeSet.MERGE_SETS.get((Object)uniq))._rows;
        new MRTask(){

            @Override
            public void setupLocal() {
                MergeSet.MERGE_SETS.remove(uniq);
            }
        }.doAllNodes();
        if (method.equals("auto") && (rows == null || rows.size() > 120000000)) {
            return this.sortingMerge(l, r, allLeft, allRite, ncols, id_maps);
        }
        if (!(!allLeft || allRite && ms._dup)) {
            walked = walked.deepCopy(null);
            String[] names = Arrays.copyOfRange(hashed._names, ncols, hashed._names.length);
            String[][] domains = (String[][])Arrays.copyOfRange(hashed.domains(), ncols, hashed.domains().length);
            byte[] types = Arrays.copyOfRange(hashed.types(), ncols, hashed.numCols());
            Frame res = ((JoinTask)new AllLeftNoDupe(ncols, rows, hashed, allRite).doAll(types, walked)).outputFrame(names, domains);
            return new ValFrame(walked.add(res));
        }
        if (!allRite) {
            String[] names = Arrays.copyOf(walked.names(), walked.numCols() + hashed.numCols() - ncols);
            System.arraycopy(hashed.names(), ncols, names, walked.numCols(), hashed.numCols() - ncols);
            String[][] domains = (String[][])Arrays.copyOf(walked.domains(), walked.numCols() + hashed.numCols() - ncols);
            System.arraycopy(hashed.domains(), ncols, domains, walked.numCols(), hashed.numCols() - ncols);
            byte[] types = walked.types();
            types = Arrays.copyOf(types, types.length + hashed.numCols() - ncols);
            System.arraycopy(hashed.types(), ncols, types, walked.numCols(), hashed.numCols() - ncols);
            return new ValFrame(((JoinTask)new AllRiteWithDupJoin(ncols, rows, hashed, allLeft).doAll(types, walked)).outputFrame(names, domains));
        }
        throw H2O.unimpl();
    }

    private ValFrame sortingMerge(Frame left, Frame right, boolean allLeft, boolean allRite, int ncols, int[][] id_maps) {
        int[] cols = new int[ncols];
        for (int i = 0; i < ncols; ++i) {
            cols[i] = i;
        }
        return new ValFrame(Merge.merge(left, right, cols, cols, allLeft, id_maps));
    }

    private int[] check(AstRoot ast) {
        double[] n;
        if (ast instanceof AstNumList) {
            n = ((AstNumList)ast).expand();
        } else if (ast instanceof AstNum) {
            n = new double[]{((AstNum)ast).getNum()};
        } else {
            throw new IllegalArgumentException("Requires a number-list, but found a " + ast.getClass());
        }
        int[] ni = new int[n.length];
        for (int i = 0; i < ni.length; ++i) {
            ni[i] = (int)n[i];
        }
        return ni;
    }

    private static class AllRiteWithDupJoin
    extends JoinTask {
        AllRiteWithDupJoin(int ncols, IcedHashMap<Row, String> rows, Frame hashed, boolean allLeft) {
            super(ncols, rows, hashed, allLeft, true);
        }

        @Override
        public void map(Chunk[] chks, NewChunk[] nchks) {
            IcedHashMap rows = this._rows;
            Vec[] vecs = this._hashed.vecs();
            Row row = new Row(this._ncols);
            BufferedString bStr = new BufferedString();
            int len = chks[0]._len;
            for (int i = 0; i < len; ++i) {
                Row hashed = this._rows.getk(row.fill(chks, null, i));
                if (hashed == null) {
                    int c;
                    if (!this._allLeft) continue;
                    for (c = 0; c < chks.length; ++c) {
                        AllRiteWithDupJoin.addElem(nchks[c], chks[c], i);
                    }
                    while (c < nchks.length) {
                        nchks[c].addNA();
                        ++c;
                    }
                    continue;
                }
                if (hashed._dups != null) {
                    for (long absrow : hashed._dups) {
                        this.addRow(nchks, chks, vecs, i, absrow, bStr);
                    }
                    continue;
                }
                this.addRow(nchks, chks, vecs, i, hashed._row, bStr);
            }
        }

        void addRow(NewChunk[] nchks, Chunk[] chks, Vec[] vecs, int relRow, long absRow, BufferedString bStr) {
            int c;
            for (c = 0; c < chks.length; ++c) {
                AllRiteWithDupJoin.addElem(nchks[c], chks[c], relRow);
            }
            while (c < nchks.length) {
                AllRiteWithDupJoin.addElem(nchks[c], vecs[c - chks.length + this._ncols], absRow, bStr);
                ++c;
            }
        }
    }

    private static class AllLeftNoDupe
    extends JoinTask {
        AllLeftNoDupe(int ncols, IcedHashMap<Row, String> rows, Frame hashed, boolean allRite) {
            super(ncols, rows, hashed, true, allRite);
        }

        @Override
        public void map(Chunk[] chks, NewChunk[] nchks) {
            IcedHashMap rows = this._rows;
            Vec[] vecs = this._hashed.vecs();
            assert (vecs.length == this._ncols + nchks.length);
            Row row = new Row(this._ncols);
            BufferedString bStr = new BufferedString();
            int len = chks[0]._len;
            for (int i = 0; i < len; ++i) {
                Row hashed = rows.getk(row.fill(chks, null, i));
                if (hashed == null) {
                    for (NewChunk nc : nchks) {
                        nc.addNA();
                    }
                    continue;
                }
                long absrow = hashed._row;
                for (int c = 0; c < nchks.length; ++c) {
                    AllLeftNoDupe.addElem(nchks[c], vecs[this._ncols + c], absrow, bStr);
                }
            }
        }
    }

    private static abstract class JoinTask
    extends MRTask<JoinTask> {
        protected final IcedHashMap<Row, String> _rows;
        protected final int _ncols;
        protected final Frame _hashed;
        protected final boolean _allLeft;
        protected final boolean _allRite;

        JoinTask(int ncols, IcedHashMap<Row, String> rows, Frame hashed, boolean allLeft, boolean allRite) {
            this._rows = rows;
            this._ncols = ncols;
            this._hashed = hashed;
            this._allLeft = allLeft;
            this._allRite = allRite;
        }

        protected static void addElem(NewChunk nc, Chunk c, int row) {
            c.extractRows(nc, row, row + 1);
        }

        protected static void addElem(NewChunk nc, Vec v, long absRow, BufferedString bStr) {
            Chunk c = v.chunkForRow(absRow);
            int relRow = (int)(absRow - c.start());
            c.extractRows(nc, relRow, relRow + 1);
        }
    }

    private static class MergeSet
    extends MRTask<MergeSet> {
        static IcedHashMap<Key, MergeSet> MERGE_SETS = new IcedHashMap();
        final Key _uniq = Key.make();
        final int _ncols;
        final int[][] _id_maps;
        final boolean _allRite;
        boolean _dup;
        IcedHashMap<Row, String> _rows;

        MergeSet(int ncols, int[][] id_maps, boolean allRite) {
            this._ncols = ncols;
            this._id_maps = id_maps;
            this._allRite = allRite;
        }

        @Override
        public void setupLocal() {
            this._rows = new IcedHashMap();
            MERGE_SETS.put(this._uniq, this);
        }

        @Override
        public void map(Chunk[] chks) {
            IcedHashMap<Row, String> rows = ((MergeSet)MergeSet.MERGE_SETS.get((Object)this._uniq))._rows;
            if (rows == null) {
                return;
            }
            int len = chks[0]._len;
            Row row = new Row(this._ncols);
            for (int i = 0; i < len; ++i) {
                if (!this.add(rows, row.fill(chks, this._id_maps, i))) continue;
                if (rows.size() > 120000000) {
                    this.abort();
                    return;
                }
                row = new Row(this._ncols);
            }
        }

        private boolean add(IcedHashMap<Row, String> rows, Row row) {
            if (rows.putIfAbsent(row, "") == null) {
                return true;
            }
            if (this._allRite) {
                this._dup = true;
                rows.getk(row).atomicAddDup(row._row);
            }
            return false;
        }

        private void abort() {
            this._rows = null;
            ((MergeSet)MergeSet.MERGE_SETS.get((Object)this._uniq))._rows = null;
        }

        @Override
        public void reduce(MergeSet ms) {
            IcedHashMap<Row, String> rows = this._rows;
            if (rows == ms._rows) {
                return;
            }
            if (rows == null || ms._rows == null) {
                this.abort();
                return;
            }
            for (Row row : ms._rows.keySet()) {
                this.add(rows, row);
            }
        }
    }

    private static class Row
    extends Iced {
        final long[] _keys;
        int _hash;
        long _row;
        long[] _dups;
        int _dupIdx;

        Row(int ncols) {
            this._keys = new long[ncols];
        }

        Row fill(Chunk[] chks, int[][] cat_maps, int row) {
            long hash = 0L;
            for (int i = 0; i < this._keys.length; ++i) {
                long l;
                if (chks[i].isNA(row)) {
                    l = 0L;
                } else {
                    l = chks[i].at8(row);
                    l = cat_maps == null || cat_maps[i] == null ? l : (long)cat_maps[i][(int)l];
                    hash += l;
                }
                this._keys[i] = l;
            }
            this._hash = (int)(hash ^ hash >> 32);
            this._row = chks[0].start() + (long)row;
            return this;
        }

        public int hashCode() {
            return this._hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Row)) {
                return false;
            }
            Row r = (Row)o;
            return this._hash == r._hash && Arrays.equals(this._keys, r._keys);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void atomicAddDup(long row) {
            Row row2 = this;
            synchronized (row2) {
                if (this._dups == null) {
                    this._dups = new long[]{this._row, row};
                    this._dupIdx = 2;
                } else {
                    if (this._dupIdx == this._dups.length) {
                        this._dups = Arrays.copyOf(this._dups, this._dups.length << 1);
                    }
                    this._dups[this._dupIdx++] = row;
                }
            }
        }
    }
}

