/*
 * Decompiled with CFR 0.152.
 */
package water.udf;

import water.MRTask;
import water.udf.CFunc;
import water.udf.CFuncLoader;
import water.udf.CFuncLoaderService;
import water.udf.CFuncRef;
import water.udf.DkvClassLoader;

public abstract class CFuncTask<T extends CFunc, S extends CFuncTask<T, S>>
extends MRTask<S> {
    protected final CFuncRef cFuncRef;
    protected transient T func;

    public CFuncTask(CFuncRef cFuncRef) {
        this.cFuncRef = cFuncRef;
    }

    @Override
    protected void setupLocal() {
        if (this.cFuncRef != null) {
            ClassLoader localCl = this.getFuncClassLoader();
            CFuncLoader loader = CFuncLoaderService.INSTANCE.getByLang(this.cFuncRef.language);
            if (loader != null) {
                this.func = (CFunc)loader.load(this.cFuncRef.funcName, this.getFuncType(), localCl);
            }
        }
    }

    protected ClassLoader getFuncClassLoader() {
        return new DkvClassLoader(this.cFuncRef.getKey(), this.getParentClassloader());
    }

    protected ClassLoader getParentClassloader() {
        return Thread.currentThread().getContextClassLoader();
    }

    protected abstract Class<T> getFuncType();
}

