/*
 * Decompiled with CFR 0.152.
 */
package water.udf;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import water.DKV;
import water.H2O;
import water.Key;
import water.Value;
import water.persist.PersistFS;
import water.udf.CFuncRef;
import water.util.Log;

class DkvClassLoader
extends URLClassLoader {
    public DkvClassLoader(CFuncRef cFuncRef, ClassLoader parent) {
        this(cFuncRef.keyName, parent);
    }

    public DkvClassLoader(String jarKeyName, ClassLoader parent) {
        this(Key.make(jarKeyName), parent);
    }

    public DkvClassLoader(Key jarKey, ClassLoader parent) {
        super(new URL[0], parent);
        Value v = DKV.get(jarKey);
        PersistFS persistFS = (PersistFS)H2O.getPM().getIce();
        File f = persistFS.getFile(v);
        f.deleteOnExit();
        try {
            Log.debug("DkvClassLoader: saving " + v + " into " + f.getAbsolutePath());
            H2O.getPM().store(1, v);
            this.addURL(f.toURI().toURL());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

