/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.jetty.io.EofException;
import water.Key;
import water.util.StringUtils;

public class FileUtils {
    public static void close(Closeable ... closeable) {
        for (Closeable c : closeable) {
            try {
                if (c == null) continue;
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void copyStream(InputStream is, OutputStream os, int buffer_size) {
        try {
            int count;
            byte[] bytes = new byte[buffer_size];
            while (is.available() > 0 && (count = is.read(bytes, 0, buffer_size)) > 0) {
                os.write(bytes, 0, count);
            }
        }
        catch (EofException bytes) {
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static URI getURI(String path) {
        boolean windowsPath = path.matches("^[a-zA-Z]:.*$");
        if (windowsPath) {
            return new File(path).toURI();
        }
        if (path.contains(":/")) {
            return URI.create(path);
        }
        return new File(path).toURI();
    }

    public static boolean delete(File file) {
        if (file.isFile()) {
            file.delete();
        } else if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                f.delete();
            }
            return file.delete();
        }
        return false;
    }

    public static File locateFile(String fname) {
        File file = new File(fname);
        if (!file.exists()) {
            file = new File("target/" + fname);
        }
        if (!file.exists()) {
            file = new File("../" + fname);
        }
        if (!file.exists()) {
            file = new File("../../" + fname);
        }
        if (!file.exists()) {
            file = new File("../target/" + fname);
        }
        if (!file.exists()) {
            file = new File(StringUtils.expandPath(fname));
        }
        if (!file.exists()) {
            file = null;
        }
        return file;
    }

    private static void check(boolean cond, String msg) throws IOException {
        if (!cond) {
            throw new IOException(msg);
        }
    }

    private static void checkFileEntry(String name, File file) throws IOException {
        FileUtils.check(file != null, "File not found: " + name);
        FileUtils.check(file.exists(), "File should exist: " + name);
    }

    public static void checkFile(File file, String name) throws IOException {
        FileUtils.checkFileEntry(name, file);
        FileUtils.check(file.isFile(), "Expected a file: " + name);
        FileUtils.check(file.canRead(), "Expected a readable file: " + name);
    }

    public static File getFile(String fname) throws IOException {
        File f = FileUtils.locateFile(fname);
        FileUtils.checkFile(f, fname);
        return f;
    }

    public static File[] contentsOf(File folder, String name) throws IOException {
        FileUtils.checkFileEntry(name, folder);
        if (!folder.isDirectory()) {
            throw new IOException("Expected a folder: " + name);
        }
        File[] files = folder.listFiles();
        if (files == null) {
            throw new IOException("Cannot read folder: " + folder);
        }
        return files;
    }

    public static String keyToFileName(Key k) {
        return k.toString().replaceAll("[^a-zA-Z0-9_\\-\\.]", "_");
    }
}

