/*
 * Decompiled with CFR 0.152.
 */
package water.util.fp;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import water.util.Java7;
import water.util.fp.Function;
import water.util.fp.Unfoldable;

public class Functions {
    public static <X, Y, Z> Function<X, Z> compose(Function<Y, Z> g, Function<X, Y> f) {
        return new Composition<X, Y, Z>(f, g);
    }

    public static <X> Function<X, X> identity() {
        return new Function<X, X>(){

            @Override
            public X apply(X x) {
                return x;
            }
        };
    }

    public static <T> Function<Long, T> onList(final List<T> list) {
        return new Function<Long, T>(){

            @Override
            public T apply(Long i) {
                return list.get(i.intValue());
            }
        };
    }

    public static <X, Y> Iterable<Y> map(Iterable<X> xs, Function<X, Y> f) {
        LinkedList<Y> ys = new LinkedList<Y>();
        for (X x : xs) {
            ys.add(f.apply(x));
        }
        return ys;
    }

    public static <X, Y> Function<X, Y> constant(final Y y) {
        return new Function<X, Y>(){

            @Override
            public Y apply(X x) {
                return y;
            }
        };
    }

    public static Unfoldable<String, String> splitBy(String separator) {
        return new StringSplitter(separator);
    }

    public static double integrate(Function<Integer, Double> x, Function<Integer, Double> y, int from, int to) {
        double s = 0.0;
        double x0 = x.apply(from);
        double y0 = y.apply(from);
        for (int i = from + 1; i <= to; ++i) {
            double x1 = x.apply(i);
            double y1 = y.apply(i);
            s += (y1 + y0) * (x1 - x0) * 0.5;
            x0 = x1;
            y0 = y1;
        }
        return s;
    }

    static class StringSplitter
    implements Unfoldable<String, String> {
        private final String separator;

        StringSplitter(String separator) {
            this.separator = separator;
        }

        @Override
        public List<String> apply(String s) {
            return Arrays.asList(s.split(this.separator));
        }

        public int hashCode() {
            return 211 + this.separator.hashCode() * 7;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StringSplitter)) {
                return false;
            }
            StringSplitter other = (StringSplitter)obj;
            return Java7.Objects.equals(this.separator, other.separator);
        }
    }

    static class Composition<X, Y, Z>
    implements Function<X, Z> {
        private final Function<X, Y> f;
        private final Function<Y, Z> g;

        Composition(Function<X, Y> f, Function<Y, Z> g) {
            this.f = f;
            this.g = g;
        }

        public int hashCode() {
            return this.f.hashCode() * 211 + this.g.hashCode() * 79;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Composition)) {
                return false;
            }
            Composition other = (Composition)obj;
            return Java7.Objects.equals(this.f, other.f) && Java7.Objects.equals(this.g, other.g);
        }

        @Override
        public Z apply(X x) {
            return this.g.apply(this.f.apply(x));
        }
    }
}

