/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.io.IOException;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.jaas.JAASLoginService;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.FormAuthenticator;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.session.HashSessionIdManager;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import water.DelegatingAuthenticator;
import water.H2O;
import water.util.Log;

public abstract class AbstractHTTPD {
    private final H2O.BaseArgs _args;
    protected String _ip;
    protected int _port;
    protected Server _server;

    protected AbstractHTTPD(H2O.BaseArgs args) {
        this._args = args;
    }

    public String getScheme() {
        if (this._args.jks != null) {
            return "https";
        }
        return "http";
    }

    public int getPort() {
        return this._port;
    }

    public String getIp() {
        return this._ip;
    }

    public Server getServer() {
        return this._server;
    }

    public void setServer(Server value) {
        this._server = value;
    }

    public void setup(String ip, int port) {
        this._ip = ip;
        this._port = port;
        System.setProperty("org.eclipse.jetty.server.Request.maxFormContentSize", Integer.toString(Integer.MAX_VALUE));
    }

    public void start(String ip, int port) throws Exception {
        this.setup(ip, port);
        if (this._args.jks != null) {
            this.startHttps();
        } else {
            this.startHttp();
        }
    }

    protected void createServer(Connector connector) throws Exception {
        this._server.setConnectors(new Connector[]{connector});
        if (this._args.hash_login || this._args.ldap_login || this._args.kerberos_login || this._args.pam_login) {
            Object authenticator;
            HashLoginService loginService;
            if (this._args.login_conf == null) {
                Log.err("Must specify -login_conf argument");
                H2O.exit(1);
            }
            if (this._args.hash_login) {
                Log.info("Configuring HashLoginService");
                loginService = new HashLoginService("H2O", this._args.login_conf);
            } else if (this._args.ldap_login) {
                Log.info("Configuring JAASLoginService (with LDAP)");
                System.setProperty("java.security.auth.login.config", this._args.login_conf);
                loginService = new JAASLoginService("ldaploginmodule");
            } else if (this._args.kerberos_login) {
                Log.info("Configuring JAASLoginService (with Kerberos)");
                System.setProperty("java.security.auth.login.config", this._args.login_conf);
                loginService = new JAASLoginService("krb5loginmodule");
            } else if (this._args.pam_login) {
                Log.info("Configuring JAASLoginService (with PAM)");
                System.setProperty("java.security.auth.login.config", this._args.login_conf);
                loginService = new JAASLoginService("pamloginmodule");
            } else {
                throw this.failEx("Unexpected authentication method selected");
            }
            DefaultIdentityService identityService = new DefaultIdentityService();
            loginService.setIdentityService((IdentityService)identityService);
            this._server.addBean((Object)loginService);
            ConstraintSecurityHandler security = new ConstraintSecurityHandler();
            Constraint constraint = new Constraint();
            constraint.setName("auth");
            constraint.setAuthenticate(true);
            constraint.setRoles(new String[]{"**"});
            ConstraintMapping mapping = new ConstraintMapping();
            mapping.setPathSpec("/*");
            mapping.setConstraint(constraint);
            security.setConstraintMappings(Collections.singletonList(mapping));
            if (this._args.form_auth) {
                BasicAuthenticator basicAuthenticator = new BasicAuthenticator();
                FormAuthenticator formAuthenticator = new FormAuthenticator("/login", "/loginError", false);
                authenticator = new DelegatingAuthenticator(basicAuthenticator, formAuthenticator);
            } else {
                authenticator = new BasicAuthenticator();
            }
            security.setLoginService((LoginService)loginService);
            security.setAuthenticator((Authenticator)authenticator);
            HashSessionIdManager idManager = new HashSessionIdManager();
            this._server.setSessionIdManager((SessionIdManager)idManager);
            HashSessionManager manager = new HashSessionManager();
            if (this._args.session_timeout > 0) {
                manager.setMaxInactiveInterval(this._args.session_timeout * 60);
            }
            SessionHandler sessionHandler = new SessionHandler((SessionManager)manager);
            sessionHandler.setHandler((Handler)security);
            this.registerHandlers((HandlerWrapper)security);
            this._server.setHandler((Handler)sessionHandler);
        } else {
            this.registerHandlers((HandlerWrapper)this._server);
        }
        this._server.start();
    }

    protected abstract RuntimeException failEx(String var1);

    protected void startHttp() throws Exception {
        this._server = new Server();
        HttpConfiguration http_config = new HttpConfiguration();
        ServerConnector httpConnector = new ServerConnector(this._server, new ConnectionFactory[]{new HttpConnectionFactory(http_config)});
        httpConnector.setHost(this._ip);
        httpConnector.setPort(this._port);
        this.createServer((Connector)httpConnector);
    }

    private void startHttps() throws Exception {
        this._server = new Server();
        SslContextFactory sslContextFactory = new SslContextFactory(this._args.jks);
        sslContextFactory.setKeyStorePassword(this._args.jks_pass);
        ServerConnector httpsConnector = new ServerConnector(this._server, sslContextFactory);
        if (this.getIp() != null) {
            httpsConnector.setHost(this.getIp());
        }
        httpsConnector.setPort(this.getPort());
        this.createServer((Connector)httpsConnector);
    }

    public void stop() throws Exception {
        if (this._server != null) {
            this._server.stop();
        }
    }

    public void registerHandlers(HandlerWrapper handlerWrapper) {
        ServletContextHandler context = new ServletContextHandler(0);
        if (null != this._args.context_path && !this._args.context_path.isEmpty()) {
            context.setContextPath(this._args.context_path);
        } else {
            context.setContextPath("/");
        }
        this.registerHandlers(handlerWrapper, context);
    }

    protected abstract void registerHandlers(HandlerWrapper var1, ServletContextHandler var2);

    protected void sendUnauthorizedResponse(HttpServletResponse response, String message) throws IOException {
        response.sendError(401, message);
    }

    public class AuthenticationHandler
    extends AbstractHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            if (!(((AbstractHTTPD)AbstractHTTPD.this)._args.ldap_login || ((AbstractHTTPD)AbstractHTTPD.this)._args.kerberos_login || ((AbstractHTTPD)AbstractHTTPD.this)._args.pam_login)) {
                return;
            }
            String loginName = request.getUserPrincipal().getName();
            if (!loginName.equals(((AbstractHTTPD)AbstractHTTPD.this)._args.user_name)) {
                Log.warn("Login name (" + loginName + ") does not match cluster owner name (" + ((AbstractHTTPD)AbstractHTTPD.this)._args.user_name + ")");
                AbstractHTTPD.this.sendUnauthorizedResponse(response, "Login name does not match cluster owner name");
                baseRequest.setHandled(true);
            }
        }
    }
}

