/*
 * Decompiled with CFR 0.152.
 */
package water.network;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.Properties;
import water.util.Log;

public class SecurityUtils {
    private static SecureRandom RANDOM = new SecureRandom();
    private static final String AB = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String[] keyToolCandidates = new String[]{"sun.security.tools.KeyTool", "sun.security.tools.keytool.Main", "com.ibm.crypto.tools.KeyTool"};

    private static StoreCredentials generateKeystore(String password, String location) throws Exception {
        return SecurityUtils.generateKeystore(password, "h2o-internal.jks", location);
    }

    private static StoreCredentials generateKeystore(String password) throws Exception {
        return SecurityUtils.generateKeystore(password, "h2o-internal.jks", "");
    }

    private static StoreCredentials generateKeystore(String password, String name, String location) throws Exception {
        String path;
        String string = path = null != location && !location.isEmpty() ? location + File.separatorChar + name : name;
        if (new File(path).exists()) {
            throw new IllegalStateException("A file under the location " + path + " already exists. Please delete it first.");
        }
        String[] genKeyArgs = new String[]{"-genkeypair", "-alias", "h2o-internal", "-keyalg", "RSA", "-sigalg", "SHA256withRSA", "-dname", "CN=Java", "-storetype", "JKS", "-keypass", password, "-keystore", path, "-storepass", password, "-validity", "3650"};
        Class<?> keytool = SecurityUtils.getKeyToolClass();
        keytool.getMethod("main", String[].class).invoke(null, new Object[]{genKeyArgs});
        new File(path).deleteOnExit();
        return new StoreCredentials(name, location, password);
    }

    private static Class<?> getKeyToolClass() {
        for (String keyToolCandidate : keyToolCandidates) {
            try {
                return Class.forName(keyToolCandidate);
            }
            catch (Exception exception) {
            }
        }
        String errorMsg = "This version of Java is not supported. Please use Oracle/OpenJDK/IBM JDK version 6/7/8.";
        Log.err(errorMsg);
        throw new IllegalStateException(errorMsg);
    }

    public static SSLCredentials generateSSLPair(String passwd, String name, String location) throws Exception {
        StoreCredentials jks = SecurityUtils.generateKeystore(passwd, name, location);
        return new SSLCredentials(jks, jks);
    }

    public static SSLCredentials generateSSLPair() throws Exception {
        Path temp = Files.createTempDirectory("h2o-internal-jks-" + Long.toString(System.nanoTime()), new FileAttribute[0]);
        temp.toFile().deleteOnExit();
        StoreCredentials jks = SecurityUtils.generateKeystore(SecurityUtils.passwordGenerator(16), temp.toAbsolutePath().toString());
        return new SSLCredentials(jks, jks);
    }

    public static String passwordGenerator(int len) {
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append(AB.charAt(RANDOM.nextInt(AB.length())));
        }
        return sb.toString();
    }

    public static String generateSSLConfig(SSLCredentials credentials) throws IOException {
        File temp = File.createTempFile("h2o-internal-" + Long.toString(System.nanoTime()), "-ssl.properties");
        temp.deleteOnExit();
        return SecurityUtils.generateSSLConfig(credentials, temp.getAbsolutePath());
    }

    public static String generateSSLConfig(SSLCredentials credentials, String file) throws IOException {
        Properties sslConfig = new Properties();
        sslConfig.put("h2o_ssl_protocol", SecurityUtils.defaultTLSVersion());
        sslConfig.put("h2o_ssl_jks_internal", credentials.jks.getLocation());
        sslConfig.put("h2o_ssl_jks_password", credentials.jks.pass);
        sslConfig.put("h2o_ssl_jts", credentials.jts.getLocation());
        sslConfig.put("h2o_ssl_jts_password", credentials.jts.pass);
        FileOutputStream output = new FileOutputStream(file);
        sslConfig.store(output, "");
        return file;
    }

    public static String defaultTLSVersion() {
        return System.getProperty("java.version", "NA").startsWith("1.6") ? "TLSv1" : "TLSv1.2";
    }

    public static class SSLCredentials {
        public StoreCredentials jks;
        public StoreCredentials jts;

        SSLCredentials(StoreCredentials jks, StoreCredentials jts) {
            this.jks = jks;
            this.jts = jts;
        }
    }

    public static class StoreCredentials {
        public String name = null;
        public String path = null;
        public String pass = null;

        StoreCredentials(String name, String path, String pass) {
            this.name = name;
            this.path = path;
            this.pass = pass;
        }

        public String getLocation() {
            return null != this.path && !this.path.isEmpty() ? this.path + File.separatorChar + this.name : this.name;
        }
    }
}

