/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.transforms;

import water.Iced;
import water.fvec.Frame;
import water.rapids.Rapids;
import water.rapids.ast.AstExec;
import water.rapids.ast.AstParameter;
import water.util.IcedHashMap;
import water.util.SB;

public abstract class Transform<T>
extends Iced {
    protected final String _name;
    protected final AstExec _ast;
    protected final boolean _inplace;
    protected final String[] _newNames;
    protected final IcedHashMap<String, AstParameter> _params;
    protected String[] _inNames;
    protected String[] _inTypes;
    protected String[] _outTypes;
    protected String[] _outNames;

    Transform(String name, String ast, boolean inplace, String[] newNames) {
        this._name = name;
        this._ast = (AstExec)Rapids.parse(ast);
        this._inplace = inplace;
        this._newNames = newNames;
        this._params = new IcedHashMap();
    }

    public String name() {
        return this._name;
    }

    protected abstract Transform<T> fit(Frame var1);

    public Frame transform(Frame f) {
        this._inNames = f.names();
        this._inTypes = f.typesStr();
        Frame ff = this.transformImpl(f);
        this._outTypes = ff.typesStr();
        this._outNames = ff.names();
        return ff;
    }

    protected abstract Frame transformImpl(Frame var1);

    abstract Frame inverseTransform(Frame var1);

    public Frame fitTransform(Frame f) {
        return this.fit(f).transform(f);
    }

    public abstract String genClassImpl();

    public StringBuilder genClass() {
        String stepName = this.name();
        StringBuilder sb = new StringBuilder();
        sb.append("  class " + stepName + " extends Step<" + stepName + "> {\n");
        sb.append("    public " + stepName + "() { super(new String[]{" + Transform.toJavaString(this._inNames) + "},\n");
        sb.append("                                new String[]{" + Transform.toJavaString(this._inTypes) + "}," + "                                new String[]{" + Transform.toJavaString(this._outNames) + "});\n");
        for (String k : this._params.keySet()) {
            String v = ((AstParameter)this._params.get(k)).toJavaString();
            sb.append("    _params.put(\"" + k + "\", new String[]{" + v.replace("\\", "\\\\") + "});\n");
        }
        sb.append("  }\n");
        return sb.append(this.genClassImpl()).append("  }\n");
    }

    private static String toJavaString(String[] strs) {
        if (strs == null || strs.length == 0) {
            return "\"null\"";
        }
        SB sb = new SB();
        for (int i = 0; i < strs.length; ++i) {
            sb.p("\"").p(strs[i]).p("\"");
            if (i == strs.length - 1) {
                return sb.toString();
            }
            sb.p(',');
        }
        throw new RuntimeException("Should never be here");
    }

    protected static String toJavaPrimitive(String vecType) {
        if (vecType.equals("String") || vecType.equals("Enum")) {
            return "String";
        }
        return "double";
    }
}

