/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import water.H2O;
import water.util.ArrayUtils;

public class RandomUtils {
    private static RNGType _rngType = RNGType.PCGRNG;

    public static Random getRNG(long ... seed) {
        switch (_rngType) {
            case JavaRNG: {
                return new H2ORandomRNG(seed[0]);
            }
            case XorShiftRNG: {
                return new XorShiftRNG(seed[0]);
            }
            case PCGRNG: {
                return new PCGRNG(seed[0], seed.length > 1 ? seed[1] : 1L);
            }
            case MersenneTwisterRNG: {
                return new MersenneTwisterRNG(ArrayUtils.unpackInts(seed));
            }
        }
        throw H2O.fail();
    }

    public static class MersenneTwisterRNG
    extends Random {
        private static final int N = 624;
        private static final int M = 397;
        private static final int[] MAG01 = new int[]{0, -1727483681};
        private static final int UPPER_MASK = Integer.MIN_VALUE;
        private static final int LOWER_MASK = Integer.MAX_VALUE;
        private static final int BOOTSTRAP_SEED = 19650218;
        private static final int BOOTSTRAP_FACTOR = 1812433253;
        private static final int SEED_FACTOR1 = 1664525;
        private static final int SEED_FACTOR2 = 1566083941;
        private static final int GENERATE_MASK1 = -1658038656;
        private static final int GENERATE_MASK2 = -272236544;
        private final ReentrantLock lock = new ReentrantLock();
        private final int[] mt = new int[624];
        private int mtIndex = 0;
        public static final int[] SEEDS = new int[]{0, 0, -1970775256, -882799044, 1746075256, -896751760, -224288771, -1232986454, -772132153, -958665115, -648852609, -1461230170, 765708388, -1247316374, 734520945, -133860912, -1491646636, -215790110, 1316798592, 289460354, 1605211051, -1932633185, 410142298, 1799548115, 747411027, 1161441007, -867137480, 1518706913, 997852649, 717266173, -2002102074, -647492477, 102502793, -976326879, 181401117, 1062539095, -52276274, 1928567892, 393380635, 2137080127, 1500631830, 942698270, -468701492, -431026235, 1002945126, 1939797300, 326732078, -1889499304, 1210640741, -190022758, -1461867613, 1358475723, -20907568, -2077935641, 1583493567, -281353328, 1108315962, -287476276, -473890173, 1547226070, 1714195345, 752191957, -494591321, -637294668, -1298630692, 1168181755, -1715273186, 183584353, -396530066, -1112894821, -1811020483, -2044822147, 1940809535, -2070821792, -1071913308, 115376524, 338654105, -938841535, 1163920979, 470095573, -755038572, -1312067011, 1945327072, 124565050, 2109151503, 904530816, -1552980885, -1175717329, 944014235, 1490553369, 524126022, 580628782, 180585581, -755747051, 78310214, -1396148685, 2111156840, -1170845188, -681049626, -1639891994, -1290047035, 1607689297, 1078027822, -1903736709, 51536150, 1702147927, 1998049344, 487966595, 2048294556, -1907439712, 1956365285, -97607247, 635382916, -102257127, -529442438, 1793129255, 305663849, -160242641, 1411774198, -311552329, 917672569, 617339131, 1298669577, 236392812, 272796523, -463211149, 744487120, 285389112, -985362308, -817875196, 627429612, 1742934300, -989235662, -481272531, -1331490234, 1439432627, -222928181, -1806981297, -162918090, 1734511349, 491006488, 835241940, 1686794267, 1446588612, 686608661, -1722171841, -1694854259, 205583745, -1899544718, 551286945, 741122101, -1205911220, -65617572, -331849439, 1104723258, 1625995726, -1622472387, 1457896316, 224447827, 842572805, -1587958905, -623202605, -932489393, -1630292696, 825747223, 41947900, -2072515961, 1685573783, 112648852, 500341838, 1551051040, -949961492, 1564517018, -981338236, 330590814, -160031065, 458156227, 372757872, 201348762, -803423906, -2026619262, 387518028, 896563363, 995697772, -552487449, 1754733690, -868398722, 560305447, 740367266, -213212690, 1242035838, 2061560525, -530850683, -31242329, -339427777, 520302660, -2099075986, 1975938889, 1455754014, -1039202748, 2039398417, -1631974271, 266554992, 671488639, 643001038, 1698801992, 811524094, 636133545, -278602891, -504047820, -495050018, 996713651, -1994927969, 1076854425, -374086681, -1701452037, 1118138972, 14283400, -1635173287, 930209645, -1078750413, -1875247849, 1029129737, -1197192252, -517000019, 2132171372, -1911296973, -1462159938, 11274712, 1073739899, -627786123, -1961360171, -777239807, -1028386787, -1193613456, 811785200, -975241843, -1483611478, 1737439524, -330391227, 1165787829, 1721286204, -69955265, -11358867, 1422390893, 2104412025, -1662397991, 944624107, -1263217307, -1519164024, 867074738, 85074352, 296253279, -756198678, -543576053, -1606264294, -692901221, -99212974, 1307152123, -1328196290, -576884167, 96370829, 1133473652, -550962105, -1224943763, 1480023073, 445180646, 484531369, 1177567520, -1029125650, -1561661330, -179787924, -762791584, -333677387, 1851388297, 874820843, 1376919771, -1657833091, -2057185664, 1676519459, 2134928216, 823148805, 440761793, 982830788, -312859465, -1592301918, -271576607, 276852305, 1427720015, 147957359, -935672812, -103099147, -94063511, 1824511651, -1293449266, 1676357518, -523015543, -499974513, -791511023, -778523863, 509256996, 95303469, 827308027, 2116435424, 1642648121, 796321206, -1356138456, 1095147865, 908508367, 814383853, 508897187, -448755315, -1293335330, 16779261, -1430568756, -1592132245, -271964760, -784818906, 364272203, -248368816, 932771841, -176654474, -855203946, -1847983849, -1241257308, -1335356834, 878843605, -888475495, -1384042021, 475849010, 973687690, 1758596671, 1868738745, 1529718953, 290655130, 1546913288, -1692155431, -243925830, 1895685470, -1672130876, -66276091, 1380555135, -1003547361, -291549073, -1884107481, -1214653621, 1281101547, 925336195, -2122075294, -1836364601, 1820939090, -1693810064, -976514086, -131691983, 167582454, -1133606404, 1516326584, -447016120, -1725273618, 1437663159, 1320541026, 1558093419, -1382344595, -1526698173, -936629121, -2110806177, -1549481210, 1829105114, 1542942647, -2073406216, -897784004, 1136765137, 457996711, -2050267449, -985549651, 132553233, -5119228, -444206541, 1348957093, -944920004, -108998458, -1546059483, -70368718, -26219121, -511753350, 700731924, -1595273146, -1071253721, -2113797430, 1431260790, 1401489772, 2102976150, -484272712, 1755013054, -537940751, -721761424, 217280574, 2029961477, 1471495700, 1421660911, 861883661, 1481976878, -162663934, 240924005, -1530191163, -652439103, 2015869759, 934565603, -2070607202, 658431191, -576037187, -1309382571, -536532192, -810532734, -1538661221, -40508900, -1443596352, -1393508843, 1629298396, -1277386390, 2015296410, 1686159510, 1314148969, -1132238510, -720259783, -547206988, -1879582111, 123080813, -1829746153, -295395709, 350443392, 1841784853, 266351291, 534144098, 256633232, 371705432, -1184919507, -1493572375, -1212569066, 1779053013, 1685137894, 119507383, -469549911, -669302951, 1962453127, -1001666432, -238890932, -102611255, 1386191941, 349381351, -1942813263, -1915115128, -1970095997, 1196904115, 2069330420, 1973046966, -923964911, 1118101742, -195020003, 2030932262, -1570700466, -1806264552, 1599588499, -1581102998, 1730634127, -810039885, -1530727886, 867557457, -1630092592, 385084471, 1551668922, 974526559, 907897879, -1585872757, -1233841615, -934779095, -2025862997, -403207560, 802359611, 1218379401, -2090693423, 1739431850, 1648147503, 1057089732, -38976193, 751810921, 1563047942, -1640105862, 74449237, -1417979921, 640513131, 1937417187, -1801686452, -1542321095, -1328088026, -165174765, -1063207840, 618026570, 886333661, 2019231318, -1820920155, 636218971, 1510625304, -2066732287, -1565301366, -1391649586, 942085763, -1622600315, -1952284089, 1087743022, 2004936750, 1108462787, -1713764284, -1201695628, -1112450890, -132559759, 1664742380, 1289121015, -1237931441, 1080608108, -468680543, 1433665907, -1785712075, -1863082135, 1058055394, 831694747, 93366596, -922383281, 1862641899, -617452269, -51397394, -1499866363, -669395849, 1628405330, -99988790, 241909533, 2056102544, 1829939695, -1591328043, -337715969, 392091942, -1600899526, -1281327568, 888835372, -1139349946, 1047390541, -718764204, 542003843, -971962634, 697841120, -531727816, 774643252, -1066800512, 1545672655, -654563001, 279186889, -1274172199, -69547925, 713262027, 1188588993, 169818456, 259938794, 1544593688, -367804472, -936637019, 1288965591, -626663447, -1943224157, -1916708252, 605754892, -1001433285, 1051923807, 676045820, 516853172, 65728639, 2092800507, 2100378437, -404061273, 1832099168, 250610379, -1834988736, 1359837628, 1681973328, 865166742, -1591976461, -1249729570, 51380673, -2053828072, -1101821222, -475086382, 2142664758, -1025922172, -1316742439, 509922399, -1543630563, -796797253, -122786757, 991080012, -1683625128, 580066072, -107270559, 1653543506, 802069152, -107346693, 559381794, -1656271743, 1934681418, -125007162, -1795979181, 191050750, -2005597090, -1866320247, 1795728203, 1068974826, -1465301398, -716996483, -1089281426, 270605349, 109597409, -237440971, 19552130, -397623457, -298473350, -1946538231};

        public MersenneTwisterRNG(int ... seedInts) {
            int k;
            this.mt[0] = 19650218;
            this.mtIndex = 1;
            while (this.mtIndex < 624) {
                this.mt[this.mtIndex] = 1812433253 * (this.mt[this.mtIndex - 1] ^ this.mt[this.mtIndex - 1] >>> 30) + this.mtIndex;
                ++this.mtIndex;
            }
            int i = 1;
            int j = 0;
            for (k = Math.max(624, SEEDS.length); k > 0; --k) {
                int jseeds = j == 0 || j == 1 ? seedInts[j] : SEEDS[j];
                this.mt[i] = (this.mt[i] ^ (this.mt[i - 1] ^ this.mt[i - 1] >>> 30) * 1664525) + jseeds + j;
                ++j;
                if (++i >= 624) {
                    this.mt[0] = this.mt[623];
                    i = 1;
                }
                if (j < SEEDS.length) continue;
                j = 0;
            }
            for (k = 623; k > 0; --k) {
                this.mt[i] = (this.mt[i] ^ (this.mt[i - 1] ^ this.mt[i - 1] >>> 30) * 1566083941) - i;
                if (++i < 624) continue;
                this.mt[0] = this.mt[623];
                i = 1;
            }
            this.mt[0] = Integer.MIN_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final int next(int bits) {
            int y;
            try {
                this.lock.lock();
                if (this.mtIndex >= 624) {
                    int kk;
                    for (kk = 0; kk < 227; ++kk) {
                        y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                        this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ MAG01[y & 1];
                    }
                    while (kk < 623) {
                        y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                        this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ MAG01[y & 1];
                        ++kk;
                    }
                    y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
                    this.mt[623] = this.mt[396] ^ y >>> 1 ^ MAG01[y & 1];
                    this.mtIndex = 0;
                }
                y = this.mt[this.mtIndex++];
            }
            finally {
                this.lock.unlock();
            }
            y ^= y >>> 11;
            y ^= y << 7 & 0x9D2C5680;
            y ^= y << 15 & 0xEFC60000;
            y ^= y >>> 18;
            return y >>> 32 - bits;
        }
    }

    public static class XorShiftRNG
    extends Random {
        private AtomicLong _seed;

        public XorShiftRNG(long seed) {
            this._seed = new AtomicLong(seed);
        }

        @Override
        public long nextLong() {
            long nextseed;
            long oldseed;
            AtomicLong seed = this._seed;
            while (!seed.compareAndSet(oldseed = seed.get(), nextseed = this.xorShift(oldseed))) {
            }
            return nextseed;
        }

        @Override
        public int nextInt() {
            return this.nextInt(Integer.MAX_VALUE);
        }

        @Override
        public int nextInt(int n) {
            int r = (int)(this.nextLong() % (long)n);
            return r > 0 ? r : -r;
        }

        @Override
        protected int next(int bits) {
            long nextseed = this.nextLong();
            return (int)(nextseed & (1L << bits) - 1L);
        }

        private long xorShift(long x) {
            x ^= x << 21;
            x ^= x >>> 35;
            x ^= x << 4;
            return x;
        }
    }

    public static class H2ORandomRNG
    extends Random {
        public H2ORandomRNG(long seed) {
            if (seed >>> 32 < 65535L) {
                seed |= 0x5B93000000000000L;
            }
            if (seed << 32 >>> 32 < 65535L) {
                seed |= 0xDB910000L;
            }
            this.setSeed(seed);
        }
    }

    public static class PCGRNG
    extends Random {
        private long _state;
        private long _inc;

        public PCGRNG(long seed, long seq) {
            super(0L);
            assert (this._state == 0L);
            this._inc = seq << 1 | 1L;
            this.nextInt();
            this._state += seed;
            this.nextInt();
        }

        @Override
        public synchronized void setSeed(long seed) {
            this._state = 0L;
            this.nextInt();
            this._state += seed;
            this.nextInt();
        }

        @Override
        public int nextInt() {
            long oldstate = this._state;
            this._state = oldstate * 6364136223846793005L + this._inc;
            int xorshifted = (int)((oldstate >>> 18 ^ oldstate) >>> 27);
            int rot = (int)(oldstate >>> 59);
            return xorshifted >>> rot | xorshifted << (-rot & 0x1F);
        }

        @Override
        public long nextLong() {
            return (long)this.nextInt() << 32 | (long)this.nextInt() & 0xFFFFFFFFL;
        }

        @Override
        protected int next(int bits) {
            long nextseed = this.nextLong();
            return (int)(nextseed & (1L << bits) - 1L);
        }

        @Override
        public int nextInt(int bound) {
            long r;
            long threshold = -((long)bound) % (long)bound & 0xFFFFFFFFL;
            while ((r = (long)this.nextInt() & 0xFFFFFFFFL) < threshold) {
            }
            return (int)(r % (long)bound);
        }
    }

    public static enum RNGType {
        PCGRNG,
        MersenneTwisterRNG,
        JavaRNG,
        XorShiftRNG;

    }
}

