/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import water.DKV;
import water.JettyHTTPD;
import water.Key;
import water.Value;

public class PutKeyServlet
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        String uri = JettyHTTPD.getDecodedUri(request);
        try {
            String destKey = this.paramDestinationKey(request, response);
            Boolean overwrite = this.paramOverwrite(request, response, true);
            if (!this.validate(destKey, overwrite, response)) {
                return;
            }
            InputStream is = JettyHTTPD.extractPartInputStream(request, response);
            if (is == null) {
                return;
            }
            Key key = Key.make(destKey);
            int bytesStored = -1;
            if (DKV.get(key) == null || overwrite.booleanValue()) {
                byte[] ba = IOUtils.toByteArray((InputStream)is);
                DKV.put(key, new Value(key, ba));
                bytesStored = ba.length;
            }
            String responsePayload = "{ \"destination_key\": \"" + destKey + "\", " + "\"total_bytes\": " + bytesStored + " " + "}\n";
            response.setContentType("application/json");
            response.getWriter().write(responsePayload);
        }
        catch (Exception e) {
            JettyHTTPD.sendErrorResponse(response, e, uri);
        }
        finally {
            JettyHTTPD.logRequest("POST", request, response);
        }
    }

    private String paramDestinationKey(HttpServletRequest request, HttpServletResponse response) {
        String keyName = request.getParameter("destination_key");
        return keyName != null ? keyName : "func_" + Key.rand();
    }

    private Boolean paramOverwrite(HttpServletRequest request, HttpServletResponse response, boolean defaultValue) {
        String val = request.getParameter("overwrite");
        return val != null ? Boolean.valueOf(val) : defaultValue;
    }

    private boolean validate(String destKey, Boolean overwrite, HttpServletResponse response) throws IOException {
        if (destKey == null) {
            JettyHTTPD.sendResponseError(response, 400, "The field 'destination_frame` is compulsory!");
            return false;
        }
        return true;
    }
}

