/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.Model;
import hex.genmodel.utils.DistributionFamily;
import water.H2O;
import water.Iced;

public class Distribution
extends Iced<Distribution> {
    public static double MIN_LOG = -19.0;
    public static double MAX = 1.0E19;
    public final DistributionFamily distribution;
    public final double tweediePower;
    public final double quantileAlpha;
    public double huberDelta;

    public Distribution(DistributionFamily family) {
        this.distribution = family;
        assert (family != DistributionFamily.tweedie);
        assert (family != DistributionFamily.quantile);
        assert (family != DistributionFamily.huber);
        this.tweediePower = 1.5;
        this.quantileAlpha = 0.5;
        this.huberDelta = Double.NaN;
    }

    public Distribution(Model.Parameters params) {
        this.distribution = params._distribution;
        this.tweediePower = params._tweedie_power;
        this.quantileAlpha = params._quantile_alpha;
        this.huberDelta = 1.0;
        assert (this.tweediePower > 1.0 && this.tweediePower < 2.0);
    }

    public void setHuberDelta(double huberDelta) {
        this.huberDelta = huberDelta;
    }

    public static double exp(double x) {
        double val = Math.min(MAX, Math.exp(x));
        return val;
    }

    public static double log(double x) {
        double val = (x = Math.max(0.0, x)) == 0.0 ? MIN_LOG : Math.max(MIN_LOG, Math.log(x));
        return val;
    }

    public static String expString(String x) {
        return "Math.min(" + MAX + ", Math.exp(" + x + "))";
    }

    public double deviance(double w, double y, double f) {
        switch (this.distribution) {
            case AUTO: 
            case gaussian: {
                return w * (y - f) * (y - f);
            }
            case huber: {
                if (Math.abs(y - f) <= this.huberDelta) {
                    return w * (y - f) * (y - f);
                }
                return 2.0 * w * (Math.abs(y - f) - this.huberDelta) * this.huberDelta;
            }
            case laplace: {
                return w * Math.abs(y - f);
            }
            case quantile: {
                return y > f ? w * this.quantileAlpha * (y - f) : w * (1.0 - this.quantileAlpha) * (f - y);
            }
            case bernoulli: {
                return -2.0 * w * (y * Distribution.log(f) + (1.0 - y) * Distribution.log(1.0 - f));
            }
            case quasibinomial: {
                if (y == f) {
                    return 0.0;
                }
                if (f > 1.0) {
                    return -2.0 * w * y * Distribution.log(f);
                }
                if (f < 0.0) {
                    return -2.0 * w * (1.0 - y) * Distribution.log(1.0 - f);
                }
                return -2.0 * w * (y * Distribution.log(f) + (1.0 - y) * Distribution.log(1.0 - f));
            }
            case poisson: {
                f = this.link(f);
                return -2.0 * w * (y * f - Distribution.exp(f));
            }
            case gamma: {
                f = this.link(f);
                return 2.0 * w * (y * Distribution.exp(-f) + f);
            }
            case tweedie: {
                f = this.link(f);
                assert (this.tweediePower > 1.0 && this.tweediePower < 2.0);
                return 2.0 * w * (Math.pow(y, 2.0 - this.tweediePower) / ((1.0 - this.tweediePower) * (2.0 - this.tweediePower)) - y * Distribution.exp(f * (1.0 - this.tweediePower)) / (1.0 - this.tweediePower) + Distribution.exp(f * (2.0 - this.tweediePower)) / (2.0 - this.tweediePower));
            }
            case modified_huber: {
                double yf = (2.0 * y - 1.0) * f;
                if (yf < -1.0) {
                    return -w * 4.0 * yf;
                }
                if (yf > 1.0) {
                    return 0.0;
                }
                return w * yf * yf;
            }
        }
        throw H2O.unimpl();
    }

    public double negHalfGradient(double y, double f) {
        switch (this.distribution) {
            case AUTO: 
            case gaussian: 
            case bernoulli: 
            case poisson: {
                return y - this.linkInv(f);
            }
            case quasibinomial: {
                double ff = this.linkInv(f);
                if (ff == y) {
                    return 0.0;
                }
                if (ff > 1.0) {
                    return y / ff;
                }
                if (ff < 0.0) {
                    return (1.0 - y) / (ff - 1.0);
                }
                return y - ff;
            }
            case gamma: {
                return y * Distribution.exp(-f) - 1.0;
            }
            case tweedie: {
                assert (this.tweediePower > 1.0 && this.tweediePower < 2.0);
                return y * Distribution.exp(f * (1.0 - this.tweediePower)) - Distribution.exp(f * (2.0 - this.tweediePower));
            }
            case huber: {
                if (Math.abs(y - f) <= this.huberDelta) {
                    return y - f;
                }
                return f >= y ? -this.huberDelta : this.huberDelta;
            }
            case laplace: {
                return f > y ? -0.5 : 0.5;
            }
            case quantile: {
                return y > f ? 0.5 * this.quantileAlpha : 0.5 * (this.quantileAlpha - 1.0);
            }
            case modified_huber: {
                double yf = (2.0 * y - 1.0) * f;
                if (yf < -1.0) {
                    return 2.0 * (2.0 * y - 1.0);
                }
                if (yf > 1.0) {
                    return 0.0;
                }
                return -f * (2.0 * y - 1.0) * (2.0 * y - 1.0);
            }
        }
        throw H2O.unimpl();
    }

    public double link(double f) {
        return this.distribution.link(f);
    }

    public double linkInv(double f) {
        return this.distribution.linkInv(f);
    }

    public String linkInvString(String f) {
        return this.distribution.linkInvString(f);
    }

    public double initFNum(double w, double o, double y) {
        switch (this.distribution) {
            case AUTO: 
            case gaussian: 
            case bernoulli: 
            case quasibinomial: 
            case multinomial: {
                return w * (y - o);
            }
            case poisson: {
                return w * y;
            }
            case gamma: {
                return w * y * this.linkInv(-o);
            }
            case tweedie: {
                return w * y * Distribution.exp(o * (1.0 - this.tweediePower));
            }
            case modified_huber: {
                return y == 1.0 ? w : 0.0;
            }
        }
        throw H2O.unimpl();
    }

    public double initFDenom(double w, double o, double y) {
        switch (this.distribution) {
            case AUTO: 
            case gaussian: 
            case bernoulli: 
            case quasibinomial: 
            case gamma: 
            case multinomial: {
                return w;
            }
            case poisson: {
                return w * this.linkInv(o);
            }
            case tweedie: {
                return w * Distribution.exp(o * (2.0 - this.tweediePower));
            }
            case modified_huber: {
                return y == 1.0 ? 0.0 : w;
            }
        }
        throw H2O.unimpl();
    }

    public double gammaNum(double w, double y, double z, double f) {
        switch (this.distribution) {
            case gaussian: 
            case bernoulli: 
            case quasibinomial: 
            case multinomial: {
                return w * z;
            }
            case poisson: {
                return w * y;
            }
            case gamma: {
                return w * (z + 1.0);
            }
            case tweedie: {
                return w * y * Distribution.exp(f * (1.0 - this.tweediePower));
            }
            case modified_huber: {
                double yf = (2.0 * y - 1.0) * f;
                if (yf < -1.0) {
                    return w * 4.0 * (2.0 * y - 1.0);
                }
                if (yf > 1.0) {
                    return 0.0;
                }
                return w * 2.0 * (2.0 * y - 1.0) * (1.0 - yf);
            }
        }
        throw H2O.unimpl();
    }

    public double gammaDenom(double w, double y, double z, double f) {
        switch (this.distribution) {
            case gaussian: 
            case gamma: {
                return w;
            }
            case bernoulli: 
            case quasibinomial: {
                double ff = y - z;
                return w * ff * (1.0 - ff);
            }
            case multinomial: {
                double absz = Math.abs(z);
                return w * (absz * (1.0 - absz));
            }
            case poisson: {
                return w * (y - z);
            }
            case tweedie: {
                return w * Distribution.exp(f * (2.0 - this.tweediePower));
            }
            case modified_huber: {
                double yf = (2.0 * y - 1.0) * f;
                if (yf < -1.0) {
                    return -w * 4.0 * yf;
                }
                if (yf > 1.0) {
                    return 0.0;
                }
                return w * (1.0 - yf) * (1.0 - yf);
            }
        }
        throw H2O.unimpl();
    }
}

