/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Stack;
import water.Futures;
import water.Key;
import water.Keyed;
import water.fvec.Frame;
import water.fvec.Vec;

public class Scope {
    private static final ThreadLocal<Scope> _scope = new ThreadLocal<Scope>(){

        @Override
        protected Scope initialValue() {
            return new Scope();
        }
    };
    private final Stack<HashSet<Key>> _keys = new Stack();

    public static void enter() {
        Scope._scope.get()._keys.push(new HashSet());
    }

    public static Key[] exit(Key ... keep) {
        ArrayList<Key> keylist = new ArrayList<Key>();
        if (keep != null) {
            for (Key k : keep) {
                if (k == null) continue;
                keylist.add(k);
            }
        }
        Object[] arrkeep = keylist.toArray();
        Arrays.sort(arrkeep);
        Stack<HashSet<Key>> keys = Scope._scope.get()._keys;
        if (keys.size() > 0) {
            Futures fs = new Futures();
            for (Key key : keys.pop()) {
                int found = Arrays.binarySearch(arrkeep, key);
                if (arrkeep.length != 0 && found >= 0 || key == null) continue;
                Keyed.remove(key, fs);
            }
            fs.blockForPending();
        }
        return keep;
    }

    public static Key[] pop() {
        Stack<HashSet<Key>> keys = Scope._scope.get()._keys;
        return keys.size() > 0 ? keys.pop().toArray(new Key[0]) : null;
    }

    static void track_internal(Key k) {
        if (k.user_allowed() || !k.isVec()) {
            return;
        }
        Scope scope = _scope.get();
        if (scope == null) {
            return;
        }
        Scope.track_impl(scope, k);
    }

    public static <T extends Keyed> Keyed<T> track_generic(Keyed<T> keyed) {
        Scope scope = _scope.get();
        assert (scope != null);
        Scope.track_impl(scope, keyed._key);
        return keyed;
    }

    public static Vec track(Vec vec) {
        Scope scope = _scope.get();
        assert (scope != null);
        Scope.track_impl(scope, vec._key);
        return vec;
    }

    public static Frame track(Frame ... frames) {
        for (Frame fr : frames) {
            Scope scope = _scope.get();
            assert (scope != null);
            Scope.track_impl(scope, fr._key);
            for (Vec vec : fr.vecs()) {
                Scope.track_impl(scope, vec._key);
            }
        }
        return frames[0];
    }

    private static void track_impl(Scope scope, Key key) {
        if (key == null) {
            return;
        }
        if (scope._keys.size() > 0 && !scope._keys.peek().contains(key)) {
            scope._keys.peek().add(key);
        }
    }

    public static void untrack(Key<Vec> ... keys) {
        Scope scope = _scope.get();
        if (scope == null) {
            return;
        }
        if (scope._keys.size() == 0) {
            return;
        }
        HashSet<Key> xkeys = scope._keys.peek();
        for (Key<Vec> key : keys) {
            xkeys.remove(key);
        }
    }

    public static void untrack(Iterable<Key<Vec>> keys) {
        Scope scope = _scope.get();
        if (scope == null) {
            return;
        }
        if (scope._keys.size() == 0) {
            return;
        }
        HashSet<Key> xkeys = scope._keys.peek();
        for (Key<Vec> key : keys) {
            xkeys.remove(key);
        }
    }
}

