/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.Model;
import hex.PartialDependence;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Key;
import water.KeySnapshot;
import water.Value;
import water.api.FSIOException;
import water.api.Handler;
import water.api.Schema;
import water.api.SchemaServer;
import water.api.StreamingSchema;
import water.api.schemas3.FrameV3;
import water.api.schemas3.JobV3;
import water.api.schemas3.KeyV3;
import water.api.schemas3.ModelExportV3;
import water.api.schemas3.ModelImportV3;
import water.api.schemas3.ModelSchemaV3;
import water.api.schemas3.ModelsV3;
import water.api.schemas3.PartialDependenceV3;
import water.api.schemas3.SchemaV3;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OKeyNotFoundArgumentException;
import water.exceptions.H2OKeyWrongTypeArgumentException;
import water.exceptions.H2OKeysNotFoundArgumentException;
import water.fvec.Frame;
import water.persist.Persist;
import water.util.FileUtils;
import water.util.JCodeGen;

public class ModelsHandler<I extends Models, S extends SchemaV3<I, S>>
extends Handler {
    public ModelsV3 list(int version, ModelsV3 s) {
        Models m = (Models)s.createAndFillImpl();
        m.models = Model.fetchAll();
        return s.fillFromImplWithSynopsis(m);
    }

    public static Model getFromDKV(String param_name, String key_str) {
        return ModelsHandler.getFromDKV(param_name, Key.make(key_str));
    }

    public static Model getFromDKV(String param_name, Key key) {
        if (key == null) {
            throw new H2OIllegalArgumentException(param_name, "Models.getFromDKV()", null);
        }
        Value v = DKV.get(key);
        if (v == null) {
            throw new H2OKeyNotFoundArgumentException(param_name, key.toString());
        }
        Object ice = v.get();
        if (!(ice instanceof Model)) {
            throw new H2OKeyWrongTypeArgumentException(param_name, key.toString(), Model.class, ice.getClass());
        }
        return (Model)ice;
    }

    public StreamingSchema fetchPreview(int version, ModelsV3 s) {
        s.preview = true;
        return this.fetchJavaCode(version, s);
    }

    public ModelsV3 fetch(int version, ModelsV3 s) {
        Model model = ModelsHandler.getFromDKV("key", s.model_id.key());
        s.models = new ModelSchemaV3[1];
        s.models[0] = (ModelSchemaV3)SchemaServer.schema(version, model).fillFromImpl(model);
        if (s.find_compatible_frames) {
            Models m = new Models();
            m.models = new Model[1];
            m.models[0] = model;
            m.find_compatible_frames = true;
            Frame[] compatible = Models.findCompatibleFrames(model, Frame.fetchAll(), m.fetchFrameCols());
            s.compatible_frames = new FrameV3[compatible.length];
            ((ModelSchemaV3)s.models[0]).compatible_frames = new String[compatible.length];
            int i = 0;
            for (Frame f : compatible) {
                s.compatible_frames[i] = new FrameV3(f);
                ((ModelSchemaV3)s.models[0]).compatible_frames[i] = f._key.toString();
                ++i;
            }
        }
        return s;
    }

    public StreamingSchema fetchJavaCode(int version, ModelsV3 s) {
        Model model = ModelsHandler.getFromDKV("key", s.model_id.key());
        if (!model.havePojo()) {
            throw H2O.unimpl(String.format("%s does not support export to POJO", ((Model.Parameters)model._parms).fullName()));
        }
        String filename = JCodeGen.toJavaId(s.model_id.key().toString()) + ".java";
        Model model2 = model;
        model2.getClass();
        return new StreamingSchema(new Model.JavaModelStreamWriter(model2, s.preview), filename);
    }

    public StreamingSchema fetchMojo(int version, ModelsV3 s) {
        Model model = ModelsHandler.getFromDKV("key", s.model_id.key());
        if (!model.haveMojo()) {
            throw H2O.unimpl(String.format("%s does not support export to MOJO", ((Model.Parameters)model._parms).fullName()));
        }
        String filename = JCodeGen.toJavaId(s.model_id.key().toString()) + ".zip";
        return new StreamingSchema(model.getMojo(), filename);
    }

    public JobV3 makePartialDependence(int version, PartialDependenceV3 s) {
        PartialDependence partialDependence = s.destination_key != null ? new PartialDependence(s.destination_key.key()) : new PartialDependence(Key.make());
        s.fillImpl(partialDependence);
        return new JobV3(partialDependence.execImpl());
    }

    public PartialDependenceV3 fetchPartialDependence(int version, KeyV3.PartialDependenceKeyV3 s) {
        PartialDependence partialDependence = (PartialDependence)DKV.getGet(s.key());
        return (PartialDependenceV3)new PartialDependenceV3().fillFromImpl(partialDependence);
    }

    public ModelsV3 delete(int version, ModelsV3 s) {
        Model model = ModelsHandler.getFromDKV("key", s.model_id.key());
        model.delete();
        return s;
    }

    public ModelsV3 deleteAll(int version, ModelsV3 models) {
        Key[] keys = KeySnapshot.globalKeysOfClass(Model.class);
        ArrayList<String> missing = new ArrayList<String>();
        Futures fs = new Futures();
        for (Key key : keys) {
            try {
                ModelsHandler.getFromDKV("(none)", key).delete(null, fs);
            }
            catch (IllegalArgumentException iae) {
                missing.add(key.toString());
            }
        }
        fs.blockForPending();
        if (missing.size() != 0) {
            throw new H2OKeysNotFoundArgumentException("(none)", missing.toArray(new String[missing.size()]));
        }
        return models;
    }

    public ModelsV3 importModel(int version, ModelImportV3 mimport) {
        ModelsV3 s = Schema.newInstance(ModelsV3.class);
        try {
            Object model = Model.importBinaryModel(mimport.dir);
            s.models = new ModelSchemaV3[]{(ModelSchemaV3)SchemaServer.schema(version, model).fillFromImpl(model)};
        }
        catch (IOException | FSIOException e) {
            throw new H2OIllegalArgumentException("dir", "importModel", mimport.dir);
        }
        return s;
    }

    public ModelExportV3 exportModel(int version, ModelExportV3 mexport) {
        Model model = ModelsHandler.getFromDKV("model_id", mexport.model_id.key());
        try {
            URI targetUri = model.exportBinaryModel(mexport.dir, mexport.force);
            mexport.dir = "file".equals(targetUri.getScheme()) ? new File(targetUri).getCanonicalPath() : targetUri.toString();
        }
        catch (IOException e) {
            throw new H2OIllegalArgumentException("dir", "exportModel", e);
        }
        return mexport;
    }

    public ModelExportV3 exportMojo(int version, ModelExportV3 mexport) {
        Model model = ModelsHandler.getFromDKV("model_id", mexport.model_id.key());
        try {
            URI targetUri = model.exportMojo(mexport.dir, mexport.force);
            mexport.dir = "file".equals(targetUri.getScheme()) ? new File(targetUri).getCanonicalPath() : targetUri.toString();
        }
        catch (IOException e) {
            throw new H2OIllegalArgumentException("dir", "exportModel", e);
        }
        return mexport;
    }

    public ModelExportV3 exportModelDetails(int version, ModelExportV3 mexport) {
        Model model = ModelsHandler.getFromDKV("model_id", mexport.model_id.key());
        try {
            URI targetUri = FileUtils.getURI(mexport.dir);
            Persist p = H2O.getPM().getPersistForURI(targetUri);
            ModelSchemaV3 modelSchema = (ModelSchemaV3)SchemaServer.schema(version, model).fillFromImpl(model);
            OutputStream os = p.create(targetUri.toString(), mexport.force);
            os.write(modelSchema.writeJSON(new AutoBuffer()).buf());
            mexport.dir = "file".equals(targetUri.getScheme()) ? new File(targetUri).getCanonicalPath() : targetUri.toString();
        }
        catch (IOException e) {
            throw new H2OIllegalArgumentException("dir", "exportModelDetails", e);
        }
        return mexport;
    }

    public static final class Models
    extends Iced {
        public Key model_id;
        public Model[] models;
        public boolean find_compatible_frames = false;

        protected Map<Frame, Set<String>> fetchFrameCols() {
            if (!this.find_compatible_frames) {
                return null;
            }
            Frame[] all_frames = Frame.fetchAll();
            HashMap<Frame, Set<String>> all_frames_cols = new HashMap<Frame, Set<String>>();
            for (Frame f : all_frames) {
                all_frames_cols.put(f, new HashSet<String>(Arrays.asList(f._names)));
            }
            return all_frames_cols;
        }

        private static Frame[] findCompatibleFrames(Model model, Frame[] all_frames, Map<Frame, Set<String>> all_frames_cols) {
            ArrayList<Frame> compatible_frames = new ArrayList<Frame>();
            HashSet<String> model_column_names = new HashSet<String>(Arrays.asList(((Model.Output)model._output)._names));
            for (Map.Entry<Frame, Set<String>> entry : all_frames_cols.entrySet()) {
                Frame frame = entry.getKey();
                Set<String> frame_cols = entry.getValue();
                if (!frame_cols.containsAll(model_column_names)) continue;
                try {
                    if (model.adaptTestForTrain(new Frame(frame), false, false).length != 0) continue;
                    compatible_frames.add(frame);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return compatible_frames.toArray(new Frame[0]);
        }
    }
}

