/*
 * Decompiled with CFR 0.152.
 */
package water.api.schemas3;

import hex.Model;
import hex.ModelCategory;
import hex.ModelMetrics;
import water.Key;
import water.api.API;
import water.api.schemas3.FrameV3;
import water.api.schemas3.KeyV3;
import water.api.schemas3.SchemaV3;
import water.fvec.Frame;
import water.util.PojoUtils;

public class ModelMetricsBaseV3<I extends ModelMetrics, S extends ModelMetricsBaseV3<I, S>>
extends SchemaV3<I, S> {
    @API(help="The model used for this scoring run.", direction=API.Direction.INOUT)
    public KeyV3.ModelKeyV3 model;
    @API(help="The checksum for the model used for this scoring run.", direction=API.Direction.INOUT)
    public long model_checksum;
    @API(help="The frame used for this scoring run.", direction=API.Direction.INOUT)
    public KeyV3.FrameKeyV3 frame;
    @API(help="The checksum for the frame used for this scoring run.", direction=API.Direction.INOUT)
    public long frame_checksum;
    @API(help="Optional description for this scoring run (to note out-of-bag, sampled data, etc.)", direction=API.Direction.OUTPUT)
    public String description;
    @API(help="The category (e.g., Clustering) for the model used for this scoring run.", values={"Unknown", "Binomial", "Multinomial", "Regression", "Clustering"}, direction=API.Direction.OUTPUT)
    public ModelCategory model_category;
    @API(help="The time in mS since the epoch for the start of this scoring run.", direction=API.Direction.OUTPUT)
    public long scoring_time;
    @API(help="Predictions Frame.", direction=API.Direction.OUTPUT)
    public FrameV3 predictions;
    @API(help="The Mean Squared Error of the prediction for this scoring run.", direction=API.Direction.OUTPUT)
    public double MSE;
    @API(help="The Root Mean Squared Error of the prediction for this scoring run.", direction=API.Direction.OUTPUT)
    public double RMSE;
    @API(help="Number of observations.")
    public long nobs;
    @API(help="Name of custom metric", direction=API.Direction.OUTPUT)
    public String custom_metric_name;
    @API(help="Value of custom metric", direction=API.Direction.OUTPUT)
    public double custom_metric_value;

    public ModelMetricsBaseV3() {
    }

    public ModelMetricsBaseV3(I impl) {
        super(impl);
    }

    @Override
    public S fillFromImpl(ModelMetrics modelMetrics) {
        Frame f;
        Model m = modelMetrics.model();
        if (m != null) {
            this.model = new KeyV3.ModelKeyV3(m._key);
            this.model_category = ((Model.Output)m._output).getModelCategory();
            this.model_checksum = m.checksum();
        }
        if (null != (f = modelMetrics.frame())) {
            this.frame = new KeyV3.FrameKeyV3((Key<Frame>)f._key);
            this.frame_checksum = f.checksum();
        }
        PojoUtils.copyProperties(this, modelMetrics, PojoUtils.FieldNaming.ORIGIN_HAS_UNDERSCORES, new String[]{"model", "model_category", "model_checksum", "frame", "frame_checksum", "custom_metric"});
        this.RMSE = modelMetrics.rmse();
        if (modelMetrics._custom_metric != null) {
            this.custom_metric_name = modelMetrics._custom_metric.name;
            this.custom_metric_value = modelMetrics._custom_metric.value;
        }
        return (S)this;
    }
}

