/*
 * Decompiled with CFR 0.152.
 */
package water.jdbc;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.concurrent.ArrayBlockingQueue;
import water.DKV;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.FileVec;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.parser.ParseDataset;
import water.util.Log;

public class SQLManager {
    private static final String TEMP_TABLE_NAME = "table_for_h2o_import";
    private static final int MAX_CONNECTIONS = 100;
    private static final String NETEZZA_DB_TYPE = "netezza";
    private static final String ORACLE_DB_TYPE = "oracle";
    private static final String SQL_SERVER_DB_TYPE = "sqlserver";
    private static final String NETEZZA_JDBC_DRIVER_CLASS = "org.netezza.Driver";

    public static Job<Frame> importSqlTable(final String connection_url, String table, String select_query, final String username, final String password, final String columns, boolean optimize) {
        Vec _v;
        byte[] columnH2OTypes;
        String[] columnNames;
        int numCol;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        String databaseType = connection_url.split(":", 3)[1];
        SQLManager.initializeDatabaseDriver(databaseType);
        final boolean needFetchClause = ORACLE_DB_TYPE.equals(databaseType) || SQL_SERVER_DB_TYPE.equals(databaseType);
        int catcols = 0;
        int intcols = 0;
        int bincols = 0;
        int realcols = 0;
        int timecols = 0;
        int stringcols = 0;
        long numRow = 0L;
        try {
            conn = DriverManager.getConnection(connection_url, username, password);
            stmt = conn.createStatement();
            stmt.setFetchSize(1);
            if (table.equals("")) {
                if (!select_query.toLowerCase().startsWith("select")) {
                    throw new IllegalArgumentException("The select_query must start with `SELECT`, but instead is: " + select_query);
                }
                table = TEMP_TABLE_NAME;
                numRow = stmt.executeUpdate("CREATE TABLE " + table + " AS " + select_query);
            } else if (table.equals(TEMP_TABLE_NAME)) {
                throw new IllegalArgumentException("The specified table cannot be named: table_for_h2o_import");
            }
            if (numRow <= 0L) {
                rs = stmt.executeQuery("SELECT COUNT(1) FROM " + table);
                rs.next();
                numRow = rs.getLong(1);
                rs.close();
            }
            rs = needFetchClause ? stmt.executeQuery("SELECT " + columns + " FROM " + table + " FETCH NEXT 1 ROWS ONLY") : stmt.executeQuery("SELECT " + columns + " FROM " + table + " LIMIT 1");
            ResultSetMetaData rsmd = rs.getMetaData();
            numCol = rsmd.getColumnCount();
            columnNames = new String[numCol];
            columnH2OTypes = new byte[numCol];
            rs.next();
            block24: for (int i = 0; i < numCol; ++i) {
                columnNames[i] = rsmd.getColumnName(i + 1);
                switch (rsmd.getColumnType(i + 1)) {
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: {
                        columnH2OTypes[i] = 3;
                        ++realcols;
                        continue block24;
                    }
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        columnH2OTypes[i] = 3;
                        ++intcols;
                        continue block24;
                    }
                    case -7: 
                    case 16: {
                        columnH2OTypes[i] = 3;
                        ++bincols;
                        continue block24;
                    }
                    case -16: 
                    case -15: 
                    case -9: 
                    case -1: 
                    case 1: 
                    case 12: {
                        columnH2OTypes[i] = 2;
                        ++stringcols;
                        continue block24;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        columnH2OTypes[i] = 5;
                        ++timecols;
                        continue block24;
                    }
                    default: {
                        Log.warn("Unsupported column type: " + rsmd.getColumnTypeName(i + 1));
                        columnH2OTypes[i] = 0;
                    }
                }
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException("SQLException: " + ex.getMessage() + "\nFailed to connect and read from SQL database with connection_url: " + connection_url);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
                stmt = null;
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
                conn = null;
            }
        }
        double binary_ones_fraction = 0.5;
        long totSize = (long)((double)((float)(catcols + intcols) * (float)numRow * 4.0f) + (double)((float)bincols * (float)numRow * 1.0f) * binary_ones_fraction + (double)((float)(realcols + timecols + stringcols) * (float)numRow * 8.0f));
        if (optimize) {
            _v = Vec.makeCon(totSize, numRow);
        } else {
            double rows_per_chunk = FileVec.calcOptimalChunkSize(totSize, numCol, numCol * 4, Runtime.getRuntime().availableProcessors(), H2O.getCloudSize(), false, false);
            _v = Vec.makeCon(0.0, numRow, (int)Math.ceil(Math.log1p(rows_per_chunk)), false);
        }
        Log.info("Number of chunks: " + _v.nChunks());
        final Key destination_key = Key.make(table + "_sql_to_hex");
        final Job<Frame> j = new Job<Frame>(destination_key, Frame.class.getName(), "Import SQL Table");
        final String finalTable = table;
        H2O.H2OCountedCompleter work = new H2O.H2OCountedCompleter(){

            @Override
            public void compute2() {
                Frame fr = ((SqlTableToH2OFrame)new SqlTableToH2OFrame(connection_url, finalTable, needFetchClause, username, password, columns, numCol, _v.nChunks(), j).doAll(columnH2OTypes, _v)).outputFrame(destination_key, columnNames, null);
                DKV.put(fr);
                _v.remove();
                ParseDataset.logParseResults(fr);
                if (finalTable.equals(SQLManager.TEMP_TABLE_NAME)) {
                    SQLManager.dropTempTable(connection_url, username, password);
                }
                this.tryComplete();
            }
        };
        j.start(work, _v.nChunks());
        return j;
    }

    private static void initializeDatabaseDriver(String databaseType) {
        switch (databaseType) {
            case "netezza": {
                try {
                    Class.forName(NETEZZA_JDBC_DRIVER_CLASS);
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Connection to Netezza database is not possible due to missing JDBC driver.");
                }
            }
        }
    }

    private static void dropTempTable(String connection_url, String username, String password) {
        Connection conn = null;
        Statement stmt = null;
        String drop_table_query = "DROP TABLE table_for_h2o_import";
        try {
            conn = DriverManager.getConnection(connection_url, username, password);
            stmt = conn.createStatement();
            stmt.executeUpdate(drop_table_query);
        }
        catch (SQLException ex) {
            throw new RuntimeException("SQLException: " + ex.getMessage() + "\nFailed to execute SQL query: " + drop_table_query);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
                stmt = null;
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
                conn = null;
            }
        }
    }

    private static class SqlTableToH2OFrame
    extends MRTask<SqlTableToH2OFrame> {
        final String _url;
        final String _table;
        final String _user;
        final String _password;
        final String _columns;
        final int _numCol;
        final int _nChunks;
        final boolean _needFetchClause;
        final Job _job;
        transient ArrayBlockingQueue<Connection> sqlConn;

        public SqlTableToH2OFrame(String url, String table, boolean needFetchClause, String user, String password, String columns, int numCol, int nChunks, Job job) {
            this._url = url;
            this._table = table;
            this._needFetchClause = needFetchClause;
            this._user = user;
            this._password = password;
            this._columns = columns;
            this._numCol = numCol;
            this._nChunks = nChunks;
            this._job = job;
        }

        @Override
        protected void setupLocal() {
            int conPerNode = (int)Math.min(Math.ceil((double)this._nChunks / (double)H2O.getCloudSize()), (double)Runtime.getRuntime().availableProcessors());
            conPerNode = Math.min(conPerNode, 100 / H2O.getCloudSize());
            Log.info("Database connections per node: " + conPerNode);
            this.sqlConn = new ArrayBlockingQueue(conPerNode);
            try {
                for (int i = 0; i < conPerNode; ++i) {
                    Connection conn = DriverManager.getConnection(this._url, this._user, this._password);
                    this.sqlConn.add(conn);
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException("SQLException: " + ex.getMessage() + "\nFailed to connect to SQL database with url: " + this._url);
            }
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] ncs) {
            if (this.isCancelled() || this._job != null && this._job.stop_requested()) {
                return;
            }
            Connection conn = null;
            Statement stmt = null;
            ResultSet rs = null;
            Chunk c0 = cs[0];
            String sqlText = "SELECT " + this._columns + " FROM " + this._table;
            sqlText = this._needFetchClause ? sqlText + " OFFSET " + c0.start() + " ROWS FETCH NEXT " + c0._len + " ROWS ONLY" : sqlText + " LIMIT " + c0._len + " OFFSET " + c0.start();
            try {
                conn = this.sqlConn.take();
                stmt = conn.createStatement();
                stmt.setFetchSize(c0._len);
                rs = stmt.executeQuery(sqlText);
                while (rs.next()) {
                    block43: for (int i = 0; i < this._numCol; ++i) {
                        Object res = rs.getObject(i + 1);
                        if (res == null) {
                            ncs[i].addNA();
                            continue;
                        }
                        switch (res.getClass().getSimpleName()) {
                            case "Double": {
                                ncs[i].addNum((Double)res);
                                continue block43;
                            }
                            case "Integer": {
                                ncs[i].addNum(((Integer)res).intValue(), 0);
                                continue block43;
                            }
                            case "Long": {
                                ncs[i].addNum((Long)res, 0);
                                continue block43;
                            }
                            case "Float": {
                                ncs[i].addNum(((Float)res).floatValue());
                                continue block43;
                            }
                            case "Short": {
                                ncs[i].addNum(((Short)res).shortValue(), 0);
                                continue block43;
                            }
                            case "Byte": {
                                ncs[i].addNum(((Byte)res).byteValue(), 0);
                                continue block43;
                            }
                            case "BigDecimal": {
                                ncs[i].addNum(((BigDecimal)res).doubleValue());
                                continue block43;
                            }
                            case "Boolean": {
                                ncs[i].addNum((Boolean)res != false ? 1 : 0, 0);
                                continue block43;
                            }
                            case "String": {
                                ncs[i].addStr(new BufferedString((String)res));
                                continue block43;
                            }
                            case "Date": {
                                ncs[i].addNum(((Date)res).getTime(), 0);
                                continue block43;
                            }
                            case "Time": {
                                ncs[i].addNum(((Time)res).getTime(), 0);
                                continue block43;
                            }
                            case "Timestamp": {
                                ncs[i].addNum(((Timestamp)res).getTime(), 0);
                                continue block43;
                            }
                            default: {
                                ncs[i].addNA();
                            }
                        }
                    }
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException("SQLException: " + ex.getMessage() + "\nFailed to read SQL data");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new RuntimeException("Interrupted exception when trying to take connection from pool");
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                    rs = null;
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sQLException) {}
                    stmt = null;
                }
                this.sqlConn.add(conn);
            }
            if (this._job != null) {
                this._job.update(1L);
            }
        }

        @Override
        protected void closeLocal() {
            try {
                for (Connection conn : this.sqlConn) {
                    conn.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

