/*
 * Decompiled with CFR 0.152.
 */
package water.network;

import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import water.H2OSecurityManager;
import water.network.SSLSocketChannel;

public class SocketChannelFactory {
    private static volatile SocketChannelFactory INSTANCE;
    private H2OSecurityManager sm;

    private SocketChannelFactory(H2OSecurityManager sm) {
        this.sm = sm;
    }

    public ByteChannel serverChannel(ByteChannel channel) throws IOException {
        if (this.sm.securityEnabled && !(channel instanceof SSLSocketChannel)) {
            return this.sm.wrapServerChannel((SocketChannel)channel);
        }
        return channel;
    }

    public ByteChannel clientChannel(ByteChannel channel, String host, int port) throws IOException {
        if (this.sm.securityEnabled && !(channel instanceof SSLSocketChannel)) {
            return this.sm.wrapClientChannel((SocketChannel)channel, host, port);
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SocketChannelFactory instance(H2OSecurityManager sm) {
        if (null != INSTANCE) return INSTANCE;
        Class<SocketChannelFactory> clazz = SocketChannelFactory.class;
        synchronized (SocketChannelFactory.class) {
            if (null != INSTANCE) return INSTANCE;
            INSTANCE = new SocketChannelFactory(sm);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }
}

